/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.text;

import com.jsql.util.LogLevelUtil;
import com.jsql.view.swing.popupmenu.JPopupMenuComponent;
import com.jsql.view.swing.text.JPlaceholder;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;

public class SyntaxTextArea
extends RSyntaxTextArea
implements JPlaceholder {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String placeholderText;

    public SyntaxTextArea() {
        this("");
    }

    public SyntaxTextArea(String text) {
        this.placeholderText = text;
        this.setPopupMenu(new JPopupMenuComponent(this));
        this.getCaret().setBlinkRate(0);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SyntaxTextArea.this.getCaret().setVisible(true);
                SyntaxTextArea.this.getCaret().setSelectionVisible(true);
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setSyntaxEditingStyle("text/sql");
        this.setMarkOccurrences(true);
        this.setMarkOccurrencesDelay(200);
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
            if (StringUtils.isEmpty(this.getText()) && StringUtils.isNotEmpty(this.placeholderText)) {
                UiUtil.drawPlaceholder(this, g, this.placeholderText);
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    @Override
    public Font getFont() {
        return UiUtil.FONT_MONO_NON_ASIAN;
    }

    @Override
    public Font getFontForToken(Token token) {
        return UiUtil.FONT_MONO_NON_ASIAN;
    }

    @Override
    public Font getFontForTokenType(int type) {
        return UiUtil.FONT_MONO_NON_ASIAN;
    }

    @Override
    public void setPlaceholderText(String placeholderText) {
        this.placeholderText = placeholderText;
    }
}

