/*
 * Decompiled with CFR 0.152.
 */
package se.jguru.nazgul.tools.validation.aspect;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.jguru.nazgul.tools.validation.api.Validatable;
import se.jguru.nazgul.tools.validation.api.exception.InternalStateValidationException;

@Aspect
public class ValidationAspect {
    private static final Logger log = LoggerFactory.getLogger(ValidationAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ ValidationAspect ajc$perSingletonInstance;

    static {
        try {
            ValidationAspect.ajc$perSingletonInstance = new ValidationAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="initialization(*.new())")
    /* synthetic */ void anyDefaultConstructor() {
    }

    @Pointcut(value="initialization(se.jguru.nazgul.tools.validation.api.Validatable+.new(..)) && this(aValidatable) && !anyDefaultConstructor()", argNames="joinPoint, aValidatable")
    /* synthetic */ void anyNonDefaultConstructor(JoinPoint joinPoint, Validatable aValidatable) {
    }

    @AfterReturning(value="anyNonDefaultConstructor(joinPoint, validatable)", argNames="joinPoint, validatable")
    public void performValidationAfterCompoundConstructor(JoinPoint joinPoint, Validatable validatable) throws InternalStateValidationException {
        if (log.isDebugEnabled()) {
            log.debug("Validating instance of type [" + validatable.getClass().getName() + "]");
        }
        if (joinPoint.getStaticPart() == null) {
            log.warn("Static part of join point was null for validatable of type: " + validatable.getClass().getName(), (Throwable)new IllegalStateException());
            return;
        }
        ConstructorSignature sig = (ConstructorSignature)joinPoint.getSignature();
        Class constructorDefinitionClass = sig.getConstructor().getDeclaringClass();
        if (validatable.getClass() == constructorDefinitionClass) {
            validatable.validateInternalState();
        } else {
            log.debug("Ignored firing validatable for constructor defined in [" + constructorDefinitionClass.getName() + "] and Validatable of type [" + validatable.getClass().getName() + "]");
        }
    }

    public static ValidationAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("se.jguru.nazgul.tools.validation.aspect.ValidationAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

