/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;

public class JTextConsole
extends JTextPane {
    private static final int DEFAULT_FONT_SIZE = 20;
    private static final String DEFAULT_FONT_NAME = "Courier New";
    private static final int DEFAULT_WIDTH_CHARS = 80;
    private static final int DEFAULT_HEIGHT_CHARS = 25;
    private Font font = null;
    private volatile boolean finished = false;
    MutableAttributeSet attrs = this.getInputAttributes();
    int widthChars = 80;
    int heightChars = 25;
    int maxLength = this.pointToInt(this.widthChars, this.heightChars);
    int[] processable = new int[]{38, 40, 37, 39, 36, 35};
    private List formRanges = new ArrayList();

    public JTextConsole() {
    }

    public JTextConsole(int width, int height) {
        this(width, height, 20, DEFAULT_FONT_NAME);
    }

    public JTextConsole(int width, int height, int fontSize, String fontName) {
        this.font = new Font(fontName, 1, fontSize);
        this.widthChars = width;
        this.heightChars = height;
        this.setFont(this.font);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        Rectangle2D stringBounds = this.font.getStringBounds(new char[]{'l'}, 0, 1, fontRenderContext);
        this.setPreferredSize(new Dimension((int)((double)(this.widthChars + 1) * stringBounds.getWidth()), (int)(((double)this.heightChars + 1.5) * stringBounds.getHeight())));
        this.setForeground(Color.WHITE);
        this.setBackground(Color.BLACK);
        this.setCaretColor(Color.WHITE);
        this.fill();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g);
    }

    private void fill() {
        StringBuffer buffer = new StringBuffer();
        for (int j = 0; j < this.heightChars; ++j) {
            for (int i = 0; i < this.widthChars; ++i) {
                buffer.append(" ");
            }
            if (j >= this.heightChars - 1) continue;
            buffer.append("\n");
        }
        this.setText(buffer.toString());
    }

    private int pointToInt(int i, int j) {
        int ret = (j - 1) * (this.widthChars + 1) + (i - 1);
        return ret;
    }

    public void gotoPosition(int x, int y) {
        int start = this.pointToInt(x, y);
        this.setCaretPosition(start);
    }

    public void gotoFirstField() {
        if (this.formRanges.size() > 0) {
            FormRange firstRange = (FormRange)this.formRanges.get(0);
            this.setCaretPosition(firstRange.start);
        }
    }

    public void clear() {
        this.setForeground(Color.WHITE);
        this.fill();
        this.reset();
    }

    public void color(int i, int j, Color color) {
        StyleConstants.setForeground(this.attrs, color);
        this.getStyledDocument().setCharacterAttributes(i, j - i, this.attrs, true);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        char keyChar = e.getKeyChar();
        int keyCode = e.getKeyCode();
        if (keyCode == 10) {
            this.finished = true;
        }
        boolean needProcess = false;
        for (int i = 0; i < this.processable.length; ++i) {
            if (this.processable[i] != keyCode) continue;
            needProcess = true;
        }
        if (!needProcess) {
            int caretPosition = this.getCaretPosition();
            for (FormRange range : this.formRanges) {
                int checkPosition = caretPosition;
                if (keyCode == 8) {
                    checkPosition = caretPosition - 1;
                }
                if (!range.isInRange(checkPosition) || e.getID() != 401) continue;
                this.setLocalColor(range.color);
                if (Character.isLetterOrDigit(keyChar)) {
                    this.write("" + keyChar);
                    continue;
                }
                if (keyCode == 32) {
                    this.write(" ");
                    continue;
                }
                if (keyCode == 127) {
                    this.write(" ");
                    continue;
                }
                if (keyCode != 8) continue;
                this.setCaretPosition(this.getCaretPosition() - 1);
                this.write(" ");
                this.setCaretPosition(this.getCaretPosition() - 1);
            }
            if (keyCode == 9 && e.getID() == 401) {
                boolean found = false;
                if (e.isShiftDown()) {
                    Collections.reverse(this.formRanges);
                }
                Iterator iter = this.formRanges.iterator();
                while (iter.hasNext() && !found) {
                    FormRange hotRange = (FormRange)iter.next();
                    int start = hotRange.start;
                    if (e.isShiftDown()) {
                        if (start >= caretPosition) continue;
                        this.setCaretPosition(start);
                        found = true;
                        continue;
                    }
                    if (start <= caretPosition) continue;
                    this.setCaretPosition(start);
                    found = true;
                }
                if (e.isShiftDown()) {
                    Collections.sort(this.formRanges);
                }
                if (!found && this.formRanges.size() > 0) {
                    this.setCaretPosition(((FormRange)this.formRanges.get(0)).start);
                }
            }
        }
        if (needProcess) {
            super.processKeyEvent(e);
        }
    }

    private void setLocalColor(Color color) {
        this.setForeground(color);
    }

    public void reset() {
        this.finished = false;
    }

    public void write(String string) {
        int caretPosition = this.getCaretPosition();
        if (caretPosition + string.length() > this.maxLength) {
            string = string.substring(0, this.maxLength - caretPosition + 1);
        }
        int start = caretPosition;
        int end = caretPosition + string.length();
        this.setSelectionStart(start);
        this.setSelectionEnd(end);
        this.replaceSelection(string);
        this.setSelectionStart(this.getCaretPosition());
        this.color(start, end, this.getForeground());
    }

    public void write(String string, Color color) {
        this.setForeground(color);
        this.write(string);
    }

    public void write(String string, int x, int y) {
        this.gotoPosition(x, y);
        this.write(string);
    }

    public void write(String string, int x, int y, Color color) {
        this.setForeground(color);
        this.gotoPosition(x, y);
        this.write(string);
    }

    public Map getValues() {
        while (!this.finished) {
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (FormRange range : this.formRanges) {
            try {
                String text = this.getText(range.start, range.end - range.start);
                map.put(range.name, text.trim());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public void addFormField(String fieldName, int width) {
        int start = this.getCaretPosition();
        int end = this.getCaretPosition() + width;
        this.addFormRange(fieldName, start, end);
    }

    public void addFormField(String fieldName, int width, Color color) {
        this.setForeground(color);
        this.addFormField(fieldName, width);
    }

    public void addFormField(String fieldName, int x, int y, int width) {
        int start = this.pointToInt(x, y);
        int end = this.pointToInt(x + width, y);
        this.addFormRange(fieldName, start, end);
    }

    public void addFormField(String fieldName, int x, int y, int width, Color color) {
        this.setForeground(color);
        int start = this.pointToInt(x, y);
        int end = this.pointToInt(x + width, y);
        this.addFormRange(fieldName, start, end);
    }

    private void addFormRange(String fieldName, int start, int end) {
        FormRange range = new FormRange(fieldName, start, end, this.getForeground());
        this.formRanges.add(range);
        Collections.sort(this.formRanges);
        StyleConstants.setUnderline(this.attrs, true);
        this.getStyledDocument().setCharacterAttributes(start, end - start, this.attrs, true);
        this.color(start, end, this.getForeground());
    }

    class FormRange
    implements Comparable {
        private String name;
        private int start;
        private int end;
        private Color color;

        public FormRange(String name, int start, int end, Color color) {
            this.name = name;
            this.start = start;
            this.end = end;
            this.color = color;
        }

        public boolean isInRange(int i) {
            return i >= this.start && i < this.end;
        }

        public int compareTo(Object other) {
            FormRange otherRange = (FormRange)other;
            return new Integer(this.start).compareTo(new Integer(otherRange.start));
        }
    }
}

