/*
 * Decompiled with CFR 0.152.
 */
package friendless.games.filler;

import friendless.games.filler.FillerPlayerSpace;
import friendless.games.filler.remote.IsMessage;
import friendless.games.filler.remote.RemoteConnection;
import friendless.games.filler.remote.messages.NewGameMessage;
import java.io.IOException;
import java.util.BitSet;
import java.util.Random;

public class FillerModel {
    public static final int VACANT = 0;
    public static final int HIS_BORDER = 1;
    public static final int SHARED_BORDER = 2;
    public static final int HIS = 3;
    public static final int REACHABLE = 4;
    public static final int HIS_REACHABLE = 5;
    public static final int BORDER = 6;
    public static final int MINE = 7;
    public static final int FREE = 8;
    public static final int INTERNAL_BORDER = 9;
    public static final int HIS_INTERNAL_BORDER = 10;
    public static final int NUM_TYPES = 11;
    public static final int NO_DISTANCE = 0;
    public static final int UNREACHABLE_DISTANCE = -1;
    public static final int UNKNOWN_DISTANCE = -2;
    private static final int MAX_NEIGHBOURS = 6;
    public static final int NO_NEIGHBOUR = -1;
    private static int count = 0;
    private static int[] x;
    private static int[] y;
    private static int[][] neighs;
    private static final Random rng;
    public static final BitSet MUST_BE_MINE;
    public static final BitSet MUST_BE_HIS;
    public static final BitSet MUST_BE_FREE;
    int[] pieces;

    private static final int[] calcNeighbours(int n, int[] nArray) {
        int n2 = x[n];
        int n3 = y[n];
        int n4 = 0;
        if (n2 < 93) {
            nArray[n4++] = FillerModel.makeIndex(n2 + 2, n3);
        }
        if (n2 > 1) {
            nArray[n4++] = FillerModel.makeIndex(n2 - 2, n3);
        }
        if (n2 % 2 == 0) {
            if (n2 > 0) {
                nArray[n4++] = FillerModel.makeIndex(n2 - 1, n3 - 1);
                nArray[n4++] = FillerModel.makeIndex(n2 - 1, n3);
            }
            if (n2 < 94) {
                nArray[n4++] = FillerModel.makeIndex(n2 + 1, n3 - 1);
                nArray[n4++] = FillerModel.makeIndex(n2 + 1, n3);
            }
        } else {
            if (n3 > 0) {
                nArray[n4++] = FillerModel.makeIndex(n2 - 1, n3);
                nArray[n4++] = FillerModel.makeIndex(n2 + 1, n3);
            }
            if (n3 < 14) {
                nArray[n4++] = FillerModel.makeIndex(n2 - 1, n3 + 1);
                nArray[n4++] = FillerModel.makeIndex(n2 + 1, n3 + 1);
            }
        }
        while (n4 < nArray.length) {
            nArray[n4++] = -1;
        }
        return nArray;
    }

    public static final int makeIndex(int n, int n2) {
        return n * 15 + n2;
    }

    public static final int getX(int n) {
        return x[n];
    }

    public static final int getY(int n) {
        return y[n];
    }

    public static final boolean valid(int n) {
        return x[n] >= 0;
    }

    public static final int[] neighbours(int n) {
        return neighs[n];
    }

    public static final boolean isPerimeter(int n) {
        int[] nArray = neighs[n];
        return nArray[nArray.length - 1] == -1;
    }

    static void allocateFree(FillerModel fillerModel, FillerPlayerSpace fillerPlayerSpace, int n, boolean[] blArray) {
        fillerPlayerSpace.resetListed();
        int[] nArray = fillerPlayerSpace.counted;
        boolean[] blArray2 = fillerPlayerSpace.listed;
        int[] nArray2 = fillerPlayerSpace.border;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 1425) {
            if (nArray[n3] == n || nArray[n3] == 2) {
                blArray2[n3] = true;
                nArray2[n2++] = n3;
            }
            ++n3;
        }
        int[] nArray3 = null;
        block4: while (n2 > 0) {
            int n4 = nArray2[--n2];
            switch (nArray[n4]) {
                case 0: 
                case 1: 
                case 2: 
                case 6: {
                    blArray[n4] = true;
                    nArray3 = neighs[n4];
                    int n5 = 0;
                    while (n5 < nArray3.length) {
                        int n6 = nArray3[n5];
                        if (n6 == -1) continue block4;
                        if (!blArray2[n6]) {
                            blArray2[n6] = true;
                            nArray2[n2++] = n6;
                        }
                        ++n5;
                    }
                    continue block4;
                }
            }
        }
    }

    protected static void allocate(FillerModel fillerModel, int n, FillerPlayerSpace fillerPlayerSpace, int n2, int n3) {
        int n4;
        int n5 = 7 - n3;
        int n6 = 10 - n2;
        fillerPlayerSpace.resetListed();
        int[] nArray = fillerPlayerSpace.counted;
        boolean[] blArray = fillerPlayerSpace.listed;
        int[] nArray2 = fillerPlayerSpace.border;
        int n7 = fillerModel.pieces[n];
        nArray[n] = n2;
        blArray[n] = true;
        int n8 = 0;
        int[] nArray3 = neighs[n];
        int n9 = 0;
        while (n9 < nArray3.length) {
            n4 = nArray3[n9];
            if (n4 == -1) break;
            blArray[n4] = true;
            nArray2[n8++] = n4;
            ++n9;
        }
        block1: while (n8 > 0) {
            int n10;
            int n11;
            int n12;
            if ((n12 = nArray[n4 = nArray2[--n8]]) != 0 && n12 != n5) continue;
            if (fillerModel.pieces[n4] == n7) {
                nArray[n4] = n2;
                nArray3 = neighs[n4];
                n11 = 0;
                while (n11 < nArray3.length) {
                    n10 = nArray3[n11];
                    if (n10 == -1) continue block1;
                    if (!blArray[n10]) {
                        blArray[n10] = true;
                        nArray2[n8++] = n10;
                    }
                    ++n11;
                }
                continue;
            }
            if (n12 == n5) {
                nArray[n4] = 2;
                continue;
            }
            nArray[n4] = n3;
            nArray3 = neighs[n4];
            n11 = 0;
            while (n11 < 6) {
                n10 = nArray3[n11];
                if (n10 == -1) continue block1;
                if (!blArray[n10] && fillerModel.pieces[n4] == fillerModel.pieces[n10] && nArray[n10] != n6) {
                    blArray[n10] = true;
                    nArray2[n8++] = n10;
                }
                ++n11;
            }
        }
    }

    static void allocateTypes(FillerModel fillerModel, int[] nArray, FillerPlayerSpace fillerPlayerSpace) {
        int[] nArray2 = fillerPlayerSpace.counted;
        boolean[] blArray = fillerPlayerSpace.reachable;
        boolean[] blArray2 = fillerPlayerSpace.hisReachable;
        fillerPlayerSpace.reset();
        fillerPlayerSpace.resetReachable();
        FillerModel.allocate(fillerModel, nArray[0], fillerPlayerSpace, 7, 6);
        FillerModel.allocate(fillerModel, nArray[1], fillerPlayerSpace, 3, 1);
        FillerModel.allocateFree(fillerModel, fillerPlayerSpace, 6, blArray);
        FillerModel.allocateFree(fillerModel, fillerPlayerSpace, 1, blArray2);
        int n = 0;
        while (n < blArray.length) {
            if (blArray[n]) {
                if (!blArray2[n]) {
                    nArray2[n] = nArray2[n] == 6 ? 9 : 4;
                } else if (nArray2[n] == 0) {
                    nArray2[n] = 8;
                }
            } else if (blArray2[n]) {
                nArray2[n] = nArray2[n] == 1 ? 10 : 5;
            }
            ++n;
        }
    }

    static void allocateDistance(FillerModel fillerModel, FillerPlayerSpace fillerPlayerSpace) {
        int n;
        int[] nArray = fillerPlayerSpace.counted;
        int[] nArray2 = fillerPlayerSpace.distance;
        int[] nArray3 = fillerPlayerSpace.border;
        int[] nArray4 = fillerModel.pieces;
        fillerPlayerSpace.resetListed();
        boolean[] blArray = fillerPlayerSpace.listed;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray2.length) {
            n = nArray[n3];
            if (!FillerModel.valid(n3)) {
                nArray2[n3] = -1;
            } else if (MUST_BE_MINE.get(n)) {
                nArray2[n3] = 0;
            } else if (MUST_BE_HIS.get(n)) {
                nArray2[n3] = -1;
            } else if (n == 6 || n == 2) {
                nArray2[n3] = 1;
                nArray3[n2++] = n3;
                blArray[n3] = true;
            } else {
                nArray2[n3] = -2;
            }
            ++n3;
        }
        block1: while (n2 > 0) {
            n = nArray3[--n2];
            blArray[n] = false;
            int n4 = nArray2[n];
            int[] nArray5 = neighs[n];
            int n5 = 0;
            while (n5 < nArray5.length) {
                int n6 = nArray5[n5];
                if (n6 == -1) continue block1;
                int n7 = nArray2[n6];
                if (n7 != -1 && n7 != 0) {
                    int n8;
                    int n9 = n8 = nArray4[n6] == nArray4[n] ? n4 : n4 + 1;
                    if (n7 == -2 || n8 < n7) {
                        nArray2[n6] = n8;
                        if (!blArray[n6]) {
                            nArray3[n2++] = n6;
                            blArray[n6] = true;
                        }
                    }
                }
                ++n5;
            }
        }
    }

    public FillerModel() {
        this.pieces = new int[1425];
    }

    public FillerModel(int[] nArray) {
        if (nArray.length != 1425) {
            throw new IllegalArgumentException("pieces wrong length");
        }
        this.pieces = (int[])nArray.clone();
    }

    void randomFill(boolean bl) {
        if (bl && !RemoteConnection.getInstance().isServer()) {
            try {
                IsMessage isMessage = RemoteConnection.getInstance().receiveMessage();
                if (isMessage.getMessageId() == 0) {
                    this.setPieces(((NewGameMessage)isMessage).getPieces());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            int n = 0;
            while (n < this.pieces.length) {
                this.pieces[n] = FillerModel.valid(n) ? rng.nextInt(9) : -1;
                ++n;
            }
            if (bl) {
                try {
                    NewGameMessage newGameMessage = new NewGameMessage(this.pieces);
                    RemoteConnection.getInstance().sendMessage(newGameMessage);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public int[] getPieces() {
        return this.pieces;
    }

    public void setPieces(int[] nArray) {
        if (nArray.length != 1425) {
            throw new IllegalArgumentException("pieces wrong length");
        }
        this.pieces = (int[])nArray.clone();
    }

    static {
        rng = new Random();
        MUST_BE_MINE = new BitSet(11);
        MUST_BE_HIS = new BitSet(11);
        MUST_BE_FREE = new BitSet(11);
        MUST_BE_FREE.set(1);
        MUST_BE_FREE.set(2);
        MUST_BE_HIS.set(3);
        MUST_BE_MINE.set(4);
        MUST_BE_HIS.set(5);
        MUST_BE_FREE.set(6);
        MUST_BE_MINE.set(7);
        MUST_BE_FREE.set(8);
        MUST_BE_MINE.set(9);
        MUST_BE_HIS.set(10);
        x = new int[1425];
        y = new int[1425];
        int n = 0;
        while (n < 1425) {
            if (n / 15 % 2 == 0 && n % 15 == 0) {
                FillerModel.x[n] = -1;
                FillerModel.y[n] = -1;
            } else {
                FillerModel.x[n] = n / 15;
                FillerModel.y[n] = n % 15;
            }
            ++n;
        }
        neighs = new int[1425][6];
        int n2 = 0;
        while (n2 < 1425) {
            if (x[n2] >= 0) {
                FillerModel.calcNeighbours(n2, neighs[n2]);
            }
            ++n2;
        }
    }
}

