/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __RANGE_CONSTRAINT_TYPE_HPP_INCLUDED
#define __RANGE_CONSTRAINT_TYPE_HPP_INCLUDED

#include "frontend/ast/TypeDeclaration.hpp"
#include "frontend/ast/DiscreteRange.hpp"

namespace ast {

//! one range constraint type.
/** This class represents one VHDL range constraint type.
 */
class RangeConstraintType : public TypeDeclaration {
public:
	//! c'tor
	/** @param declName name of the declared type.
          * @param range range constraint.
          * @param loc location of the declaration.
          */
	RangeConstraintType(
		std::string *declName,
		DiscreteRange *range,
		Location loc
		) : 	TypeDeclaration(declName, loc, BASE_TYPE_UNSET),
			constraint(range) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name != NULL);

		stream << "TYPE " << *this->name << ' ' << this->constraint;
	}


	/** the restriction */
	DiscreteRange *constraint;

protected:
	/** Destructor */
	virtual ~RangeConstraintType() {
		util::MiscUtil::terminate(constraint);
	}
};

}; /* namespace ast */

#endif /* __RANGE_CONSTRAINT_TYPE_HPP_INCLUDED */
