/*************************************************************************\
 * Copyright (c) 2002 The University of Chicago, as Operator of Argonne
 *     National Laboratory.
 * Copyright (c) 2002 The Regents of the University of California, as
 *     Operator of Los Alamos National Laboratory.
 * SPDX-License-Identifier: EPICS
 * EPICS BASE is distributed subject to a Software License Agreement found
 * in file LICENSE that is included with this distribution.
\*************************************************************************/

#ifndef INC_epicsSignal_H
#define INC_epicsSignal_H

#ifdef __cplusplus
extern "C" {
#endif

#include "libComAPI.h"

/** \file epicsSignal.h
 * \brief OS-independent routines for ignoring Posix signals
 *
 * The requests in this interface are typically ignored on OS that do not implement
 * POSIX signals.
 */

struct epicsThreadOSD;

/** Ignore the SIGHUP signal.
 * Required to avoid problems with soft IOCs getting SIGHUPs when a
 * Channel Access client disconnects
 */
LIBCOM_API void epicsStdCall epicsSignalInstallSigHupIgnore ( void );

/** Ignore the SIGPIPE signal.
 * Required to avoid terminating a process which is blocking in a
 * socket send() call when the SIGPIPE signal is generated by the OS.
 */
LIBCOM_API void epicsStdCall epicsSignalInstallSigPipeIgnore ( void );

/** Ignore the SIGALRM signal.
 * Required only if shutdown() and close() do not interrupt a thread blocking in
 * a socket system call
 */
LIBCOM_API void epicsStdCall epicsSignalInstallSigAlarmIgnore ( void );
/** Raise a SIGALRM signal to a specific epicsThread */
LIBCOM_API void epicsStdCall epicsSignalRaiseSigAlarm ( struct epicsThreadOSD * );

#ifdef __cplusplus
}
#endif

#endif /* INC_epicsSignal_H */
