/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Vector;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.server.JembossServer;

public class JembossFileServer {
    JembossParams jp = new JembossParams();

    public Vector embreo_roots(String user) {
        Vector<String> vans = new Vector<String>();
        vans.add("status");
        vans.add("0");
        vans.add("msg");
        vans.add("");
        vans.add("default-root");
        vans.add("HOME");
        vans.add("HOME");
        vans.add(this.jp.getResultsHome() + user);
        return vans;
    }

    private String getRoot(String s, String user) {
        String rt = null;
        Vector userRoots = this.embreo_roots(user);
        for (int i = 0; i < userRoots.size(); i += 2) {
            String root = (String)userRoots.get(i);
            if (!root.equalsIgnoreCase(s)) continue;
            return (String)userRoots.get(i + 1);
        }
        return rt;
    }

    public Vector directory_shortls(String options, String dirname, String user) {
        Vector<String> vans = new Vector<String>();
        int split = options.indexOf("=") + 1;
        File dir = new File(this.getRoot(options.substring(split), user) + "/" + dirname);
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File d, String n) {
                return !n.startsWith(".");
            }
        });
        String listAll = "";
        String listDir = "";
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    listDir = listDir.concat(files[i].getName() + "\n");
                }
                listAll = listAll.concat(files[i].getName() + "\n");
            }
        }
        vans.add("status");
        vans.add("0");
        vans.add("msg");
        vans.add("");
        vans.add("list");
        vans.add(listAll);
        vans.add("dirlist");
        vans.add(listDir);
        return vans;
    }

    public Vector get_file(String options, String filename, String user) {
        Vector<Object> vans = new Vector<Object>();
        int split = options.indexOf("=") + 1;
        String fullFileName = this.getRoot(options.substring(split), user) + "/" + filename;
        File file = new File(fullFileName);
        byte[] data = JembossServer.readByteFile(fullFileName);
        vans.add("contents");
        vans.add(data);
        vans.add("status");
        vans.add(data == null ? "1" : "0");
        vans.add("msg");
        vans.add("");
        return vans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector put_file(String options, String filename, byte[] filedata, String user) {
        Vector<String> vans = new Vector<String>();
        int split = options.indexOf("=") + 1;
        File f = new File(this.getRoot(options.substring(split), user) + "/" + filename);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            out.write(filedata);
            vans.add("status");
            vans.add("0");
        }
        catch (IOException ioe) {
            vans.add("status");
            vans.add("1");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        vans.add("msg");
        vans.add("");
        return vans;
    }

    public Vector mkdir(String options, String dirname, String userName) {
        Vector<String> vans = new Vector<String>();
        int split = options.indexOf("=") + 1;
        String fullDirname = this.getRoot(options.substring(split), userName) + "/" + dirname;
        File dir = new File(fullDirname);
        boolean ok = dir.mkdir();
        vans.add("msg");
        if (ok) {
            vans.add("");
        } else {
            vans.add("NOT OK");
        }
        return vans;
    }

    public Vector delFile(String options, String filename, String userName) {
        Vector<String> vans = new Vector<String>();
        int split = options.indexOf("=") + 1;
        String fullname = this.getRoot(options.substring(split), userName) + "/" + filename;
        File fn = new File(fullname);
        vans.add("msg");
        if (fn.delete()) {
            vans.add("");
        } else {
            vans.add("NOT OK");
        }
        return vans;
    }

    public Vector delDir(String options, String filename, String userName) {
        Vector<String> vans = new Vector<String>();
        boolean success = true;
        int split = options.indexOf("=") + 1;
        String fullname = this.getRoot(options.substring(split), userName) + "/" + filename;
        File dir = new File(fullname);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            success &= files[i].delete();
        }
        vans.add("msg");
        if (success &= dir.delete()) {
            vans.add("");
        } else {
            vans.add("NOT OK");
        }
        return vans;
    }

    public Vector rename(String options, String oldfile, String newfile, String userName) {
        Vector<String> vans = new Vector<String>();
        int split = options.indexOf("=") + 1;
        String oldname = this.getRoot(options.substring(split), userName) + "/" + oldfile;
        File fnOld = new File(oldname);
        File fnNew = new File(newfile);
        boolean ok = fnOld.renameTo(fnNew);
        vans.add("msg");
        if (ok) {
            vans.add("");
        } else {
            vans.add("NOT OK");
        }
        return vans;
    }
}

