import { Mixin } from 'ts-mixer';
import { BREAK } from '@swagger-api/apidom-core';
import StepSuccessCriteriaElement from "../../../../elements/nces/StepSuccessCriteria.mjs";
import SpecificationVisitor from "../../SpecificationVisitor.mjs";
import FallbackVisitor from "../../FallbackVisitor.mjs";
class SuccessCriteriaVisitor extends Mixin(SpecificationVisitor, FallbackVisitor) {
  constructor(options) {
    super(options);
    this.element = new StepSuccessCriteriaElement();
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const specPath = ['document', 'objects', 'Criterion'];
      const element = this.toRefractedElement(specPath, item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return BREAK;
  }
}
export default SuccessCriteriaVisitor;