/*#############################################################################
#                                                                             #
# fireperf - A network benchmarking tool                                      #
# Copyright (C) 2021 IPFire Development Team                                  #
#                                                                             #
# This program is free software: you can redistribute it and/or modify        #
# it under the terms of the GNU General Public License as published by        #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# This program is distributed in the hope that it will be useful,             #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with this program.  If not, see <http://www.gnu.org/licenses/>.       #
#                                                                             #
#############################################################################*/

#ifndef FIREPERF_RANDOM_H
#define FIREPERF_RANDOM_H

#include "main.h"

struct fireperf_random_pool {
	char* data;
	size_t size;
};

struct fireperf_random_pool* fireperf_random_pool_create(
	struct fireperf_config* conf, size_t size);
void fireperf_random_pool_free(struct fireperf_random_pool* pool);

const char* fireperf_random_pool_get_slice(struct fireperf_random_pool* pool, size_t size);

#endif /* FIREPERF_RANDOM_H */
