/*#############################################################################
#                                                                             #
# fireperf - A network benchmarking tool                                      #
# Copyright (C) 2021 IPFire Development Team                                  #
#                                                                             #
# This program is free software: you can redistribute it and/or modify        #
# it under the terms of the GNU General Public License as published by        #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# This program is distributed in the hope that it will be useful,             #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with this program.  If not, see <http://www.gnu.org/licenses/>.       #
#                                                                             #
#############################################################################*/

#ifndef FIREPERF_MAIN_H
#define FIREPERF_MAIN_H

#include <netinet/in.h>
#include <time.h>

#define DEFAULT_KEEPALIVE_COUNT     3
#define DEFAULT_KEEPALIVE_INTERVAL  10
#define DEFAULT_LOG_LEVEL LOG_INFO
#define DEFAULT_PARALLEL 1
#define DEFAULT_PORT 5001
#define DEFAULT_LISTENING_SOCKETS 1
#define DEFAULT_RANDOM_POOL_SIZE	(SOCKET_SEND_BUFFER_SIZE * 512)

#define MAX_PARALLEL (1 << 20)

// Socket buffer configuration
#define SOCKET_BUFFER_SIZE      (64 * 1024)
#define SOCKET_RECV_BUFFER_SIZE SOCKET_BUFFER_SIZE
#define SOCKET_SEND_BUFFER_SIZE SOCKET_BUFFER_SIZE

#define EPOLL_MAX_EVENTS 128

// Forward declaration
struct fireperf_random_pool;

struct fireperf_config {
	int terminated;
	int loglevel;
	enum {
		FIREPERF_MODE_NONE = 0,
		FIREPERF_MODE_CLIENT,
		FIREPERF_MODE_SERVER,
	} mode;
	struct in6_addr address;
	int duplex;
	int keepalive_only;
	int keepalive_count;
	int keepalive_interval;
	struct fireperf_random_pool* pool;
	int port;
	unsigned int listening_sockets;
	unsigned long parallel;
	unsigned int timeout;
	int close;
	int zero;
};

// Struct to collect statistics
struct fireperf_stats {
	struct timespec last_printed;

	// Total number of open connections
	unsigned int open_connections;

	// New connections
	unsigned int connections;

	// Total transferred data
	size_t bytes_received;
	size_t total_bytes_received;
	size_t bytes_sent;
	size_t total_bytes_sent;
};

int fireperf_dump_stats(struct fireperf_config* conf, struct fireperf_stats* stats, int mode);

int set_socket_buffer_sizes(struct fireperf_config* conf, int fd);

int handle_connection_send(struct fireperf_config* conf,
		struct fireperf_stats* stats, int fd);
int handle_connection_recv(struct fireperf_config* conf,
		struct fireperf_stats* stats, int fd);

#endif /* FIREPERF_MAIN_H */
