/*#############################################################################
#                                                                             #
# fireperf - A network benchmarking tool                                      #
# Copyright (C) 2021 IPFire Development Team                                  #
#                                                                             #
# This program is free software: you can redistribute it and/or modify        #
# it under the terms of the GNU General Public License as published by        #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# This program is distributed in the hope that it will be useful,             #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with this program.  If not, see <http://www.gnu.org/licenses/>.       #
#                                                                             #
#############################################################################*/

#include <stdarg.h>
#include <stdio.h>
#include <syslog.h>

#include "logging.h"
#include "main.h"

int fireperf_get_log_level(struct fireperf_config* conf) {
	return conf->loglevel;
}

static void fireperf_log_console(struct fireperf_config* conf, int priority,
		const char* file, int line, const char* fn, const char* format, va_list args) {
	switch (priority) {
		// Print error messages to stderr
		case LOG_ERR:
			vfprintf(stderr, format, args);
			break;

		// Otherwise print to stdout
		default:
			vprintf(format, args);
			break;
	}
}

void fireperf_log(struct fireperf_config* conf, int priority,
		const char* file, int line, const char* fn, const char* format, ...) {
	va_list args;

	va_start(args, format);
	fireperf_log_console(conf, priority, file, line, fn, format, args);
	va_end(args);
}
