/*#############################################################################
#                                                                             #
# fireperf - A network benchmarking tool                                      #
# Copyright (C) 2021 IPFire Development Team                                  #
#                                                                             #
# This program is free software: you can redistribute it and/or modify        #
# it under the terms of the GNU General Public License as published by        #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# This program is distributed in the hope that it will be useful,             #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with this program.  If not, see <http://www.gnu.org/licenses/>.       #
#                                                                             #
#############################################################################*/

#ifndef FIREPERF_LOGGING_H
#define FIREPERF_LOGGING_H

#include <syslog.h>

#include "main.h"

static inline void __attribute__((always_inline, format(printf, 2, 3)))
	fireperf_log_null(struct fireperf_config* conf, const char* format, ...) {}

#define fireperf_log_cond(conf, prio, arg...) \
	do { \
		if (fireperf_get_log_level(conf) >= prio) \
			fireperf_log(conf, prio, __FILE__, __LINE__, __FUNCTION__, ## arg); \
	} while (0)


#ifdef ENABLE_DEBUG
#  define DEBUG(conf, arg...) fireperf_log_cond(conf, LOG_DEBUG, ## arg)
#else
#  define DEBUG(conf, arg...) fireperf_log_null(conf, ## arg)
#endif

#define INFO(conf, arg...) fireperf_log_cond(conf, LOG_INFO, ## arg)
#define ERROR(conf, arg...) fireperf_log_cond(conf, LOG_ERR, ## arg)

int fireperf_get_log_level(struct fireperf_config* conf);

void fireperf_log(struct fireperf_config* config,
	int priority, const char* file, int line, const char* fn,
	const char* format, ...) __attribute__((format(printf, 6, 7)));

#endif /* FIREPERF_LOGGING_H */
