#!/usr/bin/python

import _fireinfo

class Hypervisor(object):
	def __init__(self):
		self.__info = _fireinfo.get_hypervisor()

	@property
	def vendor(self):
		"""
			Returns the name of the hypervisor vendor.
		"""
		if not self.virtual:
			return None

		# If the script already returned a hypervisor, we return the name.
		if self.__info["hypervisor"]:
			return self.__info["hypervisor"]

		# XXX fill in some code to detect hypervisors, that do
		# not say their name. 

		return "unknown"

	@property
	def type(self):
		"""
			Returns if the host is running in full virt mode or
			if it is running in a paravirtualized environment.
		"""
		if not self.virtual:
			return None

		return self.__info["virtype"]

	@property
	def virtual(self):
		"""
			Returns true if the host is running in a virtual environment.
			Otherwise: false.
		"""
		return _fireinfo.is_virtualized()


if __name__ == "__main__":
	h = Hypervisor()

	print "Vendor:", h.vendor
	print "Type:", h.type
	print "Virtual:", h.virtual
