#!/usr/bin/python

import os

import _fireinfo

PROC_CPUINFO = "/proc/cpuinfo"
SYS_CLASS_CPUID = "/sys/class/cpuid/cpu%d"

class CPU(object):
	__cpuinfo = {}

	def __init__(self):
		self.read_cpuinfo()

	def read_cpuinfo(self):
		"""
			Read information from PROC_CPUINFO and store
			it into a dictionary self.__cpuinfo.
		"""
		f = open(PROC_CPUINFO)
		while True:
			line = f.readline()

			if not line:
				break

			try:
				key, val = line.split(":", 1)
			except ValueError:
				# We got a line without key, pass that.
				pass

			key = key.strip().replace(" ", "_")
			val = val.strip()

			self.__cpuinfo[key] = val

		f.close()

	@property
	def bogomips(self):
		return float(self.__cpuinfo["bogomips"])

	@property
	def model(self):
		return int(self.__cpuinfo["model"])

	@property
	def model_string(self):
		return self.__cpuinfo["model_name"]

	@property
	def vendor(self):
		return self.__cpuinfo["vendor_id"]

	@property
	def stepping(self):
		return int(self.__cpuinfo["stepping"])

	@property
	def flags(self):
		return self.__cpuinfo["flags"].split()

	@property
	def speed(self):
		return float(self.__cpuinfo["cpu_MHz"])

	@property
	def family(self):
		return int(self.__cpuinfo["cpu_family"])
	
	@property
	def count(self):
		"""
			Count number of CPUs (cores).
		"""
		i = 0
		while (os.path.exists(SYS_CLASS_CPUID % i)):
			i += 1
		return i


if __name__ == "__main__":
	c = CPU()

	print "Vendor:", c.vendor
	print "Model:", c.model
	print "Stepping:", c.stepping
	print "Flags:", c.flags
	print "Bogomips:", c.bogomips
	print "Speed:", c.speed
	print "Hypervisor:", c.hypervisor
	print "Virtype:", c.virtype
	print "Family:", c.family
	print "Count:", c.count
	print "Model string:", c.model_string
