#!/usr/bin/python
###############################################################################
#                                                                             #
# collecty - A system statistics collection daemon for IPFire                 #
# Copyright (C) 2012 IPFire development team                                  #
#                                                                             #
# This program is free software: you can redistribute it and/or modify        #
# it under the terms of the GNU General Public License as published by        #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# This program is distributed in the hope that it will be useful,             #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with this program.  If not, see <http://www.gnu.org/licenses/>.       #
#                                                                             #
###############################################################################

from base import Timer

import cpu
import entropy
import interface
import latency
import loadavg
import memory

data_sources = [
	cpu.DataSourceCPU,
	entropy.DataSourceEntropy,
	interface.DataSourceInterface,
	latency.DataSourceLatency,
	loadavg.DataSourceLoadAvg,
	memory.DataSourceMemory,
]

# Generate graph templates list.
graph_templates = []
for ds in data_sources:
	graph_templates += ds.templates
