# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_USE_PEP517=hatchling
PYTHON_COMPAT=( pypy3_11 python3_{11..13} )

inherit distutils-r1 pypi

DESCRIPTION="Pytest plugin for testing Jupyter libraries and extensions"
HOMEPAGE="
	https://jupyter.org/
	https://github.com/jupyter-server/pytest-jupyter/
	https://pypi.org/project/pytest-jupyter/
"

LICENSE="BSD"
SLOT="0"
KEYWORDS="~amd64 ~arm ~arm64 ~loong ~ppc ~ppc64 ~riscv ~s390 ~sparc ~x86"

RDEPEND="
	>=dev-python/ipykernel-6.14[${PYTHON_USEDEP}]
	>=dev-python/jupyter-client-7.4.0[${PYTHON_USEDEP}]
	>=dev-python/jupyter-core-5.7[${PYTHON_USEDEP}]
	>=dev-python/jupyter-server-1.21[${PYTHON_USEDEP}]
	>=dev-python/nbformat-5.3[${PYTHON_USEDEP}]
	>=dev-python/pytest-7[${PYTHON_USEDEP}]
"

EPYTEST_PLUGINS=( pytest-timeout )
distutils_enable_tests pytest
