# Copyright 2025-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.5

EAPI=8

CRATES="
	adler2@2.0.0
	aho-corasick@1.1.3
	anyhow@1.0.96
	arc-swap@1.7.1
	ashpd@0.11.0
	async-broadcast@0.7.2
	async-channel@2.3.1
	async-executor@1.13.1
	async-fs@2.1.2
	async-io@2.4.0
	async-lock@3.4.0
	async-net@2.0.0
	async-process@2.3.0
	async-recursion@1.1.1
	async-signal@0.2.10
	async-task@4.7.1
	async-trait@0.1.86
	atomic-waker@1.1.2
	autocfg@1.4.0
	bitflags@1.3.2
	bitflags@2.8.0
	block@0.1.6
	blocking@1.6.1
	bytemuck@1.21.0
	byteorder@1.5.0
	cairo-rs@0.20.7
	cairo-sys-rs@0.20.7
	cc@1.2.16
	cfg-expr@0.17.2
	cfg-if@1.0.0
	cfg_aliases@0.2.1
	chrono@0.4.40
	concurrent-queue@2.5.0
	crc32fast@1.4.2
	crossbeam-utils@0.8.21
	displaydoc@0.2.5
	dlib@0.5.2
	dunce@1.0.5
	endi@1.1.0
	enumflags2@0.7.11
	enumflags2_derive@0.7.11
	env_filter@0.1.3
	env_logger@0.11.6
	equivalent@1.0.2
	errno@0.3.10
	event-listener-strategy@0.5.3
	event-listener@5.4.0
	fastrand@2.3.0
	field-offset@0.3.6
	flate2@1.1.0
	foreign-types-macros@0.2.3
	foreign-types-shared@0.3.1
	foreign-types@0.5.0
	form_urlencoded@1.2.1
	futures-channel@0.3.31
	futures-core@0.3.31
	futures-executor@0.3.31
	futures-io@0.3.31
	futures-lite@2.6.0
	futures-macro@0.3.31
	futures-task@0.3.31
	futures-timer@3.0.3
	futures-util@0.3.31
	gdk-pixbuf-sys@0.20.7
	gdk-pixbuf@0.20.9
	gdk4-sys@0.9.6
	gdk4-wayland-sys@0.9.6
	gdk4-wayland@0.9.6
	gdk4-x11-sys@0.9.6
	gdk4-x11@0.9.6
	gdk4@0.9.6
	getrandom@0.3.1
	gettext-rs@0.7.2
	gettext-sys@0.22.5
	gio-sys@0.20.9
	gio@0.20.9
	glib-macros@0.20.7
	glib-sys@0.20.9
	glib@0.20.9
	glycin-utils@3.0.1
	glycin@2.1.1
	gobject-sys@0.20.9
	graphene-rs@0.20.9
	graphene-sys@0.20.7
	gsk4-sys@0.9.6
	gsk4@0.9.6
	gtk4-macros@0.9.5
	gtk4-sys@0.9.6
	gtk4@0.9.6
	gufo-common@0.2.0
	gufo-exif@0.2.0
	gufo-jpeg@0.2.0
	gufo-png@0.2.0
	gufo-tiff@0.2.0
	gufo-webp@0.2.0
	gufo-xmp@0.2.0
	gufo@0.2.0
	gvdb-macros@0.1.14
	gvdb@0.8.0
	gweather-sys@4.5.0
	hashbrown@0.15.2
	heck@0.5.0
	hermit-abi@0.4.0
	hex@0.4.3
	humantime@2.1.0
	icu_collections@1.5.0
	icu_locid@1.5.0
	icu_locid_transform@1.5.0
	icu_locid_transform_data@1.5.0
	icu_normalizer@1.5.0
	icu_normalizer_data@1.5.0
	icu_properties@1.5.1
	icu_properties_data@1.5.0
	icu_provider@1.5.0
	icu_provider_macros@1.5.0
	idna@1.0.3
	idna_adapter@1.2.0
	indexmap@2.7.1
	itoa@1.0.14
	jobserver@0.1.32
	lazy_static@1.5.0
	lcms2-sys@4.0.5
	lcms2@6.1.0
	libadwaita-sys@0.7.1
	libadwaita@0.7.1
	libc@0.2.170
	libgweather@4.5.0
	libloading@0.8.6
	libseccomp-sys@0.2.1
	libseccomp@0.3.0
	linux-raw-sys@0.4.15
	litemap@0.7.5
	litrs@0.4.1
	locale_config@0.3.0
	log@0.4.26
	malloc_buf@0.0.6
	matchers@0.1.0
	memchr@2.7.4
	memfd@0.6.4
	memmap2@0.9.5
	memoffset@0.9.1
	miniz_oxide@0.8.5
	nix@0.29.0
	nu-ansi-term@0.46.0
	num-traits@0.2.19
	objc-foundation@0.1.1
	objc@0.2.7
	objc_id@0.1.1
	once_cell@1.20.3
	ordered-stream@0.2.0
	overload@0.1.1
	pango-sys@0.20.9
	pango@0.20.9
	parking@2.2.1
	paste@1.0.15
	percent-encoding@2.3.1
	pin-project-lite@0.2.16
	pin-utils@0.1.0
	piper@0.2.4
	pkg-config@0.3.31
	polling@3.7.4
	ppv-lite86@0.2.20
	proc-macro-crate@3.2.0
	proc-macro2@1.0.93
	quick-xml@0.37.2
	quote@1.0.38
	rand@0.9.0
	rand_chacha@0.9.0
	rand_core@0.9.2
	regex-automata@0.1.10
	regex-automata@0.4.9
	regex-syntax@0.6.29
	regex-syntax@0.8.5
	regex@1.11.1
	rmp-serde@1.3.0
	rmp@0.8.14
	rustc_version@0.4.1
	rustix@0.38.44
	rustversion@1.0.19
	ryu@1.0.19
	same-file@1.0.6
	semver@1.0.25
	serde@1.0.218
	serde_derive@1.0.218
	serde_json@1.0.139
	serde_repr@0.1.19
	serde_spanned@0.6.8
	sharded-slab@0.1.7
	shlex@1.3.0
	signal-hook-registry@1.4.2
	slab@0.4.9
	smallvec@1.14.0
	stable_deref_trait@1.2.0
	static_assertions@1.1.0
	strum@0.27.1
	strum_macros@0.27.1
	syn@2.0.98
	synstructure@0.13.1
	system-deps@7.0.3
	target-lexicon@0.12.16
	temp-dir@0.1.14
	tempfile@3.17.1
	thiserror-impl@2.0.11
	thiserror@2.0.11
	thread_local@1.1.8
	tinystr@0.7.6
	toml@0.8.20
	toml_datetime@0.6.8
	toml_edit@0.22.24
	tracing-attributes@0.1.28
	tracing-core@0.1.33
	tracing-log@0.2.0
	tracing-subscriber@0.3.19
	tracing@0.1.41
	uds_windows@1.1.0
	unicode-ident@1.0.17
	url@2.5.4
	utf16_iter@1.0.5
	utf8_iter@1.0.4
	valuable@0.1.1
	version-compare@0.2.0
	walkdir@2.5.0
	wasi@0.13.3+wasi-0.2.2
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.9
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-sys@0.59.0
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.52.6
	winnow@0.7.3
	wit-bindgen-rt@0.33.0
	write16@1.0.0
	writeable@0.5.5
	xdg-home@1.3.0
	xml-rs@0.8.25
	yeslogic-fontconfig-sys@6.0.0
	yoke-derive@0.7.5
	yoke@0.7.5
	zbus@5.5.0
	zbus_macros@5.5.0
	zbus_names@4.2.0
	zerocopy-derive@0.7.35
	zerocopy-derive@0.8.21
	zerocopy@0.7.35
	zerocopy@0.8.21
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zerovec-derive@0.10.3
	zerovec@0.10.4
	zvariant@5.4.0
	zvariant_derive@5.4.0
	zvariant_utils@3.2.0
"

RUST_MIN_VER="1.81"

inherit cargo gnome.org gnome2 meson xdg

DESCRIPTION="View images"
HOMEPAGE="https://apps.gnome.org/Loupe"

# SRC_URI for loupe is set by gnome.org eclass.
SRC_URI+=" ${CARGO_CRATE_URIS}"

LICENSE="GPL-3+"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Apache-2.0-with-LLVM-exceptions ISC MIT Unicode-3.0
	|| ( LGPL-2.1+ MPL-2.0 )
"
SLOT="0"
KEYWORDS="~amd64"

IUSE="X heif gif jpeg jpegxl svg tiff wayland"

BDEPEND="
	dev-util/itstool
	virtual/pkgconfig
"
# sys-crates in pycargoebuild order
DEPEND="
	x11-libs/cairo[X?]
	>x11-libs/gdk-pixbuf-2.42.10-r1[gif?,jpeg?,tiff?]
	dev-libs/glib:2
	sys-devel/gettext
	media-libs/graphene
	x11-libs/pango[X?]
	media-libs/fontconfig
"
# meson.build file
DEPEND+="
	>=gui-libs/gtk-4.16.0:4[X?,wayland?]
	>=gui-libs/libadwaita-1.7_beta:1
	>=dev-libs/libgweather-4.0.0:4=
	>=media-libs/lcms-2.12.0:2[jpeg?,tiff?]
	>=sys-libs/libseccomp-2.5.0
"
RDEPEND="${DEPEND}
	media-libs/glycin-loaders:1[heif?,jpegxl?,svg?]
"

QA_FLAGS_IGNORED="usr/bin/loupe"

src_configure() {
	local emesonargs=(
		$(meson_feature X x11)
	)
	meson_src_configure
	ln -s "${CARGO_HOME}" "${BUILD_DIR}/cargo-home" || die
}

pkg_preinst() {
	xdg_pkg_preinst
}

pkg_postinst() {
	xdg_pkg_postinst
	gnome2_schemas_update
}

pkg_postrm() {
	xdg_pkg_postrm
	gnome2_schemas_update
}
