/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class StringLength
extends Function {
    public String getName() {
        return "string-length";
    }

    public int getDataType() {
        return 2;
    }

    public Expression simplify() throws XPathException {
        int n = this.checkArgumentCount(0, 1);
        if (n == 1) {
            this.argument[0] = this.argument[0].simplify();
            if (this.argument[0] instanceof Value) {
                return this.evaluate(null);
            }
        }
        return this;
    }

    public double evaluateAsNumber(Context context) throws XPathException {
        if (this.getNumberOfArguments() == 1) {
            return StringValue.getLength(this.argument[0].evaluateAsString(context));
        }
        return StringValue.getLength(context.getContextNodeInfo().getStringValue());
    }

    public Value evaluate(Context context) throws XPathException {
        return new NumericValue(this.evaluateAsNumber(context));
    }

    public int getDependencies() {
        if (this.getNumberOfArguments() == 1) {
            return this.argument[0].getDependencies();
        }
        return 8;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        if (this.getNumberOfArguments() == 1) {
            StringLength stringLength = new StringLength();
            stringLength.addArgument(this.argument[0].reduce(n, context));
            stringLength.setStaticContext(this.getStaticContext());
            return stringLength.simplify();
        }
        if ((n & 8) != 0) {
            return this.evaluate(context);
        }
        return this;
    }
}

