# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_USE_PEP517=setuptools
# PYTHON_COMPAT is used only for testing
PYTHON_COMPAT=( pypy3_11 python3_{11..14} )
PYTHON_REQ_USE="ssl(+),threads(+)"

inherit distutils-r1

MY_P=${P#ensurepip-}
DESCRIPTION="Shared pip wheel for ensurepip Python module"
HOMEPAGE="
	https://pip.pypa.io/en/stable/
	https://pypi.org/project/pip/
	https://github.com/pypa/pip/
"
SRC_URI="
	https://github.com/pypa/pip/archive/${PV}.tar.gz -> ${MY_P}.gh.tar.gz
"
S=${WORKDIR}/${MY_P}

LICENSE="MIT"
SLOT="0"
KEYWORDS="~alpha amd64 arm arm64 hppa ~loong ~m68k ~mips ppc ppc64 ~riscv ~s390 sparc x86 ~amd64-linux ~x86-linux ~arm64-macos ~ppc-macos ~x64-macos ~x64-solaris"
IUSE="test test-rust"
RESTRICT="!test? ( test )"

BDEPEND="
	${RDEPEND}
	test? (
		<dev-python/ensurepip-setuptools-80
		dev-python/ensurepip-wheel
		dev-python/freezegun[${PYTHON_USEDEP}]
		dev-python/pretend[${PYTHON_USEDEP}]
		dev-python/scripttest[${PYTHON_USEDEP}]
		dev-python/virtualenv[${PYTHON_USEDEP}]
		dev-python/werkzeug[${PYTHON_USEDEP}]
		dev-python/wheel[${PYTHON_USEDEP}]
		test-rust? (
			dev-python/cryptography[${PYTHON_USEDEP}]
		)
		dev-vcs/git
	)
"

EPYTEST_PLUGINS=( pytest-rerunfailures )
EPYTEST_XDIST=1
distutils_enable_tests pytest

declare -A VENDOR_LICENSES=(
	[cachecontrol]=Apache-2.0
	[certifi]=MPL-2.0
	[dependency_groups]=MIT
	[distlib]=PSF-2
	[distro]=Apache-2.0
	[idna]=BSD
	[msgpack]=Apache-2.0
	[packaging]="|| ( Apache-2.0 MIT )"
	[pkg_resources]=MIT
	[platformdirs]=MIT
	[pygments]=BSD-2
	[pyproject_hooks]=MIT
	[requests]=Apache-2.0
	[resolvelib]=ISC
	[rich]=MIT
	[tomli]=MIT
	[tomli_w]=MIT
	[truststore]=MIT
	[urllib3]=MIT
	[typing_extensions.py]=PSF-2
)
LICENSE+=" ${VENDOR_LICENSES[*]}"

python_prepare_all() {
	local PATCHES=(
		"${FILESDIR}/pip-23.1-no-coverage.patch"
	)

	distutils-r1_python_prepare_all

	if use test; then
		local wheels=(
			"${BROOT}"/usr/lib/python/ensurepip/{setuptools,wheel}-*.whl
		)
		mkdir tests/data/common_wheels/ || die
		cp "${wheels[@]}" tests/data/common_wheels/ || die
	fi

	# Verify that we've covered licenses for all vendored packages
	cd src/pip/_vendor || die
	local packages=( */ [A-Za-z]*.py )
	local pkg missing=()
	for pkg in "${packages[@]%/}"; do
		if [[ ! -v "VENDOR_LICENSES[${pkg}]" ]]; then
			missing+=( "${pkg}" )
		else
			unset "VENDOR_LICENSES[${pkg}]"
		fi
	done

	if [[ ${missing[@]} || ${VENDOR_LICENSES[@]} ]]; then
		[[ ${missing[@]} ]] &&
			eerror "License missing for packages: ${missing[*]}"
		[[ ${VENDOR_LICENSES[@]} ]] &&
			eerror "Vendored packages removed: ${!VENDOR_LICENSES[*]}"
		die "VENDOR_LICENSES outdated"
	fi

	local upstream_count=$(wc -l < vendor.txt || die)
	if [[ ${#packages[@]} -ne ${upstream_count} ]]; then
		eerror "VENDOR_LICENSES: ${#packages[@]}"
		eerror "vendor.txt:      ${upstream_count}"
		die "Not all vendored packages matched"
	fi
}

python_test() {
	local EPYTEST_DESELECT=(
		tests/functional/test_inspect.py::test_inspect_basic
		# Internet
		tests/functional/test_config_settings.py::test_backend_sees_config_via_sdist
		tests/functional/test_install.py::test_double_install_fail
		tests/functional/test_install.py::test_install_sdist_links
		tests/functional/test_install_config.py::test_prompt_for_keyring_if_needed
		tests/functional/test_lock.py::test_lock_archive
		tests/functional/test_lock.py::test_lock_vcs
		# broken by system site-packages use
		tests/functional/test_freeze.py::test_freeze_with_setuptools
		tests/functional/test_pip_runner_script.py::test_runner_work_in_environments_with_no_pip
		tests/functional/test_uninstall.py::test_basic_uninstall_distutils
		tests/unit/test_base_command.py::test_base_command_global_tempdir_cleanup
		tests/unit/test_base_command.py::test_base_command_local_tempdir_cleanup
		tests/unit/test_base_command.py::test_base_command_provides_tempdir_helpers
	)
	local EPYTEST_IGNORE=(
		# requires proxy.py
		tests/functional/test_proxy.py
	)

	case ${EPYTHON} in
		pypy3*)
			EPYTEST_DESELECT+=(
				# unexpected tempfiles?
				tests/functional/test_install_config.py::test_do_not_prompt_for_authentication
				tests/functional/test_install_config.py::test_prompt_for_authentication
			)
			;;
		python3.14*)
			EPYTEST_DESELECT+=(
				# TODO: segfaults
				tests/unit/test_collector.py::test_get_index_content_directory_append_index
				# https://github.com/python/cpython/issues/125974
				tests/unit/test_collector.py::test_ensure_quoted_url
				tests/unit/test_finder.py::test_finder_priority_file_over_page
				tests/unit/test_urls.py::test_path_to_url_unix
				tests/unit/test_collector.py::test_clean_url_path
				tests/unit/test_collector.py::test_clean_url_path_with_local_path
				tests/unit/test_req.py::TestRequirementSet::test_download_info_local_editable_dir
				tests/unit/test_req.py::test_parse_editable_local
				tests/unit/test_req.py::test_parse_editable_local_extras
				tests/unit/test_req.py::test_get_url_from_path__archive_file
				tests/unit/test_req.py::test_get_url_from_path__installable_dir
				tests/functional/test_lock.py::test_lock_wheel_from_findlinks
				tests/functional/test_lock.py::test_lock_sdist_from_findlinks
				tests/functional/test_lock.py::test_lock_local_editable_with_dep
			)
			;;
	esac

	if ! has_version "dev-python/cryptography[${PYTHON_USEDEP}]"; then
		EPYTEST_DESELECT+=(
			tests/functional/test_install.py::test_install_sends_client_cert
			tests/functional/test_install_config.py::test_do_not_prompt_for_authentication
			tests/functional/test_install_config.py::test_prompt_for_authentication
			tests/functional/test_install_config.py::test_prompt_for_keyring_if_needed
		)
	fi

	local -x PIP_DISABLE_PIP_VERSION_CHECK=1
	# rerunfailures because test suite breaks if packages are installed
	# in parallel
	epytest -m "not network" -o tmp_path_retention_policy=all \
		--reruns=5 --use-venv
}

src_install() {
	if [[ ${DISTUTILS_WHEEL_PATH} != *py3-none-any.whl ]]; then
		die "Non-pure wheel produced?! ${DISTUTILS_WHEEL_PATH}"
	fi
	# TODO: compress it?
	insinto /usr/lib/python/ensurepip
	doins "${DISTUTILS_WHEEL_PATH}"
}
