# This file has been autogenerated by the pywayland scanner

# Copyright © 2022 Kenny Levinsen
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class WpFractionalScaleV1(Interface):
    """Fractional scale interface to a :class:`~pywayland.protocol.wayland.WlSurface`

    An additional interface to a :class:`~pywayland.protocol.wayland.WlSurface`
    object which allows the compositor to inform the client of the preferred
    scale.
    """

    name = "wp_fractional_scale_v1"
    version = 1


class WpFractionalScaleV1Proxy(Proxy[WpFractionalScaleV1]):
    interface = WpFractionalScaleV1

    @WpFractionalScaleV1.request()
    def destroy(self) -> None:
        """Remove surface scale information for surface

        Destroy the fractional scale object. When this object is destroyed,
        preferred_scale events will no longer be sent.
        """
        self._marshal(0)
        self._destroy()


class WpFractionalScaleV1Resource(Resource):
    interface = WpFractionalScaleV1

    @WpFractionalScaleV1.event(
        Argument(ArgumentType.Uint),
    )
    def preferred_scale(self, scale: int) -> None:
        """Notify of new preferred scale

        Notification of a new preferred scale for this surface that the
        compositor suggests that the client should use.

        The sent scale is the numerator of a fraction with a denominator of
        120.

        :param scale:
            the new preferred scale
        :type scale:
            `ArgumentType.Uint`
        """
        self._post_event(0, scale)


class WpFractionalScaleV1Global(Global):
    interface = WpFractionalScaleV1


WpFractionalScaleV1._gen_c()
WpFractionalScaleV1.proxy_class = WpFractionalScaleV1Proxy
WpFractionalScaleV1.resource_class = WpFractionalScaleV1Resource
WpFractionalScaleV1.global_class = WpFractionalScaleV1Global
