________________________________________________________________________

Notes on supported backend Prolog compilers  
Last updated on January 30, 2021

This file is part of Logtalk <https://logtalk.org/>  
Copyright 1998-2021 Paulo Moura <pmoura@logtalk.org>  
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
________________________________________________________________________


This file contains some notes about the adapter files provided. The folder
`unsupported` contains adapter files for Prolog compilers that are not yet
or no longer officially supported.

If you improve or correct some of these files, or write new ones for other
Prolog compilers, please send me a copy. It is simply not feasible to 
individually test Logtalk under all possible combinations of compatible
Prolog versions and operating-system versions.

As a general rule, always try to use the latest version of your Prolog 
compiler of choice. For Prolog compilers with long release cycles, this 
may require use of development versions. Most Prolog compilers are moving 
towards better compatibility with de facto and official standards and thus
improved Logtalk compatibility. Also, visit the issue tracker on the Logtalk
development website and check for any known Prolog compiler bugs that break
Logtalk functionality.

For details on how to integrate Logtalk with specific Prolog compilers,
see the files in the `integration` directory of the Logtalk distribution.

The adapter files may include hacks for missing official and de facto
Prolog standard built-in predicates. These hacks aim only to fulfill
the minimal requirements of the Logtalk compiler and runtime and are
not intended as a full replacement for missing functionality.


Top-level interpreter shorthands
--------------------------------

The adapter files define shorthands to often used Logtalk built-in
predicates such as `logtalk_load/1` and `logtalk_make/1` including:

* `{*}`  
	shorthand for `logtalk_make(all)`;
	reloads all modified Logtalk source files since last loaded
* `{!}`  
	shorthand for `logtalk_make(clean)`;
	deletes (cuts) all intermediate files generated by the compilation of Logtalk source files
* `{File}`  
	shorthand for `logtalk_load(File)`;
	compiles and loads a single Logtalk source file (using default flags)
* `{File1, File2, ...}`  
	shorthand for `logtalk_load([File1, File2, ...])`;
	compiles and loads several Logtalk source files (using default flags)

Note that these shorthands should only be used for iterative development
at the top-level interpreter. They are not part of the Logtalk language
specification and can be commented out in case of conflict with backend
Prolog compiler features or third-party libraries. See the documentation
of the compilation and loading predicates for a full list and details on
all available shorthands.


Optional features support per backend Prolog compiler
-----------------------------------------------------

Some Logtalk features are optional and require compatible support for specific
(and sometimes not yet standard) features by the backend Prolog compilers. The
following table summarizes the availability of these features:

|  Compiler        |    Tabling    |  Coinduction  |    Unicode    |    Engines    |    Threads    |  
| :--------------: | :-----------: | :-----------: | :-----------: | :-----------: | :-----------: |  
|  B-Prolog        |      yes      |       no      |       no      |       no      |       no      |  
|  Ciao Prolog     |      yes      |       no      |       no      |       no      |       no      |  
|  CxProlog        |       no      |     partial   |      yes      |       no      |       no      |  
|  ECLiPSe         |       no      |     partial   |       no      |      yes      |     partial   |  
|  GNU Prolog      |       no      |       no      |       no      |       no      |       no      |  
|  JIProlog        |       no      |       no      |      yes      |       no      |       no      |  
|  LVM             |       no      |       no      |       no      |       no      |       no      |  
|  Quintus Prolog  |       no      |       no      |       no      |       no      |       no      |  
|  Scryer Prolog   |       no      |       no      |       no      |       no      |       no      |  
|  SICStus Prolog  |       no      |      yes      |      yes      |       no      |       no      |  
|  SWI-Prolog      |      yes      |      yes      |      yes      |      yes      |      yes      |  
|  Tau Prolog      |       no      |       no      |      yes      |       no      |       no      |  
|  Trealla Prolog  |       no      |       no      |      yes      |       no      |       no      |  
|  XSB             |      yes      |       no      |       no      |       no      |       no      |  
|  YAP             |      yes      |      yes      |      yes      |       no      |       no      |  

A value of "yes" means at least partial support (but some limitations may be
present and a recent version of the Prolog system may be required). A value
of "no" may simply mean that the backend Prolog compiler either does not
provide a *compatible* implementation of the required features or that the
implementation is too buggy to be used. For "partial" values, see the Prolog
system notes.


template adapter file
---------------------

	template.pl

If an adapter file for your favorite Prolog is not available, use this 
file as a template for writing one. For each predicate in the file, 
check if it is built-in in your Prolog, available in a library, or if 
you can write a better definition.


B-Prolog 7.8 and later versions
-------------------------------

	b.pl

For B-Prolog 7.8 and later versions. Note that this adapter file
redefines the B-Prolog `::/2` finite-domain built-in predicate
(you may use the alternative `in/2` built-in predicate instead).

Some B-Prolog built-in predicates (e.g. `set_to_list/2` or `(@=)/2`) 
are not core predicates and can be redefined by the user. The predicate 
`predicate_property/2` does not return the property `built_in` for these 
predicates. The solution is to encapsulate calls to these predicates 
within objects and categories using the Logtalk `{}/1` control construct.

You may need to increase the sizes of the code areas on the integration
scripts if you run into out-of-memory errors with complex applications.

Matching clauses and action rules are currently not supported.

On Windows, the environment variable `BPDIR` must be defined and pointing
to the B-Prolog installation directory for the installer to detect it.


Ciao Prolog 1.20.0 and later versions
-------------------------------------

	ciao.pl

Experimental. Joint work with the Ciao Prolog developer José Morales. One
known issue is that most ISO Prolog standard and de facto standard predicates
are not built-in predicates but library predicates. The internal predicate
that checks predicate properties (defined in the adapter file) tries to
workaround this issue for those predicates but the solution is fragile.
There are also several standards compliance issues, notably with multifile
predicates, that trigger errors with some tools and examples. These issues
are expected to be solved soon. For the best experience, use the latest
Ciao Prolog git version.


CxProlog 0.98.1 or later versions
---------------------------------

	cx.pl

Developed and tested with the help of the CxProlog author, Artur Miguel Dias.

Due to the long release cycle of CxProlog, you may need to use its development
version if the recommended version is not yet available as a stable release.


ECLiPSe 6.1#143 or later versions
---------------------------------

	eclipse.pl

There is a clash between Logtalk and ECLiPSe regarding the `::/2` operator.
You may still use the `::/2` operator defined on the ECLiPSe constraint 
solver libraries by using explicit module qualification by writing 
`{library:(Var::Domain)}` (replace `library` by the actual library name; 
the `{}/1` control construct allows you to bypass the Logtalk compiler).

ECLiPSe defines an alias `in_set_range/2` for `::/2` that can be used to
avoid conflicts with Logtalk `::/2` message sending operator.

Adopted from an adapter file written and tested with help of Taner Bilgic 
for Logtalk 1.x.

With this Prolog compiler, avoid reloading Logtalk source files defining
dynamic predicates. Due to the semantics of the ECLiPSe built-in predicate
`compile/1`, new clauses for dynamic predicates are appended to the old ones
instead of replacing them.

The Logtalk flag `prolog_compiler` is not usable due to lack of ECLiPSe
built-in predicates for separate compilation and loading. To generate
`.eco` files when compiling Logtalk source files, set the Logtalk `clean`
flag to `off` and add the option `output:eco` to the Logtalk `prolog_loader`
flag.

ECLiPSe 7.0.25 and later versions multi-threading and engines support 
provide enough support for Logtalk threaded engines. But other Logtalk
multi-threading features cannot currently be supported due to missing
mutex predicates and missing thread creation options.

See the `scripts/embedding/eclipse` directory for a sample shell script
that can help in pre-compiling Logtalk and Logtalk applications.


GNU Prolog 1.4.5 and later versions
-----------------------------------

	gnu.pl

GNU Prolog supports the ISO Prolog standard. No problems expected. The
adapter file sets the `strict_iso` flag to `off`. This is recommended
but not required to support Logtalk.

See the `scripts/embedding/gprolog` directory for a sample shell script
that can generate e.g. a new Prolog top-level that embeds Logtalk and
optionally a Logtalk application.


JIProlog 4.1.6.1 and later versions
-----------------------------------

	ji.pl

Written with the help of Ugo Chirico, JIProlog author (but if you find any
Logtalk problem please report it to me).

See the `scripts/embedding/jiprolog` directory for a sample shell script
for embedding Logtalk and optionally a Logtalk application. The script
documentation also explains how to generate JAR files with pre-compiled
Logtalk applications.


LVM 1.7.0 and later versions
----------------------------

	lvm.pl


Quintus Prolog 3.3~3.5
----------------------

	quintus.pl

Experimental. Quintus Prolog is still maintained but (apparently) no
longer developed and thus it lacks compliance with current official and
de facto standards. Notably, the `open/4` and `read_term/2-3` built-in
predicates use a different argument order and there are also significant
differences in arithmetic functions support. This adapter file copes with
some of these issues using the dialect-level goal-expansion mechanism.

The original version of this adapter file was written and tested with help
of a friend of mine, Paulo Urbano, for a previous version. Adopted for the
current release using version 3.5 for Windows for testing.


Scryer Prolog 0.8.128 and later versions
----------------------------------------

	scryer.pl

Experimental.


SICStus Prolog 4.1.0 and later versions
---------------------------------------

	sicstus.pl

Adapter file for SICStus Prolog. Use of the latest SICStus Prolog version
is recommended due to improved standards compliance. No problems expected.
Please report any problem found (with a solution if possible).

See the `scripts/embedding/sicstus` directory for a sample shell script
that can help in pre-compiling Logtalk and Logtalk applications.


SWI-Prolog 6.6.0 and later versions
-----------------------------------

	swi.pl
	swihooks.pl

No problems expected. Please report any problem found (with a solution 
if possible).

To improve the integration between Logtalk and SWI-Prolog, the file
`swihooks.pl` allows loading of Logtalk source files using SWI-Prolog
`load_files/2` and `consult/1` predicates and adds support for the `edit/1`
and `make/0` predicates, the XPCE profiler, and the XPCE graphical tracer.
The profiler and tracer also require specific Logtalk startup settings (see
the `settings-sample.lgt` file for details). Note, however, that in the case
of syntax errors in a Logtalk source file, the `make/0` predicate will not
detect the fixed file as no intermediate Prolog file was generated in the
first loading attempt (use instead the `logtalk_make/0-1` predicates in this
case).

The `swihooks.pl` file includes experimental and commented out code for
writing stack trace for errors generated from top-level message sending
calls. To try it, copy the code to your Logtalk settings file that is
loaded at startup.

The adapter file may set the `iso` SWI-Prolog flag to `true`. This setting
may improve compatibility of Logtalk code across different backend 
Prolog compilers buy may also cause compatibility problems with some 
SWI-Prolog libraries. Comment out the corresponding `set_prolog_flag/2` 
directive if necessary.

For using XPCE from Logtalk, see the `xpce` example in the Logtalk
distribution.

With multi-threading support turned on, you may get a harmless message
when halting the system regarding threads that wouldn't die: you can 
suppress the message on POSIX systems by using `% swilgt 2> /dev/null`.

The definition of the predicate `{}/1` at the end of the adapter files
conflicts with e.g. the `clpq` and `clpr` SWI-Prolog constraint libraries.
The `{}/1` predicate is used in Logtalk as a shortcut to the `logtalk_load/1`
and  `logtalk_make/1` built-in predicates. Comment out the definition in the
adapter file if necessary. Note that Logtalk also defines a `{}/1` control
construct but this is only used within objects and categories.

Logtalk doesn't rely on the SWI-Prolog auto-loading mechanism for library
predicates. Calls of these predicates within objects and categories must
be explicitly qualified or implicit qualified by listing the predicates
in `use_module/2` directives). You may also set the Logtalk `portability`,
and `unknown_predicates` compiler flags to `warning` in order to detect
unqualified calls to library predicates. All the module libraries must
be loaded prior to compilation of object and categories containing calls
to the library predicates.

macOS users of the `SWI-Prolog.app` application, must add the definitions
for the `LOGTALKHOME` and `LOGTALKUSER` environment variables to their
`~/.plrc` or `~/.swiplrc` or `.config/swi-prolog/init.pl` init files (as
macOS GUI applications *don't* inherit shell environment variable values):

	:- if((
		current_prolog_flag(home,HOME),
		sub_atom(HOME,_,_,0,'SWI-Prolog.app/Contents/swipl')
	)).
	
		:- setenv('LOGTALKHOME', '/opt/local/share/logtalk').
		:- setenv('LOGTALKUSER', '/Users/pmoura/logtalk').
		:- ['$LOGTALKHOME/integration/logtalk_swi.pl'].
	
	:- endif.

The conditional compilation block allows automatically loading Logtalk at
startup of the the `SWI-Prolog.app` macOS GUI application while still be
able to use the shell integration script (`swilgt`).

To load Logtalk *on-demand* when using the `SWI-Prolog.app` application, you
can use the goal:

	?- ['$LOGTALKHOME/integration/logtalk_swi.pl'].

In alternative, you can install the Logtalk pack for SWI-Prolog by typing:

	?- pack_install(logtalk).

After, you can load Logtalk on-demand by typing:

	?- use_module(library(logtalk)).

The pack alternative is handy for deployment but not ideal for development as
it implicitly assumes a single user and the files are buried inside the packs
directory (e.g. `.local/share/swi-prolog/pack/`).

The Logtalk flag `prolog_compiler` is not usable due to lack of SWI-Prolog
built-in predicates for separate compilation and loading. To generate
`.qlf` files when compiling Logtalk source files, set the Logtalk `clean`
flag to `off` and add the option `qcompile(auto)` to the Logtalk flag
`prolog_loader`.

To use the SWI-Prolog graphical tracer for debugging Logtalk source code,
see the `settings-sample.lgt` file for the necessary settings. Note that
those settings result in large intermediate Prolog files as in addition
to the information collected for Logtalk own reflection features, all file
terms are decorated with additional source file location information for
integration with the SWI-Prolog own development tools. Use the `gtrace/0-1`
predicates to start the tracer. For example:

	?- gtrace(foo::bar).

You can also use the `gspy/1` predicate to spy a Logtalk predicate
specified as `Entity::Functor/Arity` using the graphical tracer.

See the `scripts/embedding/swipl` directory for a sample shell script
that can help in generating QLF files from Logtalk and optionally a
Logtalk application. The script documentation also explains how to
generate saved states that include Logtalk applications.

Messages sent from modules (including `user`) use static binding when the
Logtalk `optimize` flag is turned on before compiling the module files.


Tau Prolog 0.3.0 and later versions
-----------------------------------

	tau.pl

Experimental. Joint work with the Tau Prolog developers. For faster startups
after the first one when using the provided `taulgt` integration script,
edit the `core/core.pl` file and change the compiler flag `clean(on)` to
`clean(off)` for loading the built-in entities (look into the end of the
file for the predicate that loads them). There are also some standards
compliance issues and parser bugs that may trigger errors with some tools
and examples. These issues are expected to be solved soon. For the best
experience, use the latest Tau Prolog git version.


Trealla Prolog 1.8.72 and later versions
----------------------------------------

	trealla.pl

Experimental. Joint work with the Trealla Prolog developer, Andrew Davison.


XSB 3.8.0 and later versions
----------------------------

	xsb.pl

XSB generates intermediate files (with a `.xwam` extension) when compiling
Prolog source files (thus including the Logtalk core files). Thus, you
must either install Logtalk on a location where you have write access
or perform the first run of the integration scripts from a user with the
required privileges (e.g. using `sudo` on POSIX systems or choosing `Run as
administrator` on Windows systems).

Due to the relative long release cycle of XSB, you may need to use its
development version if the recommended version is not yet available as
a stable release.

Know multifile predicate issues in XSB 3.8.0 and earlier versions have now
been fixed in the current XSB development version; use it if possible.

The definition of the `as` operator used in Logtalk when declaring predicate
(or non-terminal) aliases conflicts with the definition of this operator in
XSB due to the use of a different priority. XSB uses this operator within
`table/1` directives to represent tabling options. In practice there's only
a conflict when, in the same `table/1` directive, more than one predicate is
declared as tabled and/or when more than one tabling option is specified.
This cases are not common, however. The workaround is to use parenthesis
around the predicates and/or the tabling options.

To generate `.xwam` files from Logtalk source files, set the `prolog_compiler`
flag to the list of options that will be passed to the XSB `compile/2` built-in
predicate and use either the built-in predicates `logtalk_compile/1-2` or the
built-in predicates `logtalk_load/1-2` with the `clean` flag turned off.

See the `scripts/embedding/xsb` directory for a sample shell script
that can help in pre-compiling Logtalk.


YAP 6.3.4 and later versions
----------------------------

	yap.pl
	yaphooks.pl

The adapter file may set the flag `language` to `iso`, but that is only
recommended and should not be needed to run Logtalk as some YAP libraries
may not be compatible with this flag setting. Comment out the corresponding
`set_prolog_flag/2` directive if necessary.

The `yaphooks.pl` file defines YAP hook predicates for improving the
integration between Logtalk and YAP.

Note that YAP can be compiled with or without support for features like
tabling or threads.

See the `scripts/embedding/yap` directory for a sample shell script
that can help in pre-compiling Logtalk and Logtalk applications. The
script documentation also explains how to generated saved states that
include Logtalk applications.

Messages sent from modules (including `user`) use static binding when the
Logtalk `optimize` flag is turned on before compiling the module files.
