/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XmiUtils {
    private static final String TEXT_NODE_NAME = "#text";
    private static final String COMMENT_NODE_NAME = "#comment";
    private static HashMap namespaces = new HashMap();

    public static String getXmiAttrValueAsString(Node node, String attributeName) {
        String result = null;
        if (node != null && (result = XmiUtils.getAttributeValueAsString(node, XmiUtils.getShortName(attributeName))) == null) {
            result = XmiUtils.getElementValueAsString(node, attributeName);
        }
        return result;
    }

    public static List getXmiRefValue(Node node, String attributeName) {
        ArrayList<String> value = new ArrayList<String>();
        if (node != null) {
            String attr = XmiUtils.getAttributeValueAsString(node, XmiUtils.getShortName(attributeName));
            if (attr == null) {
                Node refNode = XmiUtils.getChildNode(node, attributeName);
                if (refNode != null) {
                    NodeList values = refNode.getChildNodes();
                    for (int i = 0; i < values.getLength(); ++i) {
                        if (XmiUtils.isTextNode(values.item(i))) continue;
                        value.add(XmiUtils.getAttributeValueAsString(values.item(i), "xmi.idref"));
                    }
                }
            } else {
                int pos;
                while ((pos = attr.indexOf(32)) > -1) {
                    if (pos > 0) {
                        value.add(attr.substring(0, pos));
                    }
                    attr = attr.substring(pos + 1);
                }
                value.add(attr);
            }
        }
        return value;
    }

    public static String getAttributeValueAsString(Node node, String attributeName) {
        Node attribute;
        String result = null;
        if (node != null && node.hasAttributes() && (attribute = node.getAttributes().getNamedItem(attributeName)) != null) {
            result = attribute.getNodeValue();
        }
        return result;
    }

    public static String getElementValueAsString(Node node, String attributeName) {
        Node attributeNode;
        String result = null;
        if (node != null && (attributeNode = XmiUtils.getChildNode(node, attributeName)) != null) {
            result = (attributeNode = attributeNode.getFirstChild()) == null ? "" : attributeNode.getNodeValue();
        }
        return result;
    }

    public static Node getChildNode(Node parentNode, String childNodeName) {
        Node result = null;
        if (parentNode != null && childNodeName != null) {
            NodeList children = parentNode.getChildNodes();
            for (int cnt = 0; cnt < children.getLength(); ++cnt) {
                Node child = children.item(cnt);
                if (!childNodeName.equals(XmiUtils.resolveFullName(child))) continue;
                result = child;
                break;
            }
        }
        return result;
    }

    public static String resolveFullName(Node element) {
        if (XmiUtils.isXmiNode(element)) {
            return element.getNodeName();
        }
        return XmiUtils.resolveFullNameAsString(element.getNodeName());
    }

    public static String resolveFullNameAsString(String fullName) {
        if (fullName != null) {
            int index = fullName.indexOf(58);
            if (index > 0) {
                return namespaces.get(fullName.substring(0, index)) + "." + fullName.substring(index + 1);
            }
            return fullName;
        }
        return null;
    }

    public static String getShortName(String fullyQualifiedName) {
        String result = fullyQualifiedName;
        if (fullyQualifiedName != null && fullyQualifiedName.toUpperCase(Locale.US).indexOf("XMI.") > -1) {
            return fullyQualifiedName;
        }
        if (result != null && result.indexOf(":") > -1) {
            result = result.substring(result.indexOf(":") + 1);
        }
        if (result != null && result.indexOf(".") > -1) {
            result = result.substring(result.lastIndexOf(".") + 1);
        }
        return result;
    }

    public static boolean isTextNode(Node node) {
        boolean result = false;
        if (node != null) {
            result = node.getNodeName().equals(TEXT_NODE_NAME) || node.getNodeName().equals(COMMENT_NODE_NAME);
        }
        return result;
    }

    public static boolean isXmiNavigationNode(Node node) {
        boolean result = false;
        if (node != null) {
            result = node.getNodeName().equals("xmi.id") || result;
            result = node.getNodeName().equals("xmi.uuid") || result;
            result = node.getNodeName().equals("xmi.label") || result;
            result = node.getNodeName().equals("xmi.idref") || result;
        }
        return result;
    }

    public static boolean isXmiNode(Node node) {
        boolean result = false;
        if (node != null) {
            result |= XmiUtils.isXmiNavigationNode(node);
            result |= node.getNodeName().equals("XMI.any");
        }
        return result;
    }

    static {
        namespaces.put("Model", "Model");
        namespaces.put("UML", "Model_Management");
        namespaces.put("CWMOLAP", "Olap");
        namespaces.put("CWMTFM", "Transformation");
        namespaces.put("CWM", "BusinessInformation");
        namespaces.put("CWMRDB", "Relational");
    }

    public static class XmiNodeIterator {
        private Node node = null;
        private String attrName;
        private String attrValue;
        private String nodeName;
        private NodeList childNodes = null;
        private Node currentNode = null;
        private int index = 0;

        public XmiNodeIterator(Node node, String nodeName) {
            this.attrName = null;
            this.attrValue = null;
            this.nodeName = nodeName;
            this.node = node;
            this.childNodes = node.getChildNodes();
            this.findNext();
        }

        public XmiNodeIterator(Node node, String attrName, String attrValue) {
            this.attrName = attrName;
            this.attrValue = attrValue;
            this.nodeName = null;
            this.node = node;
            this.childNodes = node.getChildNodes();
            this.findNext();
        }

        public XmiNodeIterator(Node node) {
            this(node, null, null);
        }

        public boolean hasNext() {
            return this.currentNode != null;
        }

        public Node next() {
            Node result = this.currentNode;
            this.findNext();
            return result;
        }

        private void findNext() {
            for (int i = this.index; i < this.childNodes.getLength(); ++i) {
                Node sn = this.childNodes.item(i);
                if (XmiUtils.isTextNode(sn) || this.attrName != null && (XmiUtils.getXmiAttrValueAsString(sn, this.attrName) == null || !XmiUtils.getXmiAttrValueAsString(sn, this.attrName).equals(this.attrValue)) || this.nodeName != null && !XmiUtils.resolveFullName(sn).substring(this.nodeName.lastIndexOf(46) + 1).equals(this.nodeName.substring(this.nodeName.lastIndexOf(46) + 1))) continue;
                this.currentNode = sn;
                this.index = i + 1;
                return;
            }
            this.currentNode = null;
            this.index = this.childNodes.getLength();
        }
    }
}

