/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jmi.model.AggregationKind;
import javax.jmi.model.AggregationKindEnum;
import javax.jmi.model.AliasType;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.CollectionType;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.Feature;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Namespace;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.Tag;
import javax.jmi.model.TypedElement;
import javax.jmi.model.VisibilityKindEnum;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefAssociationLink;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;
import org.netbeans.api.xmi.XMIOutputConfig;
import org.netbeans.api.xmi.XMIReferenceProvider;
import org.netbeans.api.xmi.XMIWriter;
import org.netbeans.lib.jmi.util.DebugException;
import org.netbeans.lib.jmi.util.Logger;
import org.netbeans.lib.jmi.xmi.DefaultWriter;
import org.netbeans.lib.jmi.xmi.OutputConfig;
import org.netbeans.lib.jmi.xmi.XMIHeaderProvider;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WriterBase
extends XMIWriter {
    private static final String XMI_VERSION = "1.2";
    public static final String EXPORTER_NAME = "Netbeans XMI Writer";
    public static final String EXPORTER_VERSION = "1.0";
    public static final int ATTR_HREF = 0;
    public static final int ATTR_XMI_ID = 1;
    public static final int ATTR_XMI_IDREF = 2;
    public static final char HREF_DELIMITER = '#';
    protected ContentHandler contentHandler;
    protected OutputConfig configuration;
    protected XMIHeaderProvider headerProvider = null;
    protected XMIReferenceProvider provider;
    protected XMIReferenceProvider defaultProvider = new DefaultProvider();
    protected String encoding = null;
    protected AttributesImpl attributes;
    protected String thisSystemId = null;
    protected String elementName;
    protected boolean elementStarted;
    protected OutputStreamWriter stream;
    protected OutputStream outputStream = null;
    protected HashMap namespaces;
    protected List lightOutermosts;
    protected Set writtenComponents;
    protected Set nonWrittenComponents;
    protected HashMap xmiIds;
    protected int instancesCounter = 0;
    protected HashSet processedPackages;
    protected HashMap instanceAttributes_cache;
    protected HashMap classAttributes_cache;
    protected HashMap references_cache;
    protected HashMap structureFields_cache;
    protected HashMap labelPrefix_cache;
    protected boolean collectionWriting = false;
    protected Set objectsToWrite = null;
    protected List objectsToWriteAsCollection = null;

    public WriterBase() {
        this.configuration = new OutputConfig();
    }

    public WriterBase(XMIOutputConfig config) {
        this.configuration = new OutputConfig();
        this.configuration.setReferenceProvider(config.getReferenceProvider());
        if (config instanceof OutputConfig) {
            this.configuration.setHeaderProvider(((OutputConfig)config).getHeaderProvider());
            this.configuration.setEncoding(((OutputConfig)config).getEncoding());
        }
    }

    public void init() throws IOException {
        this.collectionWriting = false;
        this.attributes = new AttributesImpl();
        this.namespaces = new HashMap();
        this.xmiIds = new HashMap();
        this.nonWrittenComponents = new HashSet();
        this.writtenComponents = new HashSet();
        this.processedPackages = new HashSet();
        this.instancesCounter = 0;
        this.instanceAttributes_cache = new HashMap();
        this.classAttributes_cache = new HashMap();
        this.references_cache = new HashMap();
        this.structureFields_cache = new HashMap();
        this.labelPrefix_cache = new HashMap();
        this.lightOutermosts = new LinkedList();
        if (this.configuration == null) {
            this.provider = this.defaultProvider;
        } else {
            this.provider = this.configuration.getReferenceProvider();
            if (this.provider == null) {
                this.provider = this.defaultProvider;
            }
            if (this.configuration instanceof OutputConfig) {
                this.headerProvider = this.configuration.getHeaderProvider();
                this.encoding = this.configuration.getEncoding();
            }
        }
        if (this.outputStream != null) {
            try {
                this.stream = this.encoding == null ? new OutputStreamWriter(this.outputStream) : new OutputStreamWriter(this.outputStream, this.encoding);
                this.contentHandler = new DefaultWriter(this.stream, this.encoding);
                this.outputStream = null;
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException("Unsupported encoding: " + this.encoding);
            }
        }
    }

    public void write(OutputStream os, RefPackage extent, String xmiVersion) throws IOException {
        this.write(os, null, extent, xmiVersion);
    }

    public void write(OutputStream os, Collection objects, String xmiVersion) throws IOException {
        this.write(os, null, objects, xmiVersion);
    }

    public void write(OutputStream stream, RefPackage extent) {
        try {
            this.write(stream, extent, null);
        }
        catch (IOException e) {
            DebugException ne = new DebugException(e.toString());
            Logger.getDefault().annotate((Throwable)ne, (Throwable)e);
            throw ne;
        }
    }

    public XMIOutputConfig getConfiguration() {
        return this.configuration;
    }

    public void write(OutputStream stream, String uri, RefPackage extent, String xmiVersion) throws IOException {
        this.thisSystemId = uri;
        this.outputStream = stream;
        this.write(extent);
    }

    public void write(OutputStream stream, String uri, Collection objects, String xmiVersion) throws IOException {
        this.thisSystemId = uri;
        this.outputStream = stream;
        this.write(objects);
    }

    public void write(ContentHandler handler, String uri, RefPackage extent, String xmiVersion) throws IOException {
        this.thisSystemId = uri;
        this.contentHandler = handler;
        this.write(extent);
    }

    public void write(ContentHandler handler, String uri, Collection objects, String xmiVersion) throws IOException {
        this.thisSystemId = uri;
        this.contentHandler = handler;
        this.write(objects);
    }

    public void write(RefPackage extent) throws IOException {
        Logger.getDefault().log("XMI writer started");
        long time = System.currentTimeMillis();
        this.init();
        this.processedPackages.clear();
        this.findNamespaces(extent);
        this.writeDocument(extent);
        time = System.currentTimeMillis() - time;
        Logger.getDefault().log("finished, TIME: " + (double)time / 1000.0 + "[s]");
    }

    public void write(Collection objects) throws IOException {
        RefPackage extent;
        this.init();
        this.collectionWriting = true;
        this.processedPackages.clear();
        this.objectsToWrite = new HashSet();
        this.objectsToWriteAsCollection = new LinkedList();
        HashSet tempSet = new HashSet();
        if (objects == null || objects.size() == 0) {
            extent = null;
        } else {
            Iterator iter = objects.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof RefObject)) {
                    throw new DebugException("Bad object (not instance of RefObject) in input collection: " + obj.getClass().getName());
                }
                tempSet.add(obj);
            }
            iter = objects.iterator();
            while (iter.hasNext()) {
                RefObject obj;
                RefObject container = obj = (RefObject)iter.next();
                boolean found = false;
                do {
                    RefFeatured featured;
                    RefObject refObject = container = (featured = container.refImmediateComposite()) instanceof RefObject ? (RefObject)featured : null;
                    if (container == null || !tempSet.contains(container)) continue;
                    found = true;
                    break;
                } while (container != null);
                if (found) continue;
                this.objectsToWrite.add(obj);
                this.objectsToWriteAsCollection.add(obj);
            }
            extent = ((RefObject)this.objectsToWriteAsCollection.get(0)).refOutermostPackage();
            this.findNamespaces(extent);
        }
        this.writeDocument(extent);
    }

    protected void findNamespaces(RefPackage pkg) {
        Iterator iter;
        if (this.processedPackages.contains(pkg)) {
            return;
        }
        MofPackage metaPackage = (MofPackage)pkg.refMetaObject();
        String name = WriterBase.getTagValue((ModelElement)metaPackage, "org.omg.xmi.namespace");
        if (name != null) {
            iter = metaPackage.getQualifiedName().iterator();
            String fqName = (String)iter.next();
            while (iter.hasNext()) {
                fqName = fqName.concat(".").concat((String)iter.next());
            }
            this.namespaces.put(fqName, name);
        }
        this.processedPackages.add(pkg);
        iter = pkg.refAllPackages().iterator();
        while (iter.hasNext()) {
            this.findNamespaces((RefPackage)iter.next());
        }
    }

    public static String getTagValue(ModelElement element, String tagId) {
        List tags = ((ModelPackage)element.refImmediatePackage()).getAttachesTo().getTag(element);
        Tag tag = null;
        Iterator it = tags.iterator();
        while (it.hasNext()) {
            Tag temp;
            Object obj = it.next();
            if (!(obj instanceof Tag) || !tagId.equals((temp = (Tag)obj).getTagId())) continue;
            tag = temp;
            break;
        }
        if (tag == null) {
            return null;
        }
        List values = tag.getValues();
        if (values.size() == 0) {
            return null;
        }
        return (String)values.iterator().next();
    }

    protected void cacheContainedElements(MofClass mofClass) {
        LinkedList temp = new LinkedList();
        List superClasses = mofClass.allSupertypes();
        Namespace namespace = null;
        Iterator it = superClasses.iterator();
        while (it.hasNext()) {
            namespace = (Namespace)it.next();
            temp.addAll(namespace.getContents());
        }
        temp.addAll(mofClass.getContents());
        LinkedList<RefObject> instanceAttributes = new LinkedList<RefObject>();
        LinkedList<RefObject> classAttributes = new LinkedList<RefObject>();
        LinkedList<RefObject> references = new LinkedList<RefObject>();
        HashSet<AssociationEnd> referencedEnds = new HashSet<AssociationEnd>();
        it = temp.iterator();
        while (it.hasNext()) {
            AssociationEnd end;
            Association assoc;
            RefObject refObject = (RefObject)it.next();
            if (!(refObject instanceof Feature)) continue;
            boolean instanceLevel = ((Feature)refObject).getScope().equals(ScopeKindEnum.INSTANCE_LEVEL);
            if (refObject instanceof Attribute && !((Attribute)refObject).isDerived()) {
                if (instanceLevel) {
                    instanceAttributes.add(refObject);
                    continue;
                }
                classAttributes.add(refObject);
                continue;
            }
            if (!(refObject instanceof Reference) || (assoc = (Association)(end = ((Reference)refObject).getReferencedEnd()).getContainer()).isDerived() || referencedEnds.contains(end)) continue;
            references.add(refObject);
            referencedEnds.add(end);
        }
        this.instanceAttributes_cache.put(mofClass, instanceAttributes);
        this.classAttributes_cache.put(mofClass, classAttributes);
        this.references_cache.put(mofClass, references);
    }

    protected List instanceAttributes(MofClass mofClass) {
        List list = (List)this.instanceAttributes_cache.get(mofClass);
        if (list == null) {
            this.cacheContainedElements(mofClass);
            list = (List)this.instanceAttributes_cache.get(mofClass);
        }
        return list;
    }

    protected List classAttributes(MofClass mofClass) {
        List list = (List)this.classAttributes_cache.get(mofClass);
        if (list == null) {
            this.cacheContainedElements(mofClass);
            list = (List)this.classAttributes_cache.get(mofClass);
        }
        return list;
    }

    protected List references(MofClass mofClass) {
        List list = (List)this.references_cache.get(mofClass);
        if (list == null) {
            this.cacheContainedElements(mofClass);
            list = (List)this.references_cache.get(mofClass);
        }
        return list;
    }

    public List structureFields(StructureType type) {
        LinkedList fields = (LinkedList)this.structureFields_cache.get(type);
        if (fields != null) {
            return fields;
        }
        fields = new LinkedList();
        Iterator content = type.getContents().iterator();
        while (content.hasNext()) {
            Object element = content.next();
            if (!(element instanceof StructureField)) continue;
            fields.add(element);
        }
        this.structureFields_cache.put(type, fields);
        return fields;
    }

    public String labelPrefix(EnumerationType type) {
        String prefix = (String)this.labelPrefix_cache.get(type);
        if (prefix != null) {
            return prefix;
        }
        prefix = WriterBase.getTagValue((ModelElement)type, "org.omg.xmi.enumerationUnprefix");
        if (prefix == null) {
            prefix = "";
        }
        this.labelPrefix_cache.put(type, prefix);
        return prefix;
    }

    protected void startElement(String name) {
        if (this.elementStarted) {
            this.writeStartElement();
        }
        this.elementName = name;
        this.elementStarted = true;
    }

    protected void endElement(String name) {
        if (this.elementStarted) {
            this.writeStartElement();
        }
        try {
            this.contentHandler.endElement(null, null, name);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected void addAttribute(String name, String value) {
        this.attributes.addAttribute(null, null, name, null, value);
    }

    protected void characters(String text) {
        if (this.elementStarted) {
            this.writeStartElement();
        }
        try {
            this.contentHandler.characters(text.toCharArray(), 0, text.length());
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected void writeStartElement() {
        try {
            this.contentHandler.startElement(null, null, this.elementName, this.attributes);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        this.elementStarted = false;
        this.attributes.clear();
    }

    protected String getXmiId(RefObject obj) {
        String xmiId = (String)this.xmiIds.get(obj);
        if (xmiId == null) {
            ++this.instancesCounter;
            xmiId = "a" + this.instancesCounter;
            this.xmiIds.put(obj, xmiId);
        }
        return xmiId;
    }

    protected void markWritten(RefObject obj) {
        this.writtenComponents.add(obj);
        this.nonWrittenComponents.remove(obj);
    }

    protected void writeDocument(RefPackage pkg) {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException e) {
            // empty catch block
        }
        this.startElement("XMI");
        this.addAttribute("xmi.version", XMI_VERSION);
        this.writeNamespaces();
        this.addAttribute("timestamp", new Date().toString());
        this.writeHeader();
        this.startElement("XMI.content");
        if (!this.collectionWriting) {
            this.processedPackages.clear();
            this.writePackage(pkg);
            while (this.nonWrittenComponents.size() > 0) {
                RefObject obj;
                Iterator iter = this.nonWrittenComponents.iterator();
                while (this.nonWrittenComponents.contains((obj = (RefObject)iter.next()).refImmediateComposite())) {
                }
                this.writeInstance(obj, true);
                while (this.lightOutermosts.size() > 0) {
                    obj = (RefObject)this.lightOutermosts.remove(0);
                    this.writeInstance(obj, true);
                }
            }
            this.processedPackages.clear();
            this.writeStaticAttributes(pkg);
        } else {
            this.writeObjects();
        }
        this.processedPackages.clear();
        this.writeAssociations(pkg);
        this.endElement("XMI.content");
        this.endElement("XMI");
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    protected void writeHeader() {
        this.startElement("XMI.header");
        if (this.contentHandler instanceof DefaultWriter && this.headerProvider != null) {
            this.writeStartElement();
            this.characters("");
            Writer ps = ((DefaultWriter)this.contentHandler).getWriter();
            this.headerProvider.writeHeader(ps);
        } else {
            this.startElement("XMI.documentation");
            this.startElement("XMI.exporter");
            this.characters(EXPORTER_NAME);
            this.endElement("XMI.exporter");
            this.startElement("XMI.exporterVersion");
            this.characters(EXPORTER_VERSION);
            this.endElement("XMI.exporterVersion");
            this.endElement("XMI.documentation");
        }
        this.endElement("XMI.header");
    }

    protected void writeNamespaces() {
        HashMap<String, String> temp = new HashMap<String, String>();
        Iterator iter = this.namespaces.entrySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next().getValue();
            if (temp.get(name) != null) continue;
            temp.put(name, name);
            this.addAttribute("xmlns:" + name, "org.omg.xmi.namespace." + name);
        }
    }

    protected void writePackage(RefPackage pkg) {
        if (this.processedPackages.contains(pkg)) {
            return;
        }
        Iterator classes = pkg.refAllClasses().iterator();
        while (classes.hasNext()) {
            RefClass proxy = (RefClass)classes.next();
            Iterator instances = proxy.refAllOfClass().iterator();
            while (instances.hasNext()) {
                RefObject obj = (RefObject)instances.next();
                if (obj == null) continue;
                if (obj.equals(obj.refOutermostComposite())) {
                    this.writeInstance(obj, true);
                    while (this.lightOutermosts.size() > 0) {
                        obj = (RefObject)this.lightOutermosts.remove(0);
                        this.writeInstance(obj, true);
                    }
                    continue;
                }
                if (this.writtenComponents.contains(obj)) continue;
                this.nonWrittenComponents.add(obj);
            }
        }
        this.processedPackages.add(pkg);
        Iterator containedPackages = pkg.refAllPackages().iterator();
        while (containedPackages.hasNext()) {
            this.writePackage((RefPackage)containedPackages.next());
        }
    }

    protected void writeObjects() {
        Iterator iter = this.objectsToWriteAsCollection.iterator();
        while (iter.hasNext()) {
            this.writeInstance((RefObject)iter.next(), true);
        }
    }

    protected void writeInstance(RefObject obj, boolean isTop) {
        RefClass proxy = obj.refClass();
        ModelElement element = (ModelElement)obj.refMetaObject();
        String name = this.qualifiedName(element);
        XMIReferenceProvider.XMIReference xmiRef = this.provider.getReference(obj);
        String xmiId = xmiRef.getXmiId();
        String systemId = xmiRef.getSystemId();
        if (systemId != null && this.thisSystemId != null && this.thisSystemId.equals(systemId)) {
            systemId = null;
        }
        this.markWritten(obj);
        if (systemId != null) {
            if (!isTop) {
                this.startElement(name);
                this.addAttribute("href", systemId + '#' + xmiId);
                this.endElement(name);
            }
            this.collectLightOutermosts(obj, proxy);
            return;
        }
        this.startElement(name);
        this.addAttribute("xmi.id", xmiId);
        Iterator attrs = this.instanceAttributes((MofClass)proxy.refMetaObject()).iterator();
        LinkedList<Attribute> attrsInContent = new LinkedList<Attribute>();
        while (attrs.hasNext()) {
            Object value;
            Attribute attr = (Attribute)attrs.next();
            if (!VisibilityKindEnum.PUBLIC_VIS.equals((Object)attr.getVisibility())) continue;
            boolean isMultivalued = WriterBase.isMultivalued((StructuralFeature)attr);
            try {
                value = obj.refGetValue((RefObject)attr);
            }
            catch (Exception e) {
                Logger.getDefault().annotate((Throwable)e, ((ModelElement)obj.refMetaObject()).getName() + " " + attr.getName());
                Logger.getDefault().notify((Throwable)e);
                value = Boolean.FALSE;
            }
            Object valueToWrite = value;
            if (value == null) continue;
            if (isMultivalued) {
                Collection col = (Collection)value;
                if (col.size() <= 0) continue;
                attrsInContent.add(attr);
                continue;
            }
            Classifier type = WriterBase.getType((TypedElement)attr);
            if (!(type instanceof PrimitiveType) && !(type instanceof EnumerationType)) {
                attrsInContent.add(attr);
                continue;
            }
            this.writeValueInAttr((TypedElement)attr, valueToWrite);
        }
        Iterator iter = attrsInContent.iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            this.writeValueInContent((TypedElement)attr, obj.refGetValue((RefObject)attr));
        }
        Iterator refs = this.references((MofClass)proxy.refMetaObject()).iterator();
        while (refs.hasNext()) {
            Reference ref = (Reference)refs.next();
            this.writeReference(obj, ref);
        }
        this.endElement(name);
    }

    protected void collectLightOutermosts(RefObject obj, RefClass proxy) {
        Iterator iter;
        Collection<Object> values;
        Iterator attrs = this.instanceAttributes((MofClass)proxy.refMetaObject()).iterator();
        while (attrs.hasNext()) {
            Attribute attr = (Attribute)attrs.next();
            Classifier type = WriterBase.getType((TypedElement)attr);
            if (type instanceof PrimitiveType || type instanceof EnumerationType) continue;
            boolean isMultivalued = WriterBase.isMultivalued((StructuralFeature)attr);
            Object value = obj.refGetValue((RefObject)attr);
            if (value == null) continue;
            if (isMultivalued) {
                values = (LinkedList<Object>)value;
            } else {
                values = new LinkedList<Object>();
                values.add(value);
            }
            iter = values.iterator();
            if (type instanceof MofClass) {
                while (iter.hasNext()) {
                    this.addLightOutermost((RefObject)iter.next());
                }
                continue;
            }
            if (type instanceof StructureType) {
                while (iter.hasNext()) {
                    this.collectStructure((StructureType)type, (RefStruct)iter.next());
                }
                continue;
            }
            if (!(type instanceof CollectionType)) continue;
            while (iter.hasNext()) {
                this.collectCollection((CollectionType)type, (Collection)iter.next());
            }
        }
        Iterator refs = this.references((MofClass)proxy.refMetaObject()).iterator();
        while (refs.hasNext()) {
            Object temp;
            Reference ref = (Reference)refs.next();
            AggregationKind kind = ref.getExposedEnd().getAggregation();
            if (!AggregationKindEnum.COMPOSITE.equals((Object)kind) || (temp = obj.refGetValue((RefObject)ref)) == null) continue;
            if (WriterBase.isMultivalued((StructuralFeature)ref)) {
                values = (Collection)temp;
            } else {
                values = new LinkedList();
                values.add(temp);
            }
            iter = values.iterator();
            while (iter.hasNext()) {
                this.addLightOutermost((RefObject)iter.next());
            }
        }
    }

    protected void collectStructure(StructureType type, RefStruct value) {
        Iterator iter = this.structureFields(type).iterator();
        while (iter.hasNext()) {
            StructureField field = (StructureField)iter.next();
            Classifier fieldType = WriterBase.getType((TypedElement)field);
            if (fieldType instanceof StructureType) {
                this.collectStructure((StructureType)fieldType, (RefStruct)value.refGetValue(field.getName()));
                continue;
            }
            if (fieldType instanceof MofClass) {
                this.addLightOutermost((RefObject)value.refGetValue(field.getName()));
                continue;
            }
            if (!(fieldType instanceof CollectionType)) continue;
            this.collectCollection((CollectionType)fieldType, (Collection)value.refGetValue(field.getName()));
        }
    }

    protected void collectCollection(CollectionType collType, Collection col) {
        block4: {
            Iterator iter;
            Classifier type;
            block5: {
                block3: {
                    type = collType.getType();
                    iter = col.iterator();
                    if (!(type instanceof StructureType)) break block3;
                    while (iter.hasNext()) {
                        this.collectStructure((StructureType)type, (RefStruct)iter.next());
                    }
                    break block4;
                }
                if (!(type instanceof CollectionType)) break block5;
                while (iter.hasNext()) {
                    this.collectCollection((CollectionType)type, (Collection)iter.next());
                }
                break block4;
            }
            if (!(type instanceof MofClass)) break block4;
            while (iter.hasNext()) {
                this.addLightOutermost((RefObject)iter.next());
            }
        }
    }

    protected void addLightOutermost(RefObject obj) {
        this.lightOutermosts.add(obj);
    }

    protected void writeInstanceRef(RefObject obj, boolean externalOnly, boolean hrefForced) {
        String name = this.qualifiedName((ModelElement)obj.refMetaObject());
        XMIReferenceProvider.XMIReference xmiRef = this.provider.getReference(obj);
        String xmiId = xmiRef.getXmiId();
        String systemId = xmiRef.getSystemId();
        if (systemId != null && this.thisSystemId != null && this.thisSystemId.equals(systemId)) {
            systemId = null;
        }
        this.startElement(name);
        if (systemId == null) {
            this.addAttribute("xmi.idref", xmiId);
        } else {
            this.addAttribute("href", systemId + '#' + xmiId);
        }
        this.endElement(name);
    }

    protected void writeValueInAttr(TypedElement attr, Object value) {
        String asText;
        String name = this.elementName((ModelElement)attr);
        Classifier type = attr.getType();
        if (type instanceof EnumerationType) {
            String prefix = this.labelPrefix((EnumerationType)type);
            asText = value.toString().substring(prefix.length());
        } else {
            asText = value.toString();
        }
        this.addAttribute(name, asText);
    }

    protected void writeValueInContent(TypedElement attr, Object value) {
        LinkedList<Object> values;
        if (value == null) {
            return;
        }
        String name = this.qualifiedName((ModelElement)attr);
        Classifier type = WriterBase.getType(attr);
        boolean isMultivalued = false;
        if (attr instanceof StructuralFeature) {
            isMultivalued = WriterBase.isMultivalued((StructuralFeature)attr);
        }
        if (isMultivalued) {
            values = (LinkedList<Object>)value;
        } else {
            values = new LinkedList<Object>();
            values.add(value);
        }
        Iterator iter = values.iterator();
        if (type instanceof StructureType) {
            this.startElement(name);
            while (iter.hasNext()) {
                this.writeStructure((StructureType)type, (RefStruct)iter.next());
            }
            this.endElement(name);
        } else if (type instanceof MofClass) {
            this.startElement(name);
            while (iter.hasNext()) {
                RefObject obj = (RefObject)iter.next();
                this.writeInstance(obj, false);
            }
            this.endElement(name);
        } else if (type instanceof PrimitiveType) {
            while (iter.hasNext()) {
                Object obj = iter.next();
                this.startElement(name);
                this.characters(obj.toString());
                this.endElement(name);
            }
        } else if (type instanceof EnumerationType) {
            while (iter.hasNext()) {
                Object obj = iter.next();
                this.startElement(name);
                String prefix = this.labelPrefix((EnumerationType)type);
                String label = obj.toString().substring(prefix.length());
                this.addAttribute("xmi.value", label);
                this.endElement(name);
            }
        } else if (type instanceof CollectionType) {
            this.startElement(name);
            while (iter.hasNext()) {
                this.writeCollection((CollectionType)type, (Collection)iter.next());
            }
            this.endElement(name);
        } else {
            throw new DebugException("Unsupported type: " + type.getName());
        }
    }

    protected void writeStructure(StructureType type, RefStruct value) {
        Iterator iter = this.structureFields(type).iterator();
        while (iter.hasNext()) {
            StructureField field = (StructureField)iter.next();
            Classifier fieldType = WriterBase.getType((TypedElement)field);
            String fieldName = this.qualifiedName((ModelElement)field);
            Object fieldValue = value.refGetValue(field.getName());
            this.startElement("XMI.field");
            if (fieldType instanceof MofClass) {
                this.writeInstanceRef((RefObject)fieldValue, false, false);
            } else if (fieldType instanceof StructureType) {
                this.writeStructure((StructureType)fieldType, (RefStruct)fieldValue);
            } else if (fieldType instanceof CollectionType) {
                this.writeCollection((CollectionType)fieldType, (Collection)fieldValue);
            } else if (fieldType instanceof PrimitiveType) {
                this.characters(fieldValue.toString());
            }
            this.endElement("XMI.field");
        }
    }

    protected void writeCollection(CollectionType collType, Collection value) {
        String collTypeName = this.qualifiedName((ModelElement)collType);
        this.startElement(collTypeName);
        Iterator iter = value.iterator();
        Classifier type = collType.getType();
        String typeName = this.qualifiedName((ModelElement)type);
        if (type instanceof MofClass) {
            while (iter.hasNext()) {
                this.writeInstanceRef((RefObject)iter.next(), false, false);
            }
        } else if (type instanceof StructureType) {
            while (iter.hasNext()) {
                this.startElement(typeName);
                Object o = iter.next();
                this.writeStructure((StructureType)type, (RefStruct)o);
                this.endElement(typeName);
            }
        } else if (type instanceof CollectionType) {
            while (iter.hasNext()) {
                this.writeCollection((CollectionType)type, (Collection)iter.next());
            }
        } else if (type instanceof PrimitiveType) {
            while (iter.hasNext()) {
                this.startElement(typeName);
                this.characters(iter.next().toString());
                this.endElement(typeName);
            }
        }
        this.endElement(collTypeName);
    }

    protected void writeReference(RefObject obj, Reference ref) {
        Iterator iter;
        LinkedList<Object> values;
        AggregationKind kind = ref.getReferencedEnd().getAggregation();
        if (AggregationKindEnum.COMPOSITE.equals((Object)kind)) {
            return;
        }
        kind = ref.getExposedEnd().getAggregation();
        boolean isComposite = AggregationKindEnum.COMPOSITE.equals((Object)kind);
        Object temp = obj.refGetValue((RefObject)ref);
        if (temp == null) {
            return;
        }
        if (WriterBase.isMultivalued((StructuralFeature)ref)) {
            values = (LinkedList<Object>)temp;
        } else {
            values = new LinkedList<Object>();
            values.add(temp);
        }
        if (this.collectionWriting) {
            LinkedList<RefObject> cValues = new LinkedList<RefObject>();
            iter = values.iterator();
            while (iter.hasNext()) {
                RefObject referencedObject = (RefObject)iter.next();
                if (!this.isInClosure(referencedObject)) continue;
                cValues.add(referencedObject);
            }
            values = cValues;
        }
        if (values.isEmpty()) {
            return;
        }
        String name = this.qualifiedName((ModelElement)ref);
        this.startElement(name);
        iter = values.iterator();
        while (iter.hasNext()) {
            RefObject endValue = (RefObject)iter.next();
            if (isComposite) {
                this.writeInstance(endValue, false);
                continue;
            }
            this.writeInstanceRef(endValue, false, false);
        }
        this.endElement(name);
    }

    protected void writeStaticAttributes(RefPackage pkg) {
        if (this.processedPackages.contains(pkg)) {
            return;
        }
        Iterator iter = pkg.refAllClasses().iterator();
        while (iter.hasNext()) {
            RefClass proxy = (RefClass)iter.next();
            Iterator attrs = this.classAttributes((MofClass)proxy.refMetaObject()).iterator();
            while (attrs.hasNext()) {
                Attribute attr = (Attribute)attrs.next();
                this.writeValueInContent((TypedElement)attr, proxy.refGetValue((RefObject)attr));
            }
        }
        this.processedPackages.add(pkg);
        Iterator containedPackages = pkg.refAllPackages().iterator();
        while (containedPackages.hasNext()) {
            this.writeStaticAttributes((RefPackage)containedPackages.next());
        }
    }

    protected void writeAssociations(RefPackage pkg) {
        if (this.processedPackages.contains(pkg)) {
            return;
        }
        Iterator iter = pkg.refAllAssociations().iterator();
        while (iter.hasNext()) {
            RefAssociation proxy = (RefAssociation)iter.next();
            Association assoc = (Association)proxy.refMetaObject();
            if (assoc.isDerived()) continue;
            boolean aLinkWritten = false;
            String name = this.qualifiedName((ModelElement)assoc);
            AssociationEnd end1 = null;
            AssociationEnd end2 = null;
            Iterator content = assoc.getContents().iterator();
            while (content.hasNext()) {
                Object obj = content.next();
                if (!(obj instanceof AssociationEnd)) continue;
                if (end1 == null) {
                    end1 = (AssociationEnd)obj;
                    continue;
                }
                end2 = (AssociationEnd)obj;
                break;
            }
            MofClass type1 = (MofClass)end1.getType();
            MofClass type2 = (MofClass)end2.getType();
            boolean isComposite1 = AggregationKindEnum.COMPOSITE.equals((Object)end1.getAggregation());
            boolean isComposite2 = AggregationKindEnum.COMPOSITE.equals((Object)end2.getAggregation());
            boolean ref_1_exists = this.referenceExists(type1, end2);
            boolean ref_2_exists = this.referenceExists(type2, end1);
            if (ref_1_exists && ref_2_exists || ref_1_exists && !isComposite2 || ref_2_exists && !isComposite1) continue;
            boolean isNavigable1 = end1.isNavigable();
            boolean isNavigable2 = end2.isNavigable();
            HashMap<MofClass, Boolean> cache_1 = new HashMap<MofClass, Boolean>();
            HashMap<MofClass, Boolean> cache_2 = new HashMap<MofClass, Boolean>();
            Iterator links = proxy.refAllLinks().iterator();
            while (links.hasNext()) {
                RefAssociationLink link = (RefAssociationLink)links.next();
                RefObject value_1 = link.refFirstEnd();
                RefObject value_2 = link.refSecondEnd();
                if (this.collectionWriting && (!this.isInClosure(value_1) || !this.isInClosure(value_2))) continue;
                Boolean flag_1 = Boolean.FALSE;
                Boolean flag_2 = Boolean.FALSE;
                if (isNavigable1 && (flag_1 = (Boolean)cache_1.get(type1 = (MofClass)value_1.refMetaObject())) == null) {
                    flag_1 = this.referenceExists(type1, end2) ? Boolean.TRUE : Boolean.FALSE;
                    cache_1.put(type1, flag_1);
                }
                if (isNavigable2 && (flag_2 = (Boolean)cache_2.get(type2 = (MofClass)value_2.refMetaObject())) == null) {
                    flag_2 = this.referenceExists(type2, end1) ? Boolean.TRUE : Boolean.FALSE;
                    cache_2.put(type2, flag_2);
                }
                ref_1_exists = flag_1;
                ref_2_exists = flag_2;
                if (ref_1_exists && ref_2_exists || ref_1_exists && !isComposite2 || ref_2_exists && !isComposite1) continue;
                if (!aLinkWritten) {
                    this.startElement(name);
                    aLinkWritten = true;
                }
                this.writeInstanceRef(value_1, false, false);
                this.writeInstanceRef(value_2, false, false);
            }
            if (!aLinkWritten) continue;
            this.endElement(name);
        }
        this.processedPackages.add(pkg);
        Iterator containedPackages = pkg.refAllPackages().iterator();
        while (containedPackages.hasNext()) {
            this.writeAssociations((RefPackage)containedPackages.next());
        }
    }

    protected boolean referenceExists(MofClass mofClass, AssociationEnd assocEnd) {
        if (!assocEnd.isNavigable()) {
            return false;
        }
        Iterator references = this.references(mofClass).iterator();
        while (references.hasNext()) {
            Reference ref = (Reference)references.next();
            AssociationEnd end = ref.getReferencedEnd();
            if (!end.equals(assocEnd)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInClosure(RefObject obj) {
        RefObject container = obj;
        while (container != null) {
            if (this.objectsToWrite.contains(container)) {
                return true;
            }
            RefFeatured featured = container.refImmediateComposite();
            container = featured instanceof RefObject && featured != obj ? (RefObject)featured : null;
        }
        return false;
    }

    protected String qualifiedName(ModelElement element) {
        String namespace;
        Iterator iter = element.getQualifiedName().iterator();
        String name = (String)iter.next();
        while (iter.hasNext()) {
            name = name.concat(".").concat((String)iter.next());
        }
        int index = name.lastIndexOf(46);
        String pName = name.substring(0, index);
        String sName = name.substring(index + 1, name.length());
        if (!(element instanceof MofClass) && !(element instanceof Association) && (index = pName.lastIndexOf(46)) > -1) {
            pName = pName.substring(0, index);
            sName = name.substring(index + 1, name.length());
        }
        if ((namespace = (String)this.namespaces.get(pName)) != null) {
            return namespace + ":" + sName;
        }
        return name;
    }

    protected String elementName(ModelElement elem) {
        return elem.getName();
    }

    protected static boolean isMultivalued(StructuralFeature feature) {
        MultiplicityType multType = feature.getMultiplicity();
        return multType.getUpper() != 1;
    }

    protected static Classifier getType(TypedElement elem) {
        Classifier type = elem.getType();
        while (type instanceof AliasType) {
            type = ((AliasType)type).getType();
        }
        return type;
    }

    class DefaultProvider
    implements XMIReferenceProvider {
        DefaultProvider() {
        }

        public XMIReferenceProvider.XMIReference getReference(RefObject obj) {
            return new XMIReferenceProvider.XMIReference(null, WriterBase.this.getXmiId(obj));
        }
    }
}

