/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.xmi;

import java.io.IOException;
import java.util.Collection;
import javax.jmi.reflect.RefPackage;
import org.netbeans.api.xmi.XMIOutputConfig;
import org.netbeans.api.xmi.sax.XMIProducer;
import org.netbeans.lib.jmi.xmi.DefaultWriter;
import org.netbeans.lib.jmi.xmi.OutputConfig;
import org.netbeans.lib.jmi.xmi.WriterBase;
import org.netbeans.lib.jmi.xmi.XMI20Writer;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.LocatorImpl;

public class Producer
extends XMIProducer {
    private XMIOutputConfig config;
    private Collection objects = null;
    private RefPackage extent = null;
    private String xmiVersion = null;
    private DTDHandler dtdHandler = null;
    private ContentHandler contentHandler = null;
    private EntityResolver entityResolver = null;
    private ErrorHandler errorHandler = null;
    private ContentHandler defaultWriter = new DefaultWriter();

    public Producer() {
        this.config = new OutputConfig();
    }

    public Producer(XMIOutputConfig config) {
        this.config = config;
    }

    public void setSource(Collection objects) {
        this.objects = objects;
        this.extent = null;
    }

    public void setSource(RefPackage extent) {
        this.extent = extent;
        this.objects = null;
    }

    public Object getSource() {
        if (this.objects == null) {
            return this.extent;
        }
        return this.objects;
    }

    public void setXmiVersion(String xmiVersion) {
        this.xmiVersion = xmiVersion;
    }

    public String getXmiVersion() {
        return this.xmiVersion;
    }

    public XMIOutputConfig getConfiguration() {
        return this.config;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean getFeature(String name) throws SAXNotSupportedException {
        throw new SAXNotSupportedException(null);
    }

    public Object getProperty(String name) throws SAXNotSupportedException {
        throw new SAXNotSupportedException(null);
    }

    public void parse(InputSource input) throws IOException, SAXException {
        this.parse(input.getSystemId());
    }

    public void parse(String systemId) throws IOException, SAXException {
        ContentHandler handler = this.contentHandler != null ? this.contentHandler : this.defaultWriter;
        LocatorImpl locator = new LocatorImpl();
        locator.setSystemId(systemId);
        handler.setDocumentLocator(locator);
        if (this.extent != null) {
            this.getWriter().write(this.contentHandler, systemId, this.extent, this.xmiVersion);
        } else if (this.objects != null) {
            this.getWriter().write(this.contentHandler, systemId, this.objects, this.xmiVersion);
        } else {
            throw new SAXException("Source not specified.");
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void setFeature(String name, boolean value) throws SAXNotSupportedException {
        throw new SAXNotSupportedException(null);
    }

    public void setProperty(String name, Object value) throws SAXNotSupportedException {
        throw new SAXNotSupportedException(null);
    }

    private WriterBase getWriter() {
        if (this.xmiVersion != null && this.xmiVersion.equals("2.0")) {
            return new XMI20Writer(this.config);
        }
        return new WriterBase(this.config);
    }
}

