/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingMode;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.ModeCreateEdge;
import org.tigris.gef.base.ModeImpl;
import org.tigris.gef.event.ModeChangeEvent;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeManager
implements Serializable,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = 3180158274454415153L;
    private Vector<FigModifyingMode> modes = new Vector();
    public Editor editor;
    private EventListenerList _listeners = new EventListenerList();
    private static Log LOG = LogFactory.getLog(ModeManager.class);

    public ModeManager(Editor ed) {
        this.editor = ed;
    }

    public void setEditor(Editor w) {
        this.editor = w;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public FigModifyingMode top() {
        if (this.modes.isEmpty()) {
            return null;
        }
        return this.modes.lastElement();
    }

    public void push(FigModifyingMode newMode) {
        if (newMode == null) {
            throw new IllegalArgumentException("You cannot push a null mode.");
        }
        if (!this.includes(newMode.getClass())) {
            this.modes.addElement(newMode);
            this.fireModeChanged();
        }
    }

    public FigModifyingMode pop() {
        if (this.modes.isEmpty()) {
            return null;
        }
        FigModifyingMode res = this.top();
        if (res.canExit()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing mode " + res));
            }
            this.modes.removeElement(res);
            this.fireModeChanged();
        }
        return res;
    }

    public void popAll() {
        while (!this.modes.isEmpty() && this.top().canExit()) {
            this.modes.removeElement(this.top());
        }
        this.fireModeChanged();
    }

    public boolean includes(Class<? extends FigModifyingMode> modeClass) {
        for (FigModifyingMode m : this.modes) {
            if (m.getClass() != modeClass) continue;
            return true;
        }
        return false;
    }

    public void leaveAll() {
        for (int i = this.modes.size() - 1; i >= 0; --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this.modes.get(i);
            m.leave();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        this.checkModeTransitions(ke);
        for (int i = this.modes.size() - 1; i >= 0 && !ke.isConsumed(); --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this.modes.get(i);
            m.keyTyped(ke);
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        for (int i = this.modes.size() - 1; i >= 0 && !ke.isConsumed(); --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this.modes.get(i);
            m.keyReleased(ke);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        Vector modesCopy = (Vector)this.modes.clone();
        for (int i = modesCopy.size() - 1; i >= 0 && !ke.isConsumed(); --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)modesCopy.get(i);
            if (!this.modes.contains(m)) continue;
            m.keyPressed(ke);
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        for (int i = this.modes.size() - 1; i >= 0; --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this.modes.get(i);
            m.mouseMoved(me);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        for (int i = this.modes.size() - 1; i >= 0; --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this.modes.get(i);
            m.mouseDragged(me);
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.checkModeTransitions(me);
        for (int i = this.modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this.modes.get(i);
            m.mouseClicked(me);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.checkModeTransitions(me);
        for (int i = this.modes.size() - 1; i >= 0; --i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("MousePressed testing mode " + this.modes.get(i).getClass().getName()));
            }
            FigModifyingModeImpl m = (FigModifyingModeImpl)this.modes.get(i);
            m.mousePressed(me);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.checkModeTransitions(me);
        for (int i = this.modes.size() - 1; i >= 0; --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this.modes.get(i);
            m.mouseReleased(me);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        for (int i = this.modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this.modes.get(i);
            m.mouseEntered(me);
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
        for (int i = this.modes.size() - 1; i >= 0 && !me.isConsumed(); --i) {
            FigModifyingModeImpl m = (FigModifyingModeImpl)this.modes.get(i);
            m.mouseExited(me);
        }
    }

    public void checkModeTransitions(InputEvent ie) {
        if (!this.top().canExit() && ie.getID() == 501) {
            int y;
            MouseEvent me = (MouseEvent)ie;
            int x = me.getX();
            Fig underMouse = this.editor.hit(x, y = me.getY());
            if (underMouse instanceof FigNode && ((FigNode)underMouse).isDragConnectable()) {
                Object startPort = ((FigNode)underMouse).hitPort(x, y);
                if (startPort != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"ModeManager mousepressed detected on a draggable port");
                    }
                    ModeCreateEdge createArc = new ModeCreateEdge(this.editor);
                    this.push(createArc);
                    ((ModeImpl)createArc).mousePressed(me);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"ModeManager mousepressed detected but not on a port");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"ModeManager mousepressed detected but not on a port dragable node");
            }
        }
    }

    public void addModeChangeListener(ModeChangeListener listener) {
        this._listeners.add(ModeChangeListener.class, listener);
    }

    public void removeModeChangeListener(ModeChangeListener listener) {
        this._listeners.remove(ModeChangeListener.class, listener);
    }

    protected void fireModeChanged() {
        Object[] listeners = this._listeners.getListenerList();
        ModeChangeEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ModeChangeListener.class) continue;
            if (e == null) {
                e = new ModeChangeEvent(this.editor, this.modes);
            }
            ((ModeChangeListener)listeners[i + 1]).modeChange(e);
        }
    }

    public void paint(Graphics g) {
        for (FigModifyingMode m : this.modes) {
            m.paint(g);
        }
    }

    public int count() {
        return this.modes.size();
    }
}

