/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerPageBreaks
extends Layer {
    private static final long serialVersionUID = 5536725864099204670L;
    public final int DASH_LENGTH = 2;
    public final int GAP_LENGTH = 7;
    private boolean _paintLines = false;
    protected Color _color = Color.white;
    protected Dimension _pageSize = new Dimension(582, 717);

    public LayerPageBreaks() {
        super("PageBreaks");
    }

    public void setPageSize(Dimension d) {
        this._pageSize = d;
    }

    @Override
    public List<Fig> getContents() {
        return Collections.emptyList();
    }

    @Override
    public Fig presentationFor(Object obj) {
        return null;
    }

    @Override
    public synchronized void paintContents(Graphics g) {
        if (g instanceof PrintGraphics) {
            return;
        }
        if (!this._paintLines) {
            return;
        }
        if (this._pageSize == null) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        int x = clip.x / this._pageSize.width * this._pageSize.width - this._pageSize.width;
        int y = clip.y / this._pageSize.height * this._pageSize.height - this._pageSize.height;
        int right = clip.x + clip.width;
        int bot = clip.y + clip.height;
        int stepsY = (bot - y) / this._pageSize.height + 1;
        g.setColor(this._color);
        for (int stepsX = (right - x) / this._pageSize.width + 1; stepsX > 0; --stepsX) {
            this.drawDashedLine(g, 0, x - 1, 0, x - 1, bot);
            x += this._pageSize.width;
        }
        while (stepsY > 0) {
            this.drawDashedLine(g, 0, 0, y - 1, right, y - 1);
            y += this._pageSize.height;
            --stepsY;
        }
    }

    protected int drawDashedLine(Graphics g, int phase, int x1, int y1, int x2, int y2) {
        int dxdx = (x2 - x1) * (x2 - x1);
        int dydy = (y2 - y1) * (y2 - y1);
        int length = (int)Math.sqrt(dxdx + dydy);
        for (int i = phase; i < length - 2; i += 7) {
            int segEndY;
            int segEndX;
            int segStartX = x1 + (x2 - x1) * i / length;
            int segStartY = y1 + (y2 - y1) * i / length;
            if ((i += 2) >= length) {
                segEndX = x2;
                segEndY = y2;
            } else {
                segEndX = x1 + (x2 - x1) * i / length;
                segEndY = y1 + (y2 - y1) * i / length;
            }
            g.drawLine(segStartX, segStartY, segEndX, segEndY);
        }
        return 0;
    }

    @Override
    public void adjust() {
        this._paintLines = !this._paintLines;
        this.refreshEditors();
    }
}

