/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.apache.log4j.Logger;
import org.argouml.model.InvalidElementException;
import org.argouml.model.ModelManagementHelper;
import org.argouml.model.mdr.CoreHelperMDRImpl;
import org.argouml.model.mdr.FacadeMDRImpl;
import org.argouml.model.mdr.MDRModelImplementation;
import org.omg.uml.behavioralelements.collaborations.Collaboration;
import org.omg.uml.behavioralelements.commonbehavior.Instance;
import org.omg.uml.foundation.core.BehavioralFeature;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Dependency;
import org.omg.uml.foundation.core.GeneralizableElement;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Permission;
import org.omg.uml.foundation.datatypes.VisibilityKindEnum;
import org.omg.uml.modelmanagement.ElementImport;
import org.omg.uml.modelmanagement.Subsystem;
import org.omg.uml.modelmanagement.UmlPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelManagementHelperMDRImpl
implements ModelManagementHelper {
    private static final Logger LOG = Logger.getLogger(ModelManagementHelperMDRImpl.class);
    private MDRModelImplementation modelImpl;

    ModelManagementHelperMDRImpl(MDRModelImplementation implementation) {
        this.modelImpl = implementation;
    }

    @Override
    public Collection getAllSubSystems(Object ns) {
        if (ns == null) {
            return new ArrayList();
        }
        if (!(ns instanceof Namespace)) {
            throw new IllegalArgumentException();
        }
        Iterator it = ((Namespace)ns).getOwnedElement().iterator();
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof Namespace) {
                list.addAll(this.getAllSubSystems(o));
            }
            if (!(o instanceof Subsystem)) continue;
            list.add(o);
        }
        return list;
    }

    @Override
    public Collection getAllNamespaces(Object ns) {
        if (ns == null || !(ns instanceof Namespace)) {
            return Collections.EMPTY_LIST;
        }
        Collection namespaces = ((Namespace)ns).getOwnedElement();
        ArrayList list = Collections.EMPTY_LIST;
        if (namespaces == Collections.EMPTY_LIST || namespaces.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        for (Object o : namespaces) {
            if (!(o instanceof Namespace)) continue;
            if (list == Collections.EMPTY_LIST) {
                list = new ArrayList(namespaces.size());
            }
            list.add(o);
            Collection namespaces1 = this.getAllNamespaces(o);
            if (namespaces1 == Collections.EMPTY_LIST || namespaces1.size() <= 0) continue;
            list.addAll(namespaces1);
        }
        return list;
    }

    @Override
    public Collection getAllModelElementsOfKindWithModel(Object model, Object type) {
        if (model == null) {
            throw new IllegalArgumentException("A model must be supplied");
        }
        Class kind = (Class)type;
        ArrayList<Object> ret = this.getAllModelElementsOfKind(model, kind);
        if (kind.isAssignableFrom(model.getClass()) && !ret.contains(model)) {
            ret = new ArrayList<Object>(ret);
            ret.add(model);
        }
        return ret;
    }

    @Override
    public Collection getAllModelElementsOfKind(Object nsa, Object type) {
        long startTime = System.currentTimeMillis();
        if (nsa == null || type == null) {
            return Collections.EMPTY_LIST;
        }
        if (type instanceof String) {
            return this.getAllModelElementsOfKind(nsa, (String)type);
        }
        if (!(nsa instanceof Namespace) || !(type instanceof Class)) {
            throw new IllegalArgumentException("illegal argument - namespace: " + nsa + " type: " + type);
        }
        String name = ((Class)type).getName();
        if ((name = name.substring(name.lastIndexOf(".") + 1)).startsWith("Uml")) {
            name = name.substring(3);
        }
        Collection<Object> allOfType = Collections.emptySet();
        try {
            RefPackage extent = ((RefObject)nsa).refOutermostPackage();
            RefClass classProxy = ((FacadeMDRImpl)this.modelImpl.getFacade()).getProxy(name, extent);
            allOfType = classProxy.refAllOfType();
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        ArrayList<Object> returnElements = new ArrayList<Object>();
        for (Object me : allOfType) {
            if (!this.contained(nsa, me)) continue;
            returnElements.add(me);
        }
        long duration = System.currentTimeMillis() - startTime;
        LOG.debug((Object)("Get allOfKind took " + duration + " msec."));
        return returnElements;
    }

    private boolean contained(Object container, Object candidate) {
        RefFeatured current = ((RefObject)candidate).refImmediateComposite();
        while (current != null) {
            if (container.equals(current)) {
                return true;
            }
            current = ((RefObject)current).refImmediateComposite();
        }
        return false;
    }

    @Override
    public Collection getAllModelElementsOfKind(Object nsa, String kind) {
        if (nsa == null || kind == null) {
            return Collections.EMPTY_LIST;
        }
        if (!(nsa instanceof Namespace)) {
            throw new IllegalArgumentException("given argument " + nsa + " is not a namespace");
        }
        Collection col = null;
        try {
            col = this.getAllModelElementsOfKind(nsa, Class.forName(kind));
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Can't derive a class name from " + kind);
        }
        return col;
    }

    @Override
    public Collection getAllSurroundingNamespaces(Object ns) {
        if (!(ns instanceof Namespace)) {
            throw new IllegalArgumentException();
        }
        HashSet<Object> set = new HashSet<Object>();
        set.add(ns);
        Namespace namespace = (Namespace)ns;
        if (namespace.getNamespace() != null) {
            set.addAll(this.getAllSurroundingNamespaces(namespace.getNamespace()));
        }
        return set;
    }

    @Override
    public Collection getAllBehavioralFeatures(Object ns) {
        ArrayList features = new ArrayList();
        try {
            Collection classifiers = this.getAllModelElementsOfKind(ns, this.modelImpl.getMetaTypes().getClassifier());
            Iterator i = classifiers.iterator();
            while (i.hasNext()) {
                features.addAll(this.modelImpl.getFacade().getFeatures(i.next()));
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        ArrayList behavioralfeatures = new ArrayList();
        for (Object f : features) {
            if (!(f instanceof BehavioralFeature)) continue;
            behavioralfeatures.add(f);
        }
        return behavioralfeatures;
    }

    @Override
    public Collection getAllPossibleImports(Object pack) {
        Object container = pack;
        Object cc = this.modelImpl.getFacade().getModelElementContainer(pack);
        while (cc != null) {
            container = cc;
            cc = this.modelImpl.getFacade().getModelElementContainer(cc);
        }
        Collection mes = this.getAllModelElementsOfKind(container, this.modelImpl.getMetaTypes().getModelElement());
        ArrayList vmes = new ArrayList();
        for (Object me : mes) {
            if (!this.modelImpl.getCoreHelper().isValidNamespace(me, pack)) continue;
            vmes.add(me);
        }
        return vmes;
    }

    @Override
    public Object getElement(List<String> path, Object theRootNamespace) {
        ModelElement root = (ModelElement)theRootNamespace;
        if (root == null) {
            return this.getElement(path);
        }
        for (int i = 0; i < path.size(); ++i) {
            if (root == null || !(root instanceof Namespace)) {
                return null;
            }
            String name = path.get(i);
            boolean found = false;
            for (ModelElement me : ((Namespace)root).getOwnedElement()) {
                if (i < path.size() - 1 && !(me instanceof Namespace) || !name.equals(me.getName())) continue;
                root = me;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return root;
    }

    @Override
    public Object getElement(List<String> fullPath) {
        if (fullPath == null || fullPath.isEmpty()) {
            return null;
        }
        Object element = null;
        for (Object root : this.modelImpl.getFacade().getRootElements()) {
            if (!((ModelElement)root).getName().equals(fullPath.get(0))) continue;
            element = root;
            if (root instanceof Namespace && fullPath.size() > 1) {
                element = this.modelImpl.getModelManagementHelper().getElement(fullPath.subList(1, fullPath.size()), root);
            }
            if (element == null) continue;
            break;
        }
        return element;
    }

    @Override
    public List<String> getPathList(Object element) {
        if (element == null) {
            return new ArrayList<String>();
        }
        if (!(element instanceof RefObject)) {
            throw new IllegalArgumentException();
        }
        List<String> path = this.getPathList(((RefObject)element).refImmediateComposite());
        path.add(this.modelImpl.getFacade().getName(element));
        return path;
    }

    @Override
    public List<Object> getRootElements(Object model) {
        ArrayList<Object> contents = new ArrayList<Object>();
        contents.add(model);
        return contents;
    }

    @Override
    public boolean isCyclicOwnership(Object parent, Object child) {
        return this.getOwnerShipPath(parent).contains(child) || parent == child;
    }

    private List getOwnerShipPath(Object elem) {
        if (elem instanceof ModelElement) {
            ArrayList<Object> ownershipPath = new ArrayList<Object>();
            Object parent = this.modelImpl.getFacade().getModelElementContainer(elem);
            while (parent != null) {
                ownershipPath.add(parent);
                parent = this.modelImpl.getFacade().getModelElementContainer(parent);
            }
            return ownershipPath;
        }
        throw new IllegalArgumentException("Not a base");
    }

    @Override
    public void removeImportedElement(Object pack, Object me) {
        try {
            if (pack instanceof UmlPackage && me instanceof ModelElement) {
                Collection c = ((UmlPackage)pack).getElementImport();
                ElementImport match = null;
                for (ElementImport ei : c) {
                    if (ei.getImportedElement() != me) continue;
                    match = ei;
                    break;
                }
                if (match != null) {
                    c.remove(match);
                }
                return;
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        throw new IllegalArgumentException("There must be a Package and a ModelElement we got " + pack + " and " + me);
    }

    @Override
    public void setImportedElements(Object pack, Collection imports) {
        if (pack instanceof UmlPackage) {
            Collection currentImports = ((UmlPackage)pack).getElementImport();
            ArrayList<ElementImport> toRemove = new ArrayList<ElementImport>();
            ArrayList toAdd = new ArrayList(imports);
            for (ElementImport ei : currentImports) {
                if (imports.contains(ei.getImportedElement())) {
                    toAdd.remove(ei.getImportedElement());
                    continue;
                }
                toRemove.add(ei);
            }
            currentImports.removeAll(toRemove);
            ArrayList<Object> toAddEIs = new ArrayList<Object>();
            for (ModelElement me : toAdd) {
                toAddEIs.add(this.modelImpl.getModelManagementFactory().buildElementImport(pack, me));
            }
            currentImports.addAll(toAddEIs);
            return;
        }
        throw new IllegalArgumentException("There must be a Package and a ModelElement");
    }

    @Override
    public void setAlias(Object handle, String alias) {
        if (handle instanceof ElementImport && alias != null) {
            ((ElementImport)handle).setAlias(alias);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or alias: " + alias);
    }

    @Override
    public void setSpecification(Object handle, boolean specification) {
        if (handle instanceof ElementImport) {
            ((ElementImport)handle).setSpecification(specification);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle);
    }

    @Override
    public Collection<ModelElement> getContents(Object modelelement) {
        if (modelelement instanceof UmlPackage) {
            return ModelManagementHelperMDRImpl.getContents((UmlPackage)modelelement);
        }
        if (modelelement instanceof Namespace) {
            return ModelManagementHelperMDRImpl.getContents((Namespace)modelelement);
        }
        if (modelelement instanceof Instance) {
            return ModelManagementHelperMDRImpl.getContents((Instance)modelelement);
        }
        if (modelelement == null) {
            return Collections.emptySet();
        }
        throw new IllegalArgumentException("Unsupported element type " + modelelement);
    }

    private void getContents(Collection<ModelElement> results, Object modelelement) {
        if (modelelement instanceof UmlPackage) {
            ModelManagementHelperMDRImpl.getContents(results, (UmlPackage)modelelement);
            return;
        }
        if (modelelement instanceof Namespace) {
            ModelManagementHelperMDRImpl.getContents(results, (Namespace)modelelement);
            return;
        }
        if (modelelement instanceof Instance) {
            ModelManagementHelperMDRImpl.getContents(results, (Instance)modelelement);
            return;
        }
        if (modelelement == null) {
            return;
        }
        throw new IllegalArgumentException("Unsupported element type " + modelelement);
    }

    static Collection<ModelElement> getContents(UmlPackage pkg) {
        ArrayList<ModelElement> results = new ArrayList<ModelElement>();
        Collection c = pkg.getElementImport();
        for (ElementImport ei : c) {
            results.add(ei.getImportedElement());
        }
        results.addAll(ModelManagementHelperMDRImpl.getContents((Namespace)pkg));
        return results;
    }

    private static void getContents(Collection<ModelElement> results, UmlPackage pkg) {
        Collection c = pkg.getElementImport();
        for (ElementImport ei : c) {
            results.add(ei.getImportedElement());
        }
        ModelManagementHelperMDRImpl.getContents(results, (Namespace)pkg);
    }

    static Collection<ModelElement> getContents(Namespace namespace) {
        ArrayList<ModelElement> results = new ArrayList<ModelElement>();
        results.addAll(namespace.getOwnedElement());
        Namespace owner = namespace.getNamespace();
        if (owner != null) {
            results.addAll(ModelManagementHelperMDRImpl.getContents(owner));
        }
        return results;
    }

    private static void getContents(Collection<ModelElement> results, Namespace namespace) {
        results.addAll(namespace.getOwnedElement());
        Namespace owner = namespace.getNamespace();
        if (owner != null) {
            ModelManagementHelperMDRImpl.getContents(results, owner);
        }
    }

    static Collection<ModelElement> getContents(Instance instance) {
        ArrayList<ModelElement> results = new ArrayList<ModelElement>();
        results.addAll(instance.getOwnedInstance());
        results.addAll(instance.getOwnedLink());
        return results;
    }

    private static void getContents(Collection<ModelElement> results, Instance instance) {
        results.addAll(instance.getOwnedInstance());
        results.addAll(instance.getOwnedLink());
    }

    @Override
    public Collection<ModelElement> getAllImportedElements(Object pack) {
        if (!(pack instanceof Namespace)) {
            return Collections.emptyList();
        }
        ArrayList<ModelElement> ret = new ArrayList<ModelElement>();
        this.getAllImportedElements(ret, pack);
        return ret;
    }

    private void getAllImportedElements(Collection<ModelElement> results, Object pack) {
        if (!(pack instanceof Namespace)) {
            return;
        }
        Namespace ns = (Namespace)pack;
        try {
            Collection deps = ns.getClientDependency();
            for (Dependency dep : deps) {
                if (!(dep instanceof Permission)) continue;
                if (this.modelImpl.getExtensionMechanismsHelper().hasStereotype(dep, "friend")) {
                    for (ModelElement o : dep.getSupplier()) {
                        if (!(o instanceof Namespace)) continue;
                        results.addAll(((Namespace)o).getOwnedElement());
                    }
                    continue;
                }
                if (!this.modelImpl.getExtensionMechanismsHelper().hasStereotype(dep, "import") && !this.modelImpl.getExtensionMechanismsHelper().hasStereotype(dep, "access")) continue;
                for (ModelElement o : dep.getSupplier()) {
                    if (!(o instanceof Namespace)) continue;
                    results.addAll(CoreHelperMDRImpl.getAllVisibleElements((Namespace)o));
                }
            }
            if (ns instanceof UmlPackage) {
                results.addAll(this.modelImpl.getFacade().getImportedElements(ns));
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
    }

    @Override
    public Collection<ModelElement> getAllContents(Object pack) {
        HashSet<ModelElement> results = new HashSet<ModelElement>(2000);
        HashSet<ModelElement> dupCheck = new HashSet<ModelElement>(2000);
        this.getAllContents(results, (ModelElement)pack, dupCheck);
        return results;
    }

    void getAllContents(Collection<ModelElement> results, ModelElement pack, Collection<ModelElement> dupCheck) {
        if (pack == null || dupCheck.contains(pack)) {
            return;
        }
        dupCheck.add(pack);
        try {
            if (pack instanceof Namespace) {
                this.getContents(results, pack);
            }
            if (pack instanceof Classifier || pack instanceof UmlPackage) {
                Collection<GeneralizableElement> parents = CoreHelperMDRImpl.getParents((GeneralizableElement)pack);
                HashSet<ModelElement> allContents = new HashSet<ModelElement>(2000);
                for (GeneralizableElement parent : parents) {
                    this.getAllContents(allContents, (ModelElement)parent, dupCheck);
                }
                if (pack instanceof UmlPackage) {
                    this.getAllImportedElements(allContents, pack);
                    for (GeneralizableElement parent : parents) {
                        this.getAllImportedElements(allContents, parent);
                    }
                }
                for (ModelElement element : allContents) {
                    if (!VisibilityKindEnum.VK_PUBLIC.equals((Object)element.getVisibility()) && !VisibilityKindEnum.VK_PROTECTED.equals((Object)element.getVisibility())) continue;
                    results.add(element);
                }
            }
            if (pack instanceof Collaboration) {
                LOG.debug((Object)("Not implemented - getAllContents for: " + pack));
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
    }

    @Override
    public boolean isReadOnly(Object element) {
        try {
            RefPackage extent = ((RefObject)element).refOutermostPackage();
            return this.modelImpl.isReadOnly(extent);
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
    }
}

