/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.argouml.core.propertypanels.ui.UMLValueSpecificationModel;
import org.argouml.core.propertypanels.ui.UMLValueSpecificationValueField;
import org.argouml.i18n.Translator;
import org.argouml.ui.LookAndFeelMgr;

class UMLValueSpecificationValueFieldLiteralBoolean
extends UMLValueSpecificationValueField {
    private JRadioButton trueButton;
    private JRadioButton falseButton;
    private ButtonGroup trueFalseGroup;
    private boolean activeUpdateModele = true;

    public UMLValueSpecificationValueFieldLiteralBoolean(UMLValueSpecificationModel model, boolean notify) {
        super(model, notify);
    }

    public void buildPanel() {
        this.trueButton = new JRadioButton(Translator.localize((String)"misc.boolean.true"));
        this.falseButton = new JRadioButton(Translator.localize((String)"misc.boolean.false"));
        this.trueFalseGroup = new ButtonGroup();
        this.trueFalseGroup.add(this.trueButton);
        this.trueFalseGroup.add(this.falseButton);
        this.trueButton.setFont(LookAndFeelMgr.getInstance().getStandardFont());
        this.falseButton.setFont(LookAndFeelMgr.getInstance().getStandardFont());
        this.trueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UMLValueSpecificationValueFieldLiteralBoolean.this.updateModel();
            }
        });
        this.falseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UMLValueSpecificationValueFieldLiteralBoolean.this.updateModel();
            }
        });
        JPanel panel = new JPanel();
        panel.add(this.trueButton);
        panel.add(this.falseButton);
        this.allField = new JScrollPane(panel);
    }

    protected void updateModel() {
        boolean newSelected;
        boolean oldSelected;
        if (this.activeUpdateModele && (oldSelected = this.trueButton.isSelected()) != (newSelected = this.isToCheck())) {
            Object[] values = new Boolean[]{this.trueButton.isSelected()};
            this.getModel().setValue(values);
        }
    }

    protected void updateFields() {
        boolean newSelected;
        boolean oldSelected = this.trueButton.isSelected();
        if (oldSelected != (newSelected = this.isToCheck())) {
            boolean oldActiveUpdateModele = this.activeUpdateModele;
            this.activeUpdateModele = false;
            this.trueButton.setSelected(newSelected);
            this.falseButton.setSelected(!newSelected);
            this.activeUpdateModele = oldActiveUpdateModele;
        } else {
            oldSelected = this.falseButton.isSelected();
            if (!oldSelected && !newSelected) {
                boolean oldActiveUpdateModele = this.activeUpdateModele;
                this.activeUpdateModele = false;
                this.falseButton.setSelected(true);
                this.activeUpdateModele = oldActiveUpdateModele;
            }
        }
    }

    public boolean isToCheck() {
        Boolean[] values = (Boolean[])this.getModel().getValue();
        return values[0];
    }
}

