/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.argouml.core.propertypanels.ui.UMLModelElementListModel;
import org.argouml.i18n.Translator;
import org.argouml.model.Model;
import org.argouml.uml.ui.AbstractActionAddModelElement2;
import org.argouml.uml.ui.AbstractActionRemoveElement;

class UMLStereotypeBaseClassListModel
extends UMLModelElementListModel {
    public UMLStereotypeBaseClassListModel(Object modelElement) {
        super("baseClass", modelElement.getClass(), (AbstractActionAddModelElement2)new ActionAddStereotypeBaseClass(), new ActionDeleteStereotypeBaseClass());
        this.setTarget(modelElement);
    }

    protected void buildModelList() {
        this.removeAllElements();
        if (Model.getFacade().isAStereotype(this.getTarget())) {
            LinkedList lst = new LinkedList(Model.getFacade().getBaseClasses(this.getTarget()));
            Collections.sort(lst);
            this.addAll((Collection)lst);
        }
    }

    protected boolean isValidElement(Object element) {
        return Model.getFacade().isAStereotype(element);
    }

    private static class ActionDeleteStereotypeBaseClass
    extends AbstractActionRemoveElement {
        public ActionDeleteStereotypeBaseClass() {
            super(Translator.localize((String)"menu.popup.remove"));
        }

        public void actionPerformed(ActionEvent e) {
            Object baseclass = this.getObjectToRemove();
            if (baseclass != null) {
                Object st = this.getTarget();
                if (Model.getFacade().isAStereotype(st)) {
                    Model.getExtensionMechanismsHelper().removeBaseClass(st, baseclass);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionAddStereotypeBaseClass
    extends AbstractActionAddModelElement2 {
        private List<String> metaClasses;

        public ActionAddStereotypeBaseClass() {
            this.initMetaClasses();
        }

        void initMetaClasses() {
            Collection tmpMetaClasses = Model.getCoreHelper().getAllMetatypeNames();
            this.metaClasses = tmpMetaClasses instanceof List ? (List<Object>)tmpMetaClasses : new LinkedList<String>(tmpMetaClasses);
            try {
                Collections.sort(this.metaClasses);
            }
            catch (UnsupportedOperationException e) {
                this.metaClasses = new LinkedList<String>(tmpMetaClasses);
                Collections.sort(this.metaClasses);
            }
        }

        protected List<String> getChoices() {
            return Collections.unmodifiableList(this.metaClasses);
        }

        protected String getDialogTitle() {
            return Translator.localize((String)"dialog.title.add-baseclasses");
        }

        protected List<String> getSelected() {
            ArrayList<String> result = new ArrayList<String>();
            if (Model.getFacade().isAStereotype(this.getTarget())) {
                Collection bases = Model.getFacade().getBaseClasses(this.getTarget());
                result.addAll(bases);
            }
            return result;
        }

        protected void doIt(Collection selected) {
            Object stereo = this.getTarget();
            HashSet<String> oldSet = new HashSet<String>(this.getSelected());
            HashSet<String> toBeRemoved = new HashSet<String>(oldSet);
            for (Object e : selected) {
                if (oldSet.contains(e)) {
                    toBeRemoved.remove(e);
                    continue;
                }
                Model.getExtensionMechanismsHelper().addBaseClass(stereo, e);
            }
            for (Object e : toBeRemoved) {
                Model.getExtensionMechanismsHelper().removeBaseClass(stereo, e);
            }
        }
    }
}

