/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;
import org.argouml.core.propertypanels.ui.UMLDocument;
import org.argouml.model.AttributeChangeEvent;
import org.argouml.model.Model;
import org.argouml.model.ModelEventPump;

abstract class UMLPlainTextDocument
extends PlainDocument
implements UMLDocument {
    private static final Logger LOG = Logger.getLogger(UMLPlainTextDocument.class);
    private boolean firing = true;
    @Deprecated
    private boolean editing = false;
    private Object target = null;
    private String eventName = null;

    public UMLPlainTextDocument(String name, Object target) {
        this.setEventName(name);
        this.setTarget(target);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof AttributeChangeEvent && this.eventName.equals(evt.getPropertyName())) {
            this.updateText((String)evt.getNewValue());
        }
    }

    public final Object getTarget() {
        return this.target;
    }

    public final void setTarget(Object target) {
        ModelEventPump eventPump = Model.getPump();
        this.target = target;
        eventPump.addModelEventListener((PropertyChangeListener)this, this.target, this.getEventName());
        this.updateText(this.getProperty());
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offset, str, a);
        this.setPropertyInternal(this.getText(0, this.getLength()));
    }

    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.setPropertyInternal(this.getText(0, this.getLength()));
    }

    private void setPropertyInternal(String newValue) {
        if (this.isFiring() && !newValue.equals(this.getProperty())) {
            this.setFiring(false);
            this.setProperty(newValue);
            Model.getPump().flushModelEvents();
            this.setFiring(true);
        }
    }

    protected abstract void setProperty(String var1);

    protected abstract String getProperty();

    final synchronized void setFiring(boolean f) {
        ModelEventPump eventPump = Model.getPump();
        if (f && this.target != null) {
            eventPump.addModelEventListener((PropertyChangeListener)this, this.target, this.eventName);
        } else {
            eventPump.removeModelEventListener((PropertyChangeListener)this, this.target, this.eventName);
        }
        this.firing = f;
    }

    private final synchronized boolean isFiring() {
        return this.firing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateText(String textValue) {
        try {
            if (textValue == null) {
                textValue = "";
            }
            String currentValue = this.getText(0, this.getLength());
            if (this.isFiring() && !textValue.equals(currentValue)) {
                this.setFiring(false);
                super.remove(0, this.getLength());
                super.insertString(0, textValue, null);
            }
        }
        catch (BadLocationException b) {
            LOG.error((Object)("A BadLocationException happened\nThe string to set was: " + this.getProperty()), (Throwable)b);
        }
        finally {
            this.setFiring(true);
        }
    }

    public String getEventName() {
        return this.eventName;
    }

    protected void setEventName(String en) {
        this.eventName = en;
    }
}

