/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JCheckBox;
import org.argouml.core.propertypanels.model.GetterSetterManager;
import org.argouml.i18n.Translator;
import org.argouml.model.Model;
import org.argouml.ui.LookAndFeelMgr;
import org.argouml.ui.UndoableAction;

class CheckBox
extends JCheckBox
implements PropertyChangeListener {
    private static final long serialVersionUID = 2654856740168885592L;
    private final Object modelElement;
    private final String propertyName;
    private final Action action;
    private final GetterSetterManager getterSetter;

    public CheckBox(String text, Object modelElement, String propertyName, GetterSetterManager getterSetter) {
        super(text);
        this.getterSetter = getterSetter;
        this.propertyName = propertyName;
        this.modelElement = modelElement;
        this.setFont(LookAndFeelMgr.getInstance().getStandardFont());
        this.build();
        this.action = new SetAction(getterSetter, modelElement, propertyName);
        this.setActionCommand((String)this.action.getValue("ActionCommandKey"));
        this.addActionListener(this.action);
        Model.getPump().addModelEventListener((PropertyChangeListener)this, modelElement, propertyName);
    }

    private String propertyToLabel(String propertyName) {
        if (propertyName.startsWith("is")) {
            return "checkbox." + propertyName.substring(2).toLowerCase();
        }
        return "checkbox." + propertyName.toLowerCase();
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeActionListener(this.action);
        Model.getPump().removeModelEventListener((PropertyChangeListener)this, this.modelElement, this.propertyName);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.build();
    }

    private void build() {
        if (this.getterSetter != null) {
            this.setSelected((Boolean)this.getterSetter.get(this.modelElement, this.propertyName, null));
        }
    }

    private static class SetAction
    extends UndoableAction {
        private static final long serialVersionUID = -2708077474004286682L;
        private final GetterSetterManager getterSetter;
        private final String propertyName;
        private Object modelElement;

        protected SetAction(GetterSetterManager getterSetter, Object modelElement, String propertyName) {
            super(Translator.localize((String)"Set"), null);
            this.modelElement = modelElement;
            this.getterSetter = getterSetter;
            this.propertyName = propertyName;
            this.putValue("ShortDescription", Translator.localize((String)"Set"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            CheckBox source = (CheckBox)e.getSource();
            this.getterSetter.set(this.modelElement, source.isSelected(), this.propertyName);
        }
    }
}

