/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.normalize;

import java.util.HashSet;
import java.util.Iterator;
import tudresden.ocl.OclException;
import tudresden.ocl.OclTree;
import tudresden.ocl.check.TypeChecker;
import tudresden.ocl.check.types.Any;
import tudresden.ocl.check.types.Collection;
import tudresden.ocl.check.types.Type;
import tudresden.ocl.normalize.NodeNormalizer;
import tudresden.ocl.normalize.NormalizerPass;
import tudresden.ocl.parser.node.AActualParameterList;
import tudresden.ocl.parser.node.ABagCollectionType;
import tudresden.ocl.parser.node.ACollectionCollectionType;
import tudresden.ocl.parser.node.ACollectionTypeName;
import tudresden.ocl.parser.node.ADeclaratorTypeDeclaration;
import tudresden.ocl.parser.node.AExpression;
import tudresden.ocl.parser.node.AFeatureCallParameters;
import tudresden.ocl.parser.node.ALetExpression;
import tudresden.ocl.parser.node.ALetExpressionTypeDeclaration;
import tudresden.ocl.parser.node.ANonCollectionTypeName;
import tudresden.ocl.parser.node.APathSimpleTypeSpecifier;
import tudresden.ocl.parser.node.APathTypeName;
import tudresden.ocl.parser.node.ASequenceCollectionType;
import tudresden.ocl.parser.node.ASetCollectionType;
import tudresden.ocl.parser.node.AStandardDeclarator;
import tudresden.ocl.parser.node.Node;
import tudresden.ocl.parser.node.PCollectionType;
import tudresden.ocl.parser.node.TColon;
import tudresden.ocl.parser.node.TLPar;
import tudresden.ocl.parser.node.TRPar;
import tudresden.ocl.parser.node.TSimpleTypeName;
import tudresden.ocl.parser.node.TTBag;
import tudresden.ocl.parser.node.TTCollection;
import tudresden.ocl.parser.node.TTSequence;
import tudresden.ocl.parser.node.TTSet;

public class TypeInformationInsertion
implements NodeNormalizer {
    static HashSet setOfAllIteratingMethodNames = new HashSet(TypeChecker.setOfIteratingMethodNames);

    public void normalize(Node n, OclTree tree) {
        ALetExpression le;
        if (n instanceof AStandardDeclarator) {
            AStandardDeclarator sd = (AStandardDeclarator)n;
            if (sd.getDeclaratorTypeDeclaration() == null) {
                String iteratorName = sd.getName().toString().trim();
                AFeatureCallParameters fcp = (AFeatureCallParameters)sd.parent();
                AActualParameterList apl = (AActualParameterList)fcp.getActualParameterList();
                if (apl == null) {
                    throw new OclException("feature call must not have a declarator but no parameter in " + fcp);
                }
                Type t = tree.getTypeFor(iteratorName, apl.getExpression());
                APathTypeName ptn = this.getPathTypeName(t);
                sd.setDeclaratorTypeDeclaration(new ADeclaratorTypeDeclaration(new TColon(), new APathSimpleTypeSpecifier(ptn)));
            }
        } else if (n instanceof ALetExpression && (le = (ALetExpression)n).getLetExpressionTypeDeclaration() == null) {
            AExpression exp = (AExpression)le.parent();
            Iterator iter = exp.getLetExpression().iterator();
            while (iter.hasNext() && iter.next() != le) {
            }
            Node next = iter.hasNext() ? (Node)iter.next() : exp.getLogicalExpression();
            String letVarName = le.getName().toString().trim();
            Type t = tree.getTypeFor(letVarName, next);
            APathTypeName ptn = this.getPathTypeName(t);
            le.setLetExpressionTypeDeclaration(new ALetExpressionTypeDeclaration(new TColon(), ptn));
        }
    }

    public APathTypeName getPathTypeName(Type t) {
        APathTypeName ptn = new APathTypeName();
        if (t instanceof Collection) {
            PCollectionType ct;
            Collection c = (Collection)t;
            Any elementType = c.getElementType();
            switch (c.getCollectionKind()) {
                case 47: {
                    ct = new ASetCollectionType(new TTSet("Set"));
                    break;
                }
                case 97: {
                    ct = new ABagCollectionType(new TTBag("Bag"));
                    break;
                }
                case 690: {
                    ct = new ASequenceCollectionType(new TTSequence("Sequence"));
                    break;
                }
                case 23: {
                    ct = new ACollectionCollectionType(new TTCollection("Collection"));
                    break;
                }
                default: {
                    throw new RuntimeException("illegal collection kind");
                }
            }
            ptn.setTypeName(new ACollectionTypeName(ct, new TLPar(), new TSimpleTypeName(elementType.toString()), new TRPar()));
        } else {
            ptn.setTypeName(new ANonCollectionTypeName(new TSimpleTypeName(t.toString())));
        }
        return ptn;
    }

    public void open(OclTree tree, NormalizerPass pass) {
    }

    public void close(OclTree tree, NormalizerPass pass) {
    }

    static {
        setOfAllIteratingMethodNames.add("iterate");
    }
}

