/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.metal.MetalToolBarUI;
import tudresden.ocl.gui.OCLEditor;

public class OCLToolbar
extends JToolBar
implements ActionListener {
    private JFrame m_jfFloatFrame = null;
    private boolean m_fFloatRequest = false;
    private WeakReference m_wrocleEditor;

    public OCLToolbar() {
        this.setName("OCL Syntax Assistant");
        this.initComponents();
    }

    public void setEditor(OCLEditor ocle) {
        this.m_wrocleEditor = new WeakReference<OCLEditor>(ocle);
    }

    public OCLEditor getEditor() {
        if (this.m_wrocleEditor == null) {
            return null;
        }
        return (OCLEditor)this.m_wrocleEditor.get();
    }

    public void setVisible(boolean fVisible) {
        if (this.m_jfFloatFrame != null && this.getUI() instanceof BasicToolBarUI && ((BasicToolBarUI)this.getUI()).isFloating()) {
            ((Component)this.m_jfFloatFrame).setVisible(fVisible);
        }
        super.setVisible(fVisible);
    }

    protected void updateFloating() {
        if (!this.m_fFloatRequest) {
            super.setFloatable(false);
        } else if (this.getUI() instanceof MetalToolBarUI || this.getUI() instanceof BasicToolBarUI) {
            super.setFloatable(true);
        } else {
            super.setFloatable(false);
        }
    }

    public void setFloatable(boolean fFloatRequest) {
        if (this.m_fFloatRequest != fFloatRequest) {
            this.m_fFloatRequest = fFloatRequest;
            this.updateFloating();
        }
    }

    public void setUI(ToolBarUI tbui) {
        if (tbui instanceof MetalToolBarUI) {
            super.setUI(new MetalToolBarUI(){

                protected JFrame createFloatingFrame(JToolBar jtb) {
                    if (jtb == OCLToolbar.this) {
                        if (OCLToolbar.this.m_jfFloatFrame == null) {
                            OCLToolbar.this.m_jfFloatFrame = super.createFloatingFrame(jtb);
                        }
                        return OCLToolbar.this.m_jfFloatFrame;
                    }
                    return super.createFloatingFrame(jtb);
                }
            });
        } else if (tbui instanceof BasicToolBarUI) {
            super.setUI(new BasicToolBarUI(){

                protected JFrame createFloatingFrame(JToolBar jtb) {
                    if (jtb == OCLToolbar.this) {
                        if (OCLToolbar.this.m_jfFloatFrame == null) {
                            OCLToolbar.this.m_jfFloatFrame = super.createFloatingFrame(jtb);
                        }
                        return OCLToolbar.this.m_jfFloatFrame;
                    }
                    return super.createFloatingFrame(jtb);
                }
            });
        } else {
            super.setUI(tbui);
        }
        this.updateFloating();
    }

    private void initComponents() {
        this.setFloatable(true);
        JComboBox<ActionItem> jcb = new JComboBox<ActionItem>(new ActionItem[]{new ActionItem("General", -1), new ActionItem("inv", 0), new ActionItem("pre", 0), new ActionItem("post", 0), new ActionItem("self", 1), new ActionItem("@pre", 2), new ActionItem("result", 3)});
        jcb.addActionListener(this);
        this.add(jcb);
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(null, "\n" + sOCLText + " ", new String[]{"tmp"});
                ocle.addConstraintText(new String[]{"constraint name"}, ": ", new String[]{"constraint expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(null, "self.", new String[]{"attribute, association or query method"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"attribute or association"}, "@pre ", null);
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(null, "result ", null);
            }
        });
        jcb = new JComboBox<ActionItem>(new ActionItem[]{new ActionItem("Basic Operators", -1), new ActionItem("=", 4), new ActionItem("<>", 4), new ActionItem("<", 4), new ActionItem(">", 4), new ActionItem("<=", 4), new ActionItem(">=", 4), new ActionItem("()", 5)});
        jcb.addActionListener(this);
        this.add(jcb);
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"expression"}, " " + sOCLText + " ", new String[]{"expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, ")", null);
                ocle.addConstraintText(null, "(", new String[]{"expression"});
            }
        });
        jcb = new JComboBox<ActionItem>(new ActionItem[]{new ActionItem("Numbers", -1), new ActionItem("+", 6), new ActionItem("-", 6), new ActionItem("*", 6), new ActionItem("/", 6), new ActionItem("mod", 7), new ActionItem("div", 7), new ActionItem("abs", 8), new ActionItem("max", 7), new ActionItem("min", 7), new ActionItem("round", 8), new ActionItem("floor", 8)});
        jcb.addActionListener(this);
        this.add(jcb);
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"numeric expression"}, " " + sOCLText + " ", new String[]{"numeric expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, ")", null);
                ocle.addConstraintText(new String[]{"numeric expression"}, "." + sOCLText + " (", new String[]{"numeric expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"numeric expression"}, "." + sOCLText + " ", null);
            }
        });
        jcb = new JComboBox<ActionItem>(new ActionItem[]{new ActionItem("Strings", -1), new ActionItem("concat", 9), new ActionItem("size", 10), new ActionItem("toLower", 10), new ActionItem("toUpper", 10), new ActionItem("substring", 11)});
        jcb.addActionListener(this);
        this.add(jcb);
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, ")", null);
                ocle.addConstraintText(new String[]{"string expression"}, "." + sOCLText + " (", new String[]{"string expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"string expression"}, "." + sOCLText + " ", null);
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, ")", null);
                ocle.addConstraintText(new String[]{"tmp"}, ", ", new String[]{"integer expression"});
                ocle.addConstraintText(new String[]{"string expression"}, "." + sOCLText + " (", new String[]{"integer expression"});
            }
        });
        jcb = new JComboBox<ActionItem>(new ActionItem[]{new ActionItem("Booleans", -1), new ActionItem("or", 12), new ActionItem("and", 12), new ActionItem("xor", 12), new ActionItem("not", 13), new ActionItem("implies", 12), new ActionItem("if then else", 14)});
        jcb.addActionListener(this);
        this.add(jcb);
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"boolean expression"}, " " + sOCLText + " ", new String[]{"boolean expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(null, sOCLText + " ", new String[]{"boolean expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, " endif", null);
                ocle.addConstraintText(new String[]{"tmp"}, " else ", new String[]{"expression"});
                ocle.addConstraintText(new String[]{"tmp"}, " then ", new String[]{"expression"});
                ocle.addConstraintText(null, "if ", new String[]{"boolean expression"});
            }
        });
        jcb = new JComboBox<ActionItem>(new ActionItem[]{new ActionItem("Collections", -1), new ActionItem("-----------", Integer.MAX_VALUE), new ActionItem("General", Integer.MAX_VALUE), new ActionItem("-----------", Integer.MAX_VALUE), new ActionItem("Collection {}", "Collection", 15), new ActionItem("Set {}", "Set", 15), new ActionItem("Bag {}", "Bag", 15), new ActionItem("Sequence {}", "Sequence", 15), new ActionItem("size", 16), new ActionItem("count", 17), new ActionItem("isEmpty", 16), new ActionItem("notEmpty", 16), new ActionItem("includes", 17), new ActionItem("includesAll", 18), new ActionItem("iterate", 19), new ActionItem("exists", 19), new ActionItem("forAll", 19), new ActionItem("collect", 19), new ActionItem("select", 19), new ActionItem("reject", 19), new ActionItem("union", 18), new ActionItem("intersection", 18), new ActionItem("including", 17), new ActionItem("excluding", 17), new ActionItem("sum", 20), new ActionItem("-----------", Integer.MAX_VALUE), new ActionItem("Sets", Integer.MAX_VALUE), new ActionItem("-----------", Integer.MAX_VALUE), new ActionItem("-", 21), new ActionItem("symmetricDifference", 22), new ActionItem("-----------", Integer.MAX_VALUE), new ActionItem("Sequences", Integer.MAX_VALUE), new ActionItem("-----------", Integer.MAX_VALUE), new ActionItem("first", 23), new ActionItem("last", 23), new ActionItem("at", 24), new ActionItem("append", 25), new ActionItem("prepend", 25), new ActionItem("subSequence", 26)});
        jcb.addActionListener(this);
        this.add(jcb);
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, "}", null);
                ocle.addConstraintText(null, sOCLText + " {", new String[]{"element list"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"collection expression"}, "->" + sOCLText, null);
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, ")", null);
                ocle.addConstraintText(new String[]{"collection expression"}, "->" + sOCLText + " (", new String[]{"element expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, ")", null);
                ocle.addConstraintText(new String[]{"collection expression"}, "->" + sOCLText + " (", new String[]{"collection expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, ")", null);
                ocle.addConstraintText(new String[]{"tmp"}, " | ", new String[]{"expression"});
                ocle.addConstraintText(new String[]{"tmp"}, " : ", new String[]{"type"});
                ocle.addConstraintText(new String[]{"collection expression "}, "->" + sOCLText + " (", new String[]{"element variable"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"collection expression"}, "->" + sOCLText + "()", null);
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"set expression"}, " " + sOCLText + " ", new String[]{"set expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, ")", null);
                ocle.addConstraintText(new String[]{"set expression"}, "->" + sOCLText + " (", new String[]{"set expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"sequence expression"}, "->" + sOCLText, null);
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, ")", null);
                ocle.addConstraintText(new String[]{"sequence expression"}, "->" + sOCLText + " (", new String[]{"integer expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, ")", null);
                ocle.addConstraintText(new String[]{"sequence expression"}, "->" + sOCLText + " (", new String[]{"element expression"});
            }
        });
        ActionItem.addShortCut(new ActionItem.ShortCutAction(){

            public void performShortCut(String sOCLText, OCLEditor ocle) {
                ocle.addConstraintText(new String[]{"tmp"}, ")", null);
                ocle.addConstraintText(new String[]{"tmp"}, ", ", new String[]{"integer expression"});
                ocle.addConstraintText(new String[]{"sequence expression"}, "->" + sOCLText + " (", new String[]{"integer expression"});
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        JComboBox jcb = (JComboBox)e.getSource();
        ActionItem ai = (ActionItem)jcb.getSelectedItem();
        if (ai != null) {
            ai.perform(jcb, this.getEditor());
        }
    }

    private static final class ActionItem {
        public static final int DUMMY_ACTION = Integer.MAX_VALUE;
        private static ArrayList s_aalActions = new ArrayList();
        private String m_sCaption;
        private String m_sOCLText;
        private int m_nActionIdx;

        public ActionItem(String sCaption, String sOCLText, int nActionIdx) {
            this.m_sCaption = sCaption;
            this.m_sOCLText = sOCLText;
            this.m_nActionIdx = nActionIdx;
        }

        public ActionItem(String sOCLText, int nActionID) {
            this(sOCLText, sOCLText, nActionID);
        }

        public String toString() {
            return this.getCaption();
        }

        public String getCaption() {
            return this.m_sCaption;
        }

        public String getOCLText() {
            return this.m_sOCLText;
        }

        public void perform(JComboBox jcb, OCLEditor ocle) {
            if (this.m_nActionIdx >= 0) {
                if (this.m_nActionIdx != Integer.MAX_VALUE && ocle != null) {
                    ShortCutAction sca = (ShortCutAction)s_aalActions.get(this.m_nActionIdx);
                    sca.performShortCut(this.getOCLText(), ocle);
                }
                jcb.setSelectedIndex(0);
            }
        }

        public static void addShortCut(ShortCutAction sca) {
            s_aalActions.add(sca);
        }

        public static interface ShortCutAction {
            public void performShortCut(String var1, OCLEditor var2);
        }
    }
}

