/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreeindex;

import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.Btree;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePage;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.BtreePageSource;
import org.netbeans.mdr.persistence.btreeimpl.btreeindex.SearchResult;

public class BtreeKeySet
extends AbstractSet {
    private Btree btree;

    BtreeKeySet(Btree btree) {
        this.btree = btree;
    }

    public int size() {
        int count = 0;
        BtreeKeyIterator i = new BtreeKeyIterator();
        while (i.hasNext()) {
            i.nextKey();
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public Iterator iterator() {
        return new BtreeKeyIterator();
    }

    public class BtreeKeyIterator
    implements Iterator {
        protected SearchResult current;
        protected BtreePageSource pageSource;
        protected int modCount;

        BtreeKeyIterator() {
            try {
                BtreeKeySet.this.btree.beginRead();
                this.modCount = ((BtreeKeySet)BtreeKeySet.this).btree.modCount;
                this.pageSource = ((BtreeKeySet)BtreeKeySet.this).btree.pageSource;
                this.current = BtreeKeySet.this.btree.getFirst();
                if (this.current.entryNum >= 0) {
                    --this.current.entryNum;
                }
            }
            catch (StorageException e) {
                throw new RuntimeStorageException(e);
            }
            finally {
                BtreeKeySet.this.btree.endRead();
            }
        }

        public boolean hasNext() {
            boolean result;
            try {
                BtreeKeySet.this.btree.beginRead();
                this.checkModCount();
                if (!BtreePage.hasNext(null, this.current)) {
                    this.pageSource.unpinPage(this.current.page);
                    this.current.page = null;
                    result = false;
                } else {
                    result = true;
                }
            }
            catch (StorageException se) {
                throw new RuntimeStorageException(se);
            }
            finally {
                BtreeKeySet.this.btree.endRead();
            }
            return result;
        }

        public Object next() throws NoSuchElementException {
            byte[] key = this.nextKey();
            return ((BtreeKeySet)BtreeKeySet.this).btree.keyInfo.fromBuffer(key);
        }

        /*
         * WARNING - void declaration
         */
        private byte[] nextKey() throws NoSuchElementException {
            void var2_2;
            if (this.current.page == null) {
                throw new NoSuchElementException();
            }
            try {
                BtreeKeySet.this.btree.beginRead();
                this.checkModCount();
                BtreePage oldPage = this.current.page;
                BtreePage.getNext(null, this.current);
                if (this.current.page != oldPage) {
                    this.pageSource.unpinPage(oldPage);
                }
                if (this.current.matched) {
                    byte[] key = this.current.page.getKey(this.current.entryNum);
                } else {
                    throw new NoSuchElementException();
                }
                while (BtreePage.hasNext((byte[])var2_2, this.current)) {
                    oldPage = this.current.page;
                    BtreePage.getNext(null, this.current);
                    if (this.current.page == oldPage) continue;
                    this.pageSource.unpinPage(oldPage);
                }
            }
            catch (StorageException e) {
                throw new RuntimeStorageException(e);
            }
            finally {
                BtreeKeySet.this.btree.endRead();
            }
            return var2_2;
        }

        private void checkModCount() {
            if (((BtreeKeySet)BtreeKeySet.this).btree.modCount > this.modCount) {
                throw new ConcurrentModificationException("Index " + BtreeKeySet.this.btree.getName() + " has been modified since iterator was created.");
            }
        }

        protected void finalize() {
            if (this.current.page != null) {
                this.pageSource.unpinPage(this.current.page);
                this.current.page = null;
            }
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

