/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.reveng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.argouml.kernel.ProjectManager;
import org.argouml.language.java.reveng.ClassifierNotFoundException;
import org.argouml.language.java.reveng.Context;
import org.argouml.language.java.reveng.OuterClassifierContext;
import org.argouml.language.java.reveng.PackageContext;
import org.argouml.language.java.reveng.ParameterDeclaration;
import org.argouml.language.java.reveng.ParseState;
import org.argouml.language.java.reveng.ParseStateException;
import org.argouml.language.java.reveng.classfile.ParserUtils;
import org.argouml.model.Model;
import org.argouml.ocl.OCLUtil;
import org.argouml.profile.Profile;
import org.argouml.uml.reveng.ImportCommon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Modeller {
    private static final Logger LOG = Logger.getLogger(Modeller.class);
    private static final String JAVA_PACKAGE = "java.lang";
    private static final List<String> EMPTY_STRING_LIST = Collections.emptyList();
    private Object model;
    private Profile javaProfile;
    private ImportCommon importSession;
    private Object currentPackage;
    private ParseState parseState;
    private Stack<ParseState> parseStateStack;
    private boolean noAssociations;
    private boolean arraysAsDatatype;
    private String fileName;
    private Hashtable<String, Object> attributes = new Hashtable();
    private List<String> methodCalls = new ArrayList<String>();
    private Hashtable<String, String> localVariables = new Hashtable();
    private Collection<Object> newElements;
    private boolean generateNames = true;

    public Modeller(Object theModel, boolean attributeSelected, boolean datatypeSelected, String theFileName) {
        this(theModel, null, attributeSelected, datatypeSelected, theFileName);
    }

    public Modeller(Object theModel, Profile theJavaProfile, boolean attributeSelected, boolean datatypeSelected, String theFileName) {
        this.model = theModel;
        this.javaProfile = theJavaProfile;
        this.noAssociations = attributeSelected;
        this.arraysAsDatatype = datatypeSelected;
        this.currentPackage = this.model;
        this.newElements = new HashSet<Object>();
        this.parseState = new ParseState(this.model, this.getPackage(JAVA_PACKAGE, true));
        this.parseStateStack = new Stack();
        this.fileName = theFileName;
        if (this.javaProfile == null) {
            LOG.warn((Object)"No Java profile activated for Java source import. Why?");
        }
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void addComponent() {
        Object artifact = Model.getFacade().lookupIn(this.currentPackage, this.fileName);
        if (artifact == null) {
            artifact = Model.getFacade().getUmlVersion().charAt(0) == '1' ? Model.getCoreFactory().createComponent() : Model.getCoreFactory().createArtifact();
            Model.getCoreHelper().setName(artifact, this.fileName);
            this.newElements.add(artifact);
        }
        this.parseState.setArtifact(artifact);
        Model.getCoreHelper().setNamespace(this.parseState.getArtifact(), this.model);
    }

    public void addPackage(String name) {
        String currentName = name;
        String ownerPackageName = this.getPackageName(currentName);
        while (!"".equals(ownerPackageName)) {
            currentName = ownerPackageName;
            ownerPackageName = this.getPackageName(currentName);
        }
        Object mPackage = this.getPackage(currentName, false);
        if (this.importSession != null && this.importSession.getSrcPath() != null && Model.getFacade().getTaggedValue(mPackage, "src_path") == null) {
            String[] srcPaths = new String[]{this.importSession.getSrcPath()};
            this.buildTaggedValue(mPackage, "src_path", srcPaths);
        }
        this.currentPackage = mPackage = this.getPackage(name, false);
        this.parseState.addPackageContext(mPackage);
        Object artifact = Model.getFacade().lookupIn(this.currentPackage, this.fileName);
        if (artifact == null) {
            Model.getCoreHelper().setNamespace(this.parseState.getArtifact(), this.currentPackage);
        } else {
            Object oldArtifact = this.parseState.getArtifact();
            Model.getUmlFactory().delete(oldArtifact);
            this.newElements.remove(oldArtifact);
            this.parseState.setArtifact(artifact);
        }
    }

    public void addImport(String name) {
        this.addImport(name, false);
    }

    public void addClassSignature(String signature) {
        this.addTypeParameters(this.parseState.getClassifier(), ParserUtils.extractTypeParameters(signature));
    }

    void addImport(String name, boolean forceIt) {
        if (this.getLevel() == 0) {
            return;
        }
        String packageName = this.getPackageName(name);
        if (packageName == null || "".equals(packageName)) {
            LOG.warn((Object)("Import skipped - unable to get package name for " + name));
            return;
        }
        String classifierName = this.getClassifierName(name);
        Object mPackage = this.getPackage(packageName, true);
        if (classifierName.equals("*")) {
            this.parseState.addPackageContext(mPackage);
            Object srcFile = this.parseState.getArtifact();
            this.buildImport(mPackage, srcFile);
        } else {
            Object mClassifier = null;
            try {
                mClassifier = new PackageContext(null, mPackage).get(classifierName, false, this.javaProfile);
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && classifierName != null && mPackage != null) {
                    mPackage = packageName.length() > 0 ? this.getPackage(packageName, false) : this.model;
                    mClassifier = Model.getFacade().lookupIn(mPackage, classifierName);
                    if (mClassifier == null) {
                        LOG.info((Object)("Modeller.java: forced creation of unknown classifier " + classifierName));
                        mClassifier = Model.getCoreFactory().buildClass(classifierName, mPackage);
                        this.newElements.add(mClassifier);
                    }
                }
                this.warnClassifierNotFound(classifierName, "an imported classifier");
            }
            if (mClassifier != null) {
                this.parseState.addClassifierContext(mClassifier);
                Object srcFile = this.parseState.getArtifact();
                this.buildImport(mClassifier, srcFile);
            }
        }
    }

    private Object buildImport(Object element, Object srcFile) {
        Collection dependencies = Model.getCoreHelper().getDependencies(element, srcFile);
        for (Object dep : dependencies) {
            for (Object stereotype : Model.getFacade().getStereotypes(dep)) {
                if (!"javaImport".equals(Model.getFacade().getName(stereotype))) continue;
                return dep;
            }
        }
        Object pkgImport = Model.getCoreFactory().buildDependency(srcFile, element);
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            Model.getCoreHelper().addStereotype(pkgImport, this.getUML1Stereotype("javaImport"));
            ProjectManager.getManager().updateRoots();
        }
        String newName = this.makeDependencyName(srcFile, element);
        Model.getCoreHelper().setName(pkgImport, newName);
        this.newElements.add(pkgImport);
        return pkgImport;
    }

    private String makeAbstractionName(Object child, Object parent) {
        return this.makeFromToName(child, parent);
    }

    private String makeAssociationName(Object from, Object to) {
        return this.makeFromToName(from, to);
    }

    private String makeDependencyName(Object from, Object to) {
        return this.makeFromToName(from, to);
    }

    private String makeFromToName(Object from, Object to) {
        if (!this.generateNames) {
            return null;
        }
        return this.makeFromToName(Model.getFacade().getName(from), Model.getFacade().getName(to));
    }

    private String makeFromToName(String from, String to) {
        if (!this.generateNames) {
            return null;
        }
        return from + " -> " + to;
    }

    public void addClass(String name, short modifiers, String superclassName, List<String> interfaces, String javadoc) {
        this.addClass(name, modifiers, EMPTY_STRING_LIST, superclassName, interfaces, javadoc, false);
    }

    void addClass(String name, short modifiers, List<String> typeParameters, String superclassName, List<String> interfaces, String javadoc, boolean forceIt) {
        if (typeParameters != null && typeParameters.size() > 0) {
            this.logError("type parameters not supported on Class", name);
            for (String s : typeParameters) {
                this.logError("type parameter ", s);
            }
        }
        Object mClass = this.addClassifier(Model.getCoreFactory().createClass(), name, modifiers, javadoc, typeParameters);
        Model.getCoreHelper().setAbstract(mClass, (modifiers & 0x400) > 0);
        Model.getCoreHelper().setLeaf(mClass, (modifiers & 0x10) > 0);
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            Model.getCoreHelper().setRoot(mClass, false);
        }
        this.newElements.add(mClass);
        if (this.getLevel() == 0) {
            return;
        }
        if (superclassName != null) {
            Object parentClass = null;
            try {
                parentClass = this.getContext(superclassName).get(this.getClassifierName(superclassName), false, this.javaProfile);
                this.getGeneralization(this.currentPackage, parentClass, mClass);
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && superclassName != null && this.model != null) {
                    LOG.info((Object)("Modeller.java: forced creation of unknown class " + superclassName));
                    String packageName = this.getPackageName(superclassName);
                    String classifierName = this.getClassifierName(superclassName);
                    Object mPackage = packageName.length() > 0 ? this.getPackage(packageName, false) : this.model;
                    parentClass = Model.getFacade().lookupIn(mPackage, classifierName);
                    if (parentClass == null) {
                        parentClass = Model.getCoreFactory().buildClass(classifierName, mPackage);
                        this.newElements.add(parentClass);
                    }
                    this.getGeneralization(this.currentPackage, parentClass, mClass);
                }
                this.warnClassifierNotFound(superclassName, "a generalization");
            }
        }
        if (interfaces != null) {
            this.addInterfaces(mClass, interfaces, forceIt);
        }
    }

    public void addAnonymousClass(String type) {
        this.addAnonymousClass(type, false);
    }

    void addAnonymousClass(String type, boolean forceIt) {
        String name = this.parseState.anonymousClass();
        try {
            Object mClassifier = this.getContext(type).get(this.getClassifierName(type), false, this.javaProfile);
            ArrayList<String> interfaces = new ArrayList<String>();
            if (Model.getFacade().isAInterface(mClassifier)) {
                interfaces.add(type);
            }
            this.addClass(name, (short)0, EMPTY_STRING_LIST, Model.getFacade().isAClass(mClassifier) ? type : null, interfaces, "", forceIt);
        }
        catch (ClassifierNotFoundException e) {
            this.addClass(name, (short)0, EMPTY_STRING_LIST, null, EMPTY_STRING_LIST, "", forceIt);
            LOG.info((Object)"Modeller.java: an anonymous class was created although it could not be found in the classpath.");
        }
    }

    public void addInterface(String name, short modifiers, List<String> interfaces, String javadoc) {
        this.addInterface(name, modifiers, EMPTY_STRING_LIST, interfaces, javadoc, false);
    }

    void addInterface(String name, short modifiers, List<String> typeParameters, List<String> interfaces, String javadoc, boolean forceIt) {
        if (typeParameters != null && typeParameters.size() > 0) {
            this.logError("type parameters not supported on Interface", name);
        }
        Object mInterface = this.addClassifier(Model.getCoreFactory().createInterface(), name, modifiers, javadoc, typeParameters);
        if (this.getLevel() == 0) {
            return;
        }
        for (String interfaceName : interfaces) {
            Object parentInterface = null;
            try {
                parentInterface = this.getContext(interfaceName).get(this.getClassifierName(interfaceName), true, this.javaProfile);
                this.getGeneralization(this.currentPackage, parentInterface, mInterface);
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && interfaceName != null && this.model != null) {
                    LOG.info((Object)("Modeller.java: forced creation of unknown interface " + interfaceName));
                    String packageName = this.getPackageName(interfaceName);
                    String classifierName = this.getClassifierName(interfaceName);
                    Object mPackage = packageName.length() > 0 ? this.getPackage(packageName, false) : this.model;
                    parentInterface = Model.getFacade().lookupIn(mPackage, classifierName);
                    if (parentInterface == null) {
                        parentInterface = Model.getCoreFactory().buildInterface(classifierName, mPackage);
                        this.newElements.add(parentInterface);
                    }
                    this.getGeneralization(this.currentPackage, parentInterface, mInterface);
                    continue;
                }
                this.warnClassifierNotFound(interfaceName, "a generalization");
            }
        }
    }

    void addEnumeration(String name, short modifiers, List<String> interfaces, String javadoc, boolean forceIt) {
        Object mEnum = null;
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            mEnum = this.addClassifier(Model.getCoreFactory().createClass(), name, modifiers, javadoc, EMPTY_STRING_LIST);
            Model.getCoreHelper().addStereotype(mEnum, this.getUML1Stereotype("enumeration"));
            ProjectManager.getManager().updateRoots();
        } else {
            Object mNamespace;
            mEnum = Model.getCoreFactory().createEnumeration();
            if (this.parseState.getClassifier() != null) {
                mNamespace = this.parseState.getClassifier();
            } else {
                this.parseState.outerClassifier();
                mNamespace = this.currentPackage;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Created new enumeration for " + name));
            }
            Model.getCoreHelper().setName(mEnum, name);
            Model.getCoreHelper().setNamespace(mEnum, mNamespace);
            this.newElements.add(mEnum);
            this.parseState.innerClassifier(mEnum);
            this.parseStateStack.push(this.parseState);
            this.parseState = new ParseState(this.parseState, mEnum, this.currentPackage);
            this.setVisibility(mEnum, modifiers);
            if (this.getLevel() <= 0) {
                this.addDocumentationTag(mEnum, javadoc);
            }
        }
        if ((modifiers & 0x400) > 0) {
            this.logError("Illegal \"abstract\" modifier on enum ", name);
        } else {
            Model.getCoreHelper().setAbstract(mEnum, false);
        }
        if ((modifiers & 0x10) > 0) {
            this.logError("Illegal \"final\" modifier on enum ", name);
        } else {
            Model.getCoreHelper().setLeaf(mEnum, true);
        }
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            Model.getCoreHelper().setRoot(mEnum, false);
        }
        if (this.getLevel() == 0) {
            return;
        }
        if (interfaces != null) {
            this.addInterfaces(mEnum, interfaces, forceIt);
        }
    }

    private void addInterfaces(Object mClass, List<String> interfaces, boolean forceIt) {
        for (String interfaceName : interfaces) {
            Object mInterface = null;
            try {
                mInterface = this.getContext(interfaceName).get(this.getClassifierName(interfaceName), true, this.javaProfile);
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && interfaceName != null && this.model != null) {
                    LOG.info((Object)("Modeller.java: forced creation of unknown interface " + interfaceName));
                    String packageName = this.getPackageName(interfaceName);
                    String classifierName = this.getClassifierName(interfaceName);
                    Object mPackage = packageName.length() > 0 ? this.getPackage(packageName, false) : this.model;
                    mInterface = Model.getFacade().lookupIn(mPackage, classifierName);
                    if (mInterface == null) {
                        mInterface = Model.getCoreFactory().buildInterface(classifierName, mPackage);
                        this.newElements.add(mInterface);
                    }
                }
                this.warnClassifierNotFound(interfaceName, "an abstraction");
            }
            if (mInterface == null || mInterface == mClass) continue;
            Object mAbstraction = this.getAbstraction(mInterface, mClass);
            if (Model.getFacade().getSuppliers(mAbstraction).size() == 0) {
                Model.getCoreHelper().addSupplier(mAbstraction, mInterface);
                Model.getCoreHelper().addClient(mAbstraction, mClass);
            }
            if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
                Model.getCoreHelper().setNamespace(mAbstraction, this.currentPackage);
                Model.getCoreHelper().addStereotype(mAbstraction, this.getUML1Stereotype("realize"));
                ProjectManager.getManager().updateRoots();
            }
            this.newElements.add(mAbstraction);
        }
    }

    void addEnumerationLiteral(String name) {
        Object enumeration = this.parseState.getClassifier();
        if (!this.isAEnumeration(enumeration)) {
            throw new ParseStateException("not an Enumeration");
        }
        short mod = 25;
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            this.addAttribute(mod, null, name, null, null, true);
        } else {
            Model.getCoreFactory().buildEnumerationLiteral(name, enumeration);
        }
    }

    private boolean isAEnumeration(Object element) {
        if (Model.getFacade().isAEnumeration(element)) {
            return true;
        }
        if (!Model.getFacade().isAClass(element)) {
            return false;
        }
        return Model.getExtensionMechanismsHelper().hasStereotype(element, "enumeration");
    }

    void addAnnotationDefinition(String name, short modifiers, String javadoc, boolean forceIt) {
        this.logError("Java 5 annotation definitions not supported", "@" + name);
    }

    void addAnnotation(String name) {
        this.logError("Java 5 annotations not supported", "@" + name);
    }

    void endAnnotation() {
    }

    void addTypeParameters(Object modelElement, List<String> typeParameters) {
        if (modelElement == null || typeParameters == null) {
            return;
        }
        if (Model.getFacade().getTemplateParameters(modelElement).size() == 0) {
            for (String parameter : typeParameters) {
                Pattern p = Pattern.compile("([^ ]*)( super | extends )?((.*))");
                Matcher m = p.matcher(parameter);
                if (!m.matches()) continue;
                String templateParameterName = m.group(1);
                Object param = Model.getCoreFactory().createParameter();
                Model.getCoreHelper().setName(param, templateParameterName);
                Object templateParameter = Model.getCoreFactory().buildTemplateParameter(modelElement, param, null);
                if (m.group(2) != null) {
                    this.buildTaggedValue(param, m.group(2).trim(), new String[]{m.group(3)});
                }
                Model.getCoreHelper().addTemplateParameter(modelElement, templateParameter);
            }
        }
    }

    private Object addClassifier(Object newClassifier, String name, short modifiers, String javadoc, List<String> typeParameters) {
        Object mNamespace;
        Object mClassifier;
        if (this.parseState.getClassifier() != null) {
            mClassifier = Model.getFacade().lookupIn(this.parseState.getClassifier(), name);
            mNamespace = this.parseState.getClassifier();
        } else {
            this.parseState.outerClassifier();
            mClassifier = Model.getFacade().lookupIn(this.currentPackage, name);
            mNamespace = this.currentPackage;
        }
        if (mClassifier == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Created new classifier for " + name));
            }
            mClassifier = newClassifier;
            Model.getCoreHelper().setName(mClassifier, name);
            Model.getCoreHelper().setNamespace(mClassifier, mNamespace);
            this.newElements.add(mClassifier);
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Found existing classifier for " + name));
            }
            this.cleanModelElement(mClassifier);
        }
        this.parseState.innerClassifier(mClassifier);
        if (this.parseState.getClassifier() == null) {
            if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
                if (Model.getFacade().getElementResidences(mClassifier).isEmpty()) {
                    Object resident = Model.getCoreFactory().createElementResidence();
                    Model.getCoreHelper().setResident(resident, mClassifier);
                    Model.getCoreHelper().setContainer(resident, this.parseState.getArtifact());
                }
            } else {
                Object artifact = this.parseState.getArtifact();
                Collection c = Model.getCoreHelper().getUtilizedElements(artifact);
                if (!c.contains(mClassifier)) {
                    Object manifestation = Model.getCoreFactory().buildManifestation(mClassifier);
                    Model.getCoreHelper().addManifestation(artifact, manifestation);
                }
            }
        }
        this.parseStateStack.push(this.parseState);
        this.parseState = new ParseState(this.parseState, mClassifier, this.currentPackage);
        this.setVisibility(mClassifier, modifiers);
        if (this.getLevel() <= 0) {
            this.addDocumentationTag(mClassifier, javadoc);
        }
        this.addTypeParameters(mClassifier, typeParameters);
        return mClassifier;
    }

    private int getLevel() {
        Object level = this.getAttribute("level");
        if (level != null) {
            return (Integer)level;
        }
        return -1;
    }

    public void popClassifier() {
        this.parseState.removeObsoleteFeatures();
        this.parseState.removeObsoleteInnerClasses();
        this.parseState = this.parseStateStack.pop();
    }

    public Object addOperation(short modifiers, String returnType, String name, List<ParameterDeclaration> parameters, String javadoc) {
        return this.addOperation(modifiers, EMPTY_STRING_LIST, returnType, name, parameters, javadoc, false);
    }

    Object addOperation(short modifiers, List<String> typeParameters, String returnType, String name, List<ParameterDeclaration> parameters, String javadoc, boolean forceIt) {
        Object[] c;
        if (typeParameters != null && typeParameters.size() > 0) {
            this.logError("type parameters not supported on operation return type", name);
        }
        Object mOperation = this.getOperation(name);
        this.parseState.feature(mOperation);
        Model.getCoreHelper().setAbstract(mOperation, (modifiers & 0x400) > 0);
        Model.getCoreHelper().setLeaf(mOperation, (modifiers & 0x10) > 0);
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            Model.getCoreHelper().setRoot(mOperation, false);
        }
        this.setOwnerScope(mOperation, modifiers);
        this.setVisibility(mOperation, modifiers);
        if ((modifiers & 0x20) > 0) {
            Model.getCoreHelper().setConcurrency(mOperation, Model.getConcurrencyKind().getGuarded());
        } else if (Model.getFacade().getConcurrency(mOperation) == Model.getConcurrencyKind().getGuarded()) {
            Model.getCoreHelper().setConcurrency(mOperation, Model.getConcurrencyKind().getSequential());
        }
        for (Object parameter : c = Model.getFacade().getParameters(mOperation).toArray()) {
            Model.getCoreHelper().removeParameter(mOperation, parameter);
        }
        Object mClassifier = null;
        if (returnType == null || "void".equals(returnType) && name.equals(Model.getFacade().getName(this.parseState.getClassifier()))) {
            Model.getCoreHelper().addStereotype(mOperation, this.getStereotype(mOperation, "create", "BehavioralFeature"));
            ProjectManager.getManager().updateRoots();
        } else {
            try {
                mClassifier = this.getContext(returnType).get(this.getClassifierName(returnType), false, this.javaProfile);
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && returnType != null && this.model != null) {
                    LOG.info((Object)("Modeller.java: forced creation of unknown classifier " + returnType));
                    String packageName = this.getPackageName(returnType);
                    String classifierName = this.getClassifierName(returnType);
                    Object mPackage = packageName.length() > 0 ? this.getPackage(packageName, false) : this.model;
                    mClassifier = Model.getFacade().lookupIn(mPackage, classifierName);
                    if (mClassifier == null) {
                        mClassifier = Model.getCoreFactory().buildClass(classifierName, mPackage);
                        this.newElements.add(mClassifier);
                    }
                }
                this.warnClassifierNotFound(returnType, "operation return type");
            }
            if (mClassifier != null) {
                Object object = this.buildReturnParameter(mOperation, mClassifier);
            }
        }
        for (ParameterDeclaration parameter : parameters) {
            String typeName = parameter.getType();
            if (typeName.endsWith("...")) {
                this.logError("Unsupported variable length parameter list notation", parameter.getName());
            }
            mClassifier = null;
            try {
                mClassifier = this.getContext(typeName).get(this.getClassifierName(typeName), false, this.javaProfile);
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && typeName != null && this.model != null) {
                    LOG.info((Object)("Modeller.java: forced creation of unknown classifier " + typeName));
                    String packageName = this.getPackageName(typeName);
                    String classifierName = this.getClassifierName(typeName);
                    Object mPackage = packageName.length() > 0 ? this.getPackage(packageName, false) : this.model;
                    mClassifier = Model.getFacade().lookupIn(mPackage, classifierName);
                    if (mClassifier == null) {
                        mClassifier = Model.getCoreFactory().buildClass(classifierName, mPackage);
                        this.newElements.add(mClassifier);
                    }
                }
                this.warnClassifierNotFound(typeName, "operation params");
            }
            if (mClassifier == null) continue;
            Object object = this.buildInParameter(mOperation, mClassifier, parameter.getName());
            if (Model.getFacade().isAClassifier(mClassifier)) continue;
            this.logError("Modeller.java: a valid type for a parameter could not be resolved:\n In file: " + this.fileName + ", for operation: " + Model.getFacade().getName(mOperation) + ", for parameter: ", Model.getFacade().getName(object));
        }
        this.addDocumentationTag(mOperation, javadoc);
        return mOperation;
    }

    private Object buildInParameter(Object operation, Object classifier, String name) {
        Object parameter = this.buildParameter(operation, classifier, name);
        Model.getCoreHelper().setKind(parameter, Model.getDirectionKind().getInParameter());
        return parameter;
    }

    private Object buildReturnParameter(Object operation, Object classifier) {
        Object parameter = this.buildParameter(operation, classifier, "return");
        Model.getCoreHelper().setKind(parameter, Model.getDirectionKind().getReturnParameter());
        return parameter;
    }

    private Object buildParameter(Object operation, Object classifier, String name) {
        Object parameter = Model.getCoreFactory().buildParameter(operation, classifier);
        Model.getCoreHelper().setName(parameter, name);
        return parameter;
    }

    private void warnClassifierNotFound(String name, String operation) {
        this.logError("Modeller.java: a classifier (" + name + ") that was in the source " + "file could not be generated in the model ", operation);
    }

    private void logError(String message, String identifier) {
        LOG.warn((Object)(message + " : " + identifier));
    }

    public void addBodyToOperation(Object op, String body) {
        if (op == null || !Model.getFacade().isAOperation(op)) {
            throw new ParseStateException("Found class body in context other than a class");
        }
        if (body == null || body.length() == 0) {
            return;
        }
        Object method = this.getMethod(Model.getFacade().getName(op));
        this.parseState.feature(method);
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            Model.getCoreHelper().setBody(method, Model.getDataTypesFactory().createProcedureExpression("Java", body));
        } else {
            Model.getDataTypesHelper().setBody(method, body);
            Model.getDataTypesHelper().setLanguage(method, "Java");
        }
        Model.getCoreHelper().addMethod(op, method);
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            Model.getCoreHelper().addFeature(Model.getFacade().getOwner(op), method);
        } else {
            Model.getCoreHelper().addOwnedElement(Model.getFacade().getOwner(op), method);
        }
    }

    public void addAttribute(short modifiers, String typeSpec, String name, String initializer, String javadoc) {
        this.addAttribute(modifiers, typeSpec, name, initializer, javadoc, false);
    }

    void addAttribute(short modifiers, String typeSpec, String name, String initializer, String javadoc, boolean forceIt) {
        String multiplicity = "1_1";
        Object mClassifier = null;
        if (typeSpec != null) {
            if (!this.arraysAsDatatype && typeSpec.indexOf(91) != -1) {
                typeSpec = typeSpec.substring(0, typeSpec.indexOf(91));
                multiplicity = "1_N";
            }
            try {
                mClassifier = this.getContext(typeSpec).get(this.getClassifierName(typeSpec), false, this.javaProfile);
            }
            catch (ClassifierNotFoundException e) {
                if (forceIt && typeSpec != null && this.model != null) {
                    LOG.info((Object)("Modeller.java: forced creation of unknown classifier " + typeSpec));
                    String packageName = this.getPackageName(typeSpec);
                    String classifierName = this.getClassifierName(typeSpec);
                    Object mPackage = packageName.length() > 0 ? this.getPackage(packageName, false) : this.model;
                    mClassifier = Model.getFacade().lookupIn(mPackage, classifierName);
                    if (mClassifier == null) {
                        mClassifier = Model.getCoreFactory().buildClass(classifierName, mPackage);
                        this.newElements.add(mClassifier);
                    }
                }
                this.warnClassifierNotFound(typeSpec, "an attribute");
            }
            if (mClassifier == null) {
                this.logError("failed to find or create type", typeSpec);
                return;
            }
        }
        if (mClassifier == null || this.noAssociations || Model.getFacade().isADataType(mClassifier) || Model.getFacade().getNamespace(mClassifier) == this.getPackage(JAVA_PACKAGE, true)) {
            Object mAttribute = this.parseState.getAttribute(name);
            if (mAttribute == null) {
                mAttribute = this.buildAttribute(this.parseState.getClassifier(), mClassifier, name);
            }
            this.parseState.feature(mAttribute);
            this.setOwnerScope(mAttribute, modifiers);
            this.setVisibility(mAttribute, modifiers);
            Model.getCoreHelper().setMultiplicity(mAttribute, multiplicity);
            if (Model.getFacade().isAClassifier(mClassifier)) {
                Model.getCoreHelper().setType(mAttribute, mClassifier);
            } else {
                this.logError("Modeller.java: a valid type for a parameter could not be resolved:\n In file: " + this.fileName + ", for attribute: ", Model.getFacade().getName(mAttribute));
            }
            if (initializer != null) {
                initializer = initializer.replace('\n', ' ');
                initializer = initializer.replace('\t', ' ');
                Object newInitialValue = Model.getDataTypesFactory().createExpression("Java", initializer);
                Model.getCoreHelper().setInitialValue(mAttribute, newInitialValue);
            }
            if ((modifiers & 0x10) > 0) {
                Model.getCoreHelper().setReadOnly(mAttribute, true);
            } else if (Model.getFacade().isReadOnly(mAttribute)) {
                Model.getCoreHelper().setReadOnly(mAttribute, true);
            }
            this.addDocumentationTag(mAttribute, javadoc);
        } else {
            Object mAssociationEnd = this.getAssociationEnd(name, mClassifier);
            Model.getCoreHelper().setStatic(mAssociationEnd, (modifiers & 8) > 0);
            this.setVisibility(mAssociationEnd, modifiers);
            Model.getCoreHelper().setMultiplicity(mAssociationEnd, multiplicity);
            Model.getCoreHelper().setType(mAssociationEnd, mClassifier);
            Model.getCoreHelper().setName(mAssociationEnd, name);
            if ((modifiers & 0x10) > 0) {
                Model.getCoreHelper().setReadOnly(mAssociationEnd, true);
            }
            if (!mClassifier.equals(this.parseState.getClassifier())) {
                Model.getCoreHelper().setNavigable(mAssociationEnd, true);
            }
            this.addDocumentationTag(mAssociationEnd, javadoc);
        }
    }

    private Object getGeneralization(Object mPackage, Object parent, Object child) {
        Object mGeneralization = Model.getFacade().getGeneralization(child, parent);
        if (mGeneralization == null) {
            mGeneralization = Model.getCoreFactory().buildGeneralization(child, parent);
            this.newElements.add(mGeneralization);
        }
        if (mGeneralization != null && Model.getFacade().getUmlVersion().charAt(0) == '1') {
            Model.getCoreHelper().setNamespace(mGeneralization, mPackage);
        }
        return mGeneralization;
    }

    private Object getAbstraction(Object parent, Object child) {
        Object mAbstraction2 = null;
        for (Object mAbstraction2 : Model.getFacade().getClientDependencies(child)) {
            Collection c = Model.getFacade().getSuppliers(mAbstraction2);
            if (c == null || c.size() == 0) {
                Model.getCoreHelper().removeClientDependency(child, mAbstraction2);
                continue;
            }
            if (parent == c.toArray()[0]) break;
            mAbstraction2 = null;
        }
        if (mAbstraction2 == null) {
            mAbstraction2 = Model.getCoreFactory().buildAbstraction(this.makeAbstractionName(child, parent), parent, child);
            this.newElements.add(mAbstraction2);
        }
        return mAbstraction2;
    }

    private Object getClass(Object mPackage, String name) {
        Object mClass = null;
        for (Object c : Model.getCoreHelper().getAllClasses(mPackage)) {
            if (!name.equals(Model.getFacade().getName(c))) continue;
            mClass = c;
            break;
        }
        if (mClass == null) {
            mClass = Model.getCoreFactory().buildClass(name, mPackage);
            this.newElements.add(mClass);
        }
        return mClass;
    }

    private Object getPackage(String name, boolean useProfile) {
        Object mPackage = this.searchPackageInModel(name, useProfile);
        if (mPackage == null) {
            Object currentNs = this.model;
            StringTokenizer st = new StringTokenizer(name, ".");
            while (st.hasMoreTokens()) {
                String rname = st.nextToken();
                mPackage = Model.getFacade().lookupIn(currentNs, rname);
                if (mPackage == null || !Model.getFacade().isAPackage(mPackage)) {
                    mPackage = Model.getModelManagementFactory().buildPackage(this.getRelativePackageName(rname));
                    Model.getCoreHelper().addOwnedElement(currentNs, mPackage);
                    this.newElements.add(mPackage);
                }
                currentNs = mPackage;
            }
        }
        return mPackage;
    }

    private Object searchPackageInModel(String name, boolean useProfile) {
        Object ret = null;
        if ("".equals(this.getPackageName(name))) {
            if (useProfile && this.javaProfile != null) {
                try {
                    Object m = this.javaProfile.getProfilePackages().iterator().next();
                    ret = Model.getFacade().lookupIn(m, name);
                }
                catch (Exception e) {
                    ret = null;
                }
            }
            if (ret == null) {
                ret = Model.getFacade().lookupIn(this.model, name);
            }
            return ret;
        }
        Object owner = this.searchPackageInModel(this.getPackageName(name), useProfile);
        return owner == null ? null : Model.getFacade().lookupIn(owner, this.getRelativePackageName(name));
    }

    private Object getOperation(String name) {
        Object mOperation = this.parseState.getOperation(name);
        if (mOperation != null) {
            LOG.info((Object)("Getting the existing operation " + name));
        } else {
            LOG.info((Object)("Creating a new operation " + name));
            Object cls = this.parseState.getClassifier();
            Object returnType = ProjectManager.getManager().getCurrentProject().getDefaultReturnType();
            mOperation = Model.getCoreFactory().buildOperation2(cls, returnType, name);
            this.newElements.add(mOperation);
        }
        return mOperation;
    }

    private Object getMethod(String name) {
        Object method = this.parseState.getMethod(name);
        if (method != null) {
            LOG.info((Object)("Getting the existing method " + name));
        } else {
            LOG.info((Object)("Creating a new method " + name));
            method = Model.getCoreFactory().buildMethod(name);
            this.newElements.add(method);
            if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
                Model.getCoreHelper().addFeature(this.parseState.getClassifier(), method);
            }
        }
        return method;
    }

    private Object buildAttribute(Object classifier, Object type, String name) {
        Object mAttribute = Model.getCoreFactory().buildAttribute2(classifier, type);
        this.newElements.add(mAttribute);
        Model.getCoreHelper().setName(mAttribute, name);
        return mAttribute;
    }

    private Object getAssociationEnd(String name, Object mClassifier) {
        Object mAssociationEnd = null;
        for (Object ae : Model.getFacade().getAssociationEnds(mClassifier)) {
            Object assoc = Model.getFacade().getAssociation(ae);
            if (!name.equals(Model.getFacade().getName(ae)) || Model.getFacade().getConnections(assoc).size() != 2 || Model.getFacade().getType(Model.getFacade().getNextEnd(ae)) != this.parseState.getClassifier()) continue;
            mAssociationEnd = ae;
        }
        if (mAssociationEnd == null && !this.noAssociations) {
            String newName = this.makeAssociationName(this.parseState.getClassifier(), mClassifier);
            Object mAssociation = Modeller.buildDirectedAssociation(newName, this.parseState.getClassifier(), mClassifier);
            mAssociationEnd = Model.getFacade().getAssociationEnd(mClassifier, mAssociation);
        }
        return mAssociationEnd;
    }

    public static Object buildDirectedAssociation(String name, Object sourceClassifier, Object destClassifier) {
        return Model.getCoreFactory().buildAssociation(destClassifier, true, sourceClassifier, false, name);
    }

    private Object getUML1Stereotype(String name) {
        LOG.debug((Object)("Trying to find a stereotype of name <<" + name + ">>"));
        Object stereotype = Model.getFacade().lookupIn(this.model, name);
        if (stereotype == null) {
            LOG.debug((Object)"Couldn't find so creating it");
            return Model.getExtensionMechanismsFactory().buildStereotype(name, this.model);
        }
        if (!Model.getFacade().isAStereotype(stereotype)) {
            LOG.debug((Object)"Found something that isn't a stereotype so creating it");
            return Model.getExtensionMechanismsFactory().buildStereotype(name, this.model);
        }
        LOG.debug((Object)"Found it");
        return stereotype;
    }

    private Object getStereotype(Object me, String name, String baseClass) {
        Collection models = ProjectManager.getManager().getCurrentProject().getModels();
        Collection stereos = Model.getExtensionMechanismsHelper().getAllPossibleStereotypes(models, me);
        Object stereotype2 = null;
        if (stereos != null && stereos.size() > 0) {
            for (Object stereotype2 : stereos) {
                if (!Model.getExtensionMechanismsHelper().isStereotypeInh(stereotype2, name, baseClass)) continue;
                LOG.info((Object)("Returning the existing stereotype of <<" + Model.getFacade().getName(stereotype2) + ">>"));
                return stereotype2;
            }
        }
        if (Model.getFacade().getUmlVersion().charAt(0) != '1') {
            throw new IllegalArgumentException("Could not find a suitable stereotype for " + Model.getFacade().getName(me) + " -  stereotype: <<" + name + ">> base: " + baseClass + ".\n" + "Check if environment variable eUML.resources " + "is correctly set.");
        }
        stereotype2 = this.getUML1Stereotype(name);
        if (stereotype2 != null) {
            Model.getExtensionMechanismsHelper().addBaseClass(stereotype2, me);
            return stereotype2;
        }
        throw new IllegalArgumentException("Could not find a suitable stereotype for " + Model.getFacade().getName(me) + " -  stereotype: <<" + name + ">> base: " + baseClass);
    }

    private Object getTaggedValue(Object element, String name) {
        Object tv = Model.getFacade().getTaggedValue(element, name);
        if (tv == null) {
            String[] empties = new String[]{""};
            this.buildTaggedValue(element, name, empties);
            tv = Model.getFacade().getTaggedValue(element, name);
        }
        return tv;
    }

    private void cleanModelElement(Object element) {
        Object tv = Model.getFacade().getTaggedValue(element, "GeneratedFromImport");
        while (tv != null) {
            Model.getUmlFactory().delete(tv);
            tv = Model.getFacade().getTaggedValue(element, "GeneratedFromImport");
        }
    }

    private String getPackageName(String name) {
        int lastDot = (name = this.stripVarargAndGenerics(name)).lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        String pkgName = name.substring(0, lastDot);
        if (Character.isUpperCase(this.getRelativePackageName(pkgName).charAt(0))) {
            return this.getPackageName(pkgName);
        }
        return pkgName;
    }

    private String getRelativePackageName(String packageName) {
        return this.getClassifierName(packageName);
    }

    private String getClassifierName(String name) {
        int lastDot = (name = this.stripVarargAndGenerics(name)).lastIndexOf(46);
        if (lastDot == -1) {
            return name;
        }
        return name.substring(lastDot + 1);
    }

    private void setVisibility(Object element, short modifiers) {
        if ((modifiers & 2) > 0) {
            Model.getCoreHelper().setVisibility(element, Model.getVisibilityKind().getPrivate());
        } else if ((modifiers & 4) > 0) {
            Model.getCoreHelper().setVisibility(element, Model.getVisibilityKind().getProtected());
        } else if ((modifiers & 1) > 0) {
            Model.getCoreHelper().setVisibility(element, Model.getVisibilityKind().getPublic());
        } else {
            Model.getCoreHelper().setVisibility(element, Model.getVisibilityKind().getPackage());
        }
    }

    private void setOwnerScope(Object feature, short modifiers) {
        Model.getCoreHelper().setStatic(feature, (modifiers & 8) > 0);
    }

    private Context getContext(String name) {
        int lastDot;
        String classifierName;
        Context context = this.parseState.getContext();
        String packageName = this.getPackageName(name);
        Object pkg = this.model;
        if (!"".equals(packageName)) {
            pkg = this.getPackage(packageName, true);
        }
        if ((classifierName = name.substring(packageName.length())).charAt(0) == '.') {
            classifierName = classifierName.substring(1);
        }
        if ((lastDot = (classifierName = this.stripVarargAndGenerics(classifierName)).lastIndexOf(46)) != -1) {
            String clsName = classifierName.substring(0, lastDot);
            Object cls = this.getClass(pkg, clsName);
            context = new OuterClassifierContext(context.getContext(), cls, pkg, clsName + '$');
        } else if (!"".equals(packageName)) {
            context = new PackageContext(context, pkg);
        }
        return context;
    }

    private void addJavadocTagContents(Object me, String sTagName, String[] sTagData) {
        int colonPos;
        if (sTagData.length == 0 || sTagData[0] == null) {
            LOG.debug((Object)"Called addJavadocTagContents with no tag data!");
            return;
        }
        int n = colonPos = sTagData != null ? sTagData[0].indexOf(58) : -1;
        if (colonPos != -1 && ("invariant".equals(sTagName) || "pre-condition".equals(sTagName) || "post-condition".equals(sTagName))) {
            String sContext = OCLUtil.getContextString((Object)me);
            String name = sTagData[0].substring(0, colonPos);
            String body = null;
            body = sTagName.equals("invariant") ? sContext + " inv " + sTagData : (sTagName.equals("pre-condition") ? sContext + " pre " + sTagData : sContext + " post " + sTagData);
            Object bexpr = Model.getDataTypesFactory().createBooleanExpression("OCL", body);
            Object mc = Model.getCoreFactory().buildConstraint(name, bexpr);
            Model.getCoreHelper().addConstraint(me, mc);
            if (Model.getFacade().getNamespace(me) != null) {
                Model.getCoreHelper().addOwnedElement(Model.getFacade().getNamespace(me), mc);
            }
        } else {
            if ("stereotype".equals(sTagName)) {
                String sStereotype;
                Object tv = this.getTaggedValue(me, sTagName);
                if (tv != null && (sStereotype = Model.getFacade().getValueOfTag(tv)) != null && sStereotype.length() > 0) {
                    sTagData[0] = sStereotype + ',' + sTagData[0];
                }
                HashSet<String> stSet = new HashSet<String>();
                StringTokenizer st = new StringTokenizer(sTagData[0], ", ");
                while (st.hasMoreTokens()) {
                    stSet.add(st.nextToken().trim());
                }
                StringBuffer sb = new StringBuffer();
                Iterator iter = stSet.iterator();
                while (iter.hasNext()) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append((String)iter.next());
                }
                sTagData[0] = sb.toString();
            }
            this.buildTaggedValue(me, sTagName, sTagData);
        }
    }

    private void buildTaggedValue(Object me, String sTagName, String[] sTagData) {
        Object tv = Model.getFacade().getTaggedValue(me, sTagName);
        if (tv == null) {
            Model.getExtensionMechanismsHelper().addTaggedValue(me, Model.getExtensionMechanismsFactory().buildTaggedValue(sTagName, sTagData[0]));
        } else {
            Model.getExtensionMechanismsHelper().setDataValues(tv, sTagData);
        }
    }

    private void addDocumentationTag(Object modelElement, String sJavaDocs) {
        if (sJavaDocs != null && sJavaDocs.trim().length() >= 5) {
            StringBuffer sbPureDocs = new StringBuffer(80);
            String sCurrentTagName = null;
            String[] sCurrentTagData = new String[]{null};
            int nStartPos = 3;
            boolean fHadAsterisk = true;
            block4: while (nStartPos < sJavaDocs.length()) {
                int j;
                switch (sJavaDocs.charAt(nStartPos)) {
                    case '*': {
                        fHadAsterisk = true;
                        ++nStartPos;
                        continue block4;
                    }
                    case '\t': 
                    case ' ': {
                        if (fHadAsterisk) break;
                        ++nStartPos;
                        continue block4;
                    }
                }
                for (j = nStartPos; j < sJavaDocs.length() && (sJavaDocs.charAt(j) == ' ' || sJavaDocs.charAt(j) == '\t'); ++j) {
                }
                if (j < sJavaDocs.length()) {
                    if (sJavaDocs.charAt(j) == '@') {
                        int nTemp1;
                        int nTemp;
                        int lineEndPos = 0;
                        lineEndPos = sJavaDocs.indexOf(10, j) < 0 ? sJavaDocs.length() - 2 : sJavaDocs.indexOf(10, j) + 1;
                        sbPureDocs.append(sJavaDocs.substring(j, lineEndPos));
                        if (sCurrentTagName != null) {
                            this.addJavadocTagContents(modelElement, sCurrentTagName, sCurrentTagData);
                        }
                        if ((nTemp = sJavaDocs.indexOf(32, j + 1)) == -1) {
                            nTemp = sJavaDocs.length() - 1;
                        }
                        sCurrentTagName = sJavaDocs.substring(j + 1, nTemp);
                        nTemp1 = (nTemp1 = sJavaDocs.indexOf(10, ++nTemp)) == -1 ? sJavaDocs.length() : ++nTemp1;
                        sCurrentTagData[0] = sJavaDocs.substring(nTemp, nTemp1);
                        nStartPos = nTemp1;
                    } else {
                        int nTemp = sJavaDocs.indexOf(10, nStartPos);
                        nTemp = nTemp == -1 ? sJavaDocs.length() : ++nTemp;
                        if (sCurrentTagName != null) {
                            sbPureDocs.append(sJavaDocs.substring(nStartPos, nTemp));
                            sCurrentTagData[0] = sCurrentTagData[0] + " " + sJavaDocs.substring(nStartPos, nTemp);
                        } else {
                            sbPureDocs.append(sJavaDocs.substring(nStartPos, nTemp));
                        }
                        nStartPos = nTemp;
                    }
                }
                fHadAsterisk = false;
            }
            sJavaDocs = sbPureDocs.toString();
            sJavaDocs = this.removeTrailingSlash(sJavaDocs);
            if (sCurrentTagName != null) {
                sCurrentTagData[0] = this.removeTrailingSlash(sCurrentTagData[0]);
                this.addJavadocTagContents(modelElement, sCurrentTagName, sCurrentTagData);
            }
            String[] javadocs = new String[]{sJavaDocs};
            this.buildTaggedValue(modelElement, "documentation", javadocs);
            this.addStereotypes(modelElement);
        }
    }

    private String removeTrailingSlash(String s) {
        if (s.endsWith("\n/")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.endsWith("*/")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    private String stripVarargAndGenerics(String name) {
        if (name != null) {
            if (name.endsWith("...")) {
                name = name.substring(0, name.length() - 3);
            }
            if (name.endsWith(">")) {
                int i;
                int cnt = 1;
                for (i = name.length() - 2; i >= 0 && cnt > 0; --i) {
                    if (name.charAt(i) == '<') {
                        --cnt;
                        continue;
                    }
                    if (name.charAt(i) != '>') continue;
                    ++cnt;
                }
                name = name.substring(0, i + 1);
            }
        }
        return name;
    }

    private void addStereotypes(Object modelElement) {
        Object tv;
        if (Model.getFacade().getUmlVersion().charAt(0) == '1' && (tv = Model.getFacade().getTaggedValue(modelElement, "stereotype")) != null) {
            String stereo = Model.getFacade().getValueOfTag(tv);
            if (stereo != null && stereo.length() > 0) {
                StringTokenizer st = new StringTokenizer(stereo, ", ");
                while (st.hasMoreTokens()) {
                    Model.getCoreHelper().addStereotype(modelElement, this.getUML1Stereotype(st.nextToken().trim()));
                }
                ProjectManager.getManager().updateRoots();
            }
            Model.getUmlFactory().delete(tv);
        }
    }

    public void addCall(String methodName) {
        this.methodCalls.add(methodName);
    }

    public synchronized List<String> getMethodCalls() {
        return this.methodCalls;
    }

    public void clearMethodCalls() {
        this.methodCalls.clear();
    }

    public void addLocalVariableDeclaration(String type, String name) {
        this.localVariables.put(name, type);
    }

    public Hashtable<String, String> getLocalVariableDeclarations() {
        return this.localVariables;
    }

    public void clearLocalVariableDeclarations() {
        this.localVariables.clear();
    }

    public Collection<Object> getNewElements() {
        return this.newElements;
    }

    public void setGenerateNames(boolean generateNamesFlag) {
        this.generateNames = generateNamesFlag;
    }
}

