/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.reveng;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.argouml.application.api.Argo;
import org.argouml.configuration.Configuration;
import org.argouml.configuration.ConfigurationKey;
import org.argouml.i18n.Translator;
import org.argouml.uml.reveng.ImportClassLoader;
import org.argouml.uml.reveng.Setting;
import org.argouml.uml.reveng.SettingsTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaImportSettings {
    private static JavaImportSettings theInstance;
    private List<SettingsTypes.Setting> settingsList;
    private SettingsTypes.UniqueSelection2 attributeSetting;
    private SettingsTypes.UniqueSelection2 datatypeSetting;
    private SettingsTypes.PathListSelection pathlistSetting;
    private static final ConfigurationKey KEY_IMPORT_EXTENDED_MODEL_ATTR;
    private static final ConfigurationKey KEY_IMPORT_EXTENDED_MODEL_ARRAYS;
    private static final ConfigurationKey KEY_IMPORT_EXTENDED_COLLECTIONS_FLAG;
    private static final ConfigurationKey KEY_IMPORT_EXTENDED_COLLECTIONS_LIST;
    private static final ConfigurationKey KEY_IMPORT_EXTENDED_ORDEREDCOLLS_FLAG;
    private static final ConfigurationKey KEY_IMPORT_EXTENDED_ORDEREDCOLLS_LIST;

    public static synchronized JavaImportSettings getInstance() {
        if (theInstance == null) {
            theInstance = new JavaImportSettings();
        }
        return theInstance;
    }

    public boolean isAttributeSelected() {
        return this.attributeSetting.getSelection() == 0;
    }

    public boolean isDatatypeSelected() {
        return this.datatypeSetting.getSelection() == 0;
    }

    public List<String> getPathList() {
        if (this.pathlistSetting == null) {
            return new ArrayList<String>();
        }
        return this.pathlistSetting.getPathList();
    }

    public List<SettingsTypes.Setting> getImportSettings() {
        URL[] urls;
        this.settingsList = new ArrayList<SettingsTypes.Setting>();
        ArrayList<String> options = new ArrayList<String>();
        options.add(Translator.localize((String)"action.import-java-UML-attr"));
        options.add(Translator.localize((String)"action.import-java-UML-assoc"));
        String modelattr = Configuration.getString((ConfigurationKey)KEY_IMPORT_EXTENDED_MODEL_ATTR, (String)"0");
        int selected = Integer.parseInt(modelattr);
        this.attributeSetting = new Setting.UniqueSelection(Translator.localize((String)"action.import-java-attr-model"), options, selected);
        this.settingsList.add((SettingsTypes.Setting)this.attributeSetting);
        options.clear();
        options.add(Translator.localize((String)"action.import-java-array-model-datatype"));
        options.add(Translator.localize((String)"action.import-java-array-model-multi"));
        String modelarrays = Configuration.getString((ConfigurationKey)KEY_IMPORT_EXTENDED_MODEL_ARRAYS, (String)"0");
        selected = Integer.parseInt(modelarrays);
        this.datatypeSetting = new Setting.UniqueSelection(Translator.localize((String)"action.import-java-array-model"), options, selected);
        this.settingsList.add((SettingsTypes.Setting)this.datatypeSetting);
        ArrayList<String> paths = new ArrayList<String>();
        for (URL url : urls = ImportClassLoader.getURLs((String)Configuration.getString((ConfigurationKey)Argo.KEY_USER_IMPORT_CLASSPATH, (String)""))) {
            paths.add(url.getFile());
        }
        this.pathlistSetting = new Setting.PathListSelection(Translator.localize((String)"dialog.import.classpath.title"), Translator.localize((String)"dialog.import.classpath.text"), paths);
        this.settingsList.add((SettingsTypes.Setting)this.pathlistSetting);
        return this.settingsList;
    }

    public void saveSettings() {
        if (this.attributeSetting != null) {
            Configuration.setString((ConfigurationKey)KEY_IMPORT_EXTENDED_MODEL_ATTR, (String)String.valueOf(this.attributeSetting.getSelection()));
        }
        if (this.datatypeSetting != null) {
            Configuration.setString((ConfigurationKey)KEY_IMPORT_EXTENDED_MODEL_ARRAYS, (String)String.valueOf(this.datatypeSetting.getSelection()));
        }
    }

    static {
        KEY_IMPORT_EXTENDED_MODEL_ATTR = Configuration.makeKey((String)"import", (String)"extended", (String)"java", (String)"model", (String)"attributes");
        KEY_IMPORT_EXTENDED_MODEL_ARRAYS = Configuration.makeKey((String)"import", (String)"extended", (String)"java", (String)"model", (String)"arrays");
        KEY_IMPORT_EXTENDED_COLLECTIONS_FLAG = Configuration.makeKey((String)"import", (String)"extended", (String)"java", (String)"collections", (String)"flag");
        KEY_IMPORT_EXTENDED_COLLECTIONS_LIST = Configuration.makeKey((String)"import", (String)"extended", (String)"java", (String)"collections", (String)"list");
        KEY_IMPORT_EXTENDED_ORDEREDCOLLS_FLAG = Configuration.makeKey((String)"import", (String)"extended", (String)"java", (String)"orderedcolls", (String)"flag");
        KEY_IMPORT_EXTENDED_ORDEREDCOLLS_LIST = Configuration.makeKey((String)"import", (String)"extended", (String)"java", (String)"orderedcolls", (String)"list");
    }
}

