/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

class SimpleLookup
extends Lookup {
    private Collection allItems;

    SimpleLookup(Collection collection) {
        this.allItems = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.allItems.add(new InstanceContent.SimpleItem(iterator.next()));
        }
    }

    SimpleLookup(Collection collection, InstanceContent.Convertor convertor) {
        this.allItems = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.allItems.add(new InstanceContent.ConvertingItem(iterator.next(), convertor));
        }
    }

    public String toString() {
        return "SimpleLookup" + this.lookup(new Lookup.Template(Object.class)).allInstances();
    }

    public Lookup.Result lookup(Lookup.Template template) {
        if (template == null) {
            throw new NullPointerException();
        }
        return new SimpleResult(template);
    }

    public Object lookup(Class clazz) {
        Lookup.Item item = this.lookupItem(new Lookup.Template(clazz));
        return item == null ? null : item.getInstance();
    }

    private static boolean matches(Lookup.Template template, AbstractLookup.Pair pair) {
        if (!AbstractLookup.matches(template, pair, true)) {
            return false;
        }
        Class clazz = template.getType();
        return clazz == null || clazz.isAssignableFrom(pair.getType());
    }

    private class SimpleResult
    extends Lookup.Result {
        private Set classes;
        private Collection items;
        private Lookup.Template template;
        private Collection results;

        SimpleResult(Lookup.Template template) {
            this.template = template;
        }

        public void addLookupListener(LookupListener lookupListener) {
        }

        public void removeLookupListener(LookupListener lookupListener) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection allInstances() {
            Object object = this;
            synchronized (object) {
                if (this.results != null) {
                    return this.results;
                }
            }
            object = new ArrayList(SimpleLookup.this.allItems.size());
            Object object2 = this.allItems().iterator();
            while (object2.hasNext()) {
                object.add(((Lookup.Item)object2.next()).getInstance());
            }
            object2 = this;
            synchronized (object2) {
                this.results = Collections.unmodifiableCollection(object);
            }
            return this.results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set allClasses() {
            Object object = this;
            synchronized (object) {
                if (this.classes != null) {
                    return this.classes;
                }
            }
            object = new HashSet();
            Object object2 = this.allItems().iterator();
            while (object2.hasNext()) {
                object.add(((Lookup.Item)object2.next()).getType());
            }
            object2 = this;
            synchronized (object2) {
                this.classes = Collections.unmodifiableSet(object);
            }
            return this.classes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection allItems() {
            Object object = this;
            synchronized (object) {
                if (this.items != null) {
                    return this.items;
                }
            }
            object = new ArrayList(SimpleLookup.this.allItems.size());
            Object object2 = SimpleLookup.this.allItems.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                if (!(e instanceof AbstractLookup.Pair) || !SimpleLookup.matches(this.template, (AbstractLookup.Pair)e)) continue;
                object.add(e);
            }
            object2 = this;
            synchronized (object2) {
                this.items = Collections.unmodifiableCollection(object);
            }
            return this.items;
        }
    }
}

