/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class WeakSet
extends AbstractSet
implements Cloneable,
Serializable {
    static final long serialVersionUID = 3062376055928236721L;
    private float loadFactor;
    private int size;
    private long modcount;
    private transient ReferenceQueue refq;
    long nullCount;
    private transient Entry[] entries;
    transient Entry iterChain;

    public WeakSet() {
        this(11, 0.75f);
    }

    public WeakSet(Collection collection) {
        this();
        this.addAll(collection);
    }

    public WeakSet(int n) {
        this(n, 0.75f);
    }

    public WeakSet(int n, float f) {
        if (n <= 0 || f <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.modcount = 0L;
        this.loadFactor = f;
        this.nullCount = 0L;
        this.refq = new ReferenceQueue();
        this.entries = new Entry[n];
        this.iterChain = null;
    }

    public boolean add(Object object) {
        if (object == null) {
            ++this.size;
            ++this.nullCount;
            ++this.modcount;
            return true;
        }
        Entry entry = this.object2Entry(object);
        if (entry != null) {
            return false;
        }
        ++this.modcount;
        ++this.size;
        int n = this.hashIt(object);
        Entry entry2 = this.entries[n];
        this.iterChain = this.entries[n] = new Entry(object, this.refq, entry2, this.iterChain);
        this.rehash();
        return true;
    }

    public void clear() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.nullCount = 0L;
        ++this.modcount;
        this.size = 0;
        this.iterChain = null;
    }

    public Object clone() {
        WeakSet weakSet = new WeakSet(1, this.loadFactor);
        weakSet.size = this.size;
        weakSet.nullCount = this.nullCount;
        Entry[] entryArray = new Entry[this.entries.length];
        weakSet.entries = entryArray;
        for (int i = 0; i < entryArray.length; ++i) {
            Object t;
            if (this.entries[i] == null || (t = this.entries[i].get()) == null) {
                entryArray[i] = null;
            } else {
                entryArray[i] = this.entries[i] == null ? null : this.entries[i].clone(weakSet.refq);
                t = null;
            }
            Entry entry = entryArray[i];
            while (entry != null) {
                entry.chainIntoIter(weakSet.iterChain);
                weakSet.iterChain = entry;
                entry = entry.next;
            }
        }
        return weakSet;
    }

    public boolean contains(Object object) {
        if (object == null) {
            return this.nullCount > 0L;
        }
        return this.object2Entry(object) != null;
    }

    public boolean isEmpty() {
        return this.nullCount == 0L && this.size() == 0;
    }

    public Iterator iterator() {
        return new WeakSetIterator();
    }

    public boolean remove(Object object) {
        if (object == null) {
            if (this.nullCount > 0L) {
                --this.nullCount;
                ++this.modcount;
                --this.size;
            }
            return true;
        }
        Entry entry = this.object2Entry(object);
        if (entry != null) {
            ++this.modcount;
            --this.size;
            entry.remove();
            this.rehash();
            return true;
        }
        return false;
    }

    public int size() {
        this.checkRefQueue();
        return this.size;
    }

    public Object[] toArray(Object[] objectArray) {
        ArrayList arrayList = new ArrayList(objectArray.length);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.toArray(objectArray);
    }

    public Object[] toArray() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.toArray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        stringBuffer.append("[");
        while (iterator.hasNext()) {
            stringBuffer.append(String.valueOf(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    void checkRefQueue() {
        Entry entry;
        while ((entry = (Entry)this.refq.poll()) != null) {
            entry.remove();
            --this.size;
        }
    }

    long modCount() {
        return this.modcount;
    }

    int hashIt(Object object) {
        return (object.hashCode() & Integer.MAX_VALUE) % this.entries.length;
    }

    void rehash() {
    }

    private Entry object2Entry(Object object) {
        this.checkRefQueue();
        int n = this.hashIt(object);
        Entry entry = this.entries[n];
        if (entry == null) {
            return null;
        }
        while (entry != null && !entry.equals(object)) {
            entry = entry.next;
        }
        return entry;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.toArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        this.entries = new Entry[(int)((double)this.size * 1.5)];
        this.refq = new ReferenceQueue();
        for (int i = 0; i < objectArray.length; ++i) {
            this.add(objectArray[i]);
        }
    }

    class Entry
    extends WeakReference {
        Entry prev;
        Entry next;
        private final int hashcode;
        Entry iterChainNext;
        Entry iterChainPrev;

        Entry(Object object, ReferenceQueue referenceQueue, Entry entry, Entry entry2) {
            super(object, referenceQueue);
            this.next = entry;
            this.prev = null;
            if (entry != null) {
                entry.prev = this;
            }
            this.hashcode = object != null ? WeakSet.this.hashIt(object) : 0;
            this.chainIntoIter(entry2);
        }

        void chainIntoIter(Entry entry) {
            this.iterChainNext = entry;
            if (entry != null) {
                entry.iterChainPrev = this;
                Object t = entry.get();
                if (t == null) {
                    entry.remove();
                }
            }
        }

        void remove() {
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.iterChainNext != null) {
                this.iterChainNext.iterChainPrev = this.iterChainPrev;
            }
            if (this.iterChainPrev != null) {
                this.iterChainPrev.iterChainNext = this.iterChainNext;
            } else {
                WeakSet.this.iterChain = this.iterChainNext;
            }
            if (WeakSet.this.entries[this.hashcode] == this) {
                ((WeakSet)WeakSet.this).entries[this.hashcode] = this.next;
            }
            this.prev = null;
            this.next = null;
            this.iterChainNext = null;
            this.iterChainPrev = null;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object object) {
            Object t = this.get();
            if (t == null) {
                return false;
            }
            return t.equals(object);
        }

        public Entry clone(ReferenceQueue referenceQueue) {
            return new Entry(this.get(), referenceQueue, this.next != null ? this.next.clone(referenceQueue) : null, null);
        }
    }

    class WeakSetIterator
    implements Iterator {
        Entry current;
        Entry next;
        Object currentObj;
        Object nextObj;
        final long myModcount;
        long myNullCount;

        WeakSetIterator() {
            this.myModcount = WeakSet.this.modCount();
            this.myNullCount = WeakSet.this.nullCount;
            this.current = null;
            this.next = null;
            Entry entry = WeakSet.this.iterChain;
            if (entry == null) {
                return;
            }
            Object t = entry.get();
            while (entry.isEnqueued()) {
                entry = entry.iterChainNext;
                if (entry == null) {
                    return;
                }
                t = entry.get();
            }
            this.nextObj = t;
            this.next = entry;
        }

        public boolean hasNext() {
            this.checkModcount();
            return this.myNullCount > 0L || this.next != null;
        }

        public Object next() {
            this.checkModcount();
            WeakSet.this.checkRefQueue();
            if (this.myNullCount > 0L) {
                --this.myNullCount;
                return null;
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.currentObj = this.nextObj;
            do {
                this.next = this.next.iterChainNext;
                if (this.next == null) break;
                this.nextObj = this.next.get();
            } while (this.next.isEnqueued());
            return this.currentObj;
        }

        public void remove() {
            this.checkModcount();
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.remove();
            WeakSet.this.size--;
        }

        void checkModcount() {
            if (this.myModcount != WeakSet.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

