      PROGRAM MAIN75
C...P. Skands, May 2006.
C...Test program to generate ttbar events at Tevatron using PYTHIA
C...internal ttbar production subprocesses, with varoius options for
C...underlying-event framework and parton showers. 
C...VERSION COMPATIBILITY:
C...  ALL TUNES WORK WITH PYTHIA v.6402 OR LATER
C...DISCLAIMER:
C...* With the exception of Tune A, these tunes are rough first tunes,
C...  and so should not be taken too seriously. They reproduce eg  
C...  the charged multiplicity distribution in min-bias collisions at 
C...  the Tevatron, but many other distributions have not been checked.
C...* Since these rough tunes were produced comparing to Tevatron 
C...  distributions only, the energy rescaling parameter, PARP(90), is
C...  not determined. HOWEVER, note that variations in this parameter 
C...  can lead to large differences at LHC (and also at RHIC). Therefore, 
C...  each tune comes in 3 variants, with different energy scaling 
C...  behaviour. Tunes 0-7 use the slowest energy rescaling, leading 
C...  to comparatively more underlying activity at the LHC, tunes 10-17 
C...  give somewhat less underlying activity at the LHC, and tunes 20-27
C...  give the least underlying activity at the LHC. The opposite is 
C...  true for energies below the Tevatron, such as RHIC. See auxiliary 
C...  routine PYTUNE (included below) for details on the tunes.

C--------------- PREAMBLE: COMMON BLOCK DECLARATIONS ETC -------------
C...All real arithmetic done in double precision.
      IMPLICIT DOUBLE PRECISION(A-H, O-Z)
C...The PYTHIA event record:
      COMMON/PYJETS/N,NPAD,K(4000,5),P(4000,5),V(4000,5)
C...Internal common block needed below to get number of multiple inter-
C...actions for histogramming. For information EXTRACTION only. No 
C...variables in these blocks should be changed by user.
      COMMON/PYINT1/MINT(400),VINT(400)
C...EXTERNAL statement links PYDATA on most machines.
      EXTERNAL PYDATA

C-------------------------- PYTHIA SETUP -----------------------------
C...See SUBROUTINE PYTUNE below for descriptions of the models.
C...Choose tune (valid tunes: 0-7, 10-17, 20-27).
      ITUNE=0
      CALL PYTUNE(ITUNE)

C - Number of events to generate.
      NEV=5000

C - Other parameters
C...* Type of events to be generated: ttbar (using PYGIVE)
C...* Specify mtop
C...* CM Energy for Tevatron Run II.
      CALL PYGIVE('MSEL=6')
      CALL PYGIVE('PMAS(6,1)=174.0')
      ECM=1960D0

C - Initialize PYTHIA.
      CALL PYINIT('CMS','p','pbar',ECM)

C - Book histograms (just for fun)
      CALL PYBOOK(1,'Number of interactions',50,-0.5D0,49.5D0)
      CALL PYBOOK(2,'Charged multiplicity',100,-1D0,399D0)

C------------------------- GENERATE EVENTS ---------------------------
      DO 1000 IEV=1,NEV
        CALL PYEVNT
C...  Make a print of the event record for the first event
        IF (IEV.EQ.1) THEN 
          CALL PYLIST(2)
        ENDIF

C...Fill histograms (just for fun)
C...Extract and fill number of scatterings (/event)
        NINT=MINT(31)
        CALL PYFILL(1,DBLE(NINT),1D0/NEV)        
C...Extract and fill total charged multiplicity (/event/allowed value)
        CALL PYEDIT(3)
        CALL PYFILL(2,DBLE(N),0.5D0/NEV)
        
 1000 CONTINUE

C----------------------------- FINALIZE ------------------------------
C - Print some info on cross sections and errors/warnings
      CALL PYSTAT(1)

C...Histograms.
      CALL PYHIST

      END



C=====================================================================
C-------------------- AUXILIARY ROUTINE PYTUNE -----------------------
C              Sets parameters for a few standard scenarios.
      SUBROUTINE PYTUNE(ITUNE) 
C Quick Dictionary:
C      BR : Beam Remnants
C      CR : Colour Reconnections
C      ISR/FSR: Initial-State Radiation / Final-State Radiation
C      MB : Minimum-bias
C      MI : Multiple Interactions
C      UE : Underlying Event
C
C Energy Scaling: all tunes have Tevatron as reference scale.
C   ITUNE = 0-9  : slow scaling -> large UE at LHC / small at RHIC.
C         = 10-19: same tunes, with medium-paced energy scaling
C         = 20-29: fast scaling -> small UE at LHC / large at RHIC.
C       
C...ITUNE = 0,10,20 : Tune S0. New UE model, pT-ordered showers. 
C...Key feature: large amount of multiple interactions
C...* Small amount of radiation.
C...* Large amount of low-pT MI
C...* Low degree of proton lumpiness (broad matter dist.)
C...* CR Type S (driven by free triplets), of medium strength.
C...* See: Pythia6402 update notes or later.
C
C...ITUNE = 1,11,21 : Tune S1. New UE model, pT-ordered showers.
C...Key feature: large amount of radiation.
C...* Large amount of low-pT perturbative ISR
C...* Large amount of FSR off ISR partons
C...* Small amount of low-pT multiple interactions
C...* Moderate degree of proton lumpiness
C...* Least aggressive CR type (S+S Type I), but with large strength
C...* See: Sandhoff & Skands: FERMILAB-CONF-05-518-T, in hep-ph/0604120.
C
C...ITUNE = 2,12,22 : Tune S2. New UE model, pT-ordered showers. 
C...Key feature: very lumpy proton + gg string cluster formation allowed
C...* Small amount of radiation
C...* Moderate amount of low-pT MI
C...* High degree of proton lumpiness (more spiky matter distribution)
C...* Most aggressive CR type (S+S Type II), but with small strength
C...* See: Sandhoff & Skands: FERMILAB-CONF-05-518-T, in hep-ph/0604120.
C 
C...ITUNE = 3,13,23 : Old CR ("Lo FSR" (re)Tune). New UE, pT-ordered showers.
C...Key feature: primitive colour reconnections.
C...* NB: <pT>(Nch) problematic in this tune.
C...* Small amount of radiation
C...* Large amount of low-pT MI
C...* Very low degree of proton lumpiness.
C...* Old primitive CR model. 
C...* See: Sjostrand & Skands, Eur.Phys.J.C39(2205)129, hep-ph/0408302.
C...
C...ITUNE = 4,14,24 : No CR Tune. New UE model, pT-ordered showers.
C...Key feature: no colour reconnections (NB: "Best fit" only).
C...* NB: <pT>(Nch) problematic in this tune.
C...* Small amount of radiation
C...* Small amount of low-pT MI
C...* Low degree of proton lumpiness
C...* Large BR composite x enhancement factor
C...* Most clever colour flow without CR ("Lambda ordering")
C
C...ITUNE = 5,15,25 : Tune A. Old UE model, Q2-ordered showers.
C...Key feature: extensively compared to CDF data (R.D. Field).
C...NB: Can also be run with Pythia 6.2 or 6.312+
C...* Large starting scale for ISR (PARP(67)=4)
C...* See: http://www.phys.ufl.edu/~rfield/cdf/
C
C...ITUNE = 6,16,26 : Tune BW. Old UE model, Q2-ordered showers.
C...Key feature: extensively compared to CDF data (R.D. Field).
C...NB: Can also be run with Pythia 6.2 or 6.312+
C...* Large value of alpha_s.
C...* See: http://www.phys.ufl.edu/~rfield/cdf/
C
C...ITUNE = 7,17,27 : Rap Tune. Intermediate model, Q2-ordered showers.
C...Key feature: new UE model with Q2-ordered showers and no interleaving.
C...* NB: <pT>(Nch) problematic in this tune.
C...* Old (primitive) CR.
C...* See: Sjostrand & Skands: JHEP 03(2004)053, hep-ph/0402078.

      IMPLICIT DOUBLE PRECISION(A-H, O-Z)
      INTEGER PYK,PYCHGE,PYCOMP
 
C...Commonblocks.
      COMMON/PYDAT1/MSTU(200),PARU(200),MSTJ(200),PARJ(200)
      COMMON/PYPARS/MSTP(200),PARP(200),MSTI(200),PARI(200)
      SAVE /PYDAT1/,/PYPARS/

      IF (MOD(ITUNE,10).EQ.0) THEN 
C...New model, smooth ISR, low FSR
        CALL PYGIVE('MSTP(81)=21')
        CALL PYGIVE('MSTP(70)=2')
        CALL PYGIVE('MSTP(72)=0')
C...pT0
        CALL PYGIVE('PARP(82)=2.1D0')     
C...Transverse density profile.
        CALL PYGIVE('MSTP(82)=5')
        CALL PYGIVE('PARP(83)=1.6D0')
C...Colour Reconnections
        CALL PYGIVE('MSTP(95)=6')
        CALL PYGIVE('PARP(78)=0.2D0')
C...Reference energy for pT0 and energy scaling pace.
        CALL PYGIVE('PARP(89)=1800D0')
        IF (ITUNE/10.EQ.0) THEN 
          CALL PYGIVE('PARP(90)=0.16D0')
        ELSEIF (ITUNE/10.EQ.1) THEN 
          CALL PYGIVE('PARP(90)=0.205D0')
        ELSE
          CALL PYGIVE('PARP(90)=0.25D0')
        ENDIF
C...Lambda_FSR scale.
        CALL PYGIVE('PARJ(81)=0.14D0')
C...FSR activity.
        CALL PYGIVE('PARP(71)=4D0') 
C...Rap order, Valence qq, qq x enhc, BR-g-BR supp
        CALL PYGIVE('MSTP(89)=1')
        CALL PYGIVE('MSTP(88)=0')
        CALL PYGIVE('PARP(79)=2D0')          
        CALL PYGIVE('PARP(80)=0.01D0')
C...Switch off trial joinings
        MSTP(96)=0

      ELSEIF(MOD(ITUNE,10).EQ.1) THEN  
C...New model: sharp ISR, high FSR
        CALL PYGIVE('MSTP(81)=21')
        CALL PYGIVE('MSTP(70)=0') 
        CALL PYGIVE('MSTP(72)=1') 
C...pT0 
        CALL PYGIVE('PARP(82)=2.5D0')
C...Colour Reconnections
        CALL PYGIVE('MSTP(95)=2')
        CALL PYGIVE('PARP(78)=0.35D0')
C...Transverse density profile.
        CALL PYGIVE('MSTP(82)=5')
        CALL PYGIVE('PARP(83)=1.4D0')
C...Reference energy for pT0 and energy rescaling pace.
        CALL PYGIVE('PARP(89)=1800D0')
        IF (ITUNE/10.EQ.0) THEN 
          CALL PYGIVE('PARP(90)=0.16D0')
        ELSEIF (ITUNE/10.EQ.1) THEN 
          CALL PYGIVE('PARP(90)=0.205D0')
        ELSE
          CALL PYGIVE('PARP(90)=0.25D0')
        ENDIF
C...Lambda_FSR scale.
        CALL PYGIVE('PARJ(81)=0.14D0')
C...FSR activity.
        CALL PYGIVE('PARP(71)=4D0') 
C...Rap order, Valence qq, qq x enhc, BR-g-BR supp
        CALL PYGIVE('MSTP(89)=1')
        CALL PYGIVE('MSTP(88)=0')
        CALL PYGIVE('PARP(79)=2D0')           
        CALL PYGIVE('PARP(80)=0.01D0')
C...Switch off trial joinings
        MSTP(96)=0

      ELSEIF(MOD(ITUNE,10).EQ.2) THEN  
C...New model, smooth ISR, low FSR
        CALL PYGIVE('MSTP(81)=21')
        CALL PYGIVE('MSTP(70)=2')
        CALL PYGIVE('MSTP(72)=0')
C...pT0
        CALL PYGIVE('PARP(82)=2.25D0') 
C...Transverse density profile.
        CALL PYGIVE('MSTP(82)=5')
        CALL PYGIVE('PARP(83)=1.25D0')
C...Colour Reconnections
        CALL PYGIVE('MSTP(95)=4')
        CALL PYGIVE('PARP(78)=0.15D0')
C...Reference energy for pT0 and energy scaling pace.
        CALL PYGIVE('PARP(89)=1800D0')
        IF (ITUNE/10.EQ.0) THEN 
          CALL PYGIVE('PARP(90)=0.16D0')
        ELSEIF (ITUNE/10.EQ.1) THEN 
          CALL PYGIVE('PARP(90)=0.205D0')
        ELSE
          CALL PYGIVE('PARP(90)=0.25D0')
        ENDIF
C...Lambda_FSR scale.
        CALL PYGIVE('PARJ(81)=0.14D0')
C...FSR activity.
        CALL PYGIVE('PARP(71)=4D0') 
C...Rap order, Valence qq, qq x enhc, BR-g-BR supp
        CALL PYGIVE('MSTP(89)=1')
        CALL PYGIVE('MSTP(88)=0')
        CALL PYGIVE('PARP(79)=2D0')          
        CALL PYGIVE('PARP(80)=0.01D0')
C...Switch off trial joinings
        MSTP(96)=0

      ELSEIF(MOD(ITUNE,10).EQ.3) THEN  
C...New model, smooth ISR, low FSR
        CALL PYGIVE('MSTP(81)=21')
        CALL PYGIVE('MSTP(70)=2')
        CALL PYGIVE('MSTP(72)=0')
C...pT0
        CALL PYGIVE('PARP(82)=2.1D0')         
C...Transverse density profile.
        CALL PYGIVE('MSTP(82)=5')
        CALL PYGIVE('PARP(83)=2.0D0')
C...Colour Reconnections
        CALL PYGIVE('MSTP(95)=1')
        CALL PYGIVE('PARP(78)=1.0D0')
C...Reference energy for pT0 and energy scaling pace.
        CALL PYGIVE('PARP(89)=1800D0')
        IF (ITUNE/10.EQ.0) THEN 
          CALL PYGIVE('PARP(90)=0.16D0')
        ELSEIF (ITUNE/10.EQ.1) THEN 
          CALL PYGIVE('PARP(90)=0.205D0')
        ELSE
          CALL PYGIVE('PARP(90)=0.25D0')
        ENDIF
C...Lambda_FSR scale.
        CALL PYGIVE('PARJ(81)=0.14D0')
C...FSR activity.
        CALL PYGIVE('PARP(71)=4D0') 
C...Rap order, Valence qq, qq x enhc, BR-g-BR supp
        CALL PYGIVE('MSTP(89)=1')
        CALL PYGIVE('MSTP(88)=0')
        CALL PYGIVE('PARP(79)=2D0')          
        CALL PYGIVE('PARP(80)=0.01D0')
C...Switch off trial joinings
        MSTP(96)=0

      ELSEIF(MOD(ITUNE,10).EQ.4) THEN  
C...New model, smooth ISR, low FSR
        CALL PYGIVE('MSTP(81)=21')
        CALL PYGIVE('MSTP(70)=2')
        CALL PYGIVE('MSTP(72)=0')
C...pT0
        CALL PYGIVE('PARP(82)=2.3D0') 
C...Transverse density profile.
        CALL PYGIVE('MSTP(82)=5')
        CALL PYGIVE('PARP(83)=1.55D0')
C...Colour Reconnections
        CALL PYGIVE('MSTP(95)=0')       
C...Reference energy for pT0 and energy scaling pace.
        CALL PYGIVE('PARP(89)=1800D0')
        IF (ITUNE/10.EQ.0) THEN 
          CALL PYGIVE('PARP(90)=0.16D0')
        ELSEIF (ITUNE/10.EQ.1) THEN 
          CALL PYGIVE('PARP(90)=0.205D0')
        ELSE
          CALL PYGIVE('PARP(90)=0.25D0')
        ENDIF
C...Lambda_FSR scale.
        CALL PYGIVE('PARJ(81)=0.14D0')
C...FSR activity.
        CALL PYGIVE('PARP(71)=4D0') 
C...Lambda order, Valence qq, large qq x enhc, BR-g-BR supp
        CALL PYGIVE('MSTP(89)=2')
        CALL PYGIVE('MSTP(88)=0')
        CALL PYGIVE('PARP(79)=3D0')
        CALL PYGIVE('PARP(80)=0.01D0')
C...Switch off trial joinings
        MSTP(96)=0

C...Tunes A and BW. (by R.D. Field, CDF)
      ELSEIF(MOD(ITUNE,10).EQ.5.OR.MOD(ITUNE,10).EQ.6) THEN
C...Multiple interactions on.
        CALL PYGIVE('MSTP(81)=1')
C...Double Gaussian matter distribution. 
        CALL PYGIVE('MSTP(82)=4')
        CALL PYGIVE('PARP(83)=0.5D0')
        CALL PYGIVE('PARP(84)=0.4D0')
C...Reference energy for pT0 and energy rescaling pace.
        CALL PYGIVE('PARP(89)=1800D0')
        IF (ITUNE/10.EQ.0) THEN 
          CALL PYGIVE('PARP(90)=0.16D0')
        ELSEIF (ITUNE/10.EQ.1) THEN 
          CALL PYGIVE('PARP(90)=0.205D0')
        ELSE
          CALL PYGIVE('PARP(90)=0.25D0')
        ENDIF
C...FSR activity. 
        CALL PYGIVE('PARP(71)=4D0')
C...Lambda_FSR scale. 
        CALL PYGIVE('PARJ(81)=0.29D0')
     
        IF(MOD(ITUNE,10).EQ.5) THEN
C...Tune A. 
C...pT0.
          CALL PYGIVE('PARP(82)=2.0D0')
c...String drawing almost completely minimizes string length.
          CALL PYGIVE('PARP(85)=0.9D0')
          CALL PYGIVE('PARP(86)=0.95D0')
C...ISR cutoff, muR scale factor, and phase space size
          CALL PYGIVE('PARP(62)=1D0')
          CALL PYGIVE('PARP(64)=1D0')
          CALL PYGIVE('PARP(67)=4D0')
C...Intrinsic kT, size, and max
          CALL PYGIVE('MSTP(91)=1')
          CALL PYGIVE('PARP(91)=1D0')
          CALL PYGIVE('PARP(93)=5D0')
        ELSE
C...Tune BW (larger alpha_s, more intrinsic kT. Smaller ISR phase space.)
C...pT0.
          CALL PYGIVE('PARP(82)=1.9D0')
c...String drawing completely minimizes string length.
          CALL PYGIVE('PARP(85)=1.0D0')
          CALL PYGIVE('PARP(86)=1.0D0')
C...ISR cutoff, muR scale factor, and phase space size
          CALL PYGIVE('PARP(62)=1.25D0')
          CALL PYGIVE('PARP(64)=0.2D0')
          CALL PYGIVE('PARP(67)=1D0')
C...Intrinsic kT, size, and max
          CALL PYGIVE('MSTP(91)=1')
          CALL PYGIVE('PARP(91)=2.1D0')
          CALL PYGIVE('PARP(93)=15D0')
        ENDIF
     

      ELSEIF(MOD(ITUNE,10).EQ.7) THEN
C...  Intermediate model. Rap tune.
        CALL PYGIVE('MSTP(81)=11')
C...  Valence qq, BR-g-BR supp
        CALL PYGIVE('MSTP(88)=0')
        CALL PYGIVE('PARP(80)=0.01D0')
C...  Default diquark
        CALL PYGIVE('PARP(79)=2D0')           
C...  Final state reconnect.
        CALL PYGIVE('MSTP(95)=1')
        CALL PYGIVE('PARP(78)=0.55D0') 
C...  Maximum Q2 scale for ISR and FSR in relation to hard Q2.
        CALL PYGIVE('PARP(67)=4.0D0')
        CALL PYGIVE('PARP(71)=4.0D0')
C...  Reference energy for pT0 and energy rescaling pace.
        CALL PYGIVE('PARP(89)=1800D0')
        CALL PYGIVE('PARP(90)=0.25D0')
C...  Lambda_FSR scale.
        CALL PYGIVE('PARJ(81)=0.29D0')
C...  Rap Tune
        CALL PYGIVE('MSTP(89)=1')
C...  ExpOfPow(1.8) overlap profile
        CALL PYGIVE('MSTP(82)=5')
        CALL PYGIVE(' PARP(83)=1.8D0')
C...pT0 
        CALL PYGIVE('PARP(82)=2.40D0')

      ELSE
        CALL PYERRM(29,'(PYTUNE:) Desired Pythia tune not recognized') 

      ENDIF   
 
      RETURN 
      END 

