// Code generated by capnpc-go. DO NOT EDIT.

package rpc

import (
	capnp "capnproto.org/go/capnp/v3"
	text "capnproto.org/go/capnp/v3/encoding/text"
	schemas "capnproto.org/go/capnp/v3/schemas"
	strconv "strconv"
)

type Message capnp.Struct
type Message_Which uint16

const (
	Message_Which_unimplemented  Message_Which = 0
	Message_Which_abort          Message_Which = 1
	Message_Which_bootstrap      Message_Which = 8
	Message_Which_call           Message_Which = 2
	Message_Which_return         Message_Which = 3
	Message_Which_finish         Message_Which = 4
	Message_Which_resolve        Message_Which = 5
	Message_Which_release        Message_Which = 6
	Message_Which_disembargo     Message_Which = 13
	Message_Which_obsoleteSave   Message_Which = 7
	Message_Which_obsoleteDelete Message_Which = 9
	Message_Which_provide        Message_Which = 10
	Message_Which_accept         Message_Which = 11
	Message_Which_join           Message_Which = 12
)

func (w Message_Which) String() string {
	const s = "unimplementedabortbootstrapcallreturnfinishresolvereleasedisembargoobsoleteSaveobsoleteDeleteprovideacceptjoin"
	switch w {
	case Message_Which_unimplemented:
		return s[0:13]
	case Message_Which_abort:
		return s[13:18]
	case Message_Which_bootstrap:
		return s[18:27]
	case Message_Which_call:
		return s[27:31]
	case Message_Which_return:
		return s[31:37]
	case Message_Which_finish:
		return s[37:43]
	case Message_Which_resolve:
		return s[43:50]
	case Message_Which_release:
		return s[50:57]
	case Message_Which_disembargo:
		return s[57:67]
	case Message_Which_obsoleteSave:
		return s[67:79]
	case Message_Which_obsoleteDelete:
		return s[79:93]
	case Message_Which_provide:
		return s[93:100]
	case Message_Which_accept:
		return s[100:106]
	case Message_Which_join:
		return s[106:110]

	}
	return "Message_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Message_TypeID is the unique identifier for the type Message.
const Message_TypeID = 0x91b79f1f808db032

func NewMessage(s *capnp.Segment) (Message, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Message(st), err
}

func NewRootMessage(s *capnp.Segment) (Message, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Message(st), err
}

func ReadRootMessage(msg *capnp.Message) (Message, error) {
	root, err := msg.Root()
	return Message(root.Struct()), err
}

func (s Message) String() string {
	str, _ := text.Marshal(0x91b79f1f808db032, capnp.Struct(s))
	return str
}

func (s Message) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Message) DecodeFromPtr(p capnp.Ptr) Message {
	return Message(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Message) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Message) Which() Message_Which {
	return Message_Which(capnp.Struct(s).Uint16(0))
}
func (s Message) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Message) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Message) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Message) Unimplemented() (Message, error) {
	if capnp.Struct(s).Uint16(0) != 0 {
		panic("Which() != unimplemented")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Message(p.Struct()), err
}

func (s Message) HasUnimplemented() bool {
	if capnp.Struct(s).Uint16(0) != 0 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetUnimplemented(v Message) error {
	capnp.Struct(s).SetUint16(0, 0)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewUnimplemented sets the unimplemented field to a newly
// allocated Message struct, preferring placement in s's segment.
func (s Message) NewUnimplemented() (Message, error) {
	capnp.Struct(s).SetUint16(0, 0)
	ss, err := NewMessage(capnp.Struct(s).Segment())
	if err != nil {
		return Message{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Abort() (Exception, error) {
	if capnp.Struct(s).Uint16(0) != 1 {
		panic("Which() != abort")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Exception(p.Struct()), err
}

func (s Message) HasAbort() bool {
	if capnp.Struct(s).Uint16(0) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetAbort(v Exception) error {
	capnp.Struct(s).SetUint16(0, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewAbort sets the abort field to a newly
// allocated Exception struct, preferring placement in s's segment.
func (s Message) NewAbort() (Exception, error) {
	capnp.Struct(s).SetUint16(0, 1)
	ss, err := NewException(capnp.Struct(s).Segment())
	if err != nil {
		return Exception{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Bootstrap() (Bootstrap, error) {
	if capnp.Struct(s).Uint16(0) != 8 {
		panic("Which() != bootstrap")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Bootstrap(p.Struct()), err
}

func (s Message) HasBootstrap() bool {
	if capnp.Struct(s).Uint16(0) != 8 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetBootstrap(v Bootstrap) error {
	capnp.Struct(s).SetUint16(0, 8)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewBootstrap sets the bootstrap field to a newly
// allocated Bootstrap struct, preferring placement in s's segment.
func (s Message) NewBootstrap() (Bootstrap, error) {
	capnp.Struct(s).SetUint16(0, 8)
	ss, err := NewBootstrap(capnp.Struct(s).Segment())
	if err != nil {
		return Bootstrap{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Call() (Call, error) {
	if capnp.Struct(s).Uint16(0) != 2 {
		panic("Which() != call")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Call(p.Struct()), err
}

func (s Message) HasCall() bool {
	if capnp.Struct(s).Uint16(0) != 2 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetCall(v Call) error {
	capnp.Struct(s).SetUint16(0, 2)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewCall sets the call field to a newly
// allocated Call struct, preferring placement in s's segment.
func (s Message) NewCall() (Call, error) {
	capnp.Struct(s).SetUint16(0, 2)
	ss, err := NewCall(capnp.Struct(s).Segment())
	if err != nil {
		return Call{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Return() (Return, error) {
	if capnp.Struct(s).Uint16(0) != 3 {
		panic("Which() != return")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Return(p.Struct()), err
}

func (s Message) HasReturn() bool {
	if capnp.Struct(s).Uint16(0) != 3 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetReturn(v Return) error {
	capnp.Struct(s).SetUint16(0, 3)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewReturn sets the return field to a newly
// allocated Return struct, preferring placement in s's segment.
func (s Message) NewReturn() (Return, error) {
	capnp.Struct(s).SetUint16(0, 3)
	ss, err := NewReturn(capnp.Struct(s).Segment())
	if err != nil {
		return Return{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Finish() (Finish, error) {
	if capnp.Struct(s).Uint16(0) != 4 {
		panic("Which() != finish")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Finish(p.Struct()), err
}

func (s Message) HasFinish() bool {
	if capnp.Struct(s).Uint16(0) != 4 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetFinish(v Finish) error {
	capnp.Struct(s).SetUint16(0, 4)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewFinish sets the finish field to a newly
// allocated Finish struct, preferring placement in s's segment.
func (s Message) NewFinish() (Finish, error) {
	capnp.Struct(s).SetUint16(0, 4)
	ss, err := NewFinish(capnp.Struct(s).Segment())
	if err != nil {
		return Finish{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Resolve() (Resolve, error) {
	if capnp.Struct(s).Uint16(0) != 5 {
		panic("Which() != resolve")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Resolve(p.Struct()), err
}

func (s Message) HasResolve() bool {
	if capnp.Struct(s).Uint16(0) != 5 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetResolve(v Resolve) error {
	capnp.Struct(s).SetUint16(0, 5)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResolve sets the resolve field to a newly
// allocated Resolve struct, preferring placement in s's segment.
func (s Message) NewResolve() (Resolve, error) {
	capnp.Struct(s).SetUint16(0, 5)
	ss, err := NewResolve(capnp.Struct(s).Segment())
	if err != nil {
		return Resolve{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Release() (Release, error) {
	if capnp.Struct(s).Uint16(0) != 6 {
		panic("Which() != release")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Release(p.Struct()), err
}

func (s Message) HasRelease() bool {
	if capnp.Struct(s).Uint16(0) != 6 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetRelease(v Release) error {
	capnp.Struct(s).SetUint16(0, 6)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRelease sets the release field to a newly
// allocated Release struct, preferring placement in s's segment.
func (s Message) NewRelease() (Release, error) {
	capnp.Struct(s).SetUint16(0, 6)
	ss, err := NewRelease(capnp.Struct(s).Segment())
	if err != nil {
		return Release{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Disembargo() (Disembargo, error) {
	if capnp.Struct(s).Uint16(0) != 13 {
		panic("Which() != disembargo")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Disembargo(p.Struct()), err
}

func (s Message) HasDisembargo() bool {
	if capnp.Struct(s).Uint16(0) != 13 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetDisembargo(v Disembargo) error {
	capnp.Struct(s).SetUint16(0, 13)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewDisembargo sets the disembargo field to a newly
// allocated Disembargo struct, preferring placement in s's segment.
func (s Message) NewDisembargo() (Disembargo, error) {
	capnp.Struct(s).SetUint16(0, 13)
	ss, err := NewDisembargo(capnp.Struct(s).Segment())
	if err != nil {
		return Disembargo{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) ObsoleteSave() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(0) != 7 {
		panic("Which() != obsoleteSave")
	}
	return capnp.Struct(s).Ptr(0)
}

func (s Message) HasObsoleteSave() bool {
	if capnp.Struct(s).Uint16(0) != 7 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetObsoleteSave(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(0, 7)
	return capnp.Struct(s).SetPtr(0, v)
}
func (s Message) ObsoleteDelete() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(0) != 9 {
		panic("Which() != obsoleteDelete")
	}
	return capnp.Struct(s).Ptr(0)
}

func (s Message) HasObsoleteDelete() bool {
	if capnp.Struct(s).Uint16(0) != 9 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetObsoleteDelete(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(0, 9)
	return capnp.Struct(s).SetPtr(0, v)
}
func (s Message) Provide() (Provide, error) {
	if capnp.Struct(s).Uint16(0) != 10 {
		panic("Which() != provide")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Provide(p.Struct()), err
}

func (s Message) HasProvide() bool {
	if capnp.Struct(s).Uint16(0) != 10 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetProvide(v Provide) error {
	capnp.Struct(s).SetUint16(0, 10)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewProvide sets the provide field to a newly
// allocated Provide struct, preferring placement in s's segment.
func (s Message) NewProvide() (Provide, error) {
	capnp.Struct(s).SetUint16(0, 10)
	ss, err := NewProvide(capnp.Struct(s).Segment())
	if err != nil {
		return Provide{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Accept() (Accept, error) {
	if capnp.Struct(s).Uint16(0) != 11 {
		panic("Which() != accept")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Accept(p.Struct()), err
}

func (s Message) HasAccept() bool {
	if capnp.Struct(s).Uint16(0) != 11 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetAccept(v Accept) error {
	capnp.Struct(s).SetUint16(0, 11)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewAccept sets the accept field to a newly
// allocated Accept struct, preferring placement in s's segment.
func (s Message) NewAccept() (Accept, error) {
	capnp.Struct(s).SetUint16(0, 11)
	ss, err := NewAccept(capnp.Struct(s).Segment())
	if err != nil {
		return Accept{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Join() (Join, error) {
	if capnp.Struct(s).Uint16(0) != 12 {
		panic("Which() != join")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Join(p.Struct()), err
}

func (s Message) HasJoin() bool {
	if capnp.Struct(s).Uint16(0) != 12 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetJoin(v Join) error {
	capnp.Struct(s).SetUint16(0, 12)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewJoin sets the join field to a newly
// allocated Join struct, preferring placement in s's segment.
func (s Message) NewJoin() (Join, error) {
	capnp.Struct(s).SetUint16(0, 12)
	ss, err := NewJoin(capnp.Struct(s).Segment())
	if err != nil {
		return Join{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Message_List is a list of Message.
type Message_List = capnp.StructList[Message]

// NewMessage creates a new list of Message.
func NewMessage_List(s *capnp.Segment, sz int32) (Message_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Message](l), err
}

// Message_Future is a wrapper for a Message promised by a client call.
type Message_Future struct{ *capnp.Future }

func (f Message_Future) Struct() (Message, error) {
	p, err := f.Future.Ptr()
	return Message(p.Struct()), err
}
func (p Message_Future) Unimplemented() Message_Future {
	return Message_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Abort() Exception_Future {
	return Exception_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Bootstrap() Bootstrap_Future {
	return Bootstrap_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Call() Call_Future {
	return Call_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Return() Return_Future {
	return Return_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Finish() Finish_Future {
	return Finish_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Resolve() Resolve_Future {
	return Resolve_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Release() Release_Future {
	return Release_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Disembargo() Disembargo_Future {
	return Disembargo_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) ObsoleteSave() *capnp.Future {
	return p.Future.Field(0, nil)
}
func (p Message_Future) ObsoleteDelete() *capnp.Future {
	return p.Future.Field(0, nil)
}
func (p Message_Future) Provide() Provide_Future {
	return Provide_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Accept() Accept_Future {
	return Accept_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Join() Join_Future {
	return Join_Future{Future: p.Future.Field(0, nil)}
}

type Bootstrap capnp.Struct

// Bootstrap_TypeID is the unique identifier for the type Bootstrap.
const Bootstrap_TypeID = 0xe94ccf8031176ec4

func NewBootstrap(s *capnp.Segment) (Bootstrap, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Bootstrap(st), err
}

func NewRootBootstrap(s *capnp.Segment) (Bootstrap, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Bootstrap(st), err
}

func ReadRootBootstrap(msg *capnp.Message) (Bootstrap, error) {
	root, err := msg.Root()
	return Bootstrap(root.Struct()), err
}

func (s Bootstrap) String() string {
	str, _ := text.Marshal(0xe94ccf8031176ec4, capnp.Struct(s))
	return str
}

func (s Bootstrap) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Bootstrap) DecodeFromPtr(p capnp.Ptr) Bootstrap {
	return Bootstrap(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Bootstrap) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Bootstrap) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Bootstrap) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Bootstrap) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Bootstrap) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Bootstrap) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Bootstrap) DeprecatedObjectId() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s Bootstrap) HasDeprecatedObjectId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Bootstrap) SetDeprecatedObjectId(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}

// Bootstrap_List is a list of Bootstrap.
type Bootstrap_List = capnp.StructList[Bootstrap]

// NewBootstrap creates a new list of Bootstrap.
func NewBootstrap_List(s *capnp.Segment, sz int32) (Bootstrap_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Bootstrap](l), err
}

// Bootstrap_Future is a wrapper for a Bootstrap promised by a client call.
type Bootstrap_Future struct{ *capnp.Future }

func (f Bootstrap_Future) Struct() (Bootstrap, error) {
	p, err := f.Future.Ptr()
	return Bootstrap(p.Struct()), err
}
func (p Bootstrap_Future) DeprecatedObjectId() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Call capnp.Struct
type Call_sendResultsTo Call
type Call_sendResultsTo_Which uint16

const (
	Call_sendResultsTo_Which_caller     Call_sendResultsTo_Which = 0
	Call_sendResultsTo_Which_yourself   Call_sendResultsTo_Which = 1
	Call_sendResultsTo_Which_thirdParty Call_sendResultsTo_Which = 2
)

func (w Call_sendResultsTo_Which) String() string {
	const s = "calleryourselfthirdParty"
	switch w {
	case Call_sendResultsTo_Which_caller:
		return s[0:6]
	case Call_sendResultsTo_Which_yourself:
		return s[6:14]
	case Call_sendResultsTo_Which_thirdParty:
		return s[14:24]

	}
	return "Call_sendResultsTo_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Call_TypeID is the unique identifier for the type Call.
const Call_TypeID = 0x836a53ce789d4cd4

func NewCall(s *capnp.Segment) (Call, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return Call(st), err
}

func NewRootCall(s *capnp.Segment) (Call, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return Call(st), err
}

func ReadRootCall(msg *capnp.Message) (Call, error) {
	root, err := msg.Root()
	return Call(root.Struct()), err
}

func (s Call) String() string {
	str, _ := text.Marshal(0x836a53ce789d4cd4, capnp.Struct(s))
	return str
}

func (s Call) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Call) DecodeFromPtr(p capnp.Ptr) Call {
	return Call(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Call) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Call) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Call) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Call) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Call) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Call) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Call) Target() (MessageTarget, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return MessageTarget(p.Struct()), err
}

func (s Call) HasTarget() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Call) SetTarget(v MessageTarget) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewTarget sets the target field to a newly
// allocated MessageTarget struct, preferring placement in s's segment.
func (s Call) NewTarget() (MessageTarget, error) {
	ss, err := NewMessageTarget(capnp.Struct(s).Segment())
	if err != nil {
		return MessageTarget{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Call) InterfaceId() uint64 {
	return capnp.Struct(s).Uint64(8)
}

func (s Call) SetInterfaceId(v uint64) {
	capnp.Struct(s).SetUint64(8, v)
}

func (s Call) MethodId() uint16 {
	return capnp.Struct(s).Uint16(4)
}

func (s Call) SetMethodId(v uint16) {
	capnp.Struct(s).SetUint16(4, v)
}

func (s Call) AllowThirdPartyTailCall() bool {
	return capnp.Struct(s).Bit(128)
}

func (s Call) SetAllowThirdPartyTailCall(v bool) {
	capnp.Struct(s).SetBit(128, v)
}

func (s Call) NoPromisePipelining() bool {
	return capnp.Struct(s).Bit(129)
}

func (s Call) SetNoPromisePipelining(v bool) {
	capnp.Struct(s).SetBit(129, v)
}

func (s Call) OnlyPromisePipeline() bool {
	return capnp.Struct(s).Bit(130)
}

func (s Call) SetOnlyPromisePipeline(v bool) {
	capnp.Struct(s).SetBit(130, v)
}

func (s Call) Params() (Payload, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return Payload(p.Struct()), err
}

func (s Call) HasParams() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Call) SetParams(v Payload) error {
	return capnp.Struct(s).SetPtr(1, capnp.Struct(v).ToPtr())
}

// NewParams sets the params field to a newly
// allocated Payload struct, preferring placement in s's segment.
func (s Call) NewParams() (Payload, error) {
	ss, err := NewPayload(capnp.Struct(s).Segment())
	if err != nil {
		return Payload{}, err
	}
	err = capnp.Struct(s).SetPtr(1, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Call) SendResultsTo() Call_sendResultsTo { return Call_sendResultsTo(s) }

func (s Call_sendResultsTo) Which() Call_sendResultsTo_Which {
	return Call_sendResultsTo_Which(capnp.Struct(s).Uint16(6))
}
func (s Call_sendResultsTo) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Call_sendResultsTo) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Call_sendResultsTo) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Call_sendResultsTo) SetCaller() {
	capnp.Struct(s).SetUint16(6, 0)

}

func (s Call_sendResultsTo) SetYourself() {
	capnp.Struct(s).SetUint16(6, 1)

}

func (s Call_sendResultsTo) ThirdParty() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(6) != 2 {
		panic("Which() != thirdParty")
	}
	return capnp.Struct(s).Ptr(2)
}

func (s Call_sendResultsTo) HasThirdParty() bool {
	if capnp.Struct(s).Uint16(6) != 2 {
		return false
	}
	return capnp.Struct(s).HasPtr(2)
}

func (s Call_sendResultsTo) SetThirdParty(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(6, 2)
	return capnp.Struct(s).SetPtr(2, v)
}

// Call_List is a list of Call.
type Call_List = capnp.StructList[Call]

// NewCall creates a new list of Call.
func NewCall_List(s *capnp.Segment, sz int32) (Call_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3}, sz)
	return capnp.StructList[Call](l), err
}

// Call_Future is a wrapper for a Call promised by a client call.
type Call_Future struct{ *capnp.Future }

func (f Call_Future) Struct() (Call, error) {
	p, err := f.Future.Ptr()
	return Call(p.Struct()), err
}
func (p Call_Future) Target() MessageTarget_Future {
	return MessageTarget_Future{Future: p.Future.Field(0, nil)}
}
func (p Call_Future) Params() Payload_Future {
	return Payload_Future{Future: p.Future.Field(1, nil)}
}
func (p Call_Future) SendResultsTo() Call_sendResultsTo_Future {
	return Call_sendResultsTo_Future{p.Future}
}

// Call_sendResultsTo_Future is a wrapper for a Call_sendResultsTo promised by a client call.
type Call_sendResultsTo_Future struct{ *capnp.Future }

func (f Call_sendResultsTo_Future) Struct() (Call_sendResultsTo, error) {
	p, err := f.Future.Ptr()
	return Call_sendResultsTo(p.Struct()), err
}
func (p Call_sendResultsTo_Future) ThirdParty() *capnp.Future {
	return p.Future.Field(2, nil)
}

type Return capnp.Struct
type Return_Which uint16

const (
	Return_Which_results               Return_Which = 0
	Return_Which_exception             Return_Which = 1
	Return_Which_canceled              Return_Which = 2
	Return_Which_resultsSentElsewhere  Return_Which = 3
	Return_Which_takeFromOtherQuestion Return_Which = 4
	Return_Which_acceptFromThirdParty  Return_Which = 5
)

func (w Return_Which) String() string {
	const s = "resultsexceptioncanceledresultsSentElsewheretakeFromOtherQuestionacceptFromThirdParty"
	switch w {
	case Return_Which_results:
		return s[0:7]
	case Return_Which_exception:
		return s[7:16]
	case Return_Which_canceled:
		return s[16:24]
	case Return_Which_resultsSentElsewhere:
		return s[24:44]
	case Return_Which_takeFromOtherQuestion:
		return s[44:65]
	case Return_Which_acceptFromThirdParty:
		return s[65:85]

	}
	return "Return_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Return_TypeID is the unique identifier for the type Return.
const Return_TypeID = 0x9e19b28d3db3573a

func NewReturn(s *capnp.Segment) (Return, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Return(st), err
}

func NewRootReturn(s *capnp.Segment) (Return, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Return(st), err
}

func ReadRootReturn(msg *capnp.Message) (Return, error) {
	root, err := msg.Root()
	return Return(root.Struct()), err
}

func (s Return) String() string {
	str, _ := text.Marshal(0x9e19b28d3db3573a, capnp.Struct(s))
	return str
}

func (s Return) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Return) DecodeFromPtr(p capnp.Ptr) Return {
	return Return(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Return) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Return) Which() Return_Which {
	return Return_Which(capnp.Struct(s).Uint16(6))
}
func (s Return) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Return) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Return) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Return) AnswerId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Return) SetAnswerId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Return) ReleaseParamCaps() bool {
	return !capnp.Struct(s).Bit(32)
}

func (s Return) SetReleaseParamCaps(v bool) {
	capnp.Struct(s).SetBit(32, !v)
}

func (s Return) NoFinishNeeded() bool {
	return capnp.Struct(s).Bit(33)
}

func (s Return) SetNoFinishNeeded(v bool) {
	capnp.Struct(s).SetBit(33, v)
}

func (s Return) Results() (Payload, error) {
	if capnp.Struct(s).Uint16(6) != 0 {
		panic("Which() != results")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Payload(p.Struct()), err
}

func (s Return) HasResults() bool {
	if capnp.Struct(s).Uint16(6) != 0 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Return) SetResults(v Payload) error {
	capnp.Struct(s).SetUint16(6, 0)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResults sets the results field to a newly
// allocated Payload struct, preferring placement in s's segment.
func (s Return) NewResults() (Payload, error) {
	capnp.Struct(s).SetUint16(6, 0)
	ss, err := NewPayload(capnp.Struct(s).Segment())
	if err != nil {
		return Payload{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Return) Exception() (Exception, error) {
	if capnp.Struct(s).Uint16(6) != 1 {
		panic("Which() != exception")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Exception(p.Struct()), err
}

func (s Return) HasException() bool {
	if capnp.Struct(s).Uint16(6) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Return) SetException(v Exception) error {
	capnp.Struct(s).SetUint16(6, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewException sets the exception field to a newly
// allocated Exception struct, preferring placement in s's segment.
func (s Return) NewException() (Exception, error) {
	capnp.Struct(s).SetUint16(6, 1)
	ss, err := NewException(capnp.Struct(s).Segment())
	if err != nil {
		return Exception{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Return) SetCanceled() {
	capnp.Struct(s).SetUint16(6, 2)

}

func (s Return) SetResultsSentElsewhere() {
	capnp.Struct(s).SetUint16(6, 3)

}

func (s Return) TakeFromOtherQuestion() uint32 {
	if capnp.Struct(s).Uint16(6) != 4 {
		panic("Which() != takeFromOtherQuestion")
	}
	return capnp.Struct(s).Uint32(8)
}

func (s Return) SetTakeFromOtherQuestion(v uint32) {
	capnp.Struct(s).SetUint16(6, 4)
	capnp.Struct(s).SetUint32(8, v)
}

func (s Return) AcceptFromThirdParty() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(6) != 5 {
		panic("Which() != acceptFromThirdParty")
	}
	return capnp.Struct(s).Ptr(0)
}

func (s Return) HasAcceptFromThirdParty() bool {
	if capnp.Struct(s).Uint16(6) != 5 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Return) SetAcceptFromThirdParty(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(6, 5)
	return capnp.Struct(s).SetPtr(0, v)
}

// Return_List is a list of Return.
type Return_List = capnp.StructList[Return]

// NewReturn creates a new list of Return.
func NewReturn_List(s *capnp.Segment, sz int32) (Return_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1}, sz)
	return capnp.StructList[Return](l), err
}

// Return_Future is a wrapper for a Return promised by a client call.
type Return_Future struct{ *capnp.Future }

func (f Return_Future) Struct() (Return, error) {
	p, err := f.Future.Ptr()
	return Return(p.Struct()), err
}
func (p Return_Future) Results() Payload_Future {
	return Payload_Future{Future: p.Future.Field(0, nil)}
}
func (p Return_Future) Exception() Exception_Future {
	return Exception_Future{Future: p.Future.Field(0, nil)}
}
func (p Return_Future) AcceptFromThirdParty() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Finish capnp.Struct

// Finish_TypeID is the unique identifier for the type Finish.
const Finish_TypeID = 0xd37d2eb2c2f80e63

func NewFinish(s *capnp.Segment) (Finish, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Finish(st), err
}

func NewRootFinish(s *capnp.Segment) (Finish, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Finish(st), err
}

func ReadRootFinish(msg *capnp.Message) (Finish, error) {
	root, err := msg.Root()
	return Finish(root.Struct()), err
}

func (s Finish) String() string {
	str, _ := text.Marshal(0xd37d2eb2c2f80e63, capnp.Struct(s))
	return str
}

func (s Finish) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Finish) DecodeFromPtr(p capnp.Ptr) Finish {
	return Finish(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Finish) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Finish) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Finish) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Finish) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Finish) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Finish) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Finish) ReleaseResultCaps() bool {
	return !capnp.Struct(s).Bit(32)
}

func (s Finish) SetReleaseResultCaps(v bool) {
	capnp.Struct(s).SetBit(32, !v)
}

func (s Finish) RequireEarlyCancellationWorkaround() bool {
	return !capnp.Struct(s).Bit(33)
}

func (s Finish) SetRequireEarlyCancellationWorkaround(v bool) {
	capnp.Struct(s).SetBit(33, !v)
}

// Finish_List is a list of Finish.
type Finish_List = capnp.StructList[Finish]

// NewFinish creates a new list of Finish.
func NewFinish_List(s *capnp.Segment, sz int32) (Finish_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[Finish](l), err
}

// Finish_Future is a wrapper for a Finish promised by a client call.
type Finish_Future struct{ *capnp.Future }

func (f Finish_Future) Struct() (Finish, error) {
	p, err := f.Future.Ptr()
	return Finish(p.Struct()), err
}

type Resolve capnp.Struct
type Resolve_Which uint16

const (
	Resolve_Which_cap       Resolve_Which = 0
	Resolve_Which_exception Resolve_Which = 1
)

func (w Resolve_Which) String() string {
	const s = "capexception"
	switch w {
	case Resolve_Which_cap:
		return s[0:3]
	case Resolve_Which_exception:
		return s[3:12]

	}
	return "Resolve_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Resolve_TypeID is the unique identifier for the type Resolve.
const Resolve_TypeID = 0xbbc29655fa89086e

func NewResolve(s *capnp.Segment) (Resolve, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Resolve(st), err
}

func NewRootResolve(s *capnp.Segment) (Resolve, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Resolve(st), err
}

func ReadRootResolve(msg *capnp.Message) (Resolve, error) {
	root, err := msg.Root()
	return Resolve(root.Struct()), err
}

func (s Resolve) String() string {
	str, _ := text.Marshal(0xbbc29655fa89086e, capnp.Struct(s))
	return str
}

func (s Resolve) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Resolve) DecodeFromPtr(p capnp.Ptr) Resolve {
	return Resolve(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Resolve) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Resolve) Which() Resolve_Which {
	return Resolve_Which(capnp.Struct(s).Uint16(4))
}
func (s Resolve) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Resolve) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Resolve) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Resolve) PromiseId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Resolve) SetPromiseId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Resolve) Cap() (CapDescriptor, error) {
	if capnp.Struct(s).Uint16(4) != 0 {
		panic("Which() != cap")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return CapDescriptor(p.Struct()), err
}

func (s Resolve) HasCap() bool {
	if capnp.Struct(s).Uint16(4) != 0 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Resolve) SetCap(v CapDescriptor) error {
	capnp.Struct(s).SetUint16(4, 0)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewCap sets the cap field to a newly
// allocated CapDescriptor struct, preferring placement in s's segment.
func (s Resolve) NewCap() (CapDescriptor, error) {
	capnp.Struct(s).SetUint16(4, 0)
	ss, err := NewCapDescriptor(capnp.Struct(s).Segment())
	if err != nil {
		return CapDescriptor{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Resolve) Exception() (Exception, error) {
	if capnp.Struct(s).Uint16(4) != 1 {
		panic("Which() != exception")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Exception(p.Struct()), err
}

func (s Resolve) HasException() bool {
	if capnp.Struct(s).Uint16(4) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Resolve) SetException(v Exception) error {
	capnp.Struct(s).SetUint16(4, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewException sets the exception field to a newly
// allocated Exception struct, preferring placement in s's segment.
func (s Resolve) NewException() (Exception, error) {
	capnp.Struct(s).SetUint16(4, 1)
	ss, err := NewException(capnp.Struct(s).Segment())
	if err != nil {
		return Exception{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Resolve_List is a list of Resolve.
type Resolve_List = capnp.StructList[Resolve]

// NewResolve creates a new list of Resolve.
func NewResolve_List(s *capnp.Segment, sz int32) (Resolve_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Resolve](l), err
}

// Resolve_Future is a wrapper for a Resolve promised by a client call.
type Resolve_Future struct{ *capnp.Future }

func (f Resolve_Future) Struct() (Resolve, error) {
	p, err := f.Future.Ptr()
	return Resolve(p.Struct()), err
}
func (p Resolve_Future) Cap() CapDescriptor_Future {
	return CapDescriptor_Future{Future: p.Future.Field(0, nil)}
}
func (p Resolve_Future) Exception() Exception_Future {
	return Exception_Future{Future: p.Future.Field(0, nil)}
}

type Release capnp.Struct

// Release_TypeID is the unique identifier for the type Release.
const Release_TypeID = 0xad1a6c0d7dd07497

func NewRelease(s *capnp.Segment) (Release, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Release(st), err
}

func NewRootRelease(s *capnp.Segment) (Release, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Release(st), err
}

func ReadRootRelease(msg *capnp.Message) (Release, error) {
	root, err := msg.Root()
	return Release(root.Struct()), err
}

func (s Release) String() string {
	str, _ := text.Marshal(0xad1a6c0d7dd07497, capnp.Struct(s))
	return str
}

func (s Release) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Release) DecodeFromPtr(p capnp.Ptr) Release {
	return Release(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Release) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Release) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Release) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Release) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Release) Id() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Release) SetId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Release) ReferenceCount() uint32 {
	return capnp.Struct(s).Uint32(4)
}

func (s Release) SetReferenceCount(v uint32) {
	capnp.Struct(s).SetUint32(4, v)
}

// Release_List is a list of Release.
type Release_List = capnp.StructList[Release]

// NewRelease creates a new list of Release.
func NewRelease_List(s *capnp.Segment, sz int32) (Release_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[Release](l), err
}

// Release_Future is a wrapper for a Release promised by a client call.
type Release_Future struct{ *capnp.Future }

func (f Release_Future) Struct() (Release, error) {
	p, err := f.Future.Ptr()
	return Release(p.Struct()), err
}

type Disembargo capnp.Struct
type Disembargo_context Disembargo
type Disembargo_context_Which uint16

const (
	Disembargo_context_Which_senderLoopback   Disembargo_context_Which = 0
	Disembargo_context_Which_receiverLoopback Disembargo_context_Which = 1
	Disembargo_context_Which_accept           Disembargo_context_Which = 2
	Disembargo_context_Which_provide          Disembargo_context_Which = 3
)

func (w Disembargo_context_Which) String() string {
	const s = "senderLoopbackreceiverLoopbackacceptprovide"
	switch w {
	case Disembargo_context_Which_senderLoopback:
		return s[0:14]
	case Disembargo_context_Which_receiverLoopback:
		return s[14:30]
	case Disembargo_context_Which_accept:
		return s[30:36]
	case Disembargo_context_Which_provide:
		return s[36:43]

	}
	return "Disembargo_context_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Disembargo_TypeID is the unique identifier for the type Disembargo.
const Disembargo_TypeID = 0xf964368b0fbd3711

func NewDisembargo(s *capnp.Segment) (Disembargo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Disembargo(st), err
}

func NewRootDisembargo(s *capnp.Segment) (Disembargo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Disembargo(st), err
}

func ReadRootDisembargo(msg *capnp.Message) (Disembargo, error) {
	root, err := msg.Root()
	return Disembargo(root.Struct()), err
}

func (s Disembargo) String() string {
	str, _ := text.Marshal(0xf964368b0fbd3711, capnp.Struct(s))
	return str
}

func (s Disembargo) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Disembargo) DecodeFromPtr(p capnp.Ptr) Disembargo {
	return Disembargo(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Disembargo) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Disembargo) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Disembargo) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Disembargo) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Disembargo) Target() (MessageTarget, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return MessageTarget(p.Struct()), err
}

func (s Disembargo) HasTarget() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Disembargo) SetTarget(v MessageTarget) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewTarget sets the target field to a newly
// allocated MessageTarget struct, preferring placement in s's segment.
func (s Disembargo) NewTarget() (MessageTarget, error) {
	ss, err := NewMessageTarget(capnp.Struct(s).Segment())
	if err != nil {
		return MessageTarget{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Disembargo) Context() Disembargo_context { return Disembargo_context(s) }

func (s Disembargo_context) Which() Disembargo_context_Which {
	return Disembargo_context_Which(capnp.Struct(s).Uint16(4))
}
func (s Disembargo_context) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Disembargo_context) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Disembargo_context) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Disembargo_context) SenderLoopback() uint32 {
	if capnp.Struct(s).Uint16(4) != 0 {
		panic("Which() != senderLoopback")
	}
	return capnp.Struct(s).Uint32(0)
}

func (s Disembargo_context) SetSenderLoopback(v uint32) {
	capnp.Struct(s).SetUint16(4, 0)
	capnp.Struct(s).SetUint32(0, v)
}

func (s Disembargo_context) ReceiverLoopback() uint32 {
	if capnp.Struct(s).Uint16(4) != 1 {
		panic("Which() != receiverLoopback")
	}
	return capnp.Struct(s).Uint32(0)
}

func (s Disembargo_context) SetReceiverLoopback(v uint32) {
	capnp.Struct(s).SetUint16(4, 1)
	capnp.Struct(s).SetUint32(0, v)
}

func (s Disembargo_context) SetAccept() {
	capnp.Struct(s).SetUint16(4, 2)

}

func (s Disembargo_context) Provide() uint32 {
	if capnp.Struct(s).Uint16(4) != 3 {
		panic("Which() != provide")
	}
	return capnp.Struct(s).Uint32(0)
}

func (s Disembargo_context) SetProvide(v uint32) {
	capnp.Struct(s).SetUint16(4, 3)
	capnp.Struct(s).SetUint32(0, v)
}

// Disembargo_List is a list of Disembargo.
type Disembargo_List = capnp.StructList[Disembargo]

// NewDisembargo creates a new list of Disembargo.
func NewDisembargo_List(s *capnp.Segment, sz int32) (Disembargo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Disembargo](l), err
}

// Disembargo_Future is a wrapper for a Disembargo promised by a client call.
type Disembargo_Future struct{ *capnp.Future }

func (f Disembargo_Future) Struct() (Disembargo, error) {
	p, err := f.Future.Ptr()
	return Disembargo(p.Struct()), err
}
func (p Disembargo_Future) Target() MessageTarget_Future {
	return MessageTarget_Future{Future: p.Future.Field(0, nil)}
}
func (p Disembargo_Future) Context() Disembargo_context_Future {
	return Disembargo_context_Future{p.Future}
}

// Disembargo_context_Future is a wrapper for a Disembargo_context promised by a client call.
type Disembargo_context_Future struct{ *capnp.Future }

func (f Disembargo_context_Future) Struct() (Disembargo_context, error) {
	p, err := f.Future.Ptr()
	return Disembargo_context(p.Struct()), err
}

type Provide capnp.Struct

// Provide_TypeID is the unique identifier for the type Provide.
const Provide_TypeID = 0x9c6a046bfbc1ac5a

func NewProvide(s *capnp.Segment) (Provide, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Provide(st), err
}

func NewRootProvide(s *capnp.Segment) (Provide, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Provide(st), err
}

func ReadRootProvide(msg *capnp.Message) (Provide, error) {
	root, err := msg.Root()
	return Provide(root.Struct()), err
}

func (s Provide) String() string {
	str, _ := text.Marshal(0x9c6a046bfbc1ac5a, capnp.Struct(s))
	return str
}

func (s Provide) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Provide) DecodeFromPtr(p capnp.Ptr) Provide {
	return Provide(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Provide) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Provide) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Provide) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Provide) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Provide) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Provide) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Provide) Target() (MessageTarget, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return MessageTarget(p.Struct()), err
}

func (s Provide) HasTarget() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Provide) SetTarget(v MessageTarget) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewTarget sets the target field to a newly
// allocated MessageTarget struct, preferring placement in s's segment.
func (s Provide) NewTarget() (MessageTarget, error) {
	ss, err := NewMessageTarget(capnp.Struct(s).Segment())
	if err != nil {
		return MessageTarget{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Provide) Recipient() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(1)
}

func (s Provide) HasRecipient() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Provide) SetRecipient(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(1, v)
}

// Provide_List is a list of Provide.
type Provide_List = capnp.StructList[Provide]

// NewProvide creates a new list of Provide.
func NewProvide_List(s *capnp.Segment, sz int32) (Provide_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Provide](l), err
}

// Provide_Future is a wrapper for a Provide promised by a client call.
type Provide_Future struct{ *capnp.Future }

func (f Provide_Future) Struct() (Provide, error) {
	p, err := f.Future.Ptr()
	return Provide(p.Struct()), err
}
func (p Provide_Future) Target() MessageTarget_Future {
	return MessageTarget_Future{Future: p.Future.Field(0, nil)}
}
func (p Provide_Future) Recipient() *capnp.Future {
	return p.Future.Field(1, nil)
}

type Accept capnp.Struct

// Accept_TypeID is the unique identifier for the type Accept.
const Accept_TypeID = 0xd4c9b56290554016

func NewAccept(s *capnp.Segment) (Accept, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Accept(st), err
}

func NewRootAccept(s *capnp.Segment) (Accept, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Accept(st), err
}

func ReadRootAccept(msg *capnp.Message) (Accept, error) {
	root, err := msg.Root()
	return Accept(root.Struct()), err
}

func (s Accept) String() string {
	str, _ := text.Marshal(0xd4c9b56290554016, capnp.Struct(s))
	return str
}

func (s Accept) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Accept) DecodeFromPtr(p capnp.Ptr) Accept {
	return Accept(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Accept) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Accept) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Accept) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Accept) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Accept) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Accept) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Accept) Provision() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s Accept) HasProvision() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Accept) SetProvision(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}
func (s Accept) Embargo() bool {
	return capnp.Struct(s).Bit(32)
}

func (s Accept) SetEmbargo(v bool) {
	capnp.Struct(s).SetBit(32, v)
}

// Accept_List is a list of Accept.
type Accept_List = capnp.StructList[Accept]

// NewAccept creates a new list of Accept.
func NewAccept_List(s *capnp.Segment, sz int32) (Accept_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Accept](l), err
}

// Accept_Future is a wrapper for a Accept promised by a client call.
type Accept_Future struct{ *capnp.Future }

func (f Accept_Future) Struct() (Accept, error) {
	p, err := f.Future.Ptr()
	return Accept(p.Struct()), err
}
func (p Accept_Future) Provision() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Join capnp.Struct

// Join_TypeID is the unique identifier for the type Join.
const Join_TypeID = 0xfbe1980490e001af

func NewJoin(s *capnp.Segment) (Join, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Join(st), err
}

func NewRootJoin(s *capnp.Segment) (Join, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Join(st), err
}

func ReadRootJoin(msg *capnp.Message) (Join, error) {
	root, err := msg.Root()
	return Join(root.Struct()), err
}

func (s Join) String() string {
	str, _ := text.Marshal(0xfbe1980490e001af, capnp.Struct(s))
	return str
}

func (s Join) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Join) DecodeFromPtr(p capnp.Ptr) Join {
	return Join(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Join) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Join) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Join) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Join) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Join) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Join) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Join) Target() (MessageTarget, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return MessageTarget(p.Struct()), err
}

func (s Join) HasTarget() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Join) SetTarget(v MessageTarget) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewTarget sets the target field to a newly
// allocated MessageTarget struct, preferring placement in s's segment.
func (s Join) NewTarget() (MessageTarget, error) {
	ss, err := NewMessageTarget(capnp.Struct(s).Segment())
	if err != nil {
		return MessageTarget{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Join) KeyPart() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(1)
}

func (s Join) HasKeyPart() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Join) SetKeyPart(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(1, v)
}

// Join_List is a list of Join.
type Join_List = capnp.StructList[Join]

// NewJoin creates a new list of Join.
func NewJoin_List(s *capnp.Segment, sz int32) (Join_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Join](l), err
}

// Join_Future is a wrapper for a Join promised by a client call.
type Join_Future struct{ *capnp.Future }

func (f Join_Future) Struct() (Join, error) {
	p, err := f.Future.Ptr()
	return Join(p.Struct()), err
}
func (p Join_Future) Target() MessageTarget_Future {
	return MessageTarget_Future{Future: p.Future.Field(0, nil)}
}
func (p Join_Future) KeyPart() *capnp.Future {
	return p.Future.Field(1, nil)
}

type MessageTarget capnp.Struct
type MessageTarget_Which uint16

const (
	MessageTarget_Which_importedCap    MessageTarget_Which = 0
	MessageTarget_Which_promisedAnswer MessageTarget_Which = 1
)

func (w MessageTarget_Which) String() string {
	const s = "importedCappromisedAnswer"
	switch w {
	case MessageTarget_Which_importedCap:
		return s[0:11]
	case MessageTarget_Which_promisedAnswer:
		return s[11:25]

	}
	return "MessageTarget_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// MessageTarget_TypeID is the unique identifier for the type MessageTarget.
const MessageTarget_TypeID = 0x95bc14545813fbc1

func NewMessageTarget(s *capnp.Segment) (MessageTarget, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return MessageTarget(st), err
}

func NewRootMessageTarget(s *capnp.Segment) (MessageTarget, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return MessageTarget(st), err
}

func ReadRootMessageTarget(msg *capnp.Message) (MessageTarget, error) {
	root, err := msg.Root()
	return MessageTarget(root.Struct()), err
}

func (s MessageTarget) String() string {
	str, _ := text.Marshal(0x95bc14545813fbc1, capnp.Struct(s))
	return str
}

func (s MessageTarget) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (MessageTarget) DecodeFromPtr(p capnp.Ptr) MessageTarget {
	return MessageTarget(capnp.Struct{}.DecodeFromPtr(p))
}

func (s MessageTarget) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s MessageTarget) Which() MessageTarget_Which {
	return MessageTarget_Which(capnp.Struct(s).Uint16(4))
}
func (s MessageTarget) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s MessageTarget) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s MessageTarget) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s MessageTarget) ImportedCap() uint32 {
	if capnp.Struct(s).Uint16(4) != 0 {
		panic("Which() != importedCap")
	}
	return capnp.Struct(s).Uint32(0)
}

func (s MessageTarget) SetImportedCap(v uint32) {
	capnp.Struct(s).SetUint16(4, 0)
	capnp.Struct(s).SetUint32(0, v)
}

func (s MessageTarget) PromisedAnswer() (PromisedAnswer, error) {
	if capnp.Struct(s).Uint16(4) != 1 {
		panic("Which() != promisedAnswer")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return PromisedAnswer(p.Struct()), err
}

func (s MessageTarget) HasPromisedAnswer() bool {
	if capnp.Struct(s).Uint16(4) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s MessageTarget) SetPromisedAnswer(v PromisedAnswer) error {
	capnp.Struct(s).SetUint16(4, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewPromisedAnswer sets the promisedAnswer field to a newly
// allocated PromisedAnswer struct, preferring placement in s's segment.
func (s MessageTarget) NewPromisedAnswer() (PromisedAnswer, error) {
	capnp.Struct(s).SetUint16(4, 1)
	ss, err := NewPromisedAnswer(capnp.Struct(s).Segment())
	if err != nil {
		return PromisedAnswer{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// MessageTarget_List is a list of MessageTarget.
type MessageTarget_List = capnp.StructList[MessageTarget]

// NewMessageTarget creates a new list of MessageTarget.
func NewMessageTarget_List(s *capnp.Segment, sz int32) (MessageTarget_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[MessageTarget](l), err
}

// MessageTarget_Future is a wrapper for a MessageTarget promised by a client call.
type MessageTarget_Future struct{ *capnp.Future }

func (f MessageTarget_Future) Struct() (MessageTarget, error) {
	p, err := f.Future.Ptr()
	return MessageTarget(p.Struct()), err
}
func (p MessageTarget_Future) PromisedAnswer() PromisedAnswer_Future {
	return PromisedAnswer_Future{Future: p.Future.Field(0, nil)}
}

type Payload capnp.Struct

// Payload_TypeID is the unique identifier for the type Payload.
const Payload_TypeID = 0x9a0e61223d96743b

func NewPayload(s *capnp.Segment) (Payload, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Payload(st), err
}

func NewRootPayload(s *capnp.Segment) (Payload, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Payload(st), err
}

func ReadRootPayload(msg *capnp.Message) (Payload, error) {
	root, err := msg.Root()
	return Payload(root.Struct()), err
}

func (s Payload) String() string {
	str, _ := text.Marshal(0x9a0e61223d96743b, capnp.Struct(s))
	return str
}

func (s Payload) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Payload) DecodeFromPtr(p capnp.Ptr) Payload {
	return Payload(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Payload) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Payload) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Payload) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Payload) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Payload) Content() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s Payload) HasContent() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Payload) SetContent(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}
func (s Payload) CapTable() (CapDescriptor_List, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return CapDescriptor_List(p.List()), err
}

func (s Payload) HasCapTable() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Payload) SetCapTable(v CapDescriptor_List) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewCapTable sets the capTable field to a newly
// allocated CapDescriptor_List, preferring placement in s's segment.
func (s Payload) NewCapTable(n int32) (CapDescriptor_List, error) {
	l, err := NewCapDescriptor_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return CapDescriptor_List{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}

// Payload_List is a list of Payload.
type Payload_List = capnp.StructList[Payload]

// NewPayload creates a new list of Payload.
func NewPayload_List(s *capnp.Segment, sz int32) (Payload_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return capnp.StructList[Payload](l), err
}

// Payload_Future is a wrapper for a Payload promised by a client call.
type Payload_Future struct{ *capnp.Future }

func (f Payload_Future) Struct() (Payload, error) {
	p, err := f.Future.Ptr()
	return Payload(p.Struct()), err
}
func (p Payload_Future) Content() *capnp.Future {
	return p.Future.Field(0, nil)
}

type CapDescriptor capnp.Struct
type CapDescriptor_Which uint16

const (
	CapDescriptor_Which_none             CapDescriptor_Which = 0
	CapDescriptor_Which_senderHosted     CapDescriptor_Which = 1
	CapDescriptor_Which_senderPromise    CapDescriptor_Which = 2
	CapDescriptor_Which_receiverHosted   CapDescriptor_Which = 3
	CapDescriptor_Which_receiverAnswer   CapDescriptor_Which = 4
	CapDescriptor_Which_thirdPartyHosted CapDescriptor_Which = 5
)

func (w CapDescriptor_Which) String() string {
	const s = "nonesenderHostedsenderPromisereceiverHostedreceiverAnswerthirdPartyHosted"
	switch w {
	case CapDescriptor_Which_none:
		return s[0:4]
	case CapDescriptor_Which_senderHosted:
		return s[4:16]
	case CapDescriptor_Which_senderPromise:
		return s[16:29]
	case CapDescriptor_Which_receiverHosted:
		return s[29:43]
	case CapDescriptor_Which_receiverAnswer:
		return s[43:57]
	case CapDescriptor_Which_thirdPartyHosted:
		return s[57:73]

	}
	return "CapDescriptor_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// CapDescriptor_TypeID is the unique identifier for the type CapDescriptor.
const CapDescriptor_TypeID = 0x8523ddc40b86b8b0

func NewCapDescriptor(s *capnp.Segment) (CapDescriptor, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return CapDescriptor(st), err
}

func NewRootCapDescriptor(s *capnp.Segment) (CapDescriptor, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return CapDescriptor(st), err
}

func ReadRootCapDescriptor(msg *capnp.Message) (CapDescriptor, error) {
	root, err := msg.Root()
	return CapDescriptor(root.Struct()), err
}

func (s CapDescriptor) String() string {
	str, _ := text.Marshal(0x8523ddc40b86b8b0, capnp.Struct(s))
	return str
}

func (s CapDescriptor) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (CapDescriptor) DecodeFromPtr(p capnp.Ptr) CapDescriptor {
	return CapDescriptor(capnp.Struct{}.DecodeFromPtr(p))
}

func (s CapDescriptor) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s CapDescriptor) Which() CapDescriptor_Which {
	return CapDescriptor_Which(capnp.Struct(s).Uint16(0))
}
func (s CapDescriptor) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s CapDescriptor) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s CapDescriptor) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s CapDescriptor) SetNone() {
	capnp.Struct(s).SetUint16(0, 0)

}

func (s CapDescriptor) SenderHosted() uint32 {
	if capnp.Struct(s).Uint16(0) != 1 {
		panic("Which() != senderHosted")
	}
	return capnp.Struct(s).Uint32(4)
}

func (s CapDescriptor) SetSenderHosted(v uint32) {
	capnp.Struct(s).SetUint16(0, 1)
	capnp.Struct(s).SetUint32(4, v)
}

func (s CapDescriptor) SenderPromise() uint32 {
	if capnp.Struct(s).Uint16(0) != 2 {
		panic("Which() != senderPromise")
	}
	return capnp.Struct(s).Uint32(4)
}

func (s CapDescriptor) SetSenderPromise(v uint32) {
	capnp.Struct(s).SetUint16(0, 2)
	capnp.Struct(s).SetUint32(4, v)
}

func (s CapDescriptor) ReceiverHosted() uint32 {
	if capnp.Struct(s).Uint16(0) != 3 {
		panic("Which() != receiverHosted")
	}
	return capnp.Struct(s).Uint32(4)
}

func (s CapDescriptor) SetReceiverHosted(v uint32) {
	capnp.Struct(s).SetUint16(0, 3)
	capnp.Struct(s).SetUint32(4, v)
}

func (s CapDescriptor) ReceiverAnswer() (PromisedAnswer, error) {
	if capnp.Struct(s).Uint16(0) != 4 {
		panic("Which() != receiverAnswer")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return PromisedAnswer(p.Struct()), err
}

func (s CapDescriptor) HasReceiverAnswer() bool {
	if capnp.Struct(s).Uint16(0) != 4 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s CapDescriptor) SetReceiverAnswer(v PromisedAnswer) error {
	capnp.Struct(s).SetUint16(0, 4)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewReceiverAnswer sets the receiverAnswer field to a newly
// allocated PromisedAnswer struct, preferring placement in s's segment.
func (s CapDescriptor) NewReceiverAnswer() (PromisedAnswer, error) {
	capnp.Struct(s).SetUint16(0, 4)
	ss, err := NewPromisedAnswer(capnp.Struct(s).Segment())
	if err != nil {
		return PromisedAnswer{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s CapDescriptor) ThirdPartyHosted() (ThirdPartyCapDescriptor, error) {
	if capnp.Struct(s).Uint16(0) != 5 {
		panic("Which() != thirdPartyHosted")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return ThirdPartyCapDescriptor(p.Struct()), err
}

func (s CapDescriptor) HasThirdPartyHosted() bool {
	if capnp.Struct(s).Uint16(0) != 5 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s CapDescriptor) SetThirdPartyHosted(v ThirdPartyCapDescriptor) error {
	capnp.Struct(s).SetUint16(0, 5)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewThirdPartyHosted sets the thirdPartyHosted field to a newly
// allocated ThirdPartyCapDescriptor struct, preferring placement in s's segment.
func (s CapDescriptor) NewThirdPartyHosted() (ThirdPartyCapDescriptor, error) {
	capnp.Struct(s).SetUint16(0, 5)
	ss, err := NewThirdPartyCapDescriptor(capnp.Struct(s).Segment())
	if err != nil {
		return ThirdPartyCapDescriptor{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s CapDescriptor) AttachedFd() uint8 {
	return capnp.Struct(s).Uint8(2) ^ 255
}

func (s CapDescriptor) SetAttachedFd(v uint8) {
	capnp.Struct(s).SetUint8(2, v^255)
}

// CapDescriptor_List is a list of CapDescriptor.
type CapDescriptor_List = capnp.StructList[CapDescriptor]

// NewCapDescriptor creates a new list of CapDescriptor.
func NewCapDescriptor_List(s *capnp.Segment, sz int32) (CapDescriptor_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[CapDescriptor](l), err
}

// CapDescriptor_Future is a wrapper for a CapDescriptor promised by a client call.
type CapDescriptor_Future struct{ *capnp.Future }

func (f CapDescriptor_Future) Struct() (CapDescriptor, error) {
	p, err := f.Future.Ptr()
	return CapDescriptor(p.Struct()), err
}
func (p CapDescriptor_Future) ReceiverAnswer() PromisedAnswer_Future {
	return PromisedAnswer_Future{Future: p.Future.Field(0, nil)}
}
func (p CapDescriptor_Future) ThirdPartyHosted() ThirdPartyCapDescriptor_Future {
	return ThirdPartyCapDescriptor_Future{Future: p.Future.Field(0, nil)}
}

type PromisedAnswer capnp.Struct

// PromisedAnswer_TypeID is the unique identifier for the type PromisedAnswer.
const PromisedAnswer_TypeID = 0xd800b1d6cd6f1ca0

func NewPromisedAnswer(s *capnp.Segment) (PromisedAnswer, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return PromisedAnswer(st), err
}

func NewRootPromisedAnswer(s *capnp.Segment) (PromisedAnswer, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return PromisedAnswer(st), err
}

func ReadRootPromisedAnswer(msg *capnp.Message) (PromisedAnswer, error) {
	root, err := msg.Root()
	return PromisedAnswer(root.Struct()), err
}

func (s PromisedAnswer) String() string {
	str, _ := text.Marshal(0xd800b1d6cd6f1ca0, capnp.Struct(s))
	return str
}

func (s PromisedAnswer) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (PromisedAnswer) DecodeFromPtr(p capnp.Ptr) PromisedAnswer {
	return PromisedAnswer(capnp.Struct{}.DecodeFromPtr(p))
}

func (s PromisedAnswer) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s PromisedAnswer) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s PromisedAnswer) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s PromisedAnswer) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s PromisedAnswer) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s PromisedAnswer) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s PromisedAnswer) Transform() (PromisedAnswer_Op_List, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return PromisedAnswer_Op_List(p.List()), err
}

func (s PromisedAnswer) HasTransform() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s PromisedAnswer) SetTransform(v PromisedAnswer_Op_List) error {
	return capnp.Struct(s).SetPtr(0, v.ToPtr())
}

// NewTransform sets the transform field to a newly
// allocated PromisedAnswer_Op_List, preferring placement in s's segment.
func (s PromisedAnswer) NewTransform(n int32) (PromisedAnswer_Op_List, error) {
	l, err := NewPromisedAnswer_Op_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return PromisedAnswer_Op_List{}, err
	}
	err = capnp.Struct(s).SetPtr(0, l.ToPtr())
	return l, err
}

// PromisedAnswer_List is a list of PromisedAnswer.
type PromisedAnswer_List = capnp.StructList[PromisedAnswer]

// NewPromisedAnswer creates a new list of PromisedAnswer.
func NewPromisedAnswer_List(s *capnp.Segment, sz int32) (PromisedAnswer_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[PromisedAnswer](l), err
}

// PromisedAnswer_Future is a wrapper for a PromisedAnswer promised by a client call.
type PromisedAnswer_Future struct{ *capnp.Future }

func (f PromisedAnswer_Future) Struct() (PromisedAnswer, error) {
	p, err := f.Future.Ptr()
	return PromisedAnswer(p.Struct()), err
}

type PromisedAnswer_Op capnp.Struct
type PromisedAnswer_Op_Which uint16

const (
	PromisedAnswer_Op_Which_noop            PromisedAnswer_Op_Which = 0
	PromisedAnswer_Op_Which_getPointerField PromisedAnswer_Op_Which = 1
)

func (w PromisedAnswer_Op_Which) String() string {
	const s = "noopgetPointerField"
	switch w {
	case PromisedAnswer_Op_Which_noop:
		return s[0:4]
	case PromisedAnswer_Op_Which_getPointerField:
		return s[4:19]

	}
	return "PromisedAnswer_Op_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// PromisedAnswer_Op_TypeID is the unique identifier for the type PromisedAnswer_Op.
const PromisedAnswer_Op_TypeID = 0xf316944415569081

func NewPromisedAnswer_Op(s *capnp.Segment) (PromisedAnswer_Op, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return PromisedAnswer_Op(st), err
}

func NewRootPromisedAnswer_Op(s *capnp.Segment) (PromisedAnswer_Op, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return PromisedAnswer_Op(st), err
}

func ReadRootPromisedAnswer_Op(msg *capnp.Message) (PromisedAnswer_Op, error) {
	root, err := msg.Root()
	return PromisedAnswer_Op(root.Struct()), err
}

func (s PromisedAnswer_Op) String() string {
	str, _ := text.Marshal(0xf316944415569081, capnp.Struct(s))
	return str
}

func (s PromisedAnswer_Op) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (PromisedAnswer_Op) DecodeFromPtr(p capnp.Ptr) PromisedAnswer_Op {
	return PromisedAnswer_Op(capnp.Struct{}.DecodeFromPtr(p))
}

func (s PromisedAnswer_Op) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s PromisedAnswer_Op) Which() PromisedAnswer_Op_Which {
	return PromisedAnswer_Op_Which(capnp.Struct(s).Uint16(0))
}
func (s PromisedAnswer_Op) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s PromisedAnswer_Op) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s PromisedAnswer_Op) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s PromisedAnswer_Op) SetNoop() {
	capnp.Struct(s).SetUint16(0, 0)

}

func (s PromisedAnswer_Op) GetPointerField() uint16 {
	if capnp.Struct(s).Uint16(0) != 1 {
		panic("Which() != getPointerField")
	}
	return capnp.Struct(s).Uint16(2)
}

func (s PromisedAnswer_Op) SetGetPointerField(v uint16) {
	capnp.Struct(s).SetUint16(0, 1)
	capnp.Struct(s).SetUint16(2, v)
}

// PromisedAnswer_Op_List is a list of PromisedAnswer_Op.
type PromisedAnswer_Op_List = capnp.StructList[PromisedAnswer_Op]

// NewPromisedAnswer_Op creates a new list of PromisedAnswer_Op.
func NewPromisedAnswer_Op_List(s *capnp.Segment, sz int32) (PromisedAnswer_Op_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[PromisedAnswer_Op](l), err
}

// PromisedAnswer_Op_Future is a wrapper for a PromisedAnswer_Op promised by a client call.
type PromisedAnswer_Op_Future struct{ *capnp.Future }

func (f PromisedAnswer_Op_Future) Struct() (PromisedAnswer_Op, error) {
	p, err := f.Future.Ptr()
	return PromisedAnswer_Op(p.Struct()), err
}

type ThirdPartyCapDescriptor capnp.Struct

// ThirdPartyCapDescriptor_TypeID is the unique identifier for the type ThirdPartyCapDescriptor.
const ThirdPartyCapDescriptor_TypeID = 0xd37007fde1f0027d

func NewThirdPartyCapDescriptor(s *capnp.Segment) (ThirdPartyCapDescriptor, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ThirdPartyCapDescriptor(st), err
}

func NewRootThirdPartyCapDescriptor(s *capnp.Segment) (ThirdPartyCapDescriptor, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ThirdPartyCapDescriptor(st), err
}

func ReadRootThirdPartyCapDescriptor(msg *capnp.Message) (ThirdPartyCapDescriptor, error) {
	root, err := msg.Root()
	return ThirdPartyCapDescriptor(root.Struct()), err
}

func (s ThirdPartyCapDescriptor) String() string {
	str, _ := text.Marshal(0xd37007fde1f0027d, capnp.Struct(s))
	return str
}

func (s ThirdPartyCapDescriptor) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (ThirdPartyCapDescriptor) DecodeFromPtr(p capnp.Ptr) ThirdPartyCapDescriptor {
	return ThirdPartyCapDescriptor(capnp.Struct{}.DecodeFromPtr(p))
}

func (s ThirdPartyCapDescriptor) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s ThirdPartyCapDescriptor) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s ThirdPartyCapDescriptor) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s ThirdPartyCapDescriptor) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s ThirdPartyCapDescriptor) Id() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s ThirdPartyCapDescriptor) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s ThirdPartyCapDescriptor) SetId(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}
func (s ThirdPartyCapDescriptor) VineId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s ThirdPartyCapDescriptor) SetVineId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

// ThirdPartyCapDescriptor_List is a list of ThirdPartyCapDescriptor.
type ThirdPartyCapDescriptor_List = capnp.StructList[ThirdPartyCapDescriptor]

// NewThirdPartyCapDescriptor creates a new list of ThirdPartyCapDescriptor.
func NewThirdPartyCapDescriptor_List(s *capnp.Segment, sz int32) (ThirdPartyCapDescriptor_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[ThirdPartyCapDescriptor](l), err
}

// ThirdPartyCapDescriptor_Future is a wrapper for a ThirdPartyCapDescriptor promised by a client call.
type ThirdPartyCapDescriptor_Future struct{ *capnp.Future }

func (f ThirdPartyCapDescriptor_Future) Struct() (ThirdPartyCapDescriptor, error) {
	p, err := f.Future.Ptr()
	return ThirdPartyCapDescriptor(p.Struct()), err
}
func (p ThirdPartyCapDescriptor_Future) Id() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Exception capnp.Struct

// Exception_TypeID is the unique identifier for the type Exception.
const Exception_TypeID = 0xd625b7063acf691a

func NewException(s *capnp.Segment) (Exception, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Exception(st), err
}

func NewRootException(s *capnp.Segment) (Exception, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Exception(st), err
}

func ReadRootException(msg *capnp.Message) (Exception, error) {
	root, err := msg.Root()
	return Exception(root.Struct()), err
}

func (s Exception) String() string {
	str, _ := text.Marshal(0xd625b7063acf691a, capnp.Struct(s))
	return str
}

func (s Exception) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Exception) DecodeFromPtr(p capnp.Ptr) Exception {
	return Exception(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Exception) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Exception) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Exception) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Exception) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Exception) Reason() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Exception) HasReason() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Exception) ReasonBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Exception) SetReason(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Exception) Type() Exception_Type {
	return Exception_Type(capnp.Struct(s).Uint16(4))
}

func (s Exception) SetType(v Exception_Type) {
	capnp.Struct(s).SetUint16(4, uint16(v))
}

func (s Exception) ObsoleteIsCallersFault() bool {
	return capnp.Struct(s).Bit(0)
}

func (s Exception) SetObsoleteIsCallersFault(v bool) {
	capnp.Struct(s).SetBit(0, v)
}

func (s Exception) ObsoleteDurability() uint16 {
	return capnp.Struct(s).Uint16(2)
}

func (s Exception) SetObsoleteDurability(v uint16) {
	capnp.Struct(s).SetUint16(2, v)
}

func (s Exception) Trace() (string, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.Text(), err
}

func (s Exception) HasTrace() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Exception) TraceBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.TextBytes(), err
}

func (s Exception) SetTrace(v string) error {
	return capnp.Struct(s).SetText(1, v)
}

// Exception_List is a list of Exception.
type Exception_List = capnp.StructList[Exception]

// NewException creates a new list of Exception.
func NewException_List(s *capnp.Segment, sz int32) (Exception_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Exception](l), err
}

// Exception_Future is a wrapper for a Exception promised by a client call.
type Exception_Future struct{ *capnp.Future }

func (f Exception_Future) Struct() (Exception, error) {
	p, err := f.Future.Ptr()
	return Exception(p.Struct()), err
}

type Exception_Type uint16

// Exception_Type_TypeID is the unique identifier for the type Exception_Type.
const Exception_Type_TypeID = 0xb28c96e23f4cbd58

// Values of Exception_Type.
const (
	Exception_Type_failed        Exception_Type = 0
	Exception_Type_overloaded    Exception_Type = 1
	Exception_Type_disconnected  Exception_Type = 2
	Exception_Type_unimplemented Exception_Type = 3
)

// String returns the enum's constant name.
func (c Exception_Type) String() string {
	switch c {
	case Exception_Type_failed:
		return "failed"
	case Exception_Type_overloaded:
		return "overloaded"
	case Exception_Type_disconnected:
		return "disconnected"
	case Exception_Type_unimplemented:
		return "unimplemented"

	default:
		return ""
	}
}

// Exception_TypeFromString returns the enum value with a name,
// or the zero value if there's no such value.
func Exception_TypeFromString(c string) Exception_Type {
	switch c {
	case "failed":
		return Exception_Type_failed
	case "overloaded":
		return Exception_Type_overloaded
	case "disconnected":
		return Exception_Type_disconnected
	case "unimplemented":
		return Exception_Type_unimplemented

	default:
		return 0
	}
}

type Exception_Type_List = capnp.EnumList[Exception_Type]

func NewException_Type_List(s *capnp.Segment, sz int32) (Exception_Type_List, error) {
	return capnp.NewEnumList[Exception_Type](s, sz)
}

const schema_b312981b2552a250 = "x\xda\x9cX}l\x1c\xd5\xb5?\xe7\xde\xf5\xae\x9dx" +
	"\xb3;\x99\x89\x03yD&\xbc \xbdD/Q\x02\xe8" +
	"=p\x896\x1fv\x14GN\xe3\xebu\x0a\xa4\xad\xda" +
	"\xf1\xee\x8d=\xcexf\x98\x1d'\xde\x88(\x09M*" +
	"\x92b\xd5D@\x13DZ\x88\xa8T(\x15!\x80\x80" +
	"6\x08\x88\xf8\x03P[\xa8\xf8P\xa9\x88ZPQ\xa1" +
	"*\x12\x94\x86&\xe4c\xaa33;\xb3\xb1\xd7E\xf4" +
	"/\x8f\xee\xef\xec\xbd\xe7\x9e\x8f\xdf\xef\\/{>\xbd" +
	"2\xb5<\xbb\xb1\x05\x980\x9b\xd2\xfe\x9b=G\xc6~" +
	"[\x1c\xfe\x1e\x88\x19\xc8\xfd\xde\xa3}W\xff\xd7\xa1\xd9" +
	"O@\x13\xcf\x00\xa8\xe3\xa9\x1d\xea]\xa9\x0c\xc0\xb5\xe3" +
	")\x1f\x01\xfdc\xcf|\x7f\xe6K\xa7\xfe{\x1fYc" +
	"b\xdd\x85\x994\x80z8}R}0M\xe6G\xd2" +
	"?$\xf3k\x8e\x8d\xefn\xff\xc9\xd3wM5\x9f\x05" +
	"\xa0\xaej>\xa8v7\x93yW\xf3\\\x0e\xe8\xbfx" +
	"N\xbd\xb9_;q\xcfTs\x86L\xdd7\xf3\xa4:" +
	">\x93\xdc\xda?s;\xa0\xff5\xef\xde\x15W\xe9\xb3" +
	"\xee\x03eF\x9dq\x13#\x8b\x8fg\x1eTO\x07\xb6" +
	"\x9f\x06\xb6\x9b\x1f}\xf1\xdc\xd6\xd4\xf0\xfd\x93v\x0e\x8d" +
	"\xf5\xd6\x83\xaa\xd1J_\xb2\xf51@\xbf\xe3\xa6'V" +
	"\x8c\x1f\xbf\xfc\xc7d\xcc.\xbd$r\xb5){@\xcd" +
	"f\xc9\xeb\x96l\x10\x93\x1fy\xaf\xef\xcc\x9a\xf3~1" +
	"io\x0a\x9bzC\xee\xa0\xba*G_+r\xe4\xc7" +
	"\xcd\xcf\xf5\x14\xde\xbf\xf7\xce\xe3\xa0h\xcc\x9fg\xbc\xd6" +
	"\x91~\xfa\xea\xb7\x01P=\x92{U}80\xfci" +
	"n\x10\xd0\xb7\x9a\xf7\x7f\xb1\xe9\xde\x93\xbfj\x1c\x8a\xb7" +
	"r\x07\xd5S\x81\xf5;9\xf2x'\xfb\xe4\xbd\x0b\x19" +
	"\xe7\x8d\xc9\xd7Cr\xb3\x9a\x9f\x8d\xea\xfe<Y\xef\xcb" +
	"\x93\x13\xa5YgN\x1e_\xba\xf3\x8dF\x0e\xbf\x97?" +
	"\xa0~\x14\xd8~\x90\xa7\x9d\xdbVn\x9a\x18x\xea\x95" +
	"7\x1b\xed\xac\x1eV\x0e\xa8\x0f*\xf4uD!\xe3\x0d" +
	"\xa7\xbe)\xff\xf8\xe4\xc0[ \xe6 \xfa\xca\xff?\x97" +
	"\xfb\xc1\xff\x95\xcf\xc2&\xcc`\x0a\x99\xbab\xf6_\x01" +
	"\xd5U\xb3\xff\x02\x98\xdc\xbdQB\x16\xa8G\xd5E\xea" +
	"\\\x80k\x97\xab\xed\x08\xf8\xfc\x03W\xd8\xbfy\xfb\xf1" +
	"\xdf7\xf2Ah\xaf\xaa\xdf\xd6\xe6R\xf24\xba\xdc\xe1" +
	"\xef\xfc|\xde\xe7\xc7>\xfc\x03\x88\x1c\xf2\xa4\xba7\xf1" +
	"\x0cr\xe4\xea;\x1a\xf9pJ#w_\xb2\xe6.\xdf" +
	"\xfdZ\xcfG\x0d\xef\xb6s\xceQu\xdf\x1c\xfa\xda3" +
	"\x87\xf6\xdd3\xf1\x8d9\x9dw\xb7}\x06\xe2r\x8c\x1d" +
	"\xea\xcc0\x00\xf5\xa39\xef\xab\xa7\x03\xd3O\x03\xd3\xf8" +
	"\xe2\x0d\xfdm{D\xbd\xa5\x8d\xbe6\xb5\x91\xf1c\xf8" +
	"\xa7\x89\xd4\xa1\xf7\xce5\x0c\xc4=m;\xd4\xc3m\xe1" +
	"\xd7c\xb0\xc6w\x9d\xd2\xd2\x92\xeeXPp:\xd6\xe8" +
	"\xa6\xd9\x8b(\x16\xf2\x14@\x0a\x01\x94\x8f7\x03\x88\xbf" +
	"q\x14g\x18\"jHk\xa7;\x00\xc4'\x1c\xc5y" +
	"\x86\x0aC\x0d\x19\x80rv\x00@\x9c\xe1XL!C" +
	"\x853\x0d9\x80\x8a\xb8\x1e\xa0\x0f9\x16[i9\x83" +
	"\x1a\xa6\x00\xd4\x16\xec\x00(\xa6h=\x8f\x0c\xb1\x19\xeb" +
	"\x82\xacf\xd1\x05\xa6\xa4vk\xb4\xae\x9c=\x09 \xce" +
	"s,6\xd3\x0eM{4lAT\x9b\xf0(@\xb1" +
	"\x99v\xd0h=}\xbb\x863\x10U%X\xd7h\xfd" +
	"Jd\xe8\xdf:*+\x9ea[\xc0\xbb\xcb\xd8\x0c\x0c" +
	"\x9b\x01\x0b\x9e\xee\x0eJ\x0f\xf3\x099\x00b\x1e\xd07" +
	",O\xba[\xf4\x12ddw\x19[\x80a\x0b\xa0?" +
	"\"\xbd!\xbb\xdc]\x06\x00\xcc\x00\xc3\x0c`\xc1\xd1]" +
	"}\xa4\x82\xf9\x841\xa2-*\xd2*\xf7\xc9\xca(\xb4" +
	"\x9b^\xa5\xdf\xf6u\xd3\xb4\xb7\xf7\x0f\x19\xcc-\xf7\xea" +
	"\xaeW\xed\xd7\x0d\x93\xc2\x0c\x88\xc0\x90z\xdd\xb2{]" +
	"{\xc4\xa8\xa0\xec5\x1ci\x1aV\xc6\xb0\x06c\xd4\xb6" +
	"\xcc*\xe1hTB<cX2Fk\xc9c\x94;" +
	"\xa7SVJ\xae\xe1x\xb6\x0b\x94\xc5+x\xaa\xd5\xf7" +
	"\x834>\xb5\x18@\x1c\xe3(N0\x9c\x8f\x17\xfd(" +
	"\x93\xcf\x0e\x03\x88g8\x8a\x97\x18\xceg\x17\xfc(\x97" +
	"/\xba\x00\xe2\x05\x8e\xe2\xd7\x0c\xe7\xf3\xf3\xb4\xcc\x01\x94" +
	"Wv\x00\x88\x979\x8a7\x19fS\xe7\xfc \x97\xca" +
	"\xefh\xf5u\x8e\xe2]\x86\xd9\xa6/|\x0d\x9b\x00\x94" +
	"w\x0e\x00\x88w9\x8a\x0f)9L\xc34\xa2\xf2\x01" +
	"\x15\xd3\x9f9\x8aO\x18\xe6,\xdb\x92\x90\x0e\xe2%\xdd" +
	"u6\xe4*\x9e\x8cS\x14-\xf7\xba\xd0N\xa1\x91\xf1" +
	"\xba+K\xd2\xd8&](\xac\xb3/\xf9A\x02\xac\xb2" +
	"*\xdb\xa5\x8b\xf9ZCE\x89\xf1\x86\x8c \x05\xe8U" +
	"\xc3\x9f\x02`>a\xb9\xc8J\xf7<\xbd4$\xcb\xc0" +
	"\xd7\x961\x0d\xac)\xed\xd7\x85\x19\x9d\x8e\x0d\xb2R\xd1" +
	"\x07QR\x80\xaf\x8f\x03\xacV\xd1\x05(\x8eQ\xdd\xed" +
	"E\x86Y\xbc\xe8\x07!V\xf7\xe05\x00\xc5\xdb\x08\xb8" +
	"\x83\x00~\xc1\x0f\x82\xac\xee\xc3\xc5\x00\xc5\xdd\x04\xdcI" +
	"@\xea\xbc\x1f\xf6\xcc\xfe\xa09\xf6\x120A@S\x14" +
	"iu<\x00\xee \xe0n\x02\xd2Q\xb0\xd5\xbbp5" +
	"@\xf1N\x02\x0e\x11\x909\xebkH\xe2yO\x00L" +
	"\x10p?\x01-g|-dY\x1c\x06(\x1e\"\xe0" +
	"!\x02\xd8?}\x0d\x9b\x01\xd4\x07\xb1\x0f\xa0\xf8\x00\x01" +
	"\x8f\x120\xe3s_\xc3\x16\x00\xf5a\xdc\x01P\xfc\x19" +
	"\x01O\x120\xf3\xb4\xaf\xe1\x0c\x00\xf5\xf1\xe0\x8cG\x09" +
	"x\x86\x80\xd6\x7f\xf8\x1a\xce\x04P\x9f\x0a\xdc=F\xc0" +
	"\x09\x02\xb2\x9f\xf9\x1a\xb6\x02\xa8\xcf\x067\x7f\x92\x80\x17" +
	"\x08h\xfe\xbb\xafa\x16@}\x0e7\x03\x14O\x10\xf0" +
	"25\xef\xa8e\x8c8\xa6\x1c\x81viQ\xae\xf3\x89" +
	"\xf8\x87\xe9j\xd7\x07l\x97\x1a\xb9N\xf6h=W\xd2" +
	"M\x13\xf3\x09U\x87\xcb\x05Wz\xa3\xae\x85\xf9D\x8e" +
	"#`\x8ba\x19\x95!\xcc':\x16\x02\xbb\\Y\xb1" +
	"\xcdm\x12\xf3\x89z\xc6\x88)\xf5\x0a!\xb1XG5" +
	"d\x0fTlSz\x12rE}\x9b\xc4\xd9\xc0p6" +
	"\xa0?`\xdb^\xc5su@\x07\xf3\x89PL\xfeQ" +
	"\xa1S\xd2\xdf\xda\xcfv9\xae\xbd\xcd(\xd39\xf1\xc0" +
	"\x119\xad\x97J\xd2\xa1\xdb\xc7\x82\x1a\xdd~\xd86\xe8" +
	"\x92\xb1\x0cDG\x94\x8d\x8a\x1c\x19\xd0]\xe0\x836\xe6" +
	"\x13I\x89\xe0:.\x09\x8b\\\xf6\x07<\x19pIs" +
	"\xc2%\x8b\x88\xe9\xff\x87\xa3\xb8\xae\xae\xce\x95\xe5D\x03" +
	"\xcb8\x8a\x1b\x19\xfa\xc6\x88c\xbb\xd4b\x995\xba\x13" +
	"\xb7\xa8\x13\xd0\x9c,O\xdb\xa2um\xd6\xabWM[" +
	"\xc7rtv\xa4F\x8bV\x03\x88\x85\x1c\xc52\x86J" +
	"M\x8e\x96\xac\x07\x10\xff\xcbQ\xacc\xb8\xabd[\x9e" +
	"\xb4\xbc8\xe8%\xdd\xe9\xd7\x07LI\xdc=\x0b\xb0\x97" +
	"#\xe6\x93\x89\x13\x90\x16/97\x88v\xd8\xde\xad\xf1" +
	"\xb9]D\\\x9d\x1cEo\xa2\x82\x1bH\x05\xd7q\x14" +
	"\xfdu*(\xfa\x00D/G\xf1\xad\xaf\xac=\xae," +
	"\x19\x8e!-\xc0\xc4\xfb:\xc7\xfa\x82\xd2\x05\x98$\xcf" +
	"\xeb\x13yV\xf0J\x0d\x11Q9}\xa0N\x8a\xb3\xdc" +
	"\x8f\x08\x07\xa9Qc%\xcd\xa6.F|\xd3\x14\xb4|" +
	",\xc6\xd9\xa6\x0b\x11\xdfdI\xbc\x8b\xad\x04\\\x16\xf0" +
	"\xcd\xf9\x88o\xe6\xe0#\x00\xc5\xcb\x08X\x88\x0c\xe7g" +
	"\xce\xf9,$\x9c\x05x\x1c\xa0\xb8\x90\x90eAk\x7f" +
	"\x11\x11\xce\x92\xe0'\xcb\x08\xb8\x91\xf4\x9a-\x08\xd4]" +
	"\xbd!\xa0\x95\xebi\xbd\x93Z^\x0f*#\xd4\xda\x84" +
	"\xda\x83N\xebE\xd2\xdc5\xbaS\x81@<\x9bH\x01" +
	"\xa9AGM\xaf\x91\x12\xcb1j\x0f\xc3\x06\xb4\xa62" +
	"\x84_\xd2\xad\x924I\x052~\xb4G\x11\xa5\xe5u" +
	"\x99\x15\xb9=7$]\x12'O\xdf*\xd7\x92\xf8n" +
	"\xf4\x86\xa4+Fe{\x90\xd0\xd8\xb3\xb0\x03\xd7\xbah" +
	"\x8f\xf4\x07\xf2\x92#\x89\x8f\xd3g\xd9k\x03^\x81\xc2" +
	"\xd7\xa5,\xcb\xf2\x14\xd9\x0e\xf2J\x97\x0b\x0b\xae\xae\xd0" +
	"\xe75*\xf4\x1dQ\xa1_\xcf\x90\x1b\xf5\xd2\xb7E\xba" +
	"\xd2*AA\xae\xb1G-/\x01\x92\x8e\xee\x8a\x82a" +
	"-\xed\xaf:2,\xa3|P\xb2\x8b:($\xca\x82" +
	"\xcd\x00\xc8\x94\xf9\xc3\x00\xc8\x95\xcb]\x80\xc2\x16\xdd0" +
	"e\xd9\xb7\xb7I\xd7\xb4\xf52pY&\x0e)\xd9\x96" +
	"%!W\xf2dy2C_z1b\xce)\x9d\xd4" +
	"\x97tR\x16\xfd\x88<6\\\x95\xf4R\x96]\xf4\x1b" +
	"4SD\x1e\xdd\x80\xf1\xc53%\xdd\x99\xd4\xcd_\x9e" +
	"\xf7\x9a\x87\xdc\xe9\xe8\x8f&\x02\xafZ?;\xa1;}" +
	"*\xe2Lt$\x14H\x99\x88\x12^\xd8fX\xb2\xbb" +
	"<%\xfe\xe8tD\x85\x00\xd3\xf3J\xdc\xbe\x1b\x0e&" +
	"\xd7\x0e\xfa\x84!.\xbfe\x1e\x02\x882G\xe1L\xc3" +
	",\xb56\xe9\xc3\xa0\x9a\x89x+q\x9b\xf8\xae\xbcu" +
	"\xd4pe\x17\xd7]\xb3\xba&\xa8}S\xa7-n\xb2" +
	"\xdd\xad\xbak\x8fr\xab\\g\x9d8\xbe*(\xf1\x7f" +
	"\xe7xL\x88\x94\xae\x1e\x8e\xe2f\xf2\xfb\xca0\x87\x9b" +
	"V\x7f\x09!\xfa\x81\xbeU\xc2t\xd54/\x90\xa9A" +
	"\xbb\xd1\x98\xdb\x19\x89\xd8\xa0\xbd\xb4d[9O\x8ey" +
	"\"\x1f\x88S\xe8\x85NM\xf2]\x8e\xc2\xac\xa9\x13\xb9" +
	"a\x10%\x9a\x1c\xc5\x18\x15\xd8\x85\x90\xf9\x94QJ\xa3" +
	"\xc3Q\xdcF<y>\x1ah\xab\xe4\xb2\xc7Q\xecf" +
	"\xb59\xb4\xc7\x86\x82\xed\x0c\xe8\xa5\xadS\xe6M\xec\xb1" +
	"C$!\xacH\x98!\x1dkw\x83\x82\x08\x1b2c" +
	"\xd8\x96Ha\xfd#\x1e\x17\xe7\xa8E\x85\x16\x07{'" +
	"\xb99\xc6Q\xece\x88,\xbc\xe6\x9e_\x02\x88\xbd\x1c" +
	"\xc5\x04\xbd\xb6\"\xf5\x19\xbf\x0f@Lp\x14\xf7S9" +
	"\x85O0\xe50\x8d\xfews\x14\x0f0TR\xe1\x03" +
	"L9r\x0d\x808\xc4Q<\xc4h*\xd2+\xb6\x85" +
	"\xad\xc0\xb0\xb5n\x12\xc1\xee\x0a=T\xa4[\xa8\xac\xd5" +
	"GM/y\x92\xd4\x0c:G]}\xc00\x0d\xeeU" +
	"k\x0f\xa3\x9cWu$\xe6\x92\xfb\x00b\x0e\xb0\xdds" +
	"\xf5\x92\x8c\x8f\xa8\xcbgo4\x14\x84#\x01@\x10\x8d" +
	"\xf8a\xac\xe0<\xbe\xd1\xa9\xef\xc6\xcdI\xe7\xd5\x0ao" +
	"y_4z\xf4LWc\x9e\xab[\x95-\xb6\x0b8" +
	"\x92L\x01\xf1!\x93\xa6\x00\x16\xbe\x83\x97\xd6^rf" +
	"\x8e\x1erT\xfcA\x91\xd1\xeb\xa6\x8b2\xb22<1" +
	",\xb24\x80\xd2\xbd>a1zM\xb1@\xfa\x14\xb1" +
	"9i\x81B)\x88(\xa4\xfd\xaa=\xeaV\xa4\xb9\x85" +
	"\xf4\xa7\xf64\x01^'\x1eu\xb5\xb2:\x98\x1c3\xae" +
	"\xeeL\xa2\xa6F\xc1\xa0\x1a\xb8\x8e\xa3X9]0\xca" +
	"\xd2qeI\xf7P\x967\x0e\x0c\xcb\x92G\xe0\xe4S" +
	"\xa7d&\xb3t\xa33y\x10\\\x9c0c\xdd\xa3r" +
	"\xc9\xed\x89L\xe5,\xdbv \xed\x0fJ\xaf\xd76," +
	"\x0f\xa5\xbb\xd6\x90f9~H\xd7_3l\xed\x1c\xf5" +
	"\xf6\xa4{v\xd4S0\xd6\xfdSHY\xb2\x1a\xd8\xb4" +
	"3U8\x0d\x8ey\x97\xfc\x8fc\xbdmX\xff\xe9t" +
	"\xb7:a\xb8\xaf6\xdd\xed\xda*\xab\xa44\xb58\xff" +
	"+\x00\x00\xff\xffo\xa6F\xe8"

func RegisterSchema(reg *schemas.Registry) {
	reg.Register(&schemas.Schema{
		String: schema_b312981b2552a250,
		Nodes: []uint64{
			0x836a53ce789d4cd4,
			0x8523ddc40b86b8b0,
			0x91b79f1f808db032,
			0x95bc14545813fbc1,
			0x9a0e61223d96743b,
			0x9c6a046bfbc1ac5a,
			0x9e19b28d3db3573a,
			0xad1a6c0d7dd07497,
			0xb28c96e23f4cbd58,
			0xbbc29655fa89086e,
			0xd37007fde1f0027d,
			0xd37d2eb2c2f80e63,
			0xd4c9b56290554016,
			0xd562b4df655bdd4d,
			0xd625b7063acf691a,
			0xd800b1d6cd6f1ca0,
			0xdae8b0f61aab5f99,
			0xe94ccf8031176ec4,
			0xf316944415569081,
			0xf964368b0fbd3711,
			0xfbe1980490e001af,
		},
		Compressed: true,
	})
}
