// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: pbauth/v2beta1/traffic_permissions.proto

package authv2beta1

import (
	_ "github.com/hashicorp/consul/proto-public/pbresource"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Action specifies the behavior of a TrafficPermission.
// ACTION_DENY is only available in Consul enterprise.
//
// +kubebuilder:validation:Enum=ACTION_ALLOW;ACTION_DENY;ACTION_UNKNOWN
// +kubebuilder:validation:Type=string
type Action int32

const (
	Action_ACTION_UNSPECIFIED Action = 0
	Action_ACTION_DENY        Action = 1
	Action_ACTION_ALLOW       Action = 2
)

// Enum value maps for Action.
var (
	Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "ACTION_DENY",
		2: "ACTION_ALLOW",
	}
	Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"ACTION_DENY":        1,
		"ACTION_ALLOW":       2,
	}
)

func (x Action) Enum() *Action {
	p := new(Action)
	*p = x
	return p
}

func (x Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Action) Descriptor() protoreflect.EnumDescriptor {
	return file_pbauth_v2beta1_traffic_permissions_proto_enumTypes[0].Descriptor()
}

func (Action) Type() protoreflect.EnumType {
	return &file_pbauth_v2beta1_traffic_permissions_proto_enumTypes[0]
}

func (x Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Action.Descriptor instead.
func (Action) EnumDescriptor() ([]byte, []int) {
	return file_pbauth_v2beta1_traffic_permissions_proto_rawDescGZIP(), []int{0}
}

// TrafficPermissions authorizes traffic between workloads in a Consul service mesh.
type TrafficPermissions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Destination is a configuration of the destination proxies
	// where these traffic permissions should apply.
	Destination *Destination `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
	// Action can be either allow or deny for the entire object. It will default to allow.
	// Deny actions are available only in Consul Enterprise.
	//
	// If action is allow, we will allow the connection if one of the rules in Rules matches, in other words, we will deny
	// all requests except for the ones that match Rules. If Consul is in default allow mode, then allow
	// actions have no effect without a deny permission as everything is allowed by default.
	//
	// If action is deny, we will deny the connection if one of the rules in Rules match, in other words,
	// we will allow all requests except for the ones that match Rules. If Consul is default deny mode,
	// then deny permissions have no effect without an allow permission as everything is denied by default.
	//
	// Action unspecified is reserved for compatibility with the addition of future actions.
	Action Action `protobuf:"varint,2,opt,name=action,proto3,enum=hashicorp.consul.auth.v2beta1.Action" json:"action,omitempty"`
	// Permissions is a list of permissions to match on. They are applied using OR semantics.
	Permissions []*Permission `protobuf:"bytes,3,rep,name=permissions,proto3" json:"permissions,omitempty"`
}

func (x *TrafficPermissions) Reset() {
	*x = TrafficPermissions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrafficPermissions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficPermissions) ProtoMessage() {}

func (x *TrafficPermissions) ProtoReflect() protoreflect.Message {
	mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficPermissions.ProtoReflect.Descriptor instead.
func (*TrafficPermissions) Descriptor() ([]byte, []int) {
	return file_pbauth_v2beta1_traffic_permissions_proto_rawDescGZIP(), []int{0}
}

func (x *TrafficPermissions) GetDestination() *Destination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *TrafficPermissions) GetAction() Action {
	if x != nil {
		return x.Action
	}
	return Action_ACTION_UNSPECIFIED
}

func (x *TrafficPermissions) GetPermissions() []*Permission {
	if x != nil {
		return x.Permissions
	}
	return nil
}

// NamespaceTrafficPermissions represents traffic permissions that should
// apply to all destinations in a namespace.
type NamespaceTrafficPermissions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Action      Action        `protobuf:"varint,1,opt,name=action,proto3,enum=hashicorp.consul.auth.v2beta1.Action" json:"action,omitempty"`
	Permissions []*Permission `protobuf:"bytes,2,rep,name=permissions,proto3" json:"permissions,omitempty"`
}

func (x *NamespaceTrafficPermissions) Reset() {
	*x = NamespaceTrafficPermissions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NamespaceTrafficPermissions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamespaceTrafficPermissions) ProtoMessage() {}

func (x *NamespaceTrafficPermissions) ProtoReflect() protoreflect.Message {
	mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamespaceTrafficPermissions.ProtoReflect.Descriptor instead.
func (*NamespaceTrafficPermissions) Descriptor() ([]byte, []int) {
	return file_pbauth_v2beta1_traffic_permissions_proto_rawDescGZIP(), []int{1}
}

func (x *NamespaceTrafficPermissions) GetAction() Action {
	if x != nil {
		return x.Action
	}
	return Action_ACTION_UNSPECIFIED
}

func (x *NamespaceTrafficPermissions) GetPermissions() []*Permission {
	if x != nil {
		return x.Permissions
	}
	return nil
}

// PartitionTrafficPermissions represents traffic permissions that should
// apply to all destinations in a partition.
type PartitionTrafficPermissions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Action      Action        `protobuf:"varint,1,opt,name=action,proto3,enum=hashicorp.consul.auth.v2beta1.Action" json:"action,omitempty"`
	Permissions []*Permission `protobuf:"bytes,2,rep,name=permissions,proto3" json:"permissions,omitempty"`
}

func (x *PartitionTrafficPermissions) Reset() {
	*x = PartitionTrafficPermissions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionTrafficPermissions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionTrafficPermissions) ProtoMessage() {}

func (x *PartitionTrafficPermissions) ProtoReflect() protoreflect.Message {
	mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionTrafficPermissions.ProtoReflect.Descriptor instead.
func (*PartitionTrafficPermissions) Descriptor() ([]byte, []int) {
	return file_pbauth_v2beta1_traffic_permissions_proto_rawDescGZIP(), []int{2}
}

func (x *PartitionTrafficPermissions) GetAction() Action {
	if x != nil {
		return x.Action
	}
	return Action_ACTION_UNSPECIFIED
}

func (x *PartitionTrafficPermissions) GetPermissions() []*Permission {
	if x != nil {
		return x.Permissions
	}
	return nil
}

// Destination contains the name or name-prefix of the WorkloadIdentity.
// The WorkloadIdentity resource must be in the same tenancy as the TrafficPermissions resource.
type Destination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IdentityName string `protobuf:"bytes,1,opt,name=identity_name,json=identityName,proto3" json:"identity_name,omitempty"`
}

func (x *Destination) Reset() {
	*x = Destination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Destination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Destination) ProtoMessage() {}

func (x *Destination) ProtoReflect() protoreflect.Message {
	mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Destination.ProtoReflect.Descriptor instead.
func (*Destination) Descriptor() ([]byte, []int) {
	return file_pbauth_v2beta1_traffic_permissions_proto_rawDescGZIP(), []int{3}
}

func (x *Destination) GetIdentityName() string {
	if x != nil {
		return x.IdentityName
	}
	return ""
}

// Permissions is a list of permissions to match on.
type Permission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sources is a list of sources in this traffic permission.
	Sources []*Source `protobuf:"bytes,1,rep,name=sources,proto3" json:"sources,omitempty"`
	// DestinationRules is a list of rules to apply for matching sources in this Permission.
	// These rules are specific to the request or connection that is going to the destination(s)
	// selected by the TrafficPermissions resource.
	DestinationRules []*DestinationRule `protobuf:"bytes,2,rep,name=destination_rules,json=destinationRules,proto3" json:"destination_rules,omitempty"`
}

func (x *Permission) Reset() {
	*x = Permission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Permission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Permission) ProtoMessage() {}

func (x *Permission) ProtoReflect() protoreflect.Message {
	mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Permission.ProtoReflect.Descriptor instead.
func (*Permission) Descriptor() ([]byte, []int) {
	return file_pbauth_v2beta1_traffic_permissions_proto_rawDescGZIP(), []int{4}
}

func (x *Permission) GetSources() []*Source {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *Permission) GetDestinationRules() []*DestinationRule {
	if x != nil {
		return x.DestinationRules
	}
	return nil
}

// Source represents the source identity.
// To specify any of the wildcard sources, the specific fields need to be omitted.
// For example, for a wildcard namespace, identity_name should be omitted.
type Source struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IdentityName  string `protobuf:"bytes,1,opt,name=identity_name,json=identityName,proto3" json:"identity_name,omitempty"`
	Namespace     string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Partition     string `protobuf:"bytes,3,opt,name=partition,proto3" json:"partition,omitempty"`
	Peer          string `protobuf:"bytes,4,opt,name=peer,proto3" json:"peer,omitempty"`
	SamenessGroup string `protobuf:"bytes,5,opt,name=sameness_group,json=samenessGroup,proto3" json:"sameness_group,omitempty"`
	// Exclude is a list of sources to exclude from this source.
	Exclude []*ExcludeSource `protobuf:"bytes,6,rep,name=exclude,proto3" json:"exclude,omitempty"`
}

func (x *Source) Reset() {
	*x = Source{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Source) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Source) ProtoMessage() {}

func (x *Source) ProtoReflect() protoreflect.Message {
	mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Source.ProtoReflect.Descriptor instead.
func (*Source) Descriptor() ([]byte, []int) {
	return file_pbauth_v2beta1_traffic_permissions_proto_rawDescGZIP(), []int{5}
}

func (x *Source) GetIdentityName() string {
	if x != nil {
		return x.IdentityName
	}
	return ""
}

func (x *Source) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *Source) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *Source) GetPeer() string {
	if x != nil {
		return x.Peer
	}
	return ""
}

func (x *Source) GetSamenessGroup() string {
	if x != nil {
		return x.SamenessGroup
	}
	return ""
}

func (x *Source) GetExclude() []*ExcludeSource {
	if x != nil {
		return x.Exclude
	}
	return nil
}

// ExcludeSource is almost the same as source but it prevents the addition of
// matching sources.
type ExcludeSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	IdentityName  string `protobuf:"bytes,1,opt,name=identity_name,json=identityName,proto3" json:"identity_name,omitempty"`
	Namespace     string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Partition     string `protobuf:"bytes,3,opt,name=partition,proto3" json:"partition,omitempty"`
	Peer          string `protobuf:"bytes,4,opt,name=peer,proto3" json:"peer,omitempty"`
	SamenessGroup string `protobuf:"bytes,5,opt,name=sameness_group,json=samenessGroup,proto3" json:"sameness_group,omitempty"`
}

func (x *ExcludeSource) Reset() {
	*x = ExcludeSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExcludeSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExcludeSource) ProtoMessage() {}

func (x *ExcludeSource) ProtoReflect() protoreflect.Message {
	mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExcludeSource.ProtoReflect.Descriptor instead.
func (*ExcludeSource) Descriptor() ([]byte, []int) {
	return file_pbauth_v2beta1_traffic_permissions_proto_rawDescGZIP(), []int{6}
}

func (x *ExcludeSource) GetIdentityName() string {
	if x != nil {
		return x.IdentityName
	}
	return ""
}

func (x *ExcludeSource) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *ExcludeSource) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *ExcludeSource) GetPeer() string {
	if x != nil {
		return x.Peer
	}
	return ""
}

func (x *ExcludeSource) GetSamenessGroup() string {
	if x != nil {
		return x.SamenessGroup
	}
	return ""
}

// DestinationRule contains rules rules to apply to the incoming connection.
type DestinationRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PathExact  string `protobuf:"bytes,1,opt,name=path_exact,json=pathExact,proto3" json:"path_exact,omitempty"`
	PathPrefix string `protobuf:"bytes,2,opt,name=path_prefix,json=pathPrefix,proto3" json:"path_prefix,omitempty"`
	PathRegex  string `protobuf:"bytes,3,opt,name=path_regex,json=pathRegex,proto3" json:"path_regex,omitempty"`
	// Methods is the list of HTTP methods. If no methods are specified,
	// this rule will apply to all methods.
	Methods   []string                 `protobuf:"bytes,4,rep,name=methods,proto3" json:"methods,omitempty"`
	Headers   []*DestinationRuleHeader `protobuf:"bytes,5,rep,name=headers,proto3" json:"headers,omitempty"`
	PortNames []string                 `protobuf:"bytes,6,rep,name=port_names,json=portNames,proto3" json:"port_names,omitempty"`
	// Exclude contains a list of rules to exclude when evaluating rules for the incoming connection.
	Exclude []*ExcludePermissionRule `protobuf:"bytes,7,rep,name=exclude,proto3" json:"exclude,omitempty"`
}

func (x *DestinationRule) Reset() {
	*x = DestinationRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationRule) ProtoMessage() {}

func (x *DestinationRule) ProtoReflect() protoreflect.Message {
	mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationRule.ProtoReflect.Descriptor instead.
func (*DestinationRule) Descriptor() ([]byte, []int) {
	return file_pbauth_v2beta1_traffic_permissions_proto_rawDescGZIP(), []int{7}
}

func (x *DestinationRule) GetPathExact() string {
	if x != nil {
		return x.PathExact
	}
	return ""
}

func (x *DestinationRule) GetPathPrefix() string {
	if x != nil {
		return x.PathPrefix
	}
	return ""
}

func (x *DestinationRule) GetPathRegex() string {
	if x != nil {
		return x.PathRegex
	}
	return ""
}

func (x *DestinationRule) GetMethods() []string {
	if x != nil {
		return x.Methods
	}
	return nil
}

func (x *DestinationRule) GetHeaders() []*DestinationRuleHeader {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *DestinationRule) GetPortNames() []string {
	if x != nil {
		return x.PortNames
	}
	return nil
}

func (x *DestinationRule) GetExclude() []*ExcludePermissionRule {
	if x != nil {
		return x.Exclude
	}
	return nil
}

type ExcludePermissionRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PathExact  string `protobuf:"bytes,1,opt,name=path_exact,json=pathExact,proto3" json:"path_exact,omitempty"`
	PathPrefix string `protobuf:"bytes,2,opt,name=path_prefix,json=pathPrefix,proto3" json:"path_prefix,omitempty"`
	PathRegex  string `protobuf:"bytes,3,opt,name=path_regex,json=pathRegex,proto3" json:"path_regex,omitempty"`
	// Methods is the list of HTTP methods.
	Methods []string                 `protobuf:"bytes,4,rep,name=methods,proto3" json:"methods,omitempty"`
	Headers []*DestinationRuleHeader `protobuf:"bytes,5,rep,name=headers,proto3" json:"headers,omitempty"`
	// PortNames is a list of workload ports to apply this rule to. The ports specified here
	// must be the ports used in the connection.
	PortNames []string `protobuf:"bytes,6,rep,name=port_names,json=portNames,proto3" json:"port_names,omitempty"`
}

func (x *ExcludePermissionRule) Reset() {
	*x = ExcludePermissionRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExcludePermissionRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExcludePermissionRule) ProtoMessage() {}

func (x *ExcludePermissionRule) ProtoReflect() protoreflect.Message {
	mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExcludePermissionRule.ProtoReflect.Descriptor instead.
func (*ExcludePermissionRule) Descriptor() ([]byte, []int) {
	return file_pbauth_v2beta1_traffic_permissions_proto_rawDescGZIP(), []int{8}
}

func (x *ExcludePermissionRule) GetPathExact() string {
	if x != nil {
		return x.PathExact
	}
	return ""
}

func (x *ExcludePermissionRule) GetPathPrefix() string {
	if x != nil {
		return x.PathPrefix
	}
	return ""
}

func (x *ExcludePermissionRule) GetPathRegex() string {
	if x != nil {
		return x.PathRegex
	}
	return ""
}

func (x *ExcludePermissionRule) GetMethods() []string {
	if x != nil {
		return x.Methods
	}
	return nil
}

func (x *ExcludePermissionRule) GetHeaders() []*DestinationRuleHeader {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *ExcludePermissionRule) GetPortNames() []string {
	if x != nil {
		return x.PortNames
	}
	return nil
}

type DestinationRuleHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name    string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Present bool   `protobuf:"varint,2,opt,name=present,proto3" json:"present,omitempty"`
	Exact   string `protobuf:"bytes,3,opt,name=exact,proto3" json:"exact,omitempty"`
	Prefix  string `protobuf:"bytes,4,opt,name=prefix,proto3" json:"prefix,omitempty"`
	Suffix  string `protobuf:"bytes,5,opt,name=suffix,proto3" json:"suffix,omitempty"`
	Regex   string `protobuf:"bytes,6,opt,name=regex,proto3" json:"regex,omitempty"`
	Invert  bool   `protobuf:"varint,7,opt,name=invert,proto3" json:"invert,omitempty"`
}

func (x *DestinationRuleHeader) Reset() {
	*x = DestinationRuleHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationRuleHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationRuleHeader) ProtoMessage() {}

func (x *DestinationRuleHeader) ProtoReflect() protoreflect.Message {
	mi := &file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationRuleHeader.ProtoReflect.Descriptor instead.
func (*DestinationRuleHeader) Descriptor() ([]byte, []int) {
	return file_pbauth_v2beta1_traffic_permissions_proto_rawDescGZIP(), []int{9}
}

func (x *DestinationRuleHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DestinationRuleHeader) GetPresent() bool {
	if x != nil {
		return x.Present
	}
	return false
}

func (x *DestinationRuleHeader) GetExact() string {
	if x != nil {
		return x.Exact
	}
	return ""
}

func (x *DestinationRuleHeader) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *DestinationRuleHeader) GetSuffix() string {
	if x != nil {
		return x.Suffix
	}
	return ""
}

func (x *DestinationRuleHeader) GetRegex() string {
	if x != nil {
		return x.Regex
	}
	return ""
}

func (x *DestinationRuleHeader) GetInvert() bool {
	if x != nil {
		return x.Invert
	}
	return false
}

var File_pbauth_v2beta1_traffic_permissions_proto protoreflect.FileDescriptor

var file_pbauth_v2beta1_traffic_permissions_proto_rawDesc = []byte{
	0x0a, 0x28, 0x70, 0x62, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x61, 0x75, 0x74,
	0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x70, 0x62, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf6, 0x01, 0x0a, 0x12, 0x54, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4c,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x61, 0x75, 0x74, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x0b, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x06, 0xa2, 0x93, 0x04, 0x02, 0x08, 0x03,
	0x22, 0xb1, 0x01, 0x0a, 0x1b, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x54, 0x72,
	0x61, 0x66, 0x66, 0x69, 0x63, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x3d, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x25, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x4b, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x06, 0xa2, 0x93,
	0x04, 0x02, 0x08, 0x03, 0x22, 0xb1, 0x01, 0x0a, 0x1b, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x61, 0x75, 0x74, 0x68,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x3a, 0x06, 0xa2, 0x93, 0x04, 0x02, 0x08, 0x02, 0x22, 0x32, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xaa, 0x01, 0x0a,
	0x0a, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x07, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x61, 0x75, 0x74, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x5b, 0x0a, 0x11,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xec, 0x01, 0x0a, 0x06, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x65, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x65, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x61, 0x6d,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x73, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x46, 0x0a, 0x07, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x07, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x0d, 0x45, 0x78, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x70,
	0x65, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x65, 0x65, 0x72, 0x12,
	0x25, 0x0a, 0x0e, 0x73, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73,
	0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xc9, 0x02, 0x0a, 0x0f, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x74, 0x68, 0x5f, 0x65, 0x78, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x74, 0x68, 0x45, 0x78, 0x61, 0x63, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x74,
	0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x70, 0x61, 0x74, 0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x74, 0x68, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x74, 0x68, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x73, 0x12, 0x4e, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x75, 0x6c, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x70, 0x6f, 0x72, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x12, 0x4e, 0x0a, 0x07, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x18, 0x07, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x07, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x22, 0xff, 0x01, 0x0a, 0x15, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x74, 0x68, 0x5f, 0x65, 0x78, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x74, 0x68, 0x45, 0x78, 0x61, 0x63, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x70,
	0x61, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x70, 0x61, 0x74, 0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x74, 0x68, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x74, 0x68, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x18, 0x0a, 0x07, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0x4e, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x07, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x70, 0x6f, 0x72, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x22, 0xb9, 0x01, 0x0a, 0x15, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x07, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05,
	0x65, 0x78, 0x61, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x78, 0x61,
	0x63, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x75, 0x66, 0x66,
	0x69, 0x78, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x72, 0x65, 0x67, 0x65, 0x78, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x6e, 0x76, 0x65,
	0x72, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x74,
	0x2a, 0x43, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e,
	0x59, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x4c,
	0x4c, 0x4f, 0x57, 0x10, 0x02, 0x42, 0x98, 0x02, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x61,
	0x75, 0x74, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x17, 0x54, 0x72, 0x61,
	0x66, 0x66, 0x69, 0x63, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x2f, 0x70, 0x62, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b,
	0x61, 0x75, 0x74, 0x68, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0xa2, 0x02, 0x03, 0x48, 0x43,
	0x41, 0xaa, 0x02, 0x1d, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x2e, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xca, 0x02, 0x1d, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x41, 0x75, 0x74, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xe2, 0x02, 0x29, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x41, 0x75, 0x74, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x20,
	0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x3a, 0x3a, 0x41, 0x75, 0x74, 0x68, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pbauth_v2beta1_traffic_permissions_proto_rawDescOnce sync.Once
	file_pbauth_v2beta1_traffic_permissions_proto_rawDescData = file_pbauth_v2beta1_traffic_permissions_proto_rawDesc
)

func file_pbauth_v2beta1_traffic_permissions_proto_rawDescGZIP() []byte {
	file_pbauth_v2beta1_traffic_permissions_proto_rawDescOnce.Do(func() {
		file_pbauth_v2beta1_traffic_permissions_proto_rawDescData = protoimpl.X.CompressGZIP(file_pbauth_v2beta1_traffic_permissions_proto_rawDescData)
	})
	return file_pbauth_v2beta1_traffic_permissions_proto_rawDescData
}

var file_pbauth_v2beta1_traffic_permissions_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_pbauth_v2beta1_traffic_permissions_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_pbauth_v2beta1_traffic_permissions_proto_goTypes = []interface{}{
	(Action)(0),                         // 0: hashicorp.consul.auth.v2beta1.Action
	(*TrafficPermissions)(nil),          // 1: hashicorp.consul.auth.v2beta1.TrafficPermissions
	(*NamespaceTrafficPermissions)(nil), // 2: hashicorp.consul.auth.v2beta1.NamespaceTrafficPermissions
	(*PartitionTrafficPermissions)(nil), // 3: hashicorp.consul.auth.v2beta1.PartitionTrafficPermissions
	(*Destination)(nil),                 // 4: hashicorp.consul.auth.v2beta1.Destination
	(*Permission)(nil),                  // 5: hashicorp.consul.auth.v2beta1.Permission
	(*Source)(nil),                      // 6: hashicorp.consul.auth.v2beta1.Source
	(*ExcludeSource)(nil),               // 7: hashicorp.consul.auth.v2beta1.ExcludeSource
	(*DestinationRule)(nil),             // 8: hashicorp.consul.auth.v2beta1.DestinationRule
	(*ExcludePermissionRule)(nil),       // 9: hashicorp.consul.auth.v2beta1.ExcludePermissionRule
	(*DestinationRuleHeader)(nil),       // 10: hashicorp.consul.auth.v2beta1.DestinationRuleHeader
}
var file_pbauth_v2beta1_traffic_permissions_proto_depIdxs = []int32{
	4,  // 0: hashicorp.consul.auth.v2beta1.TrafficPermissions.destination:type_name -> hashicorp.consul.auth.v2beta1.Destination
	0,  // 1: hashicorp.consul.auth.v2beta1.TrafficPermissions.action:type_name -> hashicorp.consul.auth.v2beta1.Action
	5,  // 2: hashicorp.consul.auth.v2beta1.TrafficPermissions.permissions:type_name -> hashicorp.consul.auth.v2beta1.Permission
	0,  // 3: hashicorp.consul.auth.v2beta1.NamespaceTrafficPermissions.action:type_name -> hashicorp.consul.auth.v2beta1.Action
	5,  // 4: hashicorp.consul.auth.v2beta1.NamespaceTrafficPermissions.permissions:type_name -> hashicorp.consul.auth.v2beta1.Permission
	0,  // 5: hashicorp.consul.auth.v2beta1.PartitionTrafficPermissions.action:type_name -> hashicorp.consul.auth.v2beta1.Action
	5,  // 6: hashicorp.consul.auth.v2beta1.PartitionTrafficPermissions.permissions:type_name -> hashicorp.consul.auth.v2beta1.Permission
	6,  // 7: hashicorp.consul.auth.v2beta1.Permission.sources:type_name -> hashicorp.consul.auth.v2beta1.Source
	8,  // 8: hashicorp.consul.auth.v2beta1.Permission.destination_rules:type_name -> hashicorp.consul.auth.v2beta1.DestinationRule
	7,  // 9: hashicorp.consul.auth.v2beta1.Source.exclude:type_name -> hashicorp.consul.auth.v2beta1.ExcludeSource
	10, // 10: hashicorp.consul.auth.v2beta1.DestinationRule.headers:type_name -> hashicorp.consul.auth.v2beta1.DestinationRuleHeader
	9,  // 11: hashicorp.consul.auth.v2beta1.DestinationRule.exclude:type_name -> hashicorp.consul.auth.v2beta1.ExcludePermissionRule
	10, // 12: hashicorp.consul.auth.v2beta1.ExcludePermissionRule.headers:type_name -> hashicorp.consul.auth.v2beta1.DestinationRuleHeader
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_pbauth_v2beta1_traffic_permissions_proto_init() }
func file_pbauth_v2beta1_traffic_permissions_proto_init() {
	if File_pbauth_v2beta1_traffic_permissions_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrafficPermissions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NamespaceTrafficPermissions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionTrafficPermissions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Destination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Permission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Source); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExcludeSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExcludePermissionRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbauth_v2beta1_traffic_permissions_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationRuleHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pbauth_v2beta1_traffic_permissions_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_pbauth_v2beta1_traffic_permissions_proto_goTypes,
		DependencyIndexes: file_pbauth_v2beta1_traffic_permissions_proto_depIdxs,
		EnumInfos:         file_pbauth_v2beta1_traffic_permissions_proto_enumTypes,
		MessageInfos:      file_pbauth_v2beta1_traffic_permissions_proto_msgTypes,
	}.Build()
	File_pbauth_v2beta1_traffic_permissions_proto = out.File
	file_pbauth_v2beta1_traffic_permissions_proto_rawDesc = nil
	file_pbauth_v2beta1_traffic_permissions_proto_goTypes = nil
	file_pbauth_v2beta1_traffic_permissions_proto_depIdxs = nil
}
