/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

#ifndef __COAX_H
#define __COAX_H

#include "transcalc.h"
#include "units.h"
#include "convert.h"

typedef struct _coax {
  gfloat er;               /* dielectric constant */
  gfloat mur;              /* rel. permeability */
  gfloat tand;             /* Dielectric Loss Tangent */
  gfloat sigma;            /* Conductivity of the metal */
  gfloat f;                /* Frequency of operation */
  gfloat din;              /* Inner diameter of cable */
  gfloat dout;             /* Outer diameter of cable */
  gfloat l;                /* Length of cable */
  gfloat Z0;               /* characteristic impedance */
  gfloat ang_l;            /* Electrical length in angle */
  gfloat er_eff;           /* Effective dielectric constant */
  gfloat atten_dielectric; /* Loss in dielectric (dB) */
  gfloat atten_cond;       /* Loss in conductors (dB) */
  gfloat fc;               /* Cutoff frequency for higher order modes */
} coax;


void get_coax_sub (trans_win *, coax *);
void get_coax_comp (trans_win *, coax *);
void get_coax_phys (trans_win *, coax *);
void get_coax_elec (trans_win *, coax *);
void fixdin (GtkWidget *, trans_win *);
void fixdout (GtkWidget *, trans_win *);
gfloat alphad_coax (coax *);
gfloat alphac_coax (coax *);
void analyze_coax (GtkWidget *, trans_win *);
void synthesize_coax (GtkWidget *, trans_win *);
void coax_win (GtkWidget *); 

extern void setup_transgui (int, GtkWidget *, trans_win *);
extern void setstatus (GtkWidget *, trans_win *);

#endif
