/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/* setup_menu.c by Gopal Narayanan
 * This file containes the program that builds the menu bar
 */

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "transcalc.h"
#include "file_io.h"
#include "menu.h"
extern void print_cb (GtkWidget *, gpointer);

void 
analyzeCB (GtkWidget *parent)
{
  /* short ttype; */
  /*  gtk_signal_emit_by_name (GTK_OBJECT (twin->Analbutton), "clicked", 
      twin);*/
  /*  gtk_widget_event (GTK_OBJECT (twin->Analbutton), GDK_KEY_PRESS);*/
  /*  printf("%s\n",gtk_entry_get_text(GTK_ENTRY (twin->subparam_text[0])));*/

  /*  ttype = transtype_int();
  switch (ttype) {
  case MICROSTRIP:
    analyze_microstrip (parent, (trans_win *) twin);
    break;
  case RECTWAVEGUIDE: 
    analyze_rectwaveguide(parent, (trans_win *) twin);
    break;
  }
  */
  gtk_signal_emit_by_name (GTK_OBJECT (twin->Analbutton), "clicked",
			   twin);
}

void 
synthesizeCB (GtkWidget *parent)
{
  gtk_signal_emit_by_name (GTK_OBJECT (twin->Synbutton), "clicked",
			   twin);
}



/* This is the GtkItemFactoryEntry structure used to generate new menus.
        Item 1: The menu path. The letter after the underscore indicates an
                accelerator key once the menu is open.
        Item 2: The accelerator key for the entry
        Item 3: The callback function.
        Item 4: The callback action.  This changes the parameters with
                which the function is called.  The default is 0.
        Item 5: The item type, used to define what kind of an item it is.
                Here are the possible values:

                NULL               -> "<Item>"
                ""                 -> "<Item>"
                "<Title>"          -> create a title item
                "<Item>"           -> create a simple item
                "<CheckItem>"      -> create a check item
                "<ToggleItem>"     -> create a toggle item
                "<RadioItem>"      -> create a radio item
                <path>             -> path of a radio item to link against
                "<Separator>"      -> create a separator
                "<Branch>"         -> create an item to hold sub items (optional)
                "<LastBranch>"     -> create a right justified branch 
     */

static GtkItemFactoryEntry menu_items[] = {
  { "/_File",         NULL,         NULL, 0, "<Branch>" },
  { "/File/_Load", "<control>L", file_dialog, TC_FILE_LOAD, NULL},
  { "/File/_Save", "<control>S", file_dialog, TC_FILE_SAVE, NULL},
  { "/File/_Print", "<control>P", print_cb, 0, NULL},
  { "/File/sep1", NULL, NULL, 0, "<Separator>"},
  { "/File/_Options", "<control>O", optionsCB, 0, NULL },
  { "/File/sep1", NULL, NULL, 0, "<Separator>"},
  { "/File/Quit",     "<control>Q", destroy, 0, NULL },
  { "/_Execute",      NULL,         NULL, 0, "<Branch>" },
  { "/Execute/_Analyze", "F3", analyzeCB, 0, NULL },
  { "/Execute/_Synthesize", "F4", synthesizeCB, 0, NULL },       
  { "/_Help",         NULL,         NULL, 0, "<LastBranch>" },
  { "/_Help/_Help",   "F1",  helpCB, 0, NULL },
  { "/_Help/About",   NULL,         aboutCB, 0, NULL },
};


void 
make_main_menu (GtkWidget  *window,
		     GtkWidget *parent,
		     GtkWidget **menubar )
     {
       GtkItemFactory *item_factory;
       GtkAccelGroup *accel_group;
       gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);

       accel_group = gtk_accel_group_new ();
       
       /* This function initializes the item factory.
          Param 1: The type of menu - can be GTK_TYPE_MENU_BAR, GTK_TYPE_MENU,
                   or GTK_TYPE_OPTION_MENU.
          Param 2: The path of the menu.
          Param 3: A pointer to a gtk_accel_group.  The item factory sets up
                   the accelerator table while generating menus.
       */

       item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", 
                                            accel_group);

       /* This function generates the menu items. Pass the item factory,
          the number of items in the array, the array itself, and any
          callback data for the the menu items. */
       gtk_item_factory_create_items (item_factory, nmenu_items, menu_items, parent);

       /* Attach the new accelerator group to the window. */
       gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);

       if (menubar)
         /* Finally, return the actual menu bar created by the item factory. */ 
         *menubar = gtk_item_factory_get_widget (item_factory, "<main>");
     }





/* create the menubar */

/*GtkWidget *setup_menu (GtkWidget *top,
  GtkWidget *parent)*/
GtkWidget 
*setup_menu (trans_gui *tgui)
{
  GtkWidget *menubarT;


  make_main_menu (tgui->mainwindow, tgui->vertbox, &menubarT);

  /* Add the menu bar to the parent window */

  gtk_box_pack_start (GTK_BOX (tgui->vertbox), menubarT, 
		      FALSE, FALSE, 0);
  gtk_widget_show (menubarT);
  
  return menubarT;

}




