/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.math.Fraction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FractionTest
extends AbstractLangTest {
    private static final int SKIP = 500;

    @Test
    public void testAbs() {
        Fraction f = Fraction.getFraction((int)50, (int)75);
        f = f.abs();
        Assertions.assertEquals((int)50, (int)f.getNumerator());
        Assertions.assertEquals((int)75, (int)f.getDenominator());
        f = Fraction.getFraction((int)-50, (int)75);
        f = f.abs();
        Assertions.assertEquals((int)50, (int)f.getNumerator());
        Assertions.assertEquals((int)75, (int)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        f = f.abs();
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)-1);
        f = f.abs();
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)Integer.MIN_VALUE, (int)1).abs());
    }

    @Test
    public void testAdd() {
        Fraction f1 = Fraction.getFraction((int)3, (int)5);
        Fraction f2 = Fraction.getFraction((int)1, (int)5);
        Fraction f = f1.add(f2);
        Assertions.assertEquals((int)4, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)2, (int)5);
        f = f1.add(f2);
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)3, (int)5);
        f = f1.add(f2);
        Assertions.assertEquals((int)6, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)-4, (int)5);
        f = f1.add(f2);
        Assertions.assertEquals((int)-1, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0x7FFFFFFE, (int)1);
        f2 = Fraction.ONE;
        f = f1.add(f2);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)1, (int)2);
        f = f1.add(f2);
        Assertions.assertEquals((int)11, (int)f.getNumerator());
        Assertions.assertEquals((int)10, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)8);
        f2 = Fraction.getFraction((int)1, (int)6);
        f = f1.add(f2);
        Assertions.assertEquals((int)13, (int)f.getNumerator());
        Assertions.assertEquals((int)24, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)1, (int)5);
        f = f1.add(f2);
        Assertions.assertSame((Object)f2, (Object)f);
        f = f2.add(f1);
        Assertions.assertSame((Object)f2, (Object)f);
        f1 = Fraction.getFraction((int)-1, (int)676);
        f2 = Fraction.getFraction((int)-2, (int)442);
        Fraction fr = f1.add(f2);
        Assertions.assertEquals((int)11492, (int)fr.getDenominator());
        Assertions.assertEquals((int)-69, (int)fr.getNumerator());
        Assertions.assertThrows(NullPointerException.class, () -> fr.add(null));
        f1 = Fraction.getFraction((int)1, (int)98304);
        f2 = Fraction.getFraction((int)1, (int)59049);
        f = f1.add(f2);
        Assertions.assertEquals((int)52451, (int)f.getNumerator());
        Assertions.assertEquals((int)1934917632, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)3);
        f2 = Fraction.ONE_THIRD;
        f = f1.add(f2);
        Assertions.assertEquals((int)-2147483647, (int)f.getNumerator());
        Assertions.assertEquals((int)3, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0x7FFFFFFE, (int)1);
        f2 = Fraction.ONE;
        f = f1.add(f2);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        Fraction overflower = f;
        Assertions.assertThrows(ArithmeticException.class, () -> overflower.add(Fraction.ONE));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)Integer.MIN_VALUE, (int)5).add(Fraction.getFraction((int)-1, (int)5)));
        Fraction maxValue = Fraction.getFraction((int)-2147483647, (int)1);
        Assertions.assertThrows(ArithmeticException.class, () -> maxValue.add(maxValue));
        Fraction negativeMaxValue = Fraction.getFraction((int)-2147483647, (int)1);
        Assertions.assertThrows(ArithmeticException.class, () -> negativeMaxValue.add(negativeMaxValue));
        Fraction f3 = Fraction.getFraction((int)3, (int)327680);
        Fraction f4 = Fraction.getFraction((int)2, (int)59049);
        Assertions.assertThrows(ArithmeticException.class, () -> f3.add(f4));
    }

    @Test
    public void testCompareTo() {
        Fraction f1 = Fraction.getFraction((int)3, (int)5);
        Assertions.assertEquals((int)0, (int)f1.compareTo(f1));
        Fraction fr = f1;
        Assertions.assertThrows(NullPointerException.class, () -> fr.compareTo(null));
        Fraction f2 = Fraction.getFraction((int)2, (int)5);
        Assertions.assertTrue((f1.compareTo(f2) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)f2.compareTo(f2));
        f2 = Fraction.getFraction((int)4, (int)5);
        Assertions.assertTrue((f1.compareTo(f2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)f2.compareTo(f2));
        f2 = Fraction.getFraction((int)3, (int)5);
        Assertions.assertEquals((int)0, (int)f1.compareTo(f2));
        Assertions.assertEquals((int)0, (int)f2.compareTo(f2));
        f2 = Fraction.getFraction((int)6, (int)10);
        Assertions.assertEquals((int)0, (int)f1.compareTo(f2));
        Assertions.assertEquals((int)0, (int)f2.compareTo(f2));
        f2 = Fraction.getFraction((int)-1, (int)1, (int)Integer.MAX_VALUE);
        Assertions.assertTrue((f1.compareTo(f2) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)f2.compareTo(f2));
    }

    @Test
    public void testConstants() {
        Assertions.assertEquals((int)0, (int)Fraction.ZERO.getNumerator());
        Assertions.assertEquals((int)1, (int)Fraction.ZERO.getDenominator());
        Assertions.assertEquals((int)1, (int)Fraction.ONE.getNumerator());
        Assertions.assertEquals((int)1, (int)Fraction.ONE.getDenominator());
        Assertions.assertEquals((int)1, (int)Fraction.ONE_HALF.getNumerator());
        Assertions.assertEquals((int)2, (int)Fraction.ONE_HALF.getDenominator());
        Assertions.assertEquals((int)1, (int)Fraction.ONE_THIRD.getNumerator());
        Assertions.assertEquals((int)3, (int)Fraction.ONE_THIRD.getDenominator());
        Assertions.assertEquals((int)2, (int)Fraction.TWO_THIRDS.getNumerator());
        Assertions.assertEquals((int)3, (int)Fraction.TWO_THIRDS.getDenominator());
        Assertions.assertEquals((int)1, (int)Fraction.ONE_QUARTER.getNumerator());
        Assertions.assertEquals((int)4, (int)Fraction.ONE_QUARTER.getDenominator());
        Assertions.assertEquals((int)2, (int)Fraction.TWO_QUARTERS.getNumerator());
        Assertions.assertEquals((int)4, (int)Fraction.TWO_QUARTERS.getDenominator());
        Assertions.assertEquals((int)3, (int)Fraction.THREE_QUARTERS.getNumerator());
        Assertions.assertEquals((int)4, (int)Fraction.THREE_QUARTERS.getDenominator());
        Assertions.assertEquals((int)1, (int)Fraction.ONE_FIFTH.getNumerator());
        Assertions.assertEquals((int)5, (int)Fraction.ONE_FIFTH.getDenominator());
        Assertions.assertEquals((int)2, (int)Fraction.TWO_FIFTHS.getNumerator());
        Assertions.assertEquals((int)5, (int)Fraction.TWO_FIFTHS.getDenominator());
        Assertions.assertEquals((int)3, (int)Fraction.THREE_FIFTHS.getNumerator());
        Assertions.assertEquals((int)5, (int)Fraction.THREE_FIFTHS.getDenominator());
        Assertions.assertEquals((int)4, (int)Fraction.FOUR_FIFTHS.getNumerator());
        Assertions.assertEquals((int)5, (int)Fraction.FOUR_FIFTHS.getDenominator());
    }

    @Test
    public void testConversions() {
        Fraction f = Fraction.getFraction((int)3, (int)7, (int)8);
        Assertions.assertEquals((int)3, (int)f.intValue());
        Assertions.assertEquals((long)3L, (long)f.longValue());
        Assertions.assertEquals((float)3.875f, (float)f.floatValue(), (float)1.0E-5f);
        Assertions.assertEquals((double)3.875, (double)f.doubleValue(), (double)1.0E-5);
    }

    @Test
    public void testDivide() {
        Fraction f1 = Fraction.getFraction((int)3, (int)5);
        Fraction f2 = Fraction.getFraction((int)2, (int)5);
        Fraction f = f1.divideBy(f2);
        Assertions.assertEquals((int)3, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)3, (int)5).divideBy(Fraction.ZERO));
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)2, (int)7);
        f = f1.divideBy(f2);
        Assertions.assertSame((Object)Fraction.ZERO, (Object)f);
        f1 = Fraction.getFraction((int)2, (int)7);
        f2 = Fraction.ONE;
        f = f1.divideBy(f2);
        Assertions.assertEquals((int)2, (int)f.getNumerator());
        Assertions.assertEquals((int)7, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
        f = f1.divideBy(f1);
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
        f2 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
        Fraction fr = f1.divideBy(f2);
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)fr.getNumerator());
        Assertions.assertEquals((int)1, (int)fr.getDenominator());
        Assertions.assertThrows(NullPointerException.class, () -> fr.divideBy(null));
        Fraction smallest = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
        Assertions.assertThrows(ArithmeticException.class, () -> smallest.divideBy(smallest.invert()));
        Fraction negative = Fraction.getFraction((int)1, (int)-2147483647);
        Assertions.assertThrows(ArithmeticException.class, () -> negative.divideBy(negative.invert()));
    }

    @Test
    public void testEquals() {
        Fraction f1 = Fraction.getFraction((int)3, (int)5);
        Assertions.assertNotEquals(null, (Object)f1);
        Assertions.assertNotEquals((Object)f1, (Object)new Object());
        Assertions.assertNotEquals((Object)f1, (Object)6);
        f1 = Fraction.getFraction((int)3, (int)5);
        Fraction f2 = Fraction.getFraction((int)2, (int)5);
        Assertions.assertNotEquals((Object)f1, (Object)f2);
        Assertions.assertEquals((Object)f1, (Object)f1);
        Assertions.assertEquals((Object)f2, (Object)f2);
        f2 = Fraction.getFraction((int)3, (int)5);
        Assertions.assertEquals((Object)f1, (Object)f2);
        f2 = Fraction.getFraction((int)6, (int)10);
        Assertions.assertNotEquals((Object)f1, (Object)f2);
    }

    @Test
    public void testFactory_double() {
        int j;
        int i;
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((double)Double.NaN));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((double)Double.POSITIVE_INFINITY));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((double)Double.NEGATIVE_INFINITY));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((double)2.147483648E9));
        Fraction f = Fraction.getFraction((double)0.0);
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((double)1.0);
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((double)0.5);
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((double)-0.875);
        Assertions.assertEquals((int)-7, (int)f.getNumerator());
        Assertions.assertEquals((int)8, (int)f.getDenominator());
        f = Fraction.getFraction((double)1.25);
        Assertions.assertEquals((int)5, (int)f.getNumerator());
        Assertions.assertEquals((int)4, (int)f.getDenominator());
        f = Fraction.getFraction((double)0.66666);
        Assertions.assertEquals((int)2, (int)f.getNumerator());
        Assertions.assertEquals((int)3, (int)f.getDenominator());
        f = Fraction.getFraction((double)9.999000099990002E-5);
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        Fraction f2 = null;
        for (i = 1; i <= 100; ++i) {
            for (j = 1; j <= i; ++j) {
                f = Fraction.getFraction((double)((double)j / (double)i));
                f2 = Fraction.getReducedFraction((int)j, (int)i);
                Assertions.assertEquals((int)f2.getNumerator(), (int)f.getNumerator());
                Assertions.assertEquals((int)f2.getDenominator(), (int)f.getDenominator());
            }
        }
        for (i = 1001; i <= 10000; i += 500) {
            for (j = 1; j <= i; ++j) {
                f = Fraction.getFraction((double)((double)j / (double)i));
                f2 = Fraction.getReducedFraction((int)j, (int)i);
                Assertions.assertEquals((int)f2.getNumerator(), (int)f.getNumerator());
                Assertions.assertEquals((int)f2.getDenominator(), (int)f.getDenominator());
            }
        }
    }

    @Test
    public void testFactory_int_int() {
        Fraction f = Fraction.getFraction((int)0, (int)1);
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((int)0, (int)2);
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((int)1, (int)1);
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((int)2, (int)1);
        Assertions.assertEquals((int)2, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((int)23, (int)345);
        Assertions.assertEquals((int)23, (int)f.getNumerator());
        Assertions.assertEquals((int)345, (int)f.getDenominator());
        f = Fraction.getFraction((int)22, (int)7);
        Assertions.assertEquals((int)22, (int)f.getNumerator());
        Assertions.assertEquals((int)7, (int)f.getDenominator());
        f = Fraction.getFraction((int)-6, (int)10);
        Assertions.assertEquals((int)-6, (int)f.getNumerator());
        Assertions.assertEquals((int)10, (int)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)-10);
        Assertions.assertEquals((int)-6, (int)f.getNumerator());
        Assertions.assertEquals((int)10, (int)f.getDenominator());
        f = Fraction.getFraction((int)-6, (int)-10);
        Assertions.assertEquals((int)6, (int)f.getNumerator());
        Assertions.assertEquals((int)10, (int)f.getDenominator());
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)1, (int)0));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)2, (int)0));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)-3, (int)0));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)4, (int)Integer.MIN_VALUE));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)1, (int)Integer.MIN_VALUE));
    }

    @Test
    public void testFactory_int_int_int() {
        Fraction f = Fraction.getFraction((int)0, (int)0, (int)2);
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((int)2, (int)0, (int)2);
        Assertions.assertEquals((int)4, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((int)0, (int)1, (int)2);
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((int)1, (int)1, (int)2);
        Assertions.assertEquals((int)3, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)1, (int)-6, (int)-10));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)1, (int)-6, (int)-10));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)1, (int)-6, (int)-10));
        f = Fraction.getFraction((int)-1, (int)6, (int)10);
        Assertions.assertEquals((int)-16, (int)f.getNumerator());
        Assertions.assertEquals((int)10, (int)f.getDenominator());
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)-1, (int)-6, (int)10));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)-1, (int)6, (int)-10));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)-1, (int)-6, (int)-10));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)0, (int)1, (int)0));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)1, (int)2, (int)0));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)-1, (int)-3, (int)0));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)Integer.MAX_VALUE, (int)1, (int)2));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)-2147483647, (int)1, (int)2));
        f = Fraction.getFraction((int)-1, (int)0, (int)Integer.MAX_VALUE);
        Assertions.assertEquals((int)-2147483647, (int)f.getNumerator());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)f.getDenominator());
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)0, (int)4, (int)Integer.MIN_VALUE));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)1, (int)1, (int)Integer.MAX_VALUE));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)-1, (int)2, (int)Integer.MAX_VALUE));
    }

    @Test
    public void testFactory_String() {
        Assertions.assertThrows(NullPointerException.class, () -> Fraction.getFraction(null));
    }

    @Test
    public void testFactory_String_double() {
        Fraction f = Fraction.getFraction((String)"0.0");
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((String)"0.2");
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        f = Fraction.getFraction((String)"0.5");
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((String)"0.66666");
        Assertions.assertEquals((int)2, (int)f.getNumerator());
        Assertions.assertEquals((int)3, (int)f.getDenominator());
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)"2.3R"));
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)"2147483648"));
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)"."));
    }

    @Test
    public void testFactory_String_improper() {
        Fraction f = Fraction.getFraction((String)"0/1");
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((String)"1/5");
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        f = Fraction.getFraction((String)"1/2");
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((String)"2/3");
        Assertions.assertEquals((int)2, (int)f.getNumerator());
        Assertions.assertEquals((int)3, (int)f.getDenominator());
        f = Fraction.getFraction((String)"7/3");
        Assertions.assertEquals((int)7, (int)f.getNumerator());
        Assertions.assertEquals((int)3, (int)f.getDenominator());
        f = Fraction.getFraction((String)"2/4");
        Assertions.assertEquals((int)2, (int)f.getNumerator());
        Assertions.assertEquals((int)4, (int)f.getDenominator());
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)"2/d"));
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)"2e/3"));
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)"2/"));
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)"/"));
    }

    @Test
    public void testFactory_String_proper() {
        Fraction f = Fraction.getFraction((String)"0 0/1");
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getFraction((String)"1 1/5");
        Assertions.assertEquals((int)6, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        f = Fraction.getFraction((String)"7 1/2");
        Assertions.assertEquals((int)15, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((String)"1 2/4");
        Assertions.assertEquals((int)6, (int)f.getNumerator());
        Assertions.assertEquals((int)4, (int)f.getDenominator());
        f = Fraction.getFraction((String)"-7 1/2");
        Assertions.assertEquals((int)-15, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getFraction((String)"-1 2/4");
        Assertions.assertEquals((int)-6, (int)f.getNumerator());
        Assertions.assertEquals((int)4, (int)f.getDenominator());
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)"2 3"));
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)"a 3"));
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)"2 b/4"));
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)"2 "));
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)" 3"));
        Assertions.assertThrows(NumberFormatException.class, () -> Fraction.getFraction((String)" "));
    }

    @Test
    public void testGets() {
        Fraction f = Fraction.getFraction((int)3, (int)5, (int)6);
        Assertions.assertEquals((int)23, (int)f.getNumerator());
        Assertions.assertEquals((int)3, (int)f.getProperWhole());
        Assertions.assertEquals((int)5, (int)f.getProperNumerator());
        Assertions.assertEquals((int)6, (int)f.getDenominator());
        f = Fraction.getFraction((int)-3, (int)5, (int)6);
        Assertions.assertEquals((int)-23, (int)f.getNumerator());
        Assertions.assertEquals((int)-3, (int)f.getProperWhole());
        Assertions.assertEquals((int)5, (int)f.getProperNumerator());
        Assertions.assertEquals((int)6, (int)f.getDenominator());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)0, (int)1);
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)f.getNumerator());
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)f.getProperWhole());
        Assertions.assertEquals((int)0, (int)f.getProperNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
    }

    @Test
    public void testHashCode() {
        Fraction f1 = Fraction.getFraction((int)3, (int)5);
        Fraction f2 = Fraction.getFraction((int)3, (int)5);
        Assertions.assertEquals((int)f1.hashCode(), (int)f2.hashCode());
        f2 = Fraction.getFraction((int)2, (int)5);
        Assertions.assertTrue((f1.hashCode() != f2.hashCode() ? 1 : 0) != 0);
        f2 = Fraction.getFraction((int)6, (int)10);
        Assertions.assertTrue((f1.hashCode() != f2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testInvert() {
        Fraction f = Fraction.getFraction((int)50, (int)75);
        f = f.invert();
        Assertions.assertEquals((int)75, (int)f.getNumerator());
        Assertions.assertEquals((int)50, (int)f.getDenominator());
        f = Fraction.getFraction((int)4, (int)3);
        f = f.invert();
        Assertions.assertEquals((int)3, (int)f.getNumerator());
        Assertions.assertEquals((int)4, (int)f.getDenominator());
        f = Fraction.getFraction((int)-15, (int)47);
        f = f.invert();
        Assertions.assertEquals((int)-47, (int)f.getNumerator());
        Assertions.assertEquals((int)15, (int)f.getDenominator());
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)0, (int)3).invert());
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)Integer.MIN_VALUE, (int)1).invert());
        f = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        f = f.invert();
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)f.getDenominator());
    }

    @Test
    public void testMultiply() {
        Fraction f1 = Fraction.getFraction((int)3, (int)5);
        Fraction f2 = Fraction.getFraction((int)2, (int)5);
        Fraction f = f1.multiplyBy(f2);
        Assertions.assertEquals((int)6, (int)f.getNumerator());
        Assertions.assertEquals((int)25, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)6, (int)10);
        f2 = Fraction.getFraction((int)6, (int)10);
        f = f1.multiplyBy(f2);
        Assertions.assertEquals((int)9, (int)f.getNumerator());
        Assertions.assertEquals((int)25, (int)f.getDenominator());
        f = f.multiplyBy(f2);
        Assertions.assertEquals((int)27, (int)f.getNumerator());
        Assertions.assertEquals((int)125, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)-2, (int)5);
        f = f1.multiplyBy(f2);
        Assertions.assertEquals((int)-6, (int)f.getNumerator());
        Assertions.assertEquals((int)25, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)-3, (int)5);
        f2 = Fraction.getFraction((int)-2, (int)5);
        f = f1.multiplyBy(f2);
        Assertions.assertEquals((int)6, (int)f.getNumerator());
        Assertions.assertEquals((int)25, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)2, (int)7);
        f = f1.multiplyBy(f2);
        Assertions.assertSame((Object)Fraction.ZERO, (Object)f);
        f1 = Fraction.getFraction((int)2, (int)7);
        f2 = Fraction.ONE;
        f = f1.multiplyBy(f2);
        Assertions.assertEquals((int)2, (int)f.getNumerator());
        Assertions.assertEquals((int)7, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        f2 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
        f = f1.multiplyBy(f2);
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        Fraction fr = f;
        Assertions.assertThrows(NullPointerException.class, () -> fr.multiplyBy(null));
        Fraction fr1 = Fraction.getFraction((int)1, (int)Integer.MAX_VALUE);
        Assertions.assertThrows(ArithmeticException.class, () -> fr1.multiplyBy(fr1));
        Fraction fr2 = Fraction.getFraction((int)1, (int)-2147483647);
        Assertions.assertThrows(ArithmeticException.class, () -> fr2.multiplyBy(fr2));
    }

    @Test
    public void testNegate() {
        Fraction f = Fraction.getFraction((int)50, (int)75);
        f = f.negate();
        Assertions.assertEquals((int)-50, (int)f.getNumerator());
        Assertions.assertEquals((int)75, (int)f.getDenominator());
        f = Fraction.getFraction((int)-50, (int)75);
        f = f.negate();
        Assertions.assertEquals((int)50, (int)f.getNumerator());
        Assertions.assertEquals((int)75, (int)f.getDenominator());
        f = Fraction.getFraction((int)0x7FFFFFFE, (int)Integer.MAX_VALUE);
        f = f.negate();
        Assertions.assertEquals((int)-2147483646, (int)f.getNumerator());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)f.getDenominator());
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)Integer.MIN_VALUE, (int)1).negate());
    }

    @Test
    public void testPow() {
        Fraction f = Fraction.getFraction((int)3, (int)5);
        Assertions.assertEquals((Object)Fraction.ONE, (Object)f.pow(0));
        f = Fraction.getFraction((int)3, (int)5);
        Assertions.assertSame((Object)f, (Object)f.pow(1));
        Assertions.assertEquals((Object)f, (Object)f.pow(1));
        f = Fraction.getFraction((int)3, (int)5);
        f = f.pow(2);
        Assertions.assertEquals((int)9, (int)f.getNumerator());
        Assertions.assertEquals((int)25, (int)f.getDenominator());
        f = Fraction.getFraction((int)3, (int)5);
        f = f.pow(3);
        Assertions.assertEquals((int)27, (int)f.getNumerator());
        Assertions.assertEquals((int)125, (int)f.getDenominator());
        f = Fraction.getFraction((int)3, (int)5);
        f = f.pow(-1);
        Assertions.assertEquals((int)5, (int)f.getNumerator());
        Assertions.assertEquals((int)3, (int)f.getDenominator());
        f = Fraction.getFraction((int)3, (int)5);
        f = f.pow(-2);
        Assertions.assertEquals((int)25, (int)f.getNumerator());
        Assertions.assertEquals((int)9, (int)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)10);
        Assertions.assertEquals((Object)Fraction.ONE, (Object)f.pow(0));
        f = Fraction.getFraction((int)6, (int)10);
        Assertions.assertEquals((Object)f, (Object)f.pow(1));
        Assertions.assertNotEquals((Object)f.pow(1), (Object)Fraction.getFraction((int)3, (int)5));
        f = Fraction.getFraction((int)6, (int)10);
        f = f.pow(2);
        Assertions.assertEquals((int)9, (int)f.getNumerator());
        Assertions.assertEquals((int)25, (int)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)10);
        f = f.pow(3);
        Assertions.assertEquals((int)27, (int)f.getNumerator());
        Assertions.assertEquals((int)125, (int)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)10);
        f = f.pow(-1);
        Assertions.assertEquals((int)10, (int)f.getNumerator());
        Assertions.assertEquals((int)6, (int)f.getDenominator());
        f = Fraction.getFraction((int)6, (int)10);
        f = f.pow(-2);
        Assertions.assertEquals((int)25, (int)f.getNumerator());
        Assertions.assertEquals((int)9, (int)f.getDenominator());
        f = Fraction.getFraction((int)0, (int)1231);
        f = f.pow(1);
        Assertions.assertEquals((int)0, (int)f.compareTo(Fraction.ZERO));
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)1231, (int)f.getDenominator());
        f = f.pow(2);
        Assertions.assertEquals((int)0, (int)f.compareTo(Fraction.ZERO));
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        Fraction fr = f;
        Assertions.assertThrows(ArithmeticException.class, () -> fr.pow(-1));
        Assertions.assertThrows(ArithmeticException.class, () -> fr.pow(Integer.MIN_VALUE));
        f = Fraction.getFraction((int)1, (int)1);
        f = f.pow(0);
        Assertions.assertEquals((Object)f, (Object)Fraction.ONE);
        f = f.pow(1);
        Assertions.assertEquals((Object)f, (Object)Fraction.ONE);
        f = f.pow(-1);
        Assertions.assertEquals((Object)f, (Object)Fraction.ONE);
        f = f.pow(Integer.MAX_VALUE);
        Assertions.assertEquals((Object)f, (Object)Fraction.ONE);
        f = f.pow(Integer.MIN_VALUE);
        Assertions.assertEquals((Object)f, (Object)Fraction.ONE);
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)Integer.MAX_VALUE, (int)1).pow(2));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)Integer.MIN_VALUE, (int)1).pow(3));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)65536, (int)1).pow(2));
    }

    @Test
    public void testReduce() {
        Fraction f = Fraction.getFraction((int)50, (int)75);
        Fraction result = f.reduce();
        Assertions.assertEquals((int)2, (int)result.getNumerator());
        Assertions.assertEquals((int)3, (int)result.getDenominator());
        f = Fraction.getFraction((int)-2, (int)-3);
        result = f.reduce();
        Assertions.assertEquals((int)2, (int)result.getNumerator());
        Assertions.assertEquals((int)3, (int)result.getDenominator());
        f = Fraction.getFraction((int)2, (int)-3);
        result = f.reduce();
        Assertions.assertEquals((int)-2, (int)result.getNumerator());
        Assertions.assertEquals((int)3, (int)result.getDenominator());
        f = Fraction.getFraction((int)-2, (int)3);
        result = f.reduce();
        Assertions.assertEquals((int)-2, (int)result.getNumerator());
        Assertions.assertEquals((int)3, (int)result.getDenominator());
        Assertions.assertSame((Object)f, (Object)result);
        f = Fraction.getFraction((int)2, (int)3);
        result = f.reduce();
        Assertions.assertEquals((int)2, (int)result.getNumerator());
        Assertions.assertEquals((int)3, (int)result.getDenominator());
        Assertions.assertSame((Object)f, (Object)result);
        f = Fraction.getFraction((int)0, (int)1);
        result = f.reduce();
        Assertions.assertEquals((int)0, (int)result.getNumerator());
        Assertions.assertEquals((int)1, (int)result.getDenominator());
        Assertions.assertSame((Object)f, (Object)result);
        f = Fraction.getFraction((int)0, (int)100);
        result = f.reduce();
        Assertions.assertEquals((int)0, (int)result.getNumerator());
        Assertions.assertEquals((int)1, (int)result.getDenominator());
        Assertions.assertSame((Object)result, (Object)Fraction.ZERO);
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)2);
        result = f.reduce();
        Assertions.assertEquals((int)-1073741824, (int)result.getNumerator());
        Assertions.assertEquals((int)1, (int)result.getDenominator());
    }

    @Test
    public void testReducedFactory_int_int() {
        Fraction f = Fraction.getReducedFraction((int)0, (int)1);
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)1, (int)1);
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)2, (int)1);
        Assertions.assertEquals((int)2, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)22, (int)7);
        Assertions.assertEquals((int)22, (int)f.getNumerator());
        Assertions.assertEquals((int)7, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)-6, (int)10);
        Assertions.assertEquals((int)-3, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)6, (int)-10);
        Assertions.assertEquals((int)-3, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)-6, (int)-10);
        Assertions.assertEquals((int)3, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getReducedFraction((int)1, (int)0));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getReducedFraction((int)2, (int)0));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getReducedFraction((int)-3, (int)0));
        f = Fraction.getReducedFraction((int)0, (int)2);
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)2, (int)2);
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)2, (int)4);
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)15, (int)10);
        Assertions.assertEquals((int)3, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)121, (int)22);
        Assertions.assertEquals((int)11, (int)f.getNumerator());
        Assertions.assertEquals((int)2, (int)f.getDenominator());
        f = Fraction.getReducedFraction((int)-2, (int)Integer.MIN_VALUE);
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)0x40000000, (int)f.getDenominator());
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getReducedFraction((int)-7, (int)Integer.MIN_VALUE));
        f = Fraction.getReducedFraction((int)Integer.MIN_VALUE, (int)2);
        Assertions.assertEquals((int)-1073741824, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
    }

    @Test
    public void testSubtract() {
        Fraction f1 = Fraction.getFraction((int)3, (int)5);
        Fraction f2 = Fraction.getFraction((int)1, (int)5);
        Fraction f = f1.subtract(f2);
        Assertions.assertEquals((int)2, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)7, (int)5);
        f2 = Fraction.getFraction((int)2, (int)5);
        f = f1.subtract(f2);
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)3, (int)5);
        f = f1.subtract(f2);
        Assertions.assertEquals((int)0, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)-4, (int)5);
        f = f1.subtract(f2);
        Assertions.assertEquals((int)7, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)4, (int)5);
        f = f1.subtract(f2);
        Assertions.assertEquals((int)-4, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)-4, (int)5);
        f = f1.subtract(f2);
        Assertions.assertEquals((int)4, (int)f.getNumerator());
        Assertions.assertEquals((int)5, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)3, (int)5);
        f2 = Fraction.getFraction((int)1, (int)2);
        f = f1.subtract(f2);
        Assertions.assertEquals((int)1, (int)f.getNumerator());
        Assertions.assertEquals((int)10, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)0, (int)5);
        f2 = Fraction.getFraction((int)1, (int)5);
        f = f2.subtract(f1);
        Assertions.assertSame((Object)f2, (Object)f);
        Fraction fr = f;
        Assertions.assertThrows(NullPointerException.class, () -> fr.subtract(null));
        f1 = Fraction.getFraction((int)1, (int)98304);
        f2 = Fraction.getFraction((int)1, (int)59049);
        f = f1.subtract(f2);
        Assertions.assertEquals((int)-13085, (int)f.getNumerator());
        Assertions.assertEquals((int)1934917632, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MIN_VALUE, (int)3);
        f2 = Fraction.ONE_THIRD.negate();
        f = f1.subtract(f2);
        Assertions.assertEquals((int)-2147483647, (int)f.getNumerator());
        Assertions.assertEquals((int)3, (int)f.getDenominator());
        f1 = Fraction.getFraction((int)Integer.MAX_VALUE, (int)1);
        f2 = Fraction.ONE;
        f = f1.subtract(f2);
        Assertions.assertEquals((int)0x7FFFFFFE, (int)f.getNumerator());
        Assertions.assertEquals((int)1, (int)f.getDenominator());
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)1, (int)Integer.MAX_VALUE).subtract(Fraction.getFraction((int)1, (int)0x7FFFFFFE)));
        f = f1.subtract(f2);
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)Integer.MIN_VALUE, (int)5).subtract(Fraction.getFraction((int)1, (int)5)));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)Integer.MIN_VALUE, (int)1).subtract(Fraction.ONE));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)Integer.MAX_VALUE, (int)1).subtract(Fraction.ONE.negate()));
        Assertions.assertThrows(ArithmeticException.class, () -> Fraction.getFraction((int)3, (int)327680).subtract(Fraction.getFraction((int)2, (int)59049)));
    }

    @Test
    public void testToProperString() {
        Fraction f = Fraction.getFraction((int)3, (int)5);
        String str = f.toProperString();
        Assertions.assertEquals((Object)"3/5", (Object)str);
        Assertions.assertSame((Object)str, (Object)f.toProperString());
        f = Fraction.getFraction((int)7, (int)5);
        Assertions.assertEquals((Object)"1 2/5", (Object)f.toProperString());
        f = Fraction.getFraction((int)14, (int)10);
        Assertions.assertEquals((Object)"1 4/10", (Object)f.toProperString());
        f = Fraction.getFraction((int)4, (int)2);
        Assertions.assertEquals((Object)"2", (Object)f.toProperString());
        f = Fraction.getFraction((int)0, (int)2);
        Assertions.assertEquals((Object)"0", (Object)f.toProperString());
        f = Fraction.getFraction((int)2, (int)2);
        Assertions.assertEquals((Object)"1", (Object)f.toProperString());
        f = Fraction.getFraction((int)-7, (int)5);
        Assertions.assertEquals((Object)"-1 2/5", (Object)f.toProperString());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)0, (int)1);
        Assertions.assertEquals((Object)"-2147483648", (Object)f.toProperString());
        f = Fraction.getFraction((int)-1, (int)1, (int)Integer.MAX_VALUE);
        Assertions.assertEquals((Object)"-1 1/2147483647", (Object)f.toProperString());
        Assertions.assertEquals((Object)"-1", (Object)Fraction.getFraction((double)-1.0).toProperString());
    }

    @Test
    public void testToString() {
        Fraction f = Fraction.getFraction((int)3, (int)5);
        String str = f.toString();
        Assertions.assertEquals((Object)"3/5", (Object)str);
        Assertions.assertSame((Object)str, (Object)f.toString());
        f = Fraction.getFraction((int)7, (int)5);
        Assertions.assertEquals((Object)"7/5", (Object)f.toString());
        f = Fraction.getFraction((int)4, (int)2);
        Assertions.assertEquals((Object)"4/2", (Object)f.toString());
        f = Fraction.getFraction((int)0, (int)2);
        Assertions.assertEquals((Object)"0/2", (Object)f.toString());
        f = Fraction.getFraction((int)2, (int)2);
        Assertions.assertEquals((Object)"2/2", (Object)f.toString());
        f = Fraction.getFraction((int)Integer.MIN_VALUE, (int)0, (int)1);
        Assertions.assertEquals((Object)"-2147483648/1", (Object)f.toString());
        f = Fraction.getFraction((int)-1, (int)1, (int)Integer.MAX_VALUE);
        Assertions.assertEquals((Object)"-2147483648/2147483647", (Object)f.toString());
    }
}

