/* Copyright (c) 2020 Sultim Tsyrendashiev
This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as published by
the Free Software Foundation


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA. */

#include "Engine/StdH.h"
#include <Engine/Graphics/Vulkan/SvkMain.h>

#ifdef SE1_VULKAN

#pragma region Shaders
// these shaders were generated by a script
#include <Engine/Graphics/Vulkan/Shaders/Compiled/TexturedVertSpv.h>
#include <Engine/Graphics/Vulkan/Shaders/Compiled/TexturedFragSpv.h>
#include <Engine/Graphics/Vulkan/Shaders/Compiled/TexturedAlphaFragSpv.h>
#include <Engine/Graphics/Vulkan/Shaders/Compiled/OcclusionCheckVertSpv.h>
#include <Engine/Graphics/Vulkan/Shaders/Compiled/OcclusionCheckFragSpv.h>

extern unsigned char TexturedVert_Spirv[];
extern unsigned int TexturedVert_Size;
extern unsigned char TexturedFrag_Spirv[];
extern unsigned int TexturedFrag_Size;
extern unsigned char TexturedAlphaFrag_Spirv[];
extern unsigned int TexturedAlphaFrag_Size;
extern unsigned char OcclusionCheckVert_Spirv[];
extern unsigned int OcclusionCheckVert_Size;
extern unsigned char OcclusionCheckFrag_Spirv[];
extern unsigned int OcclusionCheckFrag_Size;
#pragma endregion

void SvkMain::CreateShaderModules()
{
  gl_VkShaderModuleVert = CreateShaderModule((uint32_t *)TexturedVert_Spirv, TexturedVert_Size);
  gl_VkShaderModuleFrag = CreateShaderModule((uint32_t *)TexturedFrag_Spirv, TexturedFrag_Size);
  gl_VkShaderModuleFragAlpha = CreateShaderModule((uint32_t *)TexturedAlphaFrag_Spirv, TexturedAlphaFrag_Size);
  gl_VkShaderModuleVertOcclusion = CreateShaderModule((uint32_t *)OcclusionCheckVert_Spirv, OcclusionCheckVert_Size);
  gl_VkShaderModuleFragOcclusion = CreateShaderModule((uint32_t *)OcclusionCheckFrag_Spirv, OcclusionCheckFrag_Size);
}

void SvkMain::DestroyShaderModules()
{
  vkDestroyShaderModule(gl_VkDevice, gl_VkShaderModuleVert, nullptr);
  vkDestroyShaderModule(gl_VkDevice, gl_VkShaderModuleFrag, nullptr);
  vkDestroyShaderModule(gl_VkDevice, gl_VkShaderModuleFragAlpha, nullptr);
  vkDestroyShaderModule(gl_VkDevice, gl_VkShaderModuleVertOcclusion, nullptr);
  vkDestroyShaderModule(gl_VkDevice, gl_VkShaderModuleFragOcclusion, nullptr);
}

#endif
