/*  $Id: lat_lon_water.inc 342047 2011-10-25 19:10:14Z kans $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Jonathan Kans et al.
 *
 * File Description:
 *   Built-in copy of lat_lon_water.txt.
 *
 */

static const char* const s_DefaultLatLonWaterText[] = {
    "- Made with Natural Earth.",
    "1",
    "Adriatic Sea",
    "	46	11	15",
    "	45	11	16",
    "	44	11	18",
    "	43	11	20",
    "	42	11	20",
    "	41	12	20",
    "	40	14	20",
    "	39	16	20",
    "	38	17	20",
    "Aegean Sea",
    "	41	21	27",
    "	40	21	27",
    "	39	21	28",
    "	38	21	29",
    "	37	21	29",
    "	36	23	29",
    "	35	23	29",
    "Albemarle Sound",
    "	37	-77	-74",
    "	36	-77	-74",
    "	35	-77	-74",
    "	34	-77	-74",
    "Alboran Sea",
    "	37	-6	-1",
    "	36	-6	0",
    "	35	-6	0",
    "	34	-6	0",
    "Amundsen Gulf",
    "	72	-126	-117",
    "	71	-128	-116",
    "	70	-128	-116",
    "	69	-128	-116",
    "	68	-127	-117",
    "Amundsen Sea",
    "	-71	-108	-101",
    "	-72	-115	-97",
    "	-73	-115	-97",
    "	-74	-115	-97",
    "	-75	-115	-97",
    "	-76	-112	-97",
    "Andaman Sea",
    "	17	93	96",
    "	16	92	97",
    "	15	91	99",
    "	14	91	99",
    "	13	91	99",
    "	12	91	99",
    "	11	91	99",
    "	10	91	99",
    "	9	91	99",
    "	8	91	99",
    "	7	91	99",
    "	6	92	99",
    "	5	92	98",
    "	4	94	96",
    "Antongila Bay",
    "	-14	48	51",
    "	-15	48	51",
    "	-16	48	51",
    "	-17	48	50",
    "Arabian Sea",
    "	26	60	67",
    "	25	59	68",
    "	24	59	69",
    "	23	58	70",
    "	22	57	71",
    "	21	57	72",
    "	20	56	74",
    "	19	55	74",
    "	18	53	74",
    "	17	51	74",
    "	16	50	74",
    "	15	50	75",
    "	14	50	75",
    "	13	50	75",
    "	12	50	74",
    "	11	50	72",
    "	10	50	72",
    "	9	50	72",
    "	8	52	72",
    "	7	54	73",
    "	6	56	73",
    "	5	58	73",
    "	4	60	73",
    "	3	63	73",
    "	2	65	73",
    "	1	67	74",
    "	0	69	74",
    "	-1	71	74",
    "Arafura Sea",
    "	-2	132	135",
    "	-3	132	138",
    "	-4	131	139",
    "	-5	131	139",
    "	-6	130	141",
    "	-7	129	141",
    "	-8	129	142",
    "	-9	129	143",
    "	-10	129	143",
    "	-11	130	143",
    "	-12	130	143",
    "	-13	133	142",
    "Aral Sea",
    "	47	58	62",
    "	46	57	62",
    "	45	57	62",
    "	44	57	61",
    "	43	57	61",
    "Arctic Ocean",
    "	90	-180	180",
    "	90	-180	180",
    "	89	-180	180",
    "	88	-180	180",
    "	87	-180	180",
    "	86	-180	180",
    "	85	-180	180",
    "	84	-180	180",
    "	83	-180	180",
    "	82	-180	180",
    "	81	-180	-69	-18	180",
    "	80	-180	-75	-4	180",
    "	79	-180	-75	10	50	100	180",
    "	78	-180	-99	-88	-79	108	180",
    "	77	-180	-107	117	180",
    "	76	-180	-112	125	180",
    "	75	-180	-119	133	148	157	180",
    "	74	-180	-125	161	180",
    "	73	-180	-132	165	180",
    "	72	-180	-138	169	180",
    "	71	-180	-145	173	180",
    "	70	-180	-152	177	180",
    "Atlantic Ocean",
    "	69	-33	-29",
    "	68	-34	-27",
    "	67	-39	-26",
    "	66	-42	-24",
    "	65	-42	-20	-17	-11",
    "	64	-43	-8",
    "	63	-43	-6",
    "	62	-43	-3",
    "	61	-44	0",
    "	60	-44	0",
    "	59	-45	0",
    "	58	-45	0",
    "	57	-46	-1",
    "	56	-47	-5",
    "	55	-48	-6",
    "	54	-48	-7",
    "	53	-49	-5",
    "	52	-50	-5",
    "	51	-51	-4",
    "	50	-51	-4",
    "	49	-52	-4",
    "	48	-56	-4",
    "	47	-60	-4",
    "	46	-62	-5",
    "	45	-65	-5",
    "	44	-66	-6",
    "	43	-68	-6",
    "	42	-74	-6",
    "	41	-75	-7",
    "	40	-75	-7",
    "	39	-76	-7",
    "	38	-76	-5",
    "	37	-77	-4",
    "	36	-77	-4",
    "	35	-78	-4",
    "	34	-80	-4",
    "	33	-81	-5",
    "	32	-82	-5",
    "	31	-82	-7",
    "	30	-82	-8",
    "	29	-82	-8",
    "	28	-82	-8",
    "	27	-81	-9",
    "	26	-81	-11",
    "	25	-81	-12",
    "	24	-81	-13",
    "	23	-81	-13",
    "	22	-81	-14",
    "	21	-81	-15",
    "	20	-78	-15",
    "	19	-76	-15",
    "	18	-74	-15",
    "	17	-69	-15",
    "	16	-62	-15",
    "	15	-61	-15",
    "	14	-61	-14",
    "	13	-60	-14",
    "	12	-61	-14",
    "	11	-61	-13",
    "	10	-62	-12",
    "	9	-62	-11",
    "	8	-62	-10",
    "	7	-61	-9",
    "	6	-59	-8",
    "	5	-59	-5",
    "	4	-58	-2",
    "	3	-53	2",
    "	2	-52	5",
    "	1	-51	7",
    "	0	-51	7",
    "	-1	-51	7",
    "Atlantic Ocean",
    "	1	-50	9",
    "	0	-50	10",
    "	-1	-50	11",
    "	-2	-47	12",
    "	-3	-44	13",
    "	-4	-40	14",
    "	-5	-39	14",
    "	-6	-37	14",
    "	-7	-36	14",
    "	-8	-36	14",
    "	-9	-37	14",
    "	-10	-38	14",
    "	-11	-39	14",
    "	-12	-40	14",
    "	-13	-40	14",
    "	-14	-40	13",
    "	-15	-40	13",
    "	-16	-40	13",
    "	-17	-40	13",
    "	-18	-41	13",
    "	-19	-41	14",
    "	-20	-42	14",
    "	-21	-45	15",
    "	-22	-46	15",
    "	-23	-48	15",
    "	-24	-49	15",
    "	-25	-49	16",
    "	-26	-49	16",
    "	-27	-50	17",
    "	-28	-51	17",
    "	-29	-51	18",
    "	-30	-52	19",
    "	-31	-53	19",
    "	-32	-54	19",
    "	-33	-55	20",
    "	-34	-56	20",
    "	-35	-57	20",
    "	-36	-58	20",
    "	-37	-62	20",
    "	-38	-63	20",
    "	-39	-63	20",
    "	-40	-64	20",
    "	-41	-66	20",
    "	-42	-66	20",
    "	-43	-66	20",
    "	-44	-66	20",
    "	-45	-66	20",
    "	-46	-67	20",
    "	-47	-68	20",
    "	-48	-68	20",
    "	-49	-68	20",
    "	-50	-69	20",
    "	-51	-69	20",
    "	-52	-69	20",
    "	-53	-70	20",
    "	-54	-70	20",
    "	-55	-70	20",
    "	-56	-69	20",
    "	-57	-69	20",
    "	-58	-69	20",
    "	-59	-69	20",
    "	-60	-69	20",
    "	-61	-69	20",
    "Bab el Mandeb",
    "	14	42	44",
    "	13	42	44",
    "	12	42	44",
    "	11	42	44",
    "Baffin Bay",
    "	79	-77	-71",
    "	78	-83	-70",
    "	77	-83	-66",
    "	76	-83	-61",
    "	75	-81	-55",
    "	74	-81	-54",
    "	73	-81	-53",
    "	72	-79	-53",
    "	71	-78	-53",
    "	70	-76	-53",
    "	69	-73	-53",
    "	68	-70	-53",
    "Bahia Blanca",
    "	-37	-63	-60",
    "	-38	-63	-60",
    "	-39	-63	-60",
    "	-40	-63	-60",
    "Bahia de Campeche",
    "	22	-94	-89",
    "	21	-98	-89",
    "	20	-98	-89",
    "	19	-98	-89",
    "	18	-97	-89",
    "	17	-96	-90",
    "Bahia Grande",
    "	-48	-69	-66",
    "	-49	-70	-66",
    "	-50	-70	-66",
    "	-51	-70	-66",
    "	-52	-70	-67",
    "	-53	-69	-67",
    "Bahia Inutil",
    "	-52	-71	-68",
    "	-53	-71	-68",
    "	-54	-71	-68",
    "	-55	-71	-68",
    "Baia de Maputo",
    "	-24	31	33",
    "	-25	31	33",
    "	-26	31	33",
    "	-27	31	33",
    "Baia de Marajo",
    "	1	-49	-47",
    "	0	-50	-47",
    "	-1	-50	-47",
    "	-2	-50	-47",
    "	-3	-50	-48",
    "Baia de Sao Marcos",
    "	0	-45	-43",
    "	-1	-45	-42",
    "	-2	-45	-42",
    "	-3	-45	-42",
    "	-4	-45	-43",
    "Baird Inlet",
    "	61	-165	-162",
    "	60	-165	-162",
    "	59	-165	-162",
    "Balearic Sea",
    "	42	0	4",
    "	41	-1	5",
    "	40	-1	5",
    "	39	-1	5",
    "	38	-1	5",
    "	37	-1	3",
    "Bali Sea",
    "	-5	114	117",
    "	-6	113	118",
    "	-7	113	118",
    "	-8	113	118",
    "	-9	113	118",
    "	-10	115	117",
    "Baltic Sea",
    "	60	16	24",
    "	59	15	24",
    "	58	15	24",
    "	57	13	23",
    "	56	11	23",
    "	55	11	22",
    "	54	11	22",
    "	53	11	21",
    "	52	13	15",
    "Banda Sea",
    "	1	121	124",
    "	0	120	126",
    "	-1	119	129",
    "	-2	119	131",
    "	-3	119	133",
    "	-4	119	134",
    "	-5	119	134",
    "	-6	119	134",
    "	-7	119	133",
    "	-8	119	132",
    "	-9	121	132",
    "Barents Sea",
    "	82	49	66",
    "	81	16	19	26	66",
    "	80	16	67",
    "	79	16	67",
    "	78	16	68",
    "	77	16	69",
    "	76	16	69",
    "	75	16	69",
    "	74	18	61",
    "	73	20	57",
    "	72	22	55",
    "	71	24	59",
    "	70	26	61",
    "	69	26	61",
    "	68	28	61",
    "	67	36	61",
    "	66	43	50",
    "	65	44	48",
    "Bass Strait",
    "	-36	143	150",
    "	-37	142	150",
    "	-38	142	150",
    "	-39	142	149",
    "	-40	142	149",
    "	-41	142	149",
    "	-42	144	148",
    "Bathurst Inlet",
    "	68	-109	-106",
    "	67	-109	-106",
    "	66	-109	-106",
    "	65	-109	-106",
    "Bay of Bengal",
    "	24	89	91",
    "	23	86	92",
    "	22	85	93",
    "	21	85	94",
    "	20	83	95",
    "	19	82	95",
    "	18	81	95",
    "	17	80	95",
    "	16	79	95",
    "	15	79	95",
    "	14	79	94",
    "	13	78	93",
    "	12	78	93",
    "	11	78	93",
    "	10	78	93",
    "	9	78	93",
    "	8	79	94",
    "	7	79	95",
    "	6	80	96",
    "	5	84	96",
    "	4	91	96",
    "Bay of Biscay",
    "	49	-6	-3",
    "	48	-7	0",
    "	47	-7	0",
    "	46	-8	1",
    "	45	-8	1",
    "	44	-9	1",
    "	43	-9	0",
    "	42	-9	0",
    "Bay of Fundy",
    "	46	-68	-62",
    "	45	-68	-62",
    "	44	-68	-62",
    "	43	-68	-64",
    "Bay of Plenty",
    "	-35	174	177",
    "	-36	174	179",
    "	-37	174	179",
    "	-38	174	179",
    "Beaufort Sea",
    "	77	-126	-121",
    "	76	-133	-121",
    "	75	-139	-121",
    "	74	-146	-122",
    "	73	-153	-122",
    "	72	-157	-122",
    "	71	-157	-123",
    "	70	-157	-124",
    "	69	-157	-125",
    "	68	-145	-127",
    "Bellingshausen Sea",
    "	-67	-74	-70",
    "	-68	-80	-70",
    "	-69	-86	-68",
    "	-70	-92	-68",
    "	-71	-96	-68",
    "	-72	-96	-68",
    "	-73	-96	-73",
    "	-74	-96	-73",
    "Bering Sea",
    "	67	-171	-168",
    "	66	-173	-165",
    "	65	-175	-163",
    "	64	-177	-163",
    "	63	-179	-163	174	180",
    "	62	-180	-163	171	180",
    "	61	-180	-160	165	180",
    "	60	-180	-160	165	180",
    "	59	-180	-160	163	180",
    "	58	-180	-160	161	180",
    "	57	-180	-160	161	180",
    "	56	-180	-160	161	180",
    "	55	-180	-160	161	180",
    "	54	-180	-160	163	180",
    "	53	-180	-161	165	180",
    "	52	-180	-163	167	180",
    "	51	-180	-166	169	180",
    "	50	-180	-171	171	180",
    "	49	178	180",
    "Bering Strait",
    "	67	-171	-168",
    "	66	-171	-166",
    "	65	-171	-166",
    "	64	-171	-166",
    "Bight of Benin",
    "	7	0	5",
    "	6	-1	6",
    "	5	-1	6",
    "	4	-1	6",
    "	3	2	6",
    "Bight of Biafra",
    "	5	5	10",
    "	4	5	10",
    "	3	5	10",
    "	2	7	10",
    "	1	8	10",
    "Bismarck Sea",
    "	0	141	148",
    "	-1	140	152",
    "	-2	140	153",
    "	-3	140	153",
    "	-4	141	153",
    "	-5	143	153",
    "	-6	144	152",
    "Black Sea",
    "	48	30	32",
    "	47	29	34",
    "	46	28	37",
    "	45	27	39",
    "	44	26	41",
    "	43	26	42",
    "	42	26	42",
    "	41	26	42",
    "	40	26	42",
    "	39	37	41",
    "Bo Hai",
    "	41	119	123",
    "	40	116	123",
    "	39	116	123",
    "	38	116	122",
    "	37	116	122",
    "	36	117	121",
    "Boca Grande",
    "	10	-62	-59",
    "	9	-62	-59",
    "	8	-62	-59",
    "	7	-62	-59",
    "Bohol Sea",
    "	11	122	126",
    "	10	122	126",
    "	9	122	126",
    "	8	122	126",
    "	7	122	126",
    "Boknafjorden",
    "	60	4	7",
    "	59	4	7",
    "	58	4	7",
    "	57	4	7",
    "Bosporus",
    "	42	27	30",
    "	41	27	30",
    "	40	27	30",
    "Bransfield Strait",
    "	-60	-58	-53",
    "	-61	-63	-53",
    "	-62	-63	-53",
    "	-63	-64	-53",
    "	-64	-64	-54",
    "	-65	-64	-59",
    "	-66	-64	-62",
    "Bristol Bay",
    "	60	-161	-155",
    "	59	-163	-155",
    "	58	-163	-155",
    "	57	-163	-155",
    "	56	-163	-156",
    "	55	-162	-157",
    "	54	-162	-159",
    "Bristol Channel",
    "	52	-7	-1",
    "	51	-7	-1",
    "	50	-7	-1",
    "	49	-6	-3",
    "Caribbean Sea",
    "	23	-84	-79",
    "	22	-88	-77",
    "	21	-88	-73",
    "	20	-88	-71",
    "	19	-89	-60",
    "	18	-89	-60",
    "	17	-89	-59",
    "	16	-89	-59",
    "	15	-88	-58",
    "	14	-87	-58",
    "	13	-84	-58",
    "	12	-84	-58",
    "	11	-84	-58",
    "	10	-84	-59",
    "	9	-84	-59",
    "	8	-84	-74	-63	-59",
    "	7	-83	-75",
    "Caspian Sea",
    "	48	49	52",
    "	47	47	54",
    "	46	46	54",
    "	45	45	54",
    "	44	45	54",
    "	43	45	53",
    "	42	46	53",
    "	41	46	53",
    "	40	47	54",
    "	39	47	54",
    "	38	47	54",
    "	37	47	55",
    "	36	47	55",
    "	35	49	55",
    "Celebes Sea",
    "	8	121	125",
    "	7	120	126",
    "	6	117	126",
    "	5	116	126",
    "	4	116	126",
    "	3	116	126",
    "	2	116	126",
    "	1	116	126",
    "	0	116	126",
    "	-1	117	124",
    "Ceram Sea",
    "	0	124	133",
    "	-1	124	134",
    "	-2	124	134",
    "	-3	124	134",
    "	-4	124	126	129	134",
    "	-5	130	134",
    "	-6	132	134",
    "Chaun Bay",
    "	70	167	171",
    "	69	167	171",
    "	68	167	171",
    "	67	168	171",
    "Chesapeake Bay",
    "	40	-77	-74",
    "	39	-78	-74",
    "	38	-78	-74",
    "	37	-78	-74",
    "	36	-78	-74",
    "	35	-77	-75",
    "Chukchi Sea",
    "	72	-179	-155	177	179",
    "	71	-180	-155	175	180",
    "	70	-180	-155	174	180",
    "	69	-180	-156	174	180",
    "	68	-180	-161	174	180",
    "	67	-180	-162	179	180",
    "	66	-176	-162",
    "	65	-175	-163",
    "	64	-169	-165",
    "Cook Inlet",
    "	62	-152	-148",
    "	61	-154	-148",
    "	60	-155	-148",
    "	59	-155	-148",
    "	58	-155	-150",
    "	57	-154	-151",
    "Cook Strait",
    "	-39	173	176",
    "	-40	173	176",
    "	-41	173	176",
    "	-42	173	176",
    "Coral Sea",
    "	-7	142	147",
    "	-8	141	148	164	168",
    "	-9	141	153	161	168",
    "	-10	141	168",
    "	-11	141	168",
    "	-12	141	168",
    "	-13	142	169",
    "	-14	142	169",
    "	-15	142	169",
    "	-16	144	169",
    "	-17	144	170",
    "	-18	144	170",
    "	-19	145	170",
    "	-20	145	170",
    "	-21	147	170",
    "	-22	148	169",
    "	-23	148	168",
    "	-24	149	167",
    "	-25	150	166",
    "	-26	151	165",
    "	-27	152	164",
    "	-28	152	162",
    "	-29	152	161",
    "	-30	152	160",
    "Cordova Bay",
    "	56	-134	-131",
    "	55	-134	-131",
    "	54	-134	-131",
    "	53	-133	-131",
    "Cumberland Sound",
    "	67	-69	-63",
    "	66	-69	-62",
    "	65	-69	-62",
    "	64	-69	-62",
    "	63	-67	-62",
    "	62	-65	-63",
    "Dardanelles",
    "	41	25	27",
    "	40	25	27",
    "	39	25	27",
    "	38	25	27",
    "Darnley Bay",
    "	70	-125	-122",
    "	69	-125	-122",
    "	68	-125	-122",
    "Davao Gulf",
    "	8	124	126",
    "	7	124	127",
    "	6	124	127",
    "	5	124	127",
    "	4	124	126",
    "Davis Sea",
    "	-62	90	104",
    "	-63	86	111",
    "	-64	84	113",
    "	-65	83	113",
    "	-66	82	113",
    "	-67	82	111",
    "	-68	82	87",
    "Davis Strait",
    "	70	-70	-52",
    "	69	-70	-50",
    "	68	-70	-49",
    "	67	-70	-49",
    "	66	-67	-49",
    "	65	-64	-49",
    "	64	-66	-48",
    "	63	-66	-47",
    "	62	-66	-44",
    "	61	-66	-43",
    "	60	-65	-43",
    "	59	-65	-43",
    "Delaware Bay",
    "	40	-76	-73",
    "	39	-76	-73",
    "	38	-76	-73",
    "	37	-76	-73",
    "Denmark Strait",
    "	71	-23	-21",
    "	70	-26	-19",
    "	69	-31	-18",
    "	68	-31	-16",
    "	67	-31	-15",
    "	66	-30	-15",
    "	65	-28	-15",
    "	64	-27	-16",
    "	63	-25	-22",
    "Disko Bay",
    "	71	-55	-49",
    "	70	-55	-49",
    "	69	-55	-49",
    "	68	-54	-49",
    "	67	-54	-49",
    "Dixon Entrance",
    "	55	-134	-130",
    "	54	-134	-130",
    "	53	-134	-130",
    "Dmitriy Laptev Strait",
    "	74	138	144",
    "	73	138	144",
    "	72	138	144",
    "	71	139	144",
    "Drake Passage",
    "	-53	-67	-62",
    "	-54	-69	-61",
    "	-55	-69	-60",
    "	-56	-69	-58",
    "	-57	-69	-57",
    "	-58	-69	-56",
    "	-59	-69	-55",
    "	-60	-69	-54",
    "	-61	-69	-54",
    "	-62	-69	-54",
    "	-63	-69	-57",
    "	-64	-69	-61",
    "	-65	-69	-62",
    "	-66	-69	-64",
    "	-67	-69	-65",
    "East China Sea",
    "	34	124	127	129	131",
    "	33	122	131",
    "	32	120	131",
    "	31	120	131",
    "	30	120	131",
    "	29	119	131",
    "	28	119	131",
    "	27	118	130",
    "	26	118	129",
    "	25	118	129",
    "	24	118	128",
    "	23	120	127",
    "	22	122	125",
    "East Korea Bay",
    "	41	127	129",
    "	40	126	129",
    "	39	126	129",
    "	38	126	129",
    "	37	126	129",
    "East Siberian Sea",
    "	78	147	158",
    "	77	137	162",
    "	76	137	166",
    "	75	137	170",
    "	74	138	174",
    "	73	138	178",
    "	72	138	180",
    "	71	142	180",
    "	70	147	180",
    "	69	150	155	157	178",
    "	68	158	176",
    "	67	159	162",
    "Eclipse Sound",
    "	74	-81	-79",
    "	73	-82	-76",
    "	72	-82	-76",
    "	71	-82	-76",
    "	70	-81	-77",
    "English Channel",
    "	52	0	2",
    "	51	-6	2",
    "	50	-7	2",
    "	49	-7	2",
    "	48	-7	2",
    "	47	-6	0",
    "Eskimo Lakes",
    "	70	-134	-130",
    "	69	-134	-130",
    "	68	-134	-130",
    "	67	-134	-131",
    "Estrecho de Magellanes",
    "	-51	-75	-67",
    "	-52	-75	-67",
    "	-53	-75	-67",
    "	-54	-74	-69",
    "	-55	-72	-69",
    "Finger Lakes",
    "	43	-78	-75",
    "	42	-78	-75",
    "	41	-78	-75",
    "Flores Sea",
    "	-4	118	121",
    "	-5	117	121",
    "	-6	116	122",
    "	-7	116	123",
    "	-8	116	123",
    "	-9	116	123",
    "Foxe Basin",
    "	71	-80	-76",
    "	70	-83	-73",
    "	69	-83	-72",
    "	68	-85	-71",
    "	67	-87	-71",
    "	66	-87	-71",
    "	65	-87	-71",
    "	64	-86	-72",
    "	63	-84	-74",
    "	62	-81	-78",
    "Franklin Bay",
    "	70	-126	-124",
    "	69	-126	-124",
    "	68	-126	-124",
    "Frobisher Bay",
    "	64	-69	-64",
    "	63	-69	-64",
    "	62	-69	-64",
    "	61	-68	-64",
    "Fury and Hecla Strait",
    "	71	-86	-82",
    "	70	-86	-81",
    "	69	-86	-81",
    "	68	-86	-81",
    "Garabogaz Bay",
    "	43	52	54",
    "	42	51	55",
    "	41	51	55",
    "	40	51	55",
    "	39	51	55",
    "Geographe Bay",
    "	-29	114	116",
    "	-30	114	116",
    "	-31	114	116",
    "	-32	114	116",
    "	-33	114	116",
    "	-34	114	116",
    "George VI Sound",
    "	-68	-70	-67",
    "	-69	-70	-66",
    "	-70	-74	-65",
    "	-71	-75	-65",
    "	-72	-75	-65",
    "	-73	-75	-65",
    "	-74	-75	-67",
    "Goldsmith Channel",
    "	74	-108	-104",
    "	73	-108	-104",
    "	72	-108	-104",
    "	71	-106	-104",
    "Golfe du Lion",
    "	44	2	6",
    "	43	2	6",
    "	42	2	6",
    "	41	2	5",
    "	40	2	4",
    "Golfo Corcovado",
    "	-40	-74	-71",
    "	-41	-74	-71",
    "	-42	-74	-71",
    "	-43	-75	-71",
    "	-44	-75	-71",
    "	-45	-75	-71",
    "	-46	-74	-71",
    "Golfo de California",
    "	32	-115	-112",
    "	31	-115	-111",
    "	30	-115	-111",
    "	29	-115	-110",
    "	28	-115	-108",
    "	27	-114	-108",
    "	26	-113	-107",
    "	25	-113	-106",
    "	24	-112	-105",
    "	23	-111	-105",
    "	22	-110	-105",
    "Golfo de Guayaquil",
    "	-1	-81	-78",
    "	-2	-81	-78",
    "	-3	-81	-78",
    "	-4	-81	-78",
    "Golfo de Panama",
    "	10	-80	-78",
    "	9	-81	-76",
    "	8	-81	-76",
    "	7	-81	-76",
    "	6	-81	-77",
    "Golfo de Penas",
    "	-45	-76	-73",
    "	-46	-76	-73",
    "	-47	-76	-73",
    "	-48	-76	-73",
    "Golfo de Tehuantepec",
    "	17	-96	-92",
    "	16	-97	-92",
    "	15	-97	-92",
    "	14	-97	-92",
    "Golfo de Uraba",
    "	9	-78	-75",
    "	8	-78	-75",
    "	7	-78	-75",
    "	6	-77	-75",
    "Golfo San Jorge",
    "	-43	-67	-65",
    "	-44	-68	-64",
    "	-45	-68	-64",
    "	-46	-68	-64",
    "	-47	-68	-64",
    "	-48	-67	-64",
    "Golfo San Matias",
    "	-39	-66	-63",
    "	-40	-66	-62",
    "	-41	-66	-62",
    "	-42	-66	-62",
    "	-43	-65	-62",
    "Great Australian Bight",
    "	-30	127	133",
    "	-31	123	135",
    "	-32	118	136",
    "	-33	117	136",
    "	-34	117	140",
    "	-35	117	140",
    "	-36	117	141",
    "	-37	119	144",
    "	-38	123	144",
    "	-39	126	145",
    "	-40	129	146",
    "	-41	133	146",
    "	-42	136	147",
    "	-43	139	147",
    "	-44	143	147",
    "Great Barrier Reef",
    "	-8	141	146",
    "	-9	141	146",
    "	-10	141	146",
    "	-11	141	146",
    "	-12	141	147",
    "	-13	142	148",
    "	-14	142	148",
    "	-15	142	148",
    "	-16	144	149",
    "	-17	144	150",
    "	-18	144	151",
    "	-19	145	151",
    "	-20	145	152",
    "	-21	147	154",
    "	-22	148	154",
    "	-23	148	154",
    "	-24	149	154",
    "	-25	150	154",
    "	-26	151	154",
    "Great Bear Lake",
    "	68	-121	-118",
    "	67	-126	-116",
    "	66	-126	-116",
    "	65	-126	-116",
    "	64	-125	-116",
    "	63	-123	-119",
    "Great Salt Lake",
    "	42	-114	-110",
    "	41	-114	-110",
    "	40	-114	-110",
    "	39	-113	-110",
    "Great Slave Lake",
    "	63	-117	-108",
    "	62	-118	-108",
    "	61	-118	-108",
    "	60	-118	-110",
    "	59	-117	-113",
    "Greenland Sea",
    "	84	-32	-17",
    "	83	-33	-3",
    "	82	-33	11",
    "	81	-33	18",
    "	80	-30	-27	-25	18",
    "	79	-24	18",
    "	78	-22	18",
    "	77	-23	18",
    "	76	-23	18",
    "	75	-23	17",
    "	74	-28	14",
    "	73	-28	10",
    "	72	-28	5",
    "	71	-27	0",
    "	70	-26	-4",
    "	69	-29	-7",
    "	68	-29	-9",
    "	67	-29	-10",
    "	66	-27	-10",
    "	65	-25	-11",
    "	64	-24	-12",
    "Guba Gusinaya",
    "	73	144	148",
    "	72	143	148",
    "	71	143	148",
    "	70	143	147",
    "Gulf of Aden",
    "	16	49	52",
    "	15	46	52",
    "	14	44	52",
    "	13	42	52",
    "	12	41	52",
    "	11	41	52",
    "	10	41	52",
    "	9	42	47",
    "Gulf of Alaska",
    "	61	-150	-138",
    "	60	-152	-137",
    "	59	-156	-135",
    "	58	-157	-135",
    "	57	-159	-135",
    "	56	-164	-139",
    "	55	-164	-145",
    "	54	-164	-152",
    "	53	-164	-158",
    "Gulf of Anadyr",
    "	67	-180	-177",
    "	66	-180	-174",
    "	65	-180	-172",
    "	64	-180	-172",
    "	63	-180	-172",
    "	62	-180	-174",
    "	61	-180	-176",
    "	60	-180	-178",
    "Gulf of Anadyr",
    "	66	175	180",
    "	65	173	180",
    "	64	173	180",
    "	63	173	180",
    "	62	177	180",
    "	61	178	180",
    "Gulf of Aqaba",
    "	30	33	35",
    "	29	33	35",
    "	28	33	35",
    "	27	33	35",
    "	26	33	35",
    "Gulf of Boothia",
    "	72	-90	-88",
    "	71	-93	-84",
    "	70	-93	-83",
    "	69	-93	-83",
    "	68	-93	-83",
    "	67	-91	-83",
    "	66	-89	-85",
    "Gulf of Bothnia",
    "	66	20	26",
    "	65	20	26",
    "	64	17	26",
    "	63	16	26",
    "	62	16	24",
    "	61	16	24",
    "	60	16	24",
    "	59	16	24",
    "	58	17	24",
    "Gulf of Buli",
    "	2	127	130",
    "	1	127	130",
    "	0	127	130",
    "	-1	127	130",
    "Gulf of Carpentaria",
    "	-11	135	142",
    "	-12	134	142",
    "	-13	134	142",
    "	-14	134	142",
    "	-15	134	142",
    "	-16	134	142",
    "	-17	136	142",
    "	-18	138	141",
    "Gulf of Finland",
    "	61	23	31",
    "	60	21	31",
    "	59	21	31",
    "	58	21	31",
    "Gulf of Gabes",
    "	36	9	12",
    "	35	9	12",
    "	34	9	12",
    "	33	9	12",
    "	32	9	11",
    "Gulf of Guinea",
    "	6	-6	3",
    "	5	-8	8",
    "	4	-8	9",
    "	3	-8	10",
    "	2	-6	10",
    "	1	-3	11",
    "	0	1	11",
    "	-1	4	11",
    "Gulf of Honduras",
    "	18	-89	-87",
    "	17	-89	-86",
    "	16	-89	-85",
    "	15	-89	-85",
    "	14	-89	-85",
    "Gulf of Kamchatka",
    "	57	161	164",
    "	56	160	164",
    "	55	160	164",
    "	54	160	164",
    "	53	160	163",
    "Gulf of Kau",
    "	3	127	129",
    "	2	126	130",
    "	1	126	130",
    "	0	126	130",
    "	-1	126	128",
    "Gulf of Khambhat",
    "	23	71	73",
    "	22	71	74",
    "	21	69	74",
    "	20	69	74",
    "	19	69	73",
    "	18	71	73",
    "Gulf of Kutch",
    "	24	67	71",
    "	23	67	71",
    "	22	67	71",
    "	21	67	71",
    "Gulf of Maine",
    "	45	-70	-65",
    "	44	-71	-64",
    "	43	-71	-64",
    "	42	-71	-64",
    "	41	-71	-65",
    "	40	-70	-67",
    "Gulf of Mannar",
    "	10	77	80",
    "	9	76	80",
    "	8	76	80",
    "	7	76	80",
    "	6	78	80",
    "Gulf of Martaban",
    "	18	95	98",
    "	17	94	98",
    "	16	94	98",
    "	15	94	98",
    "	14	94	98",
    "	13	96	98",
    "Gulf of Masira",
    "	21	56	59",
    "	20	56	59",
    "	19	56	59",
    "	18	56	58",
    "Gulf of Mexico",
    "	31	-90	-83",
    "	30	-96	-81",
    "	29	-98	-81",
    "	28	-98	-81",
    "	27	-98	-80",
    "	26	-98	-79",
    "	25	-98	-78",
    "	24	-98	-78",
    "	23	-98	-78",
    "	22	-98	-82",
    "	21	-98	-82",
    "	20	-98	-83",
    "	19	-98	-93",
    "Gulf of Ob",
    "	73	71	76",
    "	72	70	76",
    "	71	70	76",
    "	70	70	77",
    "	69	71	78",
    "	68	70	79",
    "	67	68	79",
    "	66	68	79",
    "	65	68	74",
    "Gulf of Olenek",
    "	74	117	124",
    "	73	117	124",
    "	72	117	124",
    "	71	118	124",
    "Gulf of Oman",
    "	27	55	58",
    "	26	55	62",
    "	25	55	62",
    "	24	55	62",
    "	23	55	61",
    "	22	56	61",
    "	21	58	60",
    "Gulf of Papua",
    "	-6	142	146",
    "	-7	141	147",
    "	-8	141	147",
    "	-9	141	147",
    "Gulf of Riga",
    "	60	22	24",
    "	59	21	25",
    "	58	20	25",
    "	57	20	25",
    "	56	20	25",
    "	55	22	24",
    "Gulf of Sakhalin",
    "	55	138	143",
    "	54	138	143",
    "	53	138	143",
    "	52	139	143",
    "Gulf of Sidra",
    "	33	14	20",
    "	32	14	21",
    "	31	14	21",
    "	30	14	21",
    "	29	16	21",
    "Gulf of St. Lawrence",
    "	52	-59	-55",
    "	51	-65	-55",
    "	50	-65	-55",
    "	49	-67	-56",
    "	48	-67	-53",
    "	47	-67	-53",
    "	46	-67	-53",
    "	45	-65	-54",
    "	44	-64	-60",
    "Gulf of Suez",
    "	30	31	34",
    "	29	31	34",
    "	28	31	35",
    "	27	31	35",
    "	26	32	35",
    "Gulf of Thailand",
    "	14	98	101",
    "	13	98	103",
    "	12	98	104",
    "	11	98	106",
    "	10	98	106",
    "	9	98	106",
    "	8	98	106",
    "	7	98	105",
    "	6	99	104",
    "	5	99	103",
    "Gulf of Tomini",
    "	1	119	124",
    "	0	119	124",
    "	-1	119	124",
    "	-2	119	122",
    "Gulf of Tonkin",
    "	22	105	110",
    "	21	105	111",
    "	20	104	111",
    "	19	104	111",
    "	18	104	111",
    "	17	104	109",
    "	16	105	108",
    "Gulf of Yana",
    "	76	135	138",
    "	75	135	141",
    "	74	135	141",
    "	73	133	142",
    "	72	131	142",
    "	71	131	142",
    "	70	131	140",
    "Gulf St. Vincent",
    "	-31	136	138",
    "	-32	135	138",
    "	-33	134	139",
    "	-34	134	139",
    "	-35	134	139",
    "	-36	135	139",
    "Hadley Bay",
    "	74	-109	-107",
    "	73	-109	-106",
    "	72	-109	-106",
    "	71	-109	-106",
    "	70	-109	-106",
    "Hall Basin",
    "	83	-63	-61",
    "	82	-69	-60",
    "	81	-69	-60",
    "	80	-69	-60",
    "	79	-64	-62",
    "Halmahera Sea",
    "	1	126	131",
    "	0	126	132",
    "	-1	126	132",
    "	-2	126	132",
    "Hamilton Inlet",
    "	55	-59	-56",
    "	54	-61	-56",
    "	53	-61	-56",
    "	52	-61	-57",
    "Hangzhou Bay",
    "	31	119	123",
    "	30	119	123",
    "	29	119	123",
    "	28	120	123",
    "Hecate Straight",
    "	56	-133	-129",
    "	55	-133	-128",
    "	54	-133	-128",
    "	53	-133	-128",
    "	52	-133	-128",
    "	51	-132	-129",
    "Hudson Bay",
    "	67	-87	-84",
    "	66	-88	-84",
    "	65	-94	-81",
    "	64	-94	-78",
    "	63	-94	-77",
    "	62	-95	-76",
    "	61	-95	-76",
    "	60	-95	-76",
    "	59	-95	-76",
    "	58	-95	-75",
    "	57	-95	-75",
    "	56	-93	-75",
    "	55	-93	-75",
    "	54	-88	-75",
    "	53	-83	-77",
    "Hudson Strait",
    "	65	-79	-71",
    "	64	-81	-69",
    "	63	-81	-64",
    "	62	-81	-63",
    "	61	-79	-63",
    "	60	-73	-63",
    "	59	-71	-63",
    "IJsselmeer",
    "	54	4	6",
    "	53	3	6",
    "	52	3	6",
    "	51	3	6",
    "Indian Ocean",
    "	11	49	53",
    "	10	49	55",
    "	9	49	57",
    "	8	48	59	80	85",
    "	7	48	61	79	92",
    "	6	47	64	78	96",
    "	5	46	66	77	97",
    "	4	45	68	75	98",
    "	3	44	70	74	99",
    "	2	43	99",
    "	1	40	101",
    "	0	39	101",
    "	-1	39	102",
    "	-2	38	103",
    "	-3	38	104",
    "	-4	37	105",
    "	-5	37	107",
    "	-6	37	111",
    "	-7	37	119",
    "	-8	38	120",
    "	-9	38	123",
    "	-10	38	125",
    "	-11	38	126",
    "	-12	43	127",
    "	-13	48	127",
    "	-14	48	127",
    "	-15	48	127",
    "	-16	48	126",
    "	-17	48	125",
    "	-18	47	124",
    "	-19	47	123",
    "	-20	47	122",
    "	-21	46	120",
    "	-22	46	117",
    "	-23	46	115",
    "	-24	38	114",
    "	-25	31	114",
    "	-26	31	115",
    "	-27	30	115",
    "	-28	30	115",
    "	-29	29	116",
    "	-30	28	116",
    "	-31	27	116",
    "	-32	22	116",
    "	-33	18	117",
    "	-34	18	120",
    "	-35	18	124",
    "	-36	18	127",
    "	-37	18	130",
    "	-38	18	134",
    "	-39	18	137",
    "	-40	18	140",
    "	-41	18	144",
    "	-42	18	148",
    "	-43	18	151",
    "	-44	18	153",
    "	-45	18	156",
    "	-46	18	159",
    "	-47	18	161",
    "	-48	18	164",
    "	-49	18	167",
    "	-50	18	167",
    "	-51	18	167",
    "	-52	18	167",
    "	-53	18	167",
    "	-54	18	167",
    "	-55	18	167",
    "	-56	18	167",
    "	-57	18	167",
    "	-58	18	167",
    "	-59	18	167",
    "	-60	18	167",
    "	-61	18	167",
    "Inner Sea",
    "	35	129	136",
    "	34	129	136",
    "	33	129	136",
    "	32	129	136",
    "	31	130	133",
    "Inner Seas",
    "	59	-7	-4",
    "	58	-8	-4",
    "	57	-8	-3",
    "	56	-9	-3",
    "	55	-9	-3",
    "	54	-9	-3",
    "	53	-8	-4",
    "Internal Canada (B.C.) Waters",
    "	54	-130	-126",
    "	53	-130	-126",
    "	52	-130	-126",
    "	51	-130	-126",
    "Internal Canada (B.C.) Waters",
    "	55	-133	-131",
    "	54	-133	-131",
    "	53	-133	-131",
    "	52	-133	-131",
    "Internal Canada (B.C.) Waters",
    "	56	-131	-128",
    "	55	-131	-128",
    "	54	-131	-128",
    "	53	-131	-129",
    "Internal Canada Arctic Waters",
    "	72	-119	-116",
    "	71	-119	-116",
    "	70	-119	-116",
    "Internal Canada Arctic Waters",
    "	69	-108	-104",
    "	68	-108	-104",
    "	67	-108	-104",
    "Internal Canada Arctic Waters",
    "	71	-82	-79",
    "	70	-82	-78",
    "	69	-82	-78",
    "	68	-82	-78",
    "Internal Denmark Waters",
    "	57	9	11",
    "	56	8	12",
    "	55	8	12",
    "	54	8	12",
    "	53	8	12",
    "Internal Philippines Waters",
    "	11	124	127",
    "	10	124	127",
    "	9	124	127",
    "	8	124	127",
    "Internal Philippines Waters",
    "	11	122	124",
    "	10	122	124",
    "	9	122	124",
    "	8	122	124",
    "Internal U.S. (Alaska) Waters",
    "	60	-138	-134",
    "	59	-138	-132",
    "	58	-138	-131",
    "	57	-138	-130",
    "	56	-136	-129",
    "	55	-135	-129",
    "	54	-134	-129",
    "Ionian Sea",
    "	41	15	18",
    "	40	15	22",
    "	39	14	24",
    "	38	14	24",
    "	37	14	24",
    "	36	14	23",
    "	35	14	23",
    "Irish Sea",
    "	55	-7	-1",
    "	54	-7	-1",
    "	53	-7	-1",
    "	52	-7	-1",
    "	51	-7	-2",
    "	50	-7	-4",
    "James Bay",
    "	55	-83	-77",
    "	54	-83	-77",
    "	53	-83	-77",
    "	52	-83	-77",
    "	51	-83	-77",
    "	50	-81	-77",
    "	49	-80	-78",
    "Java Sea",
    "	-1	105	114",
    "	-2	104	117",
    "	-3	104	119",
    "	-4	103	120",
    "	-5	103	120",
    "	-6	103	120",
    "	-7	104	119",
    "	-8	111	118",
    "Jones Sound",
    "	77	-92	-77",
    "	76	-92	-77",
    "	75	-92	-77",
    "	74	-91	-78",
    "Joseph Bonaparte Gulf",
    "	-12	126	130",
    "	-13	126	130",
    "	-14	126	130",
    "	-15	126	130",
    "	-16	127	130",
    "Kaliningrad",
    "	56	19	22",
    "	55	19	22",
    "	54	19	22",
    "	53	19	22",
    "Kane Basin",
    "	81	-73	-63",
    "	80	-79	-63",
    "	79	-79	-63",
    "	78	-79	-63",
    "	77	-79	-67",
    "Kangertittivaq",
    "	72	-29	-23",
    "	71	-30	-20",
    "	70	-30	-20",
    "	69	-30	-20",
    "	68	-28	-26",
    "Kara Sea",
    "	82	64	96",
    "	81	64	98",
    "	80	64	103",
    "	79	64	103",
    "	78	65	103",
    "	77	65	102",
    "	76	59	102",
    "	75	56	102",
    "	74	55	100",
    "	73	54	88",
    "	72	54	88",
    "	71	54	80",
    "	70	54	69	74	80",
    "	69	55	70	77	80",
    "	68	59	70",
    "	67	65	70",
    "Karaginskiy Gulf",
    "	61	162	167",
    "	60	161	167",
    "	59	160	167",
    "	58	160	167",
    "	57	160	166",
    "	56	161	164",
    "Karskiye Strait",
    "	71	56	60",
    "	70	56	60",
    "	69	56	60",
    "Kattegat",
    "	59	10	12",
    "	58	9	13",
    "	57	9	13",
    "	56	9	13",
    "	55	9	13",
    "	54	10	12",
    "Kennedy Channel",
    "	82	-67	-63",
    "	81	-68	-63",
    "	80	-68	-63",
    "	79	-68	-63",
    "Khatanga Gulf",
    "	76	111	114",
    "	75	108	114",
    "	74	105	114",
    "	73	104	114",
    "	72	104	113",
    "	71	104	107",
    "Korea Strait",
    "	37	128	131",
    "	36	126	133",
    "	35	125	133",
    "	34	125	133",
    "	33	125	133",
    "	32	125	131",
    "	31	126	130",
    "Kotzebue Sound",
    "	68	-164	-160",
    "	67	-165	-159",
    "	66	-165	-159",
    "	65	-165	-159",
    "Kronotskiy Gulf",
    "	55	158	162",
    "	54	158	162",
    "	53	158	162",
    "	52	158	161",
    "La Perouse Strait",
    "	47	140	142",
    "	46	140	143",
    "	45	140	143",
    "	44	140	143",
    "Labrador Sea",
    "	61	-65	-43",
    "	60	-65	-42",
    "	59	-65	-42",
    "	58	-65	-42",
    "	57	-64	-43",
    "	56	-63	-43",
    "	55	-63	-44",
    "	54	-62	-45",
    "	53	-60	-46",
    "	52	-58	-46",
    "	51	-57	-47",
    "	50	-57	-48",
    "	49	-57	-49",
    "	48	-57	-49",
    "	47	-55	-50",
    "	46	-54	-51",
    "Laccadive Sea",
    "	15	73	75",
    "	14	70	75",
    "	13	70	76",
    "	12	70	76",
    "	11	70	77",
    "	10	70	77",
    "	9	70	79",
    "	8	70	80",
    "	7	70	81",
    "	6	70	81",
    "	5	71	81",
    "	4	71	80",
    "	3	71	79",
    "	2	71	78",
    "	1	71	76",
    "	0	71	75",
    "	-1	71	74",
    "Lago de Maracaibo",
    "	11	-72	-70",
    "	10	-73	-70",
    "	9	-73	-70",
    "	8	-73	-70",
    "Lake Baikal",
    "	56	107	110",
    "	55	107	110",
    "	54	105	110",
    "	53	104	110",
    "	52	102	110",
    "	51	102	109",
    "	50	102	107",
    "Lake Chad",
    "	14	13	15",
    "	13	13	15",
    "	12	13	15",
    "	11	13	15",
    "Lake Champlain",
    "	46	-74	-72",
    "	45	-74	-72",
    "	44	-74	-72",
    "	43	-74	-72",
    "	42	-74	-72",
    "Lake Erie",
    "	44	-80	-77",
    "	43	-84	-77",
    "	42	-84	-77",
    "	41	-84	-77",
    "	40	-84	-79",
    "Lake Huron",
    "	47	-82	-80",
    "	46	-82	-78",
    "	45	-82	-78",
    "	44	-82	-78",
    "	43	-82	-78",
    "Lake Huron",
    "	47	-85	-80",
    "	46	-85	-78",
    "	45	-85	-78",
    "	44	-85	-78",
    "	43	-84	-78",
    "	42	-84	-80",
    "Lake Huron",
    "	47	-84	-80",
    "	46	-84	-80",
    "	45	-84	-80",
    "	44	-84	-80",
    "Lake Huron",
    "	45	-84	-82",
    "	44	-84	-82",
    "	43	-84	-82",
    "	42	-84	-82",
    "Lake Malawi",
    "	-8	32	35",
    "	-9	32	35",
    "	-10	32	35",
    "	-11	32	35",
    "	-12	33	36",
    "	-13	33	36",
    "	-14	33	36",
    "	-15	33	36",
    "Lake Michigan",
    "	47	-86	-84",
    "	46	-88	-83",
    "	45	-89	-83",
    "	44	-89	-83",
    "	43	-89	-84",
    "	42	-88	-85",
    "	41	-88	-85",
    "	40	-88	-85",
    "Lake Okeechobee",
    "	28	-82	-79",
    "	27	-82	-79",
    "	26	-82	-79",
    "	25	-82	-79",
    "Lake Ontario",
    "	45	-78	-74",
    "	44	-80	-74",
    "	43	-80	-74",
    "	42	-80	-75",
    "Lake Pontchartrain",
    "	31	-91	-88",
    "	30	-91	-88",
    "	29	-91	-88",
    "Lake Saint Clair",
    "	43	-84	-81",
    "	42	-84	-81",
    "	41	-84	-81",
    "Lake Shasta",
    "	41	-123	-121",
    "	40	-123	-121",
    "	39	-123	-121",
    "Lake Superior",
    "	50	-89	-87",
    "	49	-90	-84",
    "	48	-92	-83",
    "	47	-93	-83",
    "	46	-93	-83",
    "	45	-93	-83",
    "Lake Superior",
    "	48	-85	-83",
    "	47	-86	-83",
    "	46	-86	-83",
    "	45	-86	-83",
    "Lake Tahoe",
    "	40	-121	-118",
    "	39	-121	-118",
    "	38	-121	-118",
    "	37	-121	-118",
    "Lake Tanganyika",
    "	-2	28	30",
    "	-3	28	30",
    "	-4	28	30",
    "	-5	28	31",
    "	-6	28	31",
    "	-7	28	32",
    "	-8	28	32",
    "	-9	29	32",
    "Lake Victoria",
    "	1	30	35",
    "	0	30	35",
    "	-1	30	35",
    "	-2	30	35",
    "	-3	30	34",
    "	-4	31	33",
    "Lake Winnipeg",
    "	55	-99	-96",
    "	54	-100	-96",
    "	53	-100	-95",
    "	52	-100	-95",
    "	51	-99	-95",
    "	50	-99	-95",
    "	49	-97	-95",
    "Laptev Sea",
    "	82	95	101",
    "	81	95	109",
    "	80	95	118",
    "	79	95	126",
    "	78	96	134",
    "	77	101	139",
    "	76	103	139",
    "	75	104	139",
    "	74	111	138",
    "	73	111	137",
    "	72	111	137",
    "	71	112	114	126	136",
    "	70	127	134",
    "	69	129	132",
    "Leyte Gulf",
    "	12	124	126",
    "	11	124	126",
    "	10	124	126",
    "	9	124	126",
    "Liddon Gulf",
    "	76	-115	-110",
    "	75	-116	-110",
    "	74	-116	-110",
    "	73	-116	-111",
    "Ligurian Sea",
    "	45	7	10",
    "	44	6	10",
    "	43	6	10",
    "	42	6	10",
    "Lincoln Sea",
    "	84	-70	-36",
    "	83	-70	-36",
    "	82	-70	-36",
    "	81	-69	-37",
    "	80	-54	-48	-46	-43",
    "Long Island Sound",
    "	42	-74	-71",
    "	41	-74	-71",
    "	40	-74	-71",
    "	39	-74	-71",
    "Lutzow-Holm Bay",
    "	-67	32	41",
    "	-68	32	41",
    "	-69	32	41",
    "	-70	32	40",
    "	-71	37	39",
    "Luzon Strait",
    "	23	119	121",
    "	22	119	122",
    "	21	119	123",
    "	20	119	123",
    "	19	119	123",
    "	18	119	123",
    "	17	119	123",
    "M'Clure Strait",
    "	77	-123	-119",
    "	76	-124	-114",
    "	75	-125	-113",
    "	74	-125	-113",
    "	73	-125	-113",
    "	72	-116	-114",
    "Mackenzie Bay",
    "	70	-140	-133",
    "	69	-140	-133",
    "	68	-140	-133",
    "	67	-138	-134",
    "Makassar Strait",
    "	2	116	122",
    "	1	116	122",
    "	0	115	122",
    "	-1	115	121",
    "	-2	115	120",
    "	-3	115	120",
    "	-4	115	120",
    "	-5	116	120",
    "	-6	118	120",
    "Marguerite Bay",
    "	-66	-70	-65",
    "	-67	-71	-65",
    "	-68	-71	-65",
    "	-69	-71	-65",
    "	-70	-71	-65",
    "Massachusetts Bay",
    "	43	-72	-69",
    "	42	-72	-69",
    "	41	-72	-69",
    "	40	-71	-69",
    "Matochkin Shar Strait",
    "	74	53	57",
    "	73	53	57",
    "	72	53	57",
    "McMurdo Sound",
    "	-71	165	167",
    "	-72	163	170",
    "	-73	161	170",
    "	-74	159	170",
    "	-75	159	170",
    "	-76	159	170",
    "	-77	161	170",
    "	-78	161	170",
    "	-79	162	166",
    "Mecklenburger Bucht",
    "	55	9	13",
    "	54	9	13",
    "	53	9	13",
    "	52	9	12",
    "Mediterranean Sea",
    "	38	10	15",
    "	37	9	24	26	37",
    "	36	9	37",
    "	35	9	37",
    "	34	9	36",
    "	33	9	36",
    "	32	9	36",
    "	31	11	36",
    "	30	23	35",
    "	29	27	30",
    "Mediterranean Sea",
    "	44	4	10",
    "	43	3	10",
    "	42	2	10",
    "	41	2	10",
    "	40	2	10",
    "	39	-1	11",
    "	38	-2	13",
    "	37	-3	13",
    "	36	-3	13",
    "	35	-3	11",
    "	34	-2	1",
    "Melville Bay",
    "	77	-68	-59",
    "	76	-68	-56",
    "	75	-68	-55",
    "	74	-67	-55",
    "	73	-62	-55",
    "Minto Inlet",
    "	72	-119	-114",
    "	71	-119	-114",
    "	70	-119	-114",
    "Molucca Sea",
    "	5	125	127",
    "	4	124	128",
    "	3	124	129",
    "	2	123	129",
    "	1	122	129",
    "	0	122	129",
    "	-1	122	129",
    "	-2	122	128",
    "Monterey Bay",
    "	37	-123	-120",
    "	36	-123	-120",
    "	35	-123	-120",
    "Mozambique Channel",
    "	-9	39	44",
    "	-10	39	49",
    "	-11	39	50",
    "	-12	39	50",
    "	-13	39	50",
    "	-14	39	49",
    "	-15	38	48",
    "	-16	35	48",
    "	-17	34	46",
    "	-18	33	45",
    "	-19	33	45",
    "	-20	33	45",
    "	-21	33	45",
    "	-22	34	44",
    "	-23	33	45",
    "	-24	31	46",
    "	-25	31	46",
    "	-26	31	46",
    "	-27	31	39",
    "Murchison Sound",
    "	79	-73	-71",
    "	78	-73	-65",
    "	77	-73	-65",
    "	76	-73	-65",
    "North Sea",
    "	61	-2	7",
    "	60	-3	7",
    "	59	-4	8",
    "	58	-5	10",
    "	57	-5	10",
    "	56	-5	10",
    "	55	-4	10",
    "	54	-4	10",
    "	53	-2	10",
    "	52	-1	10",
    "	51	-1	5",
    "	50	-1	5",
    "	49	0	2",
    "Norton Sound",
    "	65	-165	-159",
    "	64	-165	-159",
    "	63	-165	-159",
    "	62	-165	-159",
    "Norwegian Sea",
    "	77	13	19",
    "	76	9	21",
    "	75	4	23",
    "	74	-1	25",
    "	73	-5	27",
    "	72	-9	28",
    "	71	-10	28",
    "	70	-11	28",
    "	69	-12	28",
    "	68	-12	24",
    "	67	-13	18",
    "	66	-14	15",
    "	65	-14	15",
    "	64	-14	14",
    "	63	-14	12",
    "	62	-12	10",
    "	61	-9	9",
    "	60	-7	7",
    "	59	-4	6",
    "Oresund",
    "	57	11	13",
    "	56	11	13",
    "	55	11	13",
    "	54	11	13",
    "Ozero Mogotoyevo",
    "	73	143	147",
    "	72	143	147",
    "	71	143	147",
    "Pacific Ocean",
    "	59	-140	-135",
    "	58	-146	-134",
    "	57	-153	-132	161	164",
    "	56	-159	-132	161	166",
    "	55	-164	-131	160	168",
    "	54	-167	-131	157	170",
    "	53	-172	-130	157	172",
    "	52	-180	-129	156	179",
    "	51	-180	-126	155	180",
    "	50	-180	-123	154	180",
    "	49	-180	-123	153	180",
    "	48	-180	-123	152	180",
    "	47	-180	-122	150	180",
    "	46	-180	-122	148	180",
    "	45	-180	-122	147	180",
    "	44	-180	-122	143	180",
    "	43	-180	-123	142	180",
    "	42	-180	-123	141	180",
    "	41	-180	-123	140	180",
    "	40	-180	-122	140	180",
    "	39	-180	-121	139	180",
    "	38	-180	-121	139	180",
    "	37	-180	-120	139	180",
    "	36	-180	-119	138	180",
    "	35	-180	-117	138	180",
    "	34	-180	-116	138	180",
    "	33	-180	-115	138	180",
    "	32	-180	-115	138	180",
    "	31	-180	-114	139	180",
    "	30	-180	-113	139	180",
    "	29	-180	-113	139	180",
    "	28	-180	-113	140	180",
    "	27	-180	-111	141	180",
    "	26	-180	-111	141	180",
    "	25	-180	-110	141	180",
    "	24	-180	-105	140	180",
    "	23	-180	-104	140	180",
    "	22	-180	-104	140	180",
    "	21	-180	-104	140	180",
    "	20	-180	-103	140	180",
    "	19	-180	-101	143	180",
    "	18	-180	-99	144	180",
    "	17	-180	-97	145	180",
    "	16	-180	-91	145	180",
    "	15	-180	-90	144	180",
    "	14	-180	-86	144	180",
    "	13	-180	-85	143	180",
    "	12	-180	-84	141	180",
    "	11	-180	-84	140	180",
    "	10	-180	-82	138	180",
    "	9	-180	-80	136	180",
    "	8	-180	-76	135	180",
    "	7	-180	-76	133	180",
    "	6	-180	-76	132	180",
    "	5	-180	-76	130	180",
    "	4	-180	-76	128	180",
    "	3	-180	-76	127	180",
    "	2	-180	-76	127	180",
    "	1	-180	-76	127	180",
    "	0	-180	-77	128	180",
    "	-1	-180	-78	128	180",
    "Pacific Ocean",
    "	4	171	173",
    "	3	-93	-90	170	174",
    "	2	-93	-89	170	174",
    "	1	-180	-79	130	180",
    "	0	-180	-79	130	180",
    "	-1	-180	-79	130	180",
    "	-2	-180	-79	133	180",
    "	-3	-180	-79	133	142	145	180",
    "	-4	-180	-79	133	136	150	180",
    "	-5	-180	-78	152	180",
    "	-6	-180	-78	153	180",
    "	-7	-180	-77	154	180",
    "	-8	-180	-77	156	180",
    "	-9	-180	-76	158	180",
    "	-10	-180	-76	160	180",
    "	-11	-180	-75	160	180",
    "	-12	-180	-75	166	180",
    "	-13	-180	-74	166	180",
    "	-14	-180	-73	166	180",
    "	-15	-180	-71	166	180",
    "	-16	-180	-69	167	180",
    "	-17	-180	-69	167	180",
    "	-18	-180	-69	167	180",
    "	-19	-180	-69	168	180",
    "	-20	-180	-69	167	180",
    "	-21	-180	-69	166	180",
    "	-22	-180	-69	165	180",
    "	-23	-180	-69	164	180",
    "	-24	-180	-69	163	180",
    "	-25	-180	-69	161	180",
    "	-26	-180	-69	160	180",
    "	-27	-180	-69	159	180",
    "	-28	-180	-69	158	180",
    "	-29	-180	-70	158	180",
    "	-30	-180	-70	158	180",
    "	-31	-180	-70	158	180",
    "	-32	-180	-70	158	180",
    "	-33	-180	-70	161	180",
    "	-34	-180	-70	165	180",
    "	-35	-180	-70	169	180",
    "	-36	-180	-71	172	180",
    "	-37	-180	-71	173	180",
    "	-38	-180	-72	174	180",
    "	-39	-180	-72	175	180",
    "	-40	-180	-72	173	180",
    "	-41	-180	-72	172	180",
    "	-42	-180	-72	170	180",
    "	-43	-180	-72	169	180",
    "	-44	-180	-72	169	180",
    "	-45	-180	-72	166	180",
    "	-46	-180	-72	166	180",
    "	-47	-180	-72	165	180",
    "	-48	-180	-72	165	180",
    "	-49	-180	-72	165	180",
    "	-50	-180	-71	165	180",
    "	-51	-180	-71	165	180",
    "	-52	-180	-71	165	180",
    "	-53	-180	-68	165	180",
    "	-54	-180	-67	165	180",
    "	-55	-180	-67	165	180",
    "	-56	-180	-67	165	180",
    "	-57	-180	-67	165	180",
    "	-58	-180	-67	165	180",
    "	-59	-180	-67	165	180",
    "	-60	-180	-67	165	180",
    "	-61	-180	-67	165	180",
    "Palk Strait",
    "	11	78	80",
    "	10	77	81",
    "	9	77	81",
    "	8	77	81",
    "	7	78	80",
    "Pamlico Sound",
    "	36	-78	-74",
    "	35	-78	-74",
    "	34	-78	-74",
    "	33	-77	-75",
    "Peacock Sound",
    "	-71	-103	-94",
    "	-72	-103	-94",
    "	-73	-103	-94",
    "	-74	-102	-94",
    "Persian Gulf",
    "	31	46	51",
    "	30	46	51",
    "	29	46	52",
    "	28	46	57",
    "	27	47	58",
    "	26	47	58",
    "	25	48	58",
    "	24	49	57",
    "	23	49	55",
    "	22	50	53",
    "Philippine Sea",
    "	36	135	139",
    "	35	135	140",
    "	34	132	141",
    "	33	130	141",
    "	32	129	141",
    "	31	129	141",
    "	30	129	142",
    "	29	128	143",
    "	28	127	143",
    "	27	126	143",
    "	26	126	143",
    "	25	120	143",
    "	24	120	143",
    "	23	119	143",
    "	22	119	144",
    "	21	119	146",
    "	20	119	146",
    "	19	120	147",
    "	18	121	147",
    "	17	120	147",
    "	16	120	147",
    "	15	120	147",
    "	14	120	147",
    "	13	120	146",
    "	12	121	146",
    "	11	123	145",
    "	10	124	144",
    "	9	124	142",
    "	8	125	141",
    "	7	125	139",
    "	6	124	137",
    "	5	124	136",
    "	4	124	134",
    "	3	124	133",
    "	2	124	131",
    "	1	127	129",
    "Porpoise Bay",
    "	-65	125	131",
    "	-66	125	131",
    "	-67	125	131",
    "	-68	126	130",
    "Prince ALbert Sound",
    "	71	-118	-110",
    "	70	-118	-110",
    "	69	-118	-110",
    "Prince of Wales Strait",
    "	74	-118	-113",
    "	73	-121	-113",
    "	72	-121	-113",
    "	71	-121	-115",
    "	70	-121	-117",
    "Prince William Sound",
    "	62	-149	-145",
    "	61	-149	-144",
    "	60	-149	-144",
    "	59	-149	-144",
    "	58	-148	-146",
    "Prydz Bay",
    "	-66	68	75",
    "	-67	68	80",
    "	-68	66	80",
    "	-69	66	80",
    "	-70	66	78",
    "	-71	65	74",
    "	-72	65	72",
    "	-73	65	71",
    "	-74	65	68",
    "Puget Sound",
    "	49	-123	-121",
    "	48	-124	-121",
    "	47	-124	-121",
    "	46	-124	-121",
    "Qiongzhou Strait",
    "	21	108	111",
    "	20	108	111",
    "	19	108	111",
    "	18	108	110",
    "Queen Charlotte Sound",
    "	54	-130	-128",
    "	53	-132	-127",
    "	52	-132	-126",
    "	51	-132	-126",
    "	50	-132	-126",
    "	49	-130	-126",
    "Queen Charlotte Straight",
    "	52	-128	-125",
    "	51	-128	-123",
    "	50	-128	-123",
    "	49	-128	-123",
    "Ragay Gulf",
    "	14	121	124",
    "	13	121	124",
    "	12	121	124",
    "	11	122	124",
    "Red Sea",
    "	29	33	36",
    "	28	32	36",
    "	27	32	37",
    "	26	32	38",
    "	25	32	39",
    "	24	33	39",
    "	23	34	40",
    "	22	34	40",
    "	21	34	41",
    "	20	35	42",
    "	19	36	42",
    "	18	36	43",
    "	17	36	43",
    "	16	37	43",
    "	15	38	44",
    "	14	38	44",
    "	13	39	44",
    "	12	40	44",
    "	11	41	44",
    "Richard Collinson Inlet",
    "	74	-115	-113",
    "	73	-115	-112",
    "	72	-115	-112",
    "	71	-115	-112",
    "Rio de la Plata",
    "	-31	-59	-57",
    "	-32	-59	-57",
    "	-33	-59	-53",
    "	-34	-59	-53",
    "	-35	-59	-53",
    "	-36	-58	-54",
    "	-37	-58	-55",
    "Robeson Channel",
    "	83	-63	-56",
    "	82	-63	-55",
    "	81	-63	-55",
    "	80	-62	-55",
    "Ronne Entrance",
    "	-70	-76	-74",
    "	-71	-76	-72",
    "	-72	-76	-72",
    "	-73	-76	-72",
    "Ross Sea",
    "	-70	169	180",
    "	-71	167	180",
    "	-72	167	180",
    "	-73	167	180",
    "	-74	168	180",
    "	-75	168	180",
    "	-76	165	180",
    "	-77	160	180",
    "	-78	158	180",
    "	-79	157	180",
    "	-80	157	180",
    "	-81	157	180",
    "	-82	159	180",
    "	-83	160	180",
    "	-84	166	180",
    "	-85	176	180",
    "Ross Sea",
    "	-70	-180	-101",
    "	-71	-180	-101",
    "	-72	-180	-101",
    "	-73	-180	-101",
    "	-74	-180	-107",
    "	-75	-180	-130	-125	-113",
    "	-76	-180	-135",
    "	-77	-180	-144",
    "	-78	-180	-147",
    "	-79	-180	-147",
    "	-80	-180	-147",
    "	-81	-180	-147",
    "	-82	-180	-149",
    "	-83	-180	-152",
    "	-84	-180	-155",
    "	-85	-180	-155",
    "	-86	-159	-155",
    "Salton Sea",
    "	34	-117	-114",
    "	33	-117	-114",
    "	32	-117	-114",
    "Samar Sea",
    "	14	122	124",
    "	13	122	125",
    "	12	122	126",
    "	11	122	126",
    "	10	123	126",
    "San Francisco Bay",
    "	39	-123	-120",
    "	38	-123	-120",
    "	37	-123	-120",
    "	36	-123	-121",
    "Sargasso Sea",
    "	36	-68	-51",
    "	35	-69	-50",
    "	34	-70	-49",
    "	33	-70	-49",
    "	32	-71	-49",
    "	31	-71	-49",
    "	30	-71	-49",
    "	29	-71	-49",
    "	28	-71	-49",
    "	27	-71	-49",
    "	26	-71	-49",
    "	25	-71	-49",
    "	24	-71	-49",
    "	23	-70	-49",
    "	22	-69	-49",
    "	21	-68	-49",
    "	20	-67	-49",
    "	19	-64	-50",
    "Savu Sea",
    "	-7	117	126",
    "	-8	117	126",
    "	-9	117	126",
    "	-10	117	125",
    "	-11	119	124",
    "Scotia Sea",
    "	-50	-59	-53",
    "	-51	-60	-46",
    "	-52	-60	-40",
    "	-53	-60	-35",
    "	-54	-60	-35",
    "	-55	-59	-35",
    "	-56	-59	-36",
    "	-57	-58	-37",
    "	-58	-58	-39",
    "	-59	-57	-40",
    "	-60	-57	-41",
    "	-61	-56	-43",
    "	-62	-56	-49",
    "Sea of Azov",
    "	48	36	40",
    "	47	33	40",
    "	46	33	40",
    "	45	33	39",
    "	44	33	39",
    "Sea of Crete",
    "	39	22	24",
    "	38	21	25",
    "	37	21	29",
    "	36	21	29",
    "	35	22	29",
    "	34	22	28",
    "Sea of Japan",
    "	52	139	143",
    "	51	139	143",
    "	50	139	143",
    "	49	138	143",
    "	48	137	143",
    "	47	137	143",
    "	46	135	143",
    "	45	134	143",
    "	44	130	143",
    "	43	129	142",
    "	42	128	142",
    "	41	127	141",
    "	40	127	141",
    "	39	127	141",
    "	38	127	141",
    "	37	127	140",
    "	36	126	139",
    "	35	125	138",
    "	34	125	137",
    "	33	125	133",
    "	32	125	131",
    "	31	126	130",
    "Sea of Marmara",
    "	42	26	30",
    "	41	25	30",
    "	40	25	30",
    "	39	25	30",
    "Sea of Okhotsk",
    "	60	141	156",
    "	59	139	156",
    "	58	137	157",
    "	57	137	157",
    "	56	137	157",
    "	55	136	157",
    "	54	136	157",
    "	53	136	157",
    "	52	136	139	141	158",
    "	51	142	158",
    "	50	142	158",
    "	49	141	157",
    "	48	141	156",
    "	47	141	155",
    "	46	140	154",
    "	45	140	153",
    "	44	140	151",
    "	43	141	149",
    "	42	143	148",
    "Selat Bali",
    "	-7	113	116",
    "	-8	113	116",
    "	-9	113	116",
    "Selat Dampier",
    "	1	128	132",
    "	0	128	132",
    "	-1	128	132",
    "	-2	130	132",
    "Seno de Skyring",
    "	-51	-74	-70",
    "	-52	-74	-70",
    "	-53	-74	-70",
    "	-54	-74	-71",
    "Seno Otway",
    "	-51	-72	-70",
    "	-52	-73	-70",
    "	-53	-73	-70",
    "	-54	-73	-70",
    "Shark Bay",
    "	-23	112	114",
    "	-24	112	115",
    "	-25	112	115",
    "	-26	112	115",
    "	-27	112	115",
    "Shelikhova Gulf",
    "	63	162	166",
    "	62	155	166",
    "	61	153	166",
    "	60	153	165",
    "	59	153	164",
    "	58	153	162",
    "	57	154	160",
    "	56	155	158",
    "Sherman Basin",
    "	69	-99	-97",
    "	68	-99	-96",
    "	67	-99	-96",
    "	66	-99	-96",
    "Sibuyan Sea",
    "	14	120	123",
    "	13	120	124",
    "	12	120	124",
    "	11	120	124",
    "	10	120	124",
    "Skagerrak",
    "	60	8	12",
    "	59	6	12",
    "	58	6	12",
    "	57	6	12",
    "	56	6	11",
    "	55	7	9",
    "Smith Sound",
    "	53	-128	-125",
    "	52	-129	-125",
    "	51	-129	-125",
    "	50	-129	-125",
    "Sognefjorden",
    "	62	3	8",
    "	61	3	8",
    "	60	3	8",
    "	59	4	8",
    "Solomon Sea",
    "	-3	151	155",
    "	-4	146	155",
    "	-5	145	157",
    "	-6	145	160",
    "	-7	145	161",
    "	-8	146	162",
    "	-9	147	163",
    "	-10	147	163",
    "	-11	148	163",
    "	-12	152	162",
    "South China Sea",
    "	24	112	121",
    "	23	112	121",
    "	22	109	122",
    "	21	108	123",
    "	20	108	123",
    "	19	107	123",
    "	18	105	123",
    "	17	105	123",
    "	16	105	121",
    "	15	106	121",
    "	14	107	121",
    "	13	108	121",
    "	12	107	121",
    "	11	104	121",
    "	10	104	120",
    "	9	103	120",
    "	8	102	119",
    "	7	101	118",
    "	6	101	117",
    "	5	101	117",
    "	4	101	117",
    "	3	102	116",
    "	2	102	114",
    "	1	101	113",
    "	0	101	112",
    "	-1	101	111",
    "	-2	103	111",
    "	-3	103	111",
    "	-4	105	107",
    "Southern Ocean",
    "	-59	-180	180",
    "	-60	-180	180",
    "	-61	-180	180",
    "	-62	-180	180",
    "	-63	-180	180",
    "	-64	-180	180",
    "	-65	-180	91	103	180",
    "	-66	-180	87	110	180",
    "	-67	-180	52	54	85	112	180",
    "	-68	-180	51	54	84	112	122	141	180",
    "	-69	-180	-69	-66	44	74	80	145	180",
    "	-70	-180	-73	-64	33	154	180",
    "	-71	-180	-79	-63	33	159	180",
    "	-72	-180	-85	-62	2	24	27	161	163	166	180",
    "	-73	-100	-91",
    "St. Helena Bay",
    "	-30	16	19",
    "	-31	16	19",
    "	-32	16	19",
    "	-33	16	19",
    "St. Lawrence River",
    "	51	-67	-63",
    "	50	-69	-63",
    "	49	-72	-63",
    "	48	-72	-63",
    "	47	-74	-66",
    "	46	-75	-68",
    "	45	-75	-69",
    "	44	-75	-72",
    "Stettiner Haff",
    "	55	12	14",
    "	54	12	15",
    "	53	12	15",
    "	52	12	15",
    "Storfjorden",
    "	79	17	22",
    "	78	16	22",
    "	77	15	22",
    "	76	15	22",
    "	75	15	19",
    "Strait of Belle Isle",
    "	53	-56	-54",
    "	52	-58	-54",
    "	51	-58	-54",
    "	50	-58	-54",
    "Strait of Georgia",
    "	51	-126	-122",
    "	50	-126	-121",
    "	49	-126	-121",
    "	48	-126	-121",
    "	47	-124	-121",
    "Strait of Gibraltar",
    "	37	-7	-4",
    "	36	-7	-4",
    "	35	-7	-4",
    "	34	-6	-4",
    "Strait of Juan de Fuca",
    "	49	-125	-121",
    "	48	-125	-121",
    "	47	-125	-121",
    "Strait of Malacca",
    "	9	97	99",
    "	8	97	100",
    "	7	95	101",
    "	6	94	101",
    "	5	94	101",
    "	4	94	102",
    "	3	96	103",
    "	2	97	104",
    "	1	98	104",
    "	0	99	104",
    "	-1	101	104",
    "Strait of Singapore",
    "	2	102	105",
    "	1	102	105",
    "	0	102	105",
    "Straits of Florida",
    "	27	-81	-77",
    "	26	-82	-77",
    "	25	-84	-77",
    "	24	-84	-77",
    "	23	-84	-77",
    "	22	-84	-78",
    "Sulu Sea",
    "	13	118	122",
    "	12	118	123",
    "	11	118	123",
    "	10	117	124",
    "	9	116	124",
    "	8	115	124",
    "	7	115	124",
    "	6	115	123",
    "	5	115	123",
    "	4	116	121",
    "Sulzberger Bay",
    "	-75	-153	-144",
    "	-76	-159	-144",
    "	-77	-159	-144",
    "	-78	-159	-144",
    "Surigao Strait",
    "	11	124	126",
    "	10	124	126",
    "	9	124	126",
    "	8	124	126",
    "Taiwan Strait",
    "	26	117	122",
    "	25	116	122",
    "	24	116	122",
    "	23	116	121",
    "	22	116	121",
    "Tasman Sea",
    "	-28	152	160",
    "	-29	152	160",
    "	-30	151	162",
    "	-31	150	166",
    "	-32	150	170",
    "	-33	149	174",
    "	-34	149	174",
    "	-35	148	175",
    "	-36	148	175",
    "	-37	147	175",
    "	-38	146	176",
    "	-39	146	176",
    "	-40	146	176",
    "	-41	146	176",
    "	-42	145	175",
    "	-43	145	172",
    "	-44	145	171",
    "	-45	147	169",
    "	-46	150	168",
    "	-47	152	168",
    "	-48	155	168",
    "	-49	158	167",
    "	-50	160	167",
    "	-51	163	167",
    "Tatar Strait",
    "	54	139	142",
    "	53	139	142",
    "	52	139	142",
    "	51	140	142",
    "	50	140	142",
    "Tayabas Bay",
    "	14	119	123",
    "	13	119	123",
    "	12	119	123",
    "The North Western Passages",
    "	81	-101	-95",
    "	80	-108	-90	-88	-82",
    "	79	-114	-80",
    "	78	-117	-80",
    "	77	-120	-80",
    "	76	-120	-81",
    "	75	-120	-78",
    "	74	-120	-76",
    "	73	-106	-76",
    "	72	-106	-76",
    "	71	-118	-116	-106	-83",
    "	70	-119	-112	-108	-83",
    "	69	-119	-85",
    "	68	-119	-92",
    "	67	-118	-92",
    "	66	-116	-106	-104	-94",
    "	65	-97	-94",
    "Timor Sea",
    "	-7	125	131",
    "	-8	123	131",
    "	-9	121	132",
    "	-10	121	133",
    "	-11	121	133",
    "	-12	122	133",
    "	-13	124	133",
    "	-14	125	131",
    "Torres Strait",
    "	-8	140	144",
    "	-9	140	144",
    "	-10	140	144",
    "	-11	141	143",
    "	-12	141	143",
    "Trondheimsfjorden",
    "	65	10	12",
    "	64	7	12",
    "	63	7	12",
    "	62	7	12",
    "Tsugaru Strait",
    "	42	139	142",
    "	41	139	142",
    "	40	139	142",
    "	39	139	142",
    "Tyrrhenian Sea",
    "	45	8	11",
    "	44	8	11",
    "	43	8	12",
    "	42	8	14",
    "	41	8	16",
    "	40	8	17",
    "	39	7	17",
    "	38	7	17",
    "	37	7	17",
    "	36	10	14",
    "Uchiura Bay",
    "	43	139	144",
    "	42	139	144",
    "	41	139	144",
    "	40	139	143",
    "	39	140	142",
    "Uda Bay",
    "	57	136	139",
    "	56	134	139",
    "	55	134	139",
    "	54	134	139",
    "	53	134	139",
    "	52	135	138",
    "Ungava Bay",
    "	61	-71	-63",
    "	60	-71	-63",
    "	59	-71	-63",
    "	58	-71	-64",
    "	57	-71	-64",
    "	56	-70	-66",
    "Uummannaq Fjord",
    "	73	-54	-52",
    "	72	-55	-50",
    "	71	-55	-49",
    "	70	-55	-49",
    "	69	-55	-49",
    "Vestfjorden",
    "	69	12	18",
    "	68	11	18",
    "	67	11	18",
    "	66	11	17",
    "	65	12	14",
    "Vil'kitskogo Strait",
    "	79	99	106",
    "	78	99	106",
    "	77	99	106",
    "	76	99	106",
    "	75	99	101",
    "Vincennes Bay",
    "	-65	103	111",
    "	-66	103	111",
    "	-67	103	111",
    "Visayan Sea",
    "	13	122	124",
    "	12	121	125",
    "	11	121	125",
    "	10	121	125",
    "	9	121	125",
    "Viscount Melville Sound",
    "	76	-110	-103",
    "	75	-115	-103",
    "	74	-116	-103",
    "	73	-116	-103",
    "	72	-116	-104",
    "	71	-114	-107",
    "Waddenzee",
    "	54	3	7",
    "	53	3	7",
    "	52	3	7",
    "	51	3	6",
    "Wager Bay",
    "	66	-92	-86",
    "	65	-92	-86",
    "	64	-92	-86",
    "Weddell Sea",
    "	-70	-62	-9",
    "	-71	-63	-9",
    "	-72	-63	-9",
    "	-73	-64	-10",
    "	-74	-66	-13",
    "	-75	-78	-14",
    "	-76	-84	-17",
    "	-77	-84	-25",
    "	-78	-84	-22",
    "	-79	-84	-22",
    "	-80	-82	-22",
    "	-81	-79	-23",
    "	-82	-70	-36",
    "	-83	-66	-50	-48	-42",
    "	-84	-62	-57",
    "White Sea",
    "	69	37	45",
    "	68	30	33	37	45",
    "	67	30	45",
    "	66	30	45",
    "	65	31	45",
    "	64	33	41",
    "	63	33	41",
    "	62	35	38",
    "Wrigley Gulf",
    "	-72	-131	-124",
    "	-73	-135	-123",
    "	-74	-135	-123",
    "	-75	-135	-123",
    "Wynniat Bay",
    "	73	-112	-109",
    "	72	-112	-109",
    "	71	-112	-109",
    "Yellow Sea",
    "	41	123	125",
    "	40	120	126",
    "	39	120	126",
    "	38	119	127",
    "	37	119	127",
    "	36	118	127",
    "	35	118	127",
    "	34	118	127",
    "	33	118	127",
    "	32	119	127",
    "	31	119	125",
    "	30	120	123",
    "Yellowstone Lake",
    "	45	-111	-109",
    "	44	-111	-109",
    "	43	-111	-109",
    "Yenisey Gulf",
    "	74	77	81",
    "	73	77	83",
    "	72	77	84",
    "	71	77	84",
    "	70	79	84",
    "	69	81	84",
    "Yucatan Channel",
    "	23	-86	-84",
    "	22	-88	-83",
    "	21	-88	-83",
    "	20	-88	-83"
};
