'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
require('dayjs');
var shiftTimezone = require('../../utils/shift-timezone.cjs');
require('../DatesProvider/DatesProvider.cjs');
var useDatesContext = require('../DatesProvider/use-dates-context.cjs');

function formatValue(value, type) {
  const ctx = useDatesContext.useDatesContext();
  const formatDateWithTimezone = (date) => {
    return shiftTimezone.shiftTimezone("remove", date, ctx.getTimezone()).toISOString();
  };
  if (type === "range" && Array.isArray(value)) {
    const [startDate, endDate] = value;
    if (!startDate) {
      return "";
    }
    if (!endDate) {
      return `${formatDateWithTimezone(startDate)} \u2013`;
    }
    return `${formatDateWithTimezone(startDate)} \u2013 ${formatDateWithTimezone(endDate)}`;
  }
  if (type === "multiple" && Array.isArray(value)) {
    return value.map((date) => date && formatDateWithTimezone(date)).filter(Boolean).join(", ");
  }
  if (!Array.isArray(value) && value) {
    return formatDateWithTimezone(value);
  }
  return "";
}
function HiddenDatesInput({ value, type, name, form }) {
  return /* @__PURE__ */ jsxRuntime.jsx("input", { type: "hidden", value: formatValue(value, type), name, form });
}
HiddenDatesInput.displayName = "@mantine/dates/HiddenDatesInput";

exports.HiddenDatesInput = HiddenDatesInput;
//# sourceMappingURL=HiddenDatesInput.cjs.map
