/* --< GKrellStock 0.5.1 >--{ 21 April 2003 }--
 *
 * GkrellM2.0 Port
 * Author: M.R.Muthu Kumar (m_muthukumar@users.sourceforge.net)
 *
 */

#include <gkrellm2/gkrellm.h>

/*
 * Make sure we have a compatible version of GKrellM
 * (Version 2.0+ is required)
 */
#if !defined(GKRELLM_VERSION_MAJOR) \
     || (GKRELLM_VERSION_MAJOR < 2 )
#error This plugin requires GKrellM version >= 2.0
#endif


#define GKRELLSTOCK_VER 	"0.5.1"
#define DEFAULT_TICKERS		"T SPTN GE" 
#define DEFAULT_S_TICKERS	"^dji ^ixic" 

#define COMMAND			"GetQuote2"
#define DELIM			"!"

#define	CONFIG_NAME	"GkrellStock"	/* Name in the configuration window */
#define	STYLE_NAME	"GkrellStock"	/* Theme subdirectory name */
			                /*  and gkrellmrc style name.*/ 


#define MAX_DECALS	2	/* Maximum Decals Used */
#define MAX_TICKERS	101	/* Maximum Tickers */
#define DETAIL_ELEM	8	/* Number of Ticker Detail Elements */
#define DEFAULT_SI	30	/* Default Switch Interval */
#define DEFAULT_UI	5	/* Default Update Interval */

#define MAX_MARKETS	5

#define USA_M		"USA"
#define EURO_M		"European"
#define AUS_M		"Australia"
#define CAN_M		"Canadian"
#define ASIA_M		"Asian"

/*    net update status    */
static gboolean    net_update;

static GkrellmPanel	*stk_panel, *q_panel;

static GkrellmDecal	*decal_text1[MAX_DECALS], *decal_text2[MAX_DECALS];

static gchar	scroll_text[MAX_TICKERS][512];
static gchar	quote_text[MAX_TICKERS][512];
static gchar	tic_details[MAX_TICKERS][DETAIL_ELEM][512];
static gboolean scroll_q[MAX_TICKERS];


static gint		style_id;

static gint panel_state = 0;
static gint x_scroll  = 0;
static gint active_tickers = 0;
static gint switch_interval;
static gint update_interval;
static gint stock_src;
static gint tic_number;

static GkrellmMonitor *stk_monitor;

static GtkWidget	*switch_interval_option, 
                    *update_interval_option,
                    *ticker_option,
                    *scroll_option,
                    *stock_clist,
                    *market_select_option;

static GtkTooltips  *stock_tips = 0;
static gchar        *stock_tips_text;
static gint	switch_timer = 0;

gchar stk_filename[512];
gchar *stock_src_name[] = { "usa", "europe", "australia", "canada", "asia" };
gchar *market_name[] = { USA_M, EURO_M, AUS_M, CAN_M, ASIA_M };

gchar tickers[4096];
gchar command[4352];

typedef struct
{
  gchar *ticker;
  gint  want_scroll;
} GStock;

static GList *tickerList;	// list to hold GStock.

static gint selected_tic_row = -1;
static gboolean config_data_modified=FALSE;

static gint
expose_event (GtkWidget *widget, GdkEventExpose *ev)
{
    if (widget == stk_panel->drawing_area)
    {
        gdk_draw_pixmap(widget->window,
            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
            stk_panel->pixmap, ev->area.x, ev->area.y, ev->area.x, ev->area.y,
            ev->area.width, ev->area.height);
    }
    if (widget == q_panel->drawing_area)
    {
        gdk_draw_pixmap(widget->window,
            widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
            q_panel->pixmap, ev->area.x, ev->area.y, ev->area.x, ev->area.y,
            ev->area.width, ev->area.height);
    }
    return FALSE;
}

static FILE *command_pipe;

static void
run_command ()
{
    if (command_pipe)
        return;
    command_pipe = popen(command, "r");
    if (command_pipe)
        fcntl(fileno(command_pipe), F_SETFL, O_NONBLOCK);
    net_update = TRUE;
}

static gboolean
command_done ()
{
    gchar buf[64];

    while (fread(buf, 1, sizeof(buf) - 1, command_pipe) > 0)
        ;
    if (feof(command_pipe))
    {
        pclose(command_pipe);
        command_pipe = NULL;
        return TRUE;
    }
    return FALSE;
}

static void
show_stock_tips()
{
   gchar str[4096];

   if ( stock_tips != NULL )
   {
      g_free( stock_tips_text);	   
      sprintf( str, "%-50s\n%-50s\n%-50s\n%-50s\n%-50s\n%-50s\n%-50s\n%-50s\n", 
		    tic_details[panel_state][0] , 
		    tic_details[panel_state][1] ,
		    tic_details[panel_state][2] ,
		    tic_details[panel_state][3] ,
		    tic_details[panel_state][4] ,
		    tic_details[panel_state][5] ,
		    tic_details[panel_state][6] ,
		    tic_details[panel_state][7] 
		    );

      stock_tips_text = g_strdup(str);
      gtk_tooltips_set_tip(stock_tips, stk_panel->drawing_area,
                           stock_tips_text, NULL);
      gtk_tooltips_set_tip(stock_tips, q_panel->drawing_area,
                           stock_tips_text, NULL);
   }	   
}	

static gboolean
read_stock()
{
  FILE *fp;

  gint i = 0;
  gint j = 0;

  gchar tmp_buff[4096],*tmp_tok[4096];

  gchar *token, *q_token;

  if ( ( fp = fopen( stk_filename, "r" ) ) != NULL )
  {
    while ( feof( fp ) == 0  )
    {
      if ( fgets( tmp_buff, 4096, fp ) != NULL )
      {
	token = strtok( tmp_buff, DELIM );
	if ( token != NULL )
	{
	  *tmp_tok = token;
	  q_token = strsep( tmp_tok, " " );

	  strcpy(scroll_text[i], q_token); 
	  strcpy(quote_text[i], *tmp_tok); 

	  j = 0;
	  while( ( token = strtok( NULL, DELIM ) ) != NULL )
          {
            strcpy( tic_details[i][j], token );
	    j++;
            if ( j >= DETAIL_ELEM ) { break; }
	  }	  
          i++;
	}  
      }	

      if ( i >= MAX_TICKERS ) { break; }
    }
    active_tickers = i - 1;

    show_stock_tips();
  }
  else
  {
    sprintf( scroll_text[0], "Error Reading Stock Data" );
    sprintf( quote_text[0], "Error Reading Stock Data" );
  }


  if (fp) { fclose( fp ); }

  return TRUE;

}
static void
draw_panel ()
{
  gint i = 0;

  gint i_new;

  static gint	w, v;

  v++;
  i = panel_state;

  if ( panel_state > 1 ) { i_new = panel_state % 2; }
  else { i_new = panel_state; }

  if ( scroll_q[i] ) 
  {
    if (w == 0) { w = gkrellm_chart_width(); }
     x_scroll = (x_scroll + 1) % (2 * w);
     decal_text2[i_new]->x_off = w - x_scroll;
     gkrellm_draw_decal_text(q_panel, decal_text2[i_new], quote_text[i], w - x_scroll);
     decal_text1[i_new]->x_off = ( w / 2 ) - (strlen(scroll_text[i]) * 4);
     gkrellm_draw_decal_text(stk_panel, decal_text1[i_new], scroll_text[i], v);
   }
   else
   {
     x_scroll = 0;
     if (w == 0) { w = gkrellm_chart_width(); }
     decal_text1[i_new]->x_off = ( w / 2 ) - (strlen(scroll_text[i]) * 4);
     gkrellm_draw_decal_text(stk_panel, decal_text1[i_new], scroll_text[i], v);
     decal_text2[i_new]->x_off = 0;
     gkrellm_draw_decal_text(q_panel, decal_text2[i_new], quote_text[i], v);
   }

}


static void
panel_switch()
{

   gint old_state, i_old, i_new;

   old_state = panel_state;
   panel_state++;
   if ( panel_state > active_tickers ) { panel_state = 0 ; }

   if ( old_state > 1 ) { i_old = old_state % 2; }
   else { i_old = old_state; }

   if ( panel_state > 1 ) { i_new = panel_state % 2; }
   else { i_new = panel_state; }

   gkrellm_make_decal_invisible(stk_panel, decal_text1[i_old] );
   gkrellm_make_decal_invisible(q_panel, decal_text2[i_old] );

   draw_panel();

   gkrellm_make_decal_visible(stk_panel, decal_text1[i_new] );
   gkrellm_draw_panel_layers(stk_panel);
   gkrellm_make_decal_visible(q_panel, decal_text2[i_new] );


   show_stock_tips();
}	


static gint
panel_press (GtkWidget *widget, GdkEventButton *ev)
{
    if (ev->button == 2 )
    {
       switch_timer = 0;
	   x_scroll = 0;
       panel_switch();	
    }
    if (ev->button == 3 )
    {
	  gkrellm_open_config_window (stk_monitor);
	}

    return TRUE;
}

static void
update_plugin()
{
	static gint	minute_timer = 0;


	if ( command_pipe )
	{
	  net_update = command_done() && read_stock();
	}	

	if(!net_update && GK.timer_ticks % 600 == 0)
        {
          run_command();
        }

        if ( GK.second_tick && switch_interval > 0 && 
             switch_timer++ >= switch_interval )
        {
          switch_timer = 0;

	  panel_switch();
        }
	if (GK.minute_tick && ++minute_timer >= update_interval)
        {
          minute_timer = 0;
          run_command();
        }

    draw_panel();
	gkrellm_draw_panel_layers(stk_panel);

	gkrellm_draw_panel_layers(q_panel);

}



static void
create_plugin(GtkWidget *vbox, gint first_create)
{
	GkrellmStyle			*style;
	GkrellmTextstyle		*ts, *ts_alt;
	gint			i = 0;
	gint			j = 0;
	gint			prev_state = 0;

	if (first_create)
	{
	  stk_panel = gkrellm_panel_new0();
	  q_panel = gkrellm_panel_new0();
	}  
	else 
	{ 
	  gkrellm_destroy_krell_list(stk_panel);
	  gkrellm_destroy_decal_list(stk_panel); 

	  gkrellm_destroy_krell_list(q_panel);
	  gkrellm_destroy_decal_list(q_panel); 
	}

	style = gkrellm_meter_style(style_id);

	/* Each Style has two text styles.  The theme designer has picked the
	|  colors and font sizes, presumably based on knowledge of what you draw
	|  on your panel.  You just do the drawing.  You probably could assume
	|  the ts font is larger than the ts_alt font, but again you can be
	|  overridden by the theme designer.
	*/
	ts = gkrellm_meter_textstyle(style_id);
	ts_alt = gkrellm_meter_alt_textstyle(style_id);
	stk_panel->textstyle = ts;		/* would be used for a panel label */
	q_panel->textstyle = ts;		/* would be used for a panel label */

	/* Create a text decal that will be used to scroll text.  Make it
	|  the full panel width (minus the margins).  Position it at top border
	|  and left margin of the style.
	*/

    for ( i = 0; i < MAX_DECALS ; i++ )
    {
	   decal_text1[i] = gkrellm_create_decal_text(stk_panel, "Ay", ts, style, -1, -1, -1);
	   decal_text2[i] = gkrellm_create_decal_text(q_panel, "Ay", ts_alt, style, -1, -1, -1);
	 }

     for ( i = 0; i < MAX_TICKERS; i++ ) {

	   for ( j = 0; j < DETAIL_ELEM; j++ )
       {
	     strcpy( tic_details[i][j], "" );
	   }
     }

	/* Configure the panel to hold the above created decals, add in a little
	|  bottom margin for looks, and create the panel.
	*/
        gkrellm_panel_configure(stk_panel, NULL, style);
        // gkrellm_panel_create(vbox, stk_panel, gkrellm_bg_meter_piximage(style_id));
        gkrellm_panel_create(vbox, stk_monitor, stk_panel );

        gkrellm_panel_configure(q_panel, NULL, style);
        gkrellm_panel_create(vbox, stk_monitor, q_panel );
	/* Note: all of the above gkrellm_draw_decal_XXX() calls will not
	|  appear on the panel until a 	gkrellm_draw_panel_layers(panel); call is
	|  made.  This will be done in update_plugin(), otherwise we would
	|  make the call here and anytime the decals are changed.
	*/


        if (stock_tips == NULL)
        {
          stock_tips = gtk_tooltips_new();
          stock_tips_text = g_strdup("GKrellStock");
          gtk_tooltips_set_tip(stock_tips, stk_panel->drawing_area,
                               stock_tips_text, NULL);
          gtk_tooltips_set_tip(stock_tips, q_panel->drawing_area,
                               stock_tips_text, NULL);
          gtk_tooltips_set_delay(stock_tips, 1000);
        }

        x_scroll = 0;

        for ( i = MAX_DECALS - 1; i >=0; i-- )
        {
          panel_state = i; 
	      draw_panel();
	      if ( i == 0 ) { prev_state = i; }
	      else { prev_state = i - 1; }

          gkrellm_make_decal_invisible(stk_panel, decal_text1[panel_state] );
          gkrellm_make_decal_visible(stk_panel, decal_text1[prev_state] );

          gkrellm_make_decal_invisible(q_panel, decal_text2[panel_state] );
          gkrellm_make_decal_visible(q_panel, decal_text2[prev_state] );
        }


	if (first_create)
	{	
	    gtk_signal_connect(GTK_OBJECT (stk_panel->drawing_area), "expose_event",
    	        (GtkSignalFunc) expose_event, NULL);
	    gtk_signal_connect(GTK_OBJECT (q_panel->drawing_area), "expose_event",
    	        (GtkSignalFunc) expose_event, NULL);
	    gtk_signal_connect(GTK_OBJECT(stk_panel->drawing_area),
            "button_press_event", (GtkSignalFunc) panel_press, NULL);
	    gtk_signal_connect(GTK_OBJECT(q_panel->drawing_area),
            "button_press_event", (GtkSignalFunc) panel_press, NULL);

	}  

}
static gint get_num_tickers( GStock *value )
{
  gchar *token;

  gchar *tmp_buf[1024], tic_buf[1024];

  gint res = 0;

  strcpy( tic_buf, value->ticker );
  g_strstrip( tic_buf);

  *tmp_buf = tic_buf;
  while( ( token = strsep( tmp_buf, " " ) ) != NULL )
  {
	  if ( strlen( token) ) { res++; }
  }

  return res;

}

static void
set_tickers( void )
{
   gint i,j,k, num_tics;
   
   GStock *gstock;
   GList *list;

   i = 0;
   j = 0;
   for (list = tickerList; list; list = list->next)
   {
     gstock = (GStock *) list->data;

     num_tics = get_num_tickers( gstock );

	 for( k = 0; k < num_tics; k++ )
	 {
	   if ( gstock->want_scroll == 0 ) { scroll_q[j] = FALSE; }
	   else { scroll_q[j] = TRUE; }
	   j++;
	 }

     if ( i == 0 ) { strcpy( tickers, gstock->ticker ); i=1;}
 	 else { strcat( tickers, gstock->ticker); }

	 strcat( tickers, " " );
  } 
}

#define PLUGIN_CONFIG_KEYWORD    "gkrellstock"

static gint stock_src_set( gchar *value )
{
  gint i;

  for( i = 0; i < MAX_MARKETS; i++ )
  {
    if( ! strcmp( value, market_name[i] ) ) { return i; }
  }

  return 0;

}
static void
save_stock_config (FILE *f)
{
	gint i;

    GStock *gstock;
    GList *list;

    fprintf(f, "%s update_int %d\n", PLUGIN_CONFIG_KEYWORD,
            update_interval);
    fprintf(f, "%s switch_int %d\n", PLUGIN_CONFIG_KEYWORD,
            switch_interval);
    fprintf(f, "%s stock_src %d\n", PLUGIN_CONFIG_KEYWORD,
            stock_src);

    tic_number = g_list_length( tickerList );

    fprintf(f, "%s tic_number %d\n", PLUGIN_CONFIG_KEYWORD,
            tic_number);
    i=0;
	for ( list = tickerList; list; list = list->next )
	{
	  gstock = (GStock *) list->data;
      fprintf(f, "%s tickers%d %s!%d\n", PLUGIN_CONFIG_KEYWORD, 
	          i, gstock->ticker, gstock->want_scroll);
      i++;
	}
}

static void
load_stock_config (gchar *arg)
{
    gchar config[64], item[1024], tmp_buf[64];
    gint n, i;

	gchar **tmp_split;

	GStock *gstock;

    n = sscanf(arg, "%s %[^\n]", config, item);
    if (n == 2)
    {

        if (strcmp(config, "update_int") == 0)
            sscanf(item, "%d\n", &(update_interval));
        if (strcmp(config, "switch_int") == 0)
            sscanf(item, "%d\n", &(switch_interval));
        if (strcmp(config, "stock_src") == 0)
            sscanf(item, "%d\n", &(stock_src));
        if (strcmp(config, "tic_number") == 0)
            sscanf(item, "%d\n", &(tic_number));

        for( i=0; i < tic_number; i++ )
		{
		  sprintf( tmp_buf, "tickers%d", i );
          if (strcmp(config, tmp_buf) == 0)
	      {	
            if ( i == 0 )
			{
			  config_data_modified=TRUE;
              while (tickerList)
              {
                gstock = (GStock *) tickerList->data;
                tickerList = g_list_remove(tickerList, gstock);
              }
			}  

            gstock = g_new0( GStock, 1 );
            tmp_split = g_strsplit( item, DELIM, 2 );

            gstock->ticker = g_strdup( tmp_split[0] );
            gstock->want_scroll = atoi( tmp_split[1] );
            tickerList = g_list_append( tickerList, gstock );

            g_strfreev( tmp_split );

			if ( tic_number == i + 1 )
			{
              set_tickers();
              sprintf( command, "%s %s %s", COMMAND, stock_src_name[stock_src], tickers );
			}
	      }    

		}
    }
}

static void
apply_stock_config (void)
{
    gchar *c, *string;

    GStock *gstock;
	GList *newList ;

	gint row;

	if ( config_data_modified )
	{
	  newList = NULL;

	  for (row = 0; row < (GTK_CLIST (stock_clist)->rows); row += 1)
      {
        gstock = g_new0 (GStock, 1);
        newList = g_list_append (newList, gstock);

        gtk_clist_set_row_data (GTK_CLIST (stock_clist), row, gstock);

        gtk_clist_get_text (GTK_CLIST (stock_clist), row, 0, &string);
        gstock->want_scroll = (strcmp (string, "No") ? 1 : 0);

        gtk_clist_get_text (GTK_CLIST (stock_clist), row, 1, &string);
        gkrellm_dup_string (&gstock->ticker, string);
      }

      while (tickerList)
      {
        gstock = (GStock *) tickerList->data;
        tickerList = g_list_remove(tickerList, gstock);
      }

	  tickerList = newList;


      set_tickers();

	  config_data_modified = FALSE;

	}

    update_interval = gtk_spin_button_get_value_as_int(
            GTK_SPIN_BUTTON(update_interval_option));
    switch_interval = gtk_spin_button_get_value_as_int(
            GTK_SPIN_BUTTON(switch_interval_option));

    c = gkrellm_gtk_entry_get_text(&(GTK_COMBO(market_select_option)->entry));
    stock_src = stock_src_set( c );
    sprintf( command, "%s %s %s", COMMAND, stock_src_name[stock_src], tickers );
    run_command();

}

static void clearEntryFields()
{
   gtk_entry_set_text (GTK_ENTRY (ticker_option), "");
   gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (scroll_option), 0);

}
static void cbUpdate (GtkWidget *widget, gpointer data)
{
  gchar *tmp_buf[2];

  tmp_buf[0] = (gtk_toggle_button_get_active
               (GTK_TOGGLE_BUTTON (scroll_option)) == TRUE ? "Yes" : "No");
  tmp_buf[1] = gkrellm_gtk_entry_get_text (&ticker_option);

  /*
   * Ignore empty tickers.
   */
   if ( !strlen (tmp_buf[1]) ) { return; }

  /*
   * If a row is selected, we're modifying an existing entry,
   * else we're adding a new one.
   */
  if (selected_tic_row >= 0)
  {
    gtk_clist_set_text (GTK_CLIST (stock_clist),
                        selected_tic_row, 0, tmp_buf[0]);
    gtk_clist_set_text (GTK_CLIST (stock_clist),
                        selected_tic_row, 1, tmp_buf[1]);
    gtk_clist_unselect_row (GTK_CLIST (stock_clist), selected_tic_row, 0);
    selected_tic_row = -1;
    config_data_modified = TRUE;
  }
  else
  {
    gtk_clist_append (GTK_CLIST (stock_clist), tmp_buf);
    config_data_modified = TRUE;
  } 

  clearEntryFields();
}

static void cbDelete (GtkWidget *widget, gpointer data)
{

  clearEntryFields();

  if (selected_tic_row >= 0)
  {
    gtk_clist_remove (GTK_CLIST (stock_clist), selected_tic_row);
    selected_tic_row = -1;
    config_data_modified = TRUE;
  }


}

static void cbMoveUp (GtkWidget *widget, gpointer data)
{
  gint      row;
  GtkWidget *clist;

  clist = stock_clist;
  row = selected_tic_row;

  /*
   * Only attempt a move if we're not on the first row.
   */
  if (row > 0)
  {
    /*
     * Move the selected row up one position.
     * Note that we have to reselect it afterwards.
     */
    gtk_clist_row_move (GTK_CLIST (clist), row, row - 1);
    gtk_clist_select_row (GTK_CLIST (clist), row - 1, -1);

    selected_tic_row = row - 1;
    config_data_modified = TRUE;
  }
}

static void cbMoveDown (GtkWidget *widget, gpointer data)
{
  gint      row;
  GtkWidget *clist;

  clist = stock_clist;
  row = selected_tic_row;

  /*
   * Only attempt a row if we're not on the last row.
   * Note that we have to reselect it afterwards.
   */
  if ((row >= 0) && (row < (GTK_CLIST (clist)->rows - 1)))
  {
    gtk_clist_row_move (GTK_CLIST (clist), row, row + 1);
    gtk_clist_select_row (GTK_CLIST (clist), row + 1, -1);

    selected_tic_row = row + 1;
    config_data_modified = TRUE;
  }

}

static void cbStkSelected (GtkWidget *clist, gint row, gint column,
                          GdkEventButton *bevent, gpointer data)
{
  gchar *string;

  /*
   * Fill the entry widgets & check box accoring to the selected row's text
   */
  gtk_clist_get_text (GTK_CLIST (stock_clist), row, 0, &string);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (scroll_option),
                                strcmp (string, "No") ? TRUE : FALSE);

  gtk_clist_get_text (GTK_CLIST (stock_clist), row, 1, &string);
  gtk_entry_set_text (GTK_ENTRY (ticker_option), string);

  selected_tic_row = row;
}

static void cbStkUnselected (GtkWidget *clist, gint row, gint column,
                             GdkEventButton *bevent, gpointer data)
{
  clearEntryFields();

  selected_tic_row = -1;
}

static void
create_stock_tab (GtkWidget *tab)
{
    GtkWidget *laptop, *frame, *ybox, *hbox, *vbox, *separator, *scroll_win,
              *label, *text, *info_window, *about_label, *button, *arrow;
    GtkAdjustment *switch_adjust, *update_adjust;

	GList *market_items = NULL;
	gint i;

    gchar *col_title[2] = { "Scroll Quote", "Ticker Symbols" };
	gchar *tmp_buf[2];
	gchar tmp_scroll[5];
	GStock *gstock;
	GList *stk_list;

    gchar *about_text = NULL;
    static gchar *help_text[] =
    {
      "<b>" CONFIG_NAME " " GKRELLSTOCK_VER "\n\n" ,
      "Shows stock quotes for given tickers " ,
      "<i> maximum of 100. \n",
	  "Each line can hold upto 64 characters, selected tickers can \n" ,
	  "set to scroll by clicking Scroll Quote checkbox.\n\n" ,
      "Middle click cycles through tickers.\n" ,
      "Right click will open configuration window.\n\n",
      "Tooltip will give details of that Ticker.\n\n" ,
      "<b> Options \n\n" ,
      "switch interval - number of seconds between display switch.\n",
      "update interval - number of minutes between updating tickers. \n\n" ,
      "<b> Source Stock Exchange \n\n", 
      " For Europe and Asia Tickers must be entered like SYMBOL.EXCHANGE \n\n" ,
      "<i> e.g. 12150.PA for Paris Exchange \n" ,
      "<i> e.g. CREA.SI for Singapore Exchange \n\n" ,
      "Please check Finance::Quote perl Module documentation " ,
      "for more details \n" ,
      "http://finance-quote.sourceforge.net/documentation.html "
    };
    laptop = gtk_notebook_new();
    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(laptop), GTK_POS_TOP);
    gtk_box_pack_start(GTK_BOX(tab), laptop, TRUE, TRUE, 0);

    /* options */
    frame = gtk_frame_new(NULL);
    gtk_container_border_width(GTK_CONTAINER(frame), 3);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 3);

    /* Source Stock Exchange Radio Buttons */
    ybox = gtk_hbox_new(FALSE, 0);
    label = gtk_label_new("Source Stock Exchange");

    for( i = 0; i < MAX_MARKETS; i++ )
	{
	  market_items = g_list_append( market_items, market_name[i] );
	}

	market_select_option = gtk_combo_new();
    gtk_combo_set_popdown_strings (GTK_COMBO (market_select_option), 
	                               market_items);
    gtk_combo_set_value_in_list( GTK_COMBO(market_select_option), TRUE, FALSE );
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(market_select_option)->entry),
                                                market_name[stock_src] );

    gtk_box_pack_start(GTK_BOX(ybox), label, FALSE, FALSE, 4);
	gtk_box_pack_start(GTK_BOX(ybox), market_select_option, FALSE, FALSE, 0);

    /* Switch & Update Interval */

    switch_adjust = (GtkAdjustment *) gtk_adjustment_new((gfloat)
            switch_interval, DEFAULT_SI, 100.0, 1.0, 5.0, 0.0);
    switch_interval_option = gtk_spin_button_new(switch_adjust, 1.0, 1);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(switch_interval_option),
            (guint) 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(switch_interval_option),
            switch_interval);
    gtk_box_pack_end(GTK_BOX(ybox), switch_interval_option, FALSE, FALSE, 0);
    label = gtk_label_new("switch interval (secs)");
    gtk_box_pack_end(GTK_BOX(ybox), label, FALSE, FALSE, 4);

	gtk_box_pack_start(GTK_BOX(vbox), ybox, FALSE, TRUE, 0);

    ybox = gtk_hbox_new(FALSE, 0);
    update_adjust = (GtkAdjustment *) gtk_adjustment_new((gfloat)
            update_interval, DEFAULT_UI, 100.0, 1.0, 5.0, 0.0);
    update_interval_option = gtk_spin_button_new(update_adjust, 1.0, 1);
    gtk_spin_button_set_digits(GTK_SPIN_BUTTON(update_interval_option),
            (guint) 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(update_interval_option),
            update_interval);
    label = gtk_label_new("update interval (minutes)");

    gtk_box_pack_end(GTK_BOX(ybox), update_interval_option, FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(ybox), label, FALSE, FALSE, 4);

	gtk_box_pack_start(GTK_BOX(vbox), ybox, FALSE, TRUE, 0);

    separator = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 4);

    /* Tickers */
    hbox = gtk_hbox_new(FALSE, 0);
    label = gtk_label_new("Ticker Symbols(space separated)" );
    ticker_option = gtk_entry_new_with_max_length(64);
    gtk_entry_set_editable(GTK_ENTRY(ticker_option), TRUE);
    
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 4);
    gtk_box_pack_start(GTK_BOX(hbox), ticker_option, TRUE, TRUE, 0);

    scroll_option = gtk_check_button_new_with_label( "Scroll Quote" );
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(scroll_option), 0 );
    gtk_box_pack_start(GTK_BOX(hbox), scroll_option, FALSE, FALSE, 0);

	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);

    hbox = gtk_hbox_new(FALSE, 0);

    button = gtk_button_new_with_label ("Add/Update");
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      (GtkSignalFunc) cbUpdate, NULL);
    gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);

    button = gtk_button_new_with_label ("Delete");
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      (GtkSignalFunc) cbDelete, NULL);
    gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);

    button = gtk_button_new();
	arrow = gtk_arrow_new(GTK_ARROW_UP, GTK_SHADOW_ETCHED_OUT);
    gtk_container_add(GTK_CONTAINER(button), arrow);

    gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      (GtkSignalFunc) cbMoveUp, NULL);

    gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);

    button = gtk_button_new();
	arrow = gtk_arrow_new(GTK_ARROW_DOWN, GTK_SHADOW_ETCHED_OUT);
    gtk_container_add(GTK_CONTAINER(button), arrow);
    gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      (GtkSignalFunc) cbMoveDown, NULL);
    gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);

    stock_clist = gtk_clist_new_with_titles (2, col_title);
    gtk_clist_set_shadow_type (GTK_CLIST (stock_clist), GTK_SHADOW_OUT);

    gtk_clist_set_column_width (GTK_CLIST (stock_clist), 0, 70);
    gtk_clist_set_column_width (GTK_CLIST (stock_clist), 1, 70);

	gtk_clist_set_column_justification (GTK_CLIST (stock_clist),
                                        0, GTK_JUSTIFY_LEFT);
	gtk_clist_set_column_justification (GTK_CLIST (stock_clist),
                                        1, GTK_JUSTIFY_LEFT);


    scroll_win = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll_win),
                                  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_box_pack_start (GTK_BOX (vbox), scroll_win, TRUE, TRUE, 0);

   /*
    * Add signals for selecting a row in the CList.
    */
    gtk_signal_connect (GTK_OBJECT (stock_clist), "select_row",
                      (GtkSignalFunc) cbStkSelected, NULL);

   /*
    * Add signal for deselecting a row in the CList.
    * If not, delselecting & attempting to create a new entry will overwrite
    * the previuosly selected row.
    */
    gtk_signal_connect (GTK_OBJECT (stock_clist), "unselect_row",
                      (GtkSignalFunc) cbStkUnselected, NULL);


    gtk_container_add (GTK_CONTAINER (scroll_win), stock_clist);


  /*
   * Fill the tickerList with Stock Tickers.
   */
   i = 0;
   for ( stk_list = tickerList; stk_list; stk_list = stk_list->next)
   {
     gstock = (GStock *) stk_list->data;
     sprintf (tmp_scroll, "%s", (gstock->want_scroll == 1 ? "Yes" : "No"));
     tmp_buf[0] = tmp_scroll;
     tmp_buf[1] = gstock->ticker;
     gtk_clist_append (GTK_CLIST (stock_clist), tmp_buf);
     gtk_clist_set_row_data (GTK_CLIST (stock_clist), i, gstock);
	 i++;
   }



    label = gtk_label_new("Options");
    gtk_container_add(GTK_CONTAINER(frame), vbox);
    gtk_notebook_append_page(GTK_NOTEBOOK(laptop), frame, label);

        /* help */
    frame = gtk_frame_new(NULL);
    gtk_container_border_width(GTK_CONTAINER(frame), 3);
    info_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(info_window),
    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_container_add(GTK_CONTAINER(frame), info_window);

    text = gtk_text_view_new();

	gkrellm_gtk_text_view_append_strings(text, help_text, sizeof(help_text)/sizeof(gchar*));
    gtk_text_view_set_editable(GTK_TEXT_VIEW(text), FALSE);
    gtk_container_add(GTK_CONTAINER(info_window), text);

    label = gtk_label_new("Help");
    gtk_notebook_append_page(GTK_NOTEBOOK(laptop), frame, label);

        /* about */
    about_text = g_strdup_printf(
        "GKrellStock %s\n" \
        "GKrellM Stock Plugin\n" \
        "\n" \
        "Copyright (C) 2003 M.R.Muthu Kumar\n" \
        "m_muthukumar@users.sourceforge.net\n" \
        "\n" \
        "Released under the GNU Public License\n" \
	"GkrellStock comes with ABSOLUTELY NO WARRANTY\n" \
	"Stock Quotes are delayed and Terms and Conditions for \n" \
	"using this information are bound by Finance::Quote module \n" \
	"and Yahoo! Finance \n" \
        , GKRELLSTOCK_VER
    );
    about_label = gtk_label_new(about_text);
    g_free(about_text);
    label = gtk_label_new("About");
    gtk_notebook_append_page(GTK_NOTEBOOK(laptop), about_label, label);

}


/* The monitor structure tells GKrellM how to call the plugin routines.
*/
static GkrellmMonitor	plugin_mon	=
	{
	CONFIG_NAME,        	/* Name, for config tab.    */
	0,			/* Id,  0 if a plugin       */
	create_plugin,		/* The create function      */
	update_plugin,		/* The update function      */
	create_stock_tab,	/* The config tab create function   */
	apply_stock_config,	/* Apply the config function        */ 
	save_stock_config,	/* Save user config*/
	load_stock_config,	/* Load user config*/
	PLUGIN_CONFIG_KEYWORD,	/* config keyword*/ 
	NULL,			/* Undefined 2	*/
	NULL,			/* Undefined 1	*/
	NULL,			/* private		*/ 
	MON_MAIL,		/* Insert plugin before this monitor*/ 
	NULL,			/* Handle if a plugin, filled in by GKrellM */
	NULL			/* path if a plugin, filled in by GKrellM   */
	};

static void
read_default(void)
{
   GStock *gstock;

   switch_interval = DEFAULT_SI;
   update_interval = DEFAULT_UI;
   stock_src = 0;
   selected_tic_row = -1;

   gstock = g_new0( GStock, 1 );
   gstock->ticker = g_strdup( DEFAULT_TICKERS );
   gstock->want_scroll = 0;
   tickerList = g_list_append( tickerList, gstock );

   gstock = g_new0( GStock, 1 );
   gstock->ticker = g_strdup( DEFAULT_S_TICKERS );
   gstock->want_scroll = 1;
   tickerList = g_list_append( tickerList, gstock );

   tic_number = g_list_length( tickerList );

   set_tickers();

   sprintf( stk_filename, "%s/.smStockReports2/stockinfo.dat", getenv( "HOME" ) );
   sprintf( command, "%s %s %s", COMMAND, stock_src_name[stock_src], tickers );
}	

  /* All GKrellM plugins must have one global routine named init_plugin()
  |  which returns a pointer to a filled in monitor structure.
  */
GkrellmMonitor *
gkrellm_init_plugin()
	{
	/* If this call is made, the background and krell images for this plugin
	|  can be custom themed by putting bg_meter.png or krell.png in the
	|  subdirectory STYLE_NAME of the theme directory.  Text colors (and
	|  other things) can also be specified for the plugin with gkrellmrc
	|  lines like:  StyleMeter  STYLE_NAME.textcolor orange black shadow
	|  If no custom themeing has been done, then all above calls using
	|  style_id will be equivalent to style_id = DEFAULT_STYLE_ID.
	*/
	/* style_id = gkrellm_add_meter_style(&plugin_mon, STYLE_NAME); */

	// style_id = gkrellm_lookup_meter_style_id(  STYLE_NAME);
	
	style_id = gkrellm_add_meter_style(&plugin_mon, STYLE_NAME); 


	read_default();

	/* run_command(); */

	net_update = FALSE;

	return (stk_monitor = &plugin_mon);
	}
