/* Copyright (c) 2002
 *	Marko Boomstra (m.boomstra@chello.nl).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <conf.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <ncurses.h>
#include <panel.h>
#include "mudix.h"


void show_aliases(void)
{
    static int		 current;
    	   NAMING  	*alias;
    	   char    	*str;
    	   int      	 line, i, width, height, centre, wsize;

    width  = LEN_COL-4;
    height = 20;
    wsize  = height-2;
    centre = ((width-2)/2)-1;

    wresize(wMsg, height, width);
    werase(wMsg);
    move_panel(pMsg, 1, 2);

    if (panel_hidden(pMsg) == PANEL_HIDDEN)
	current = 0;

    for (line=1, i=0, alias = settings->naming_list; 
		      				alias; alias = alias->next) {
    	if (!alias->name || !alias->string)
            continue;

	i+=2;
	if (i < (current*wsize)+2)
	    continue;

        mvwprintw(wMsg, line++, 1, "Name: %s", alias->name);
        mvwprintw(wMsg, line++, 1, "Resp: %s", alias->string);

	if (line >= wsize && alias->next) {
	    current++;
	    break;
	}

	if (!alias->next)	/* last one */
	    current = 0;
    }

    draw_border(wMsg);
    str = "Aliases";
    mvwprintw(wMsg, 0, centre-strlen(str)/2, str);
    show_panel(pMsg);
    return;
}

NAMING *new_naming(bool last)
{
    NAMING *alias;

    if (!(alias = (NAMING *)malloc(sizeof(NAMING))))
        return NULL;

    if (last && settings->naming_list) {
	NAMING *iAlias;

	for (iAlias = settings->naming_list; iAlias; iAlias = iAlias->next) {
	    if (!iAlias->next)
		break;
	}
	iAlias->next = alias;
	alias->next  = NULL;
    }
    else {
    	alias->next = settings->naming_list;
    	settings->naming_list = alias;
    }

    alias->name   = NULL;
    alias->string = NULL;

    return alias;
}

void free_naming(NAMING *name)
{
    NAMING *alias;

    if (!name)
	return;

    for (alias = settings->naming_list; alias; alias = alias->next) {
    	if (alias->next == name) {
            alias->next = name->next;
            break;
        }
    }

    if (name == settings->naming_list)
        settings->naming_list = name->next;

    if (name->name)
	free(name->name);
    if (name->string)
    	free(name->string);
    free(name);
    return;
}

bool process_naming(char *buffer)
{
    NAMING *pNm;
    char    alias[MAX_STRING];

    if (settings->state != STATE_READY)
        return FALSE;

    buffer = get_arg(buffer, alias);
    for (pNm = settings->naming_list; pNm; pNm = pNm->next) {
        if (strcmp(pNm->name, alias))
            continue;

        process_input(pNm->string, buffer, TRUE);
        return TRUE;
    }

    return FALSE;
}

bool process_alias(int alias)
{
    switch (alias) {
        case F1:
        case F2:
        case F3:
        case F4:
        case F5:
            alias -= F1;
            break;
        case F6:
        case F7:
        case F8:
            alias = 5 + (alias-F6);
            break;
        case F9:
            alias = 8;
            break;
        case F10:
            alias = 9;
            break;
        case F11:
        case F12:
            alias = 10 + (alias-F11);
            break;
        default:
            return FALSE;
    }

    if (alias < 0 || alias > ALIAS_MAX || !settings->alias[alias])
        return FALSE;

    if (!process_naming(settings->alias[alias]))
    	process_input(settings->alias[alias], NULL, TRUE);

    return TRUE;
}
